/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn.util;

import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.StrategyEvaluatorList;
import zeus.util.Core;

public abstract class StrategyEvaluator {
    public static final int OK = 0;
    public static final int FAIL = 1;
    public static final int WAIT = 2;
    public static final int MESSAGE = 3;
    protected AgentContext context = null;
    protected StrategyEvaluatorList evaluators = null;
    protected boolean isActive = true;
    protected Vector goals = null;
    protected ProtocolDbResult protocolInfo = null;

    public void set(AgentContext agentContext) {
        this.context = agentContext;
    }

    public void set(StrategyEvaluatorList strategyEvaluatorList) {
        this.evaluators = strategyEvaluatorList;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Vector getGoals() {
        return this.goals;
    }

    public ProtocolDbResult getProtocolInfo() {
        return this.protocolInfo;
    }

    public abstract int evaluateFirst(Vector var1, ProtocolDbResult var2);

    public abstract int evaluateNext(DelegationStruct var1);

    protected String getParam(String string, String string2) {
        if (this.protocolInfo == null) {
            return string2;
        }
        String string3 = (String)this.protocolInfo.parameters.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    protected int getIntParam(String string, int n) {
        if (this.protocolInfo == null) {
            return n;
        }
        String string2 = (String)this.protocolInfo.parameters.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Core.USER_ERROR("NumberFormat error in parameter " + string + "=" + string2 + " of strategy " + this.protocolInfo.strategy + " of protocol " + this.protocolInfo.protocol + " -- integer value expected ");
            return n;
        }
    }

    protected double getDoubleParam(String string, double d) {
        if (this.protocolInfo == null) {
            return d;
        }
        String string2 = (String)this.protocolInfo.parameters.get(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Core.USER_ERROR("NumberFormat error in parameter " + string + "=" + string2 + " of strategy " + this.protocolInfo.strategy + " of protocol " + this.protocolInfo.protocol + " -- double value expected ");
            return d;
        }
    }

    protected boolean getBooleanParam(String string, boolean bl) {
        if (this.protocolInfo == null) {
            return bl;
        }
        String string2 = (String)this.protocolInfo.parameters.get(string);
        if (string2 == null) {
            return bl;
        }
        try {
            return Boolean.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Core.USER_ERROR("NumberFormat error in parameter " + string + "=" + string2 + " of strategy " + this.protocolInfo.strategy + " of protocol " + this.protocolInfo.protocol + " -- boolean value expected ");
            return bl;
        }
    }
}

