/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Vector;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Graph;
import zeus.actors.rtn.Node;
import zeus.util.Core;
import zeus.util.Misc;

public class PGraph
extends Graph {
    protected Vector done_nodes = new Vector();
    protected Vector failed_nodes = new Vector();
    protected Node[] start_nodes = null;
    protected boolean first = true;
    protected int min_done = -1;
    protected int max_fail = 0;

    public PGraph(String string, String[][] stringArray, String string2) {
        super(string, stringArray, string2);
    }

    public PGraph(String string, String[][] stringArray, String string2, int n) {
        super(string, stringArray, string2);
        this.min_done = n;
    }

    protected void start(Engine engine, Object object) {
        this.state = 1;
        Object[] objectArray = (Object[])object;
        this.start_nodes = new Node[objectArray.length];
        if (this.min_done != -1) {
            this.max_fail = objectArray.length - this.min_done;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.start_nodes[n] = this.newNode(engine, this.start_node, this.previous_node);
            if (this.start_nodes[n] == null) {
                this.fail(engine, "Start node not found");
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.start_nodes[n2].setInput(engine, objectArray[n2]);
            engine.add(this.start_nodes[n2]);
            ++n2;
        }
    }

    void done(Engine engine, Node node) {
        this.done_nodes.addElement(node);
        Core.DEBUG(3, this.description + " no: " + this.done_nodes.size() + " done");
        if (this.done_nodes.size() + this.failed_nodes.size() == this.start_nodes.length) {
            this.doSucceed(engine);
        }
    }

    protected void doSucceed(Engine engine) {
        this.setState(engine, 2);
        if (this.graph != null) {
            Node node = this.graph.newNode(engine, this.next_node, this.previous_node, this.getTerminalNodes());
            if (node == null) {
                this.fail(engine, "next_node - " + this.next_node + " - not found");
                return;
            }
            Object[] objectArray = new Object[this.done_nodes.size()];
            int n = 0;
            while (n < this.done_nodes.size()) {
                objectArray[n] = ((Node)this.done_nodes.elementAt(n)).getOutput();
                ++n;
            }
            node.setInput(engine, objectArray);
            engine.add(node);
        } else if (this.node_wakeup_key != null) {
            engine.wakeup(this.node_wakeup_key);
        }
    }

    void failed(Engine engine, Node node) {
        if (this.state != 3) {
            int n = 0;
            while (n < this.start_nodes.length) {
                if (this.start_nodes[n] == node) {
                    this.failed_nodes.addElement(node);
                    if (this.failed_nodes.size() <= this.max_fail) break;
                    this.setState(engine, 3);
                    break;
                }
                ++n;
            }
            if (this.state == 3) {
                int n2 = 0;
                while (n2 < this.done_nodes.size()) {
                    ((Node)this.done_nodes.elementAt(n2)).fail(engine, true, "Parallel branch failed");
                    ++n2;
                }
            }
        } else {
            int n = 0;
            while (n < this.start_nodes.length) {
                if (this.start_nodes[n] == node) {
                    this.failed_nodes.addElement(node);
                    break;
                }
                ++n;
            }
        }
        if (this.first && this.failed_nodes.size() == this.start_nodes.length) {
            this.first = false;
            this.fail(engine, "Parallel graph failed");
        } else if (this.failed_nodes.size() + this.done_nodes.size() == this.start_nodes.length) {
            this.doSucceed(engine);
        }
    }

    Node newNode(Engine engine, String string, Node node) {
        if (this.state == 3) {
            return null;
        }
        return super.newNode(engine, string, node);
    }

    Vector getTerminalNodes() {
        Vector vector;
        Node node;
        Vector vector2 = new Vector();
        Core.DEBUG(3, "PGraph: getTerminalNodes for: " + this.description);
        int n = 0;
        while (n < this.done_nodes.size()) {
            node = (Node)this.done_nodes.elementAt(n);
            Core.DEBUG(3, "\tConsidering done_node: " + node);
            vector = node.getParentsOfNextNode();
            if (vector != null) {
                vector2 = Misc.union(vector2, vector);
            } else {
                vector2.addElement(node);
            }
            Core.DEBUG(3, "\tCurrent terminals: " + vector2);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.failed_nodes.size()) {
            node = (Node)this.failed_nodes.elementAt(n2);
            Core.DEBUG(3, "\tConsidering failed_node: " + node);
            vector = node.getParentsOfNextNode();
            if (vector != null) {
                vector2 = Misc.union(vector2, vector);
            } else {
                vector2.addElement(node);
            }
            Core.DEBUG(3, "\tCurrent terminals: " + vector2);
            ++n2;
        }
        Core.DEBUG(3, "\tFinal terminals: " + vector2);
        return vector2;
    }

    boolean allow_backtrack(Node node) {
        int n = 0;
        while (n < this.start_nodes.length) {
            if (this.start_nodes[n] == node) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

