/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.rtn.Arc;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Graph;
import zeus.util.Core;
import zeus.util.Misc;

public class Node {
    public static final int NOT_READY = 0;
    public static final int READY = 1;
    public static final int WAITING = 2;
    public static final int RUNNING = 3;
    public static final int DONE = 4;
    public static final int FAILED = 5;
    protected static final int OK = 1;
    protected static final int FAIL = 2;
    protected static final int WAIT = 3;
    protected static final int OK_WAIT = 4;
    private static int count = 0;
    protected String[] arcs = null;
    protected String[] nodes = null;
    protected Object input = null;
    protected Object output = null;
    protected Node previous_node = null;
    protected Node[] parents = null;
    protected Graph graph = null;
    protected String description = null;
    protected int state = 0;
    protected int current_arc = -1;
    protected double timeout = 0.0;
    protected String msg_wait_key = null;
    protected AgentContext context = null;
    protected Vector parents_of_next_node = null;

    public String getDesc() {
        return null;
    }

    public void finaliser() {
        this.finals();
    }

    public void finals() {
        if (this.arcs != null) {
            int n = 0;
            while (n < this.arcs.length) {
                this.arcs[n] = null;
                ++n;
            }
        }
        this.arcs = null;
        if (this.nodes != null) {
            int n = 0;
            while (n < this.nodes.length) {
                this.nodes[n] = null;
                ++n;
            }
        }
        this.nodes = null;
        this.input = null;
        this.output = null;
        this.previous_node = null;
        if (this.parents != null) {
            int n = 0;
            while (n < this.parents.length) {
                this.parents[n] = null;
                ++n;
            }
        }
        this.parents = null;
    }

    public Node(String string) {
        this.description = string + "-" + count++;
        Core.DEBUG(3, "New node " + this.description + " created");
    }

    public final String getDescription() {
        return this.description;
    }

    public final double getTimeout() {
        return this.timeout;
    }

    public final String getMsgWaitKey() {
        return this.msg_wait_key;
    }

    public final Object getOutput() {
        return this.output;
    }

    public final Node getPrevious() {
        return this.previous_node;
    }

    public final Node[] getParents() {
        return this.parents;
    }

    public final int getState() {
        return this.state;
    }

    public final Graph getGraph() {
        return this.graph;
    }

    final void set(Graph graph, String[] stringArray, String[] stringArray2, Node node) {
        this.arcs = stringArray;
        this.nodes = stringArray2;
        this.graph = graph;
        this.previous_node = node;
        if (node != null) {
            this.parents = new Node[1];
            this.parents[0] = node;
        }
    }

    final void set(Graph graph, String[] stringArray, String[] stringArray2, Node node, Vector vector) {
        this.arcs = stringArray;
        this.nodes = stringArray2;
        this.graph = graph;
        this.previous_node = node;
        this.parents = new Node[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.parents[n] = (Node)vector.elementAt(n);
            ++n;
        }
    }

    final void run(Engine engine) {
        this.context = engine.getAgentContext();
        block0 : switch (this.state) {
            case 1: 
            case 2: {
                if (!this.graph.allow_exec()) {
                    this.fail(engine, false, "Exec refused by graph");
                    break;
                }
                int n = this.state == 1 ? this.exec() : this.continue_exec();
                switch (n) {
                    case 1: {
                        this.setState(engine, 3);
                        engine.add(this);
                        break block0;
                    }
                    case 3: {
                        engine.waitForMsg(this);
                        this.setState(engine, 2);
                        break block0;
                    }
                }
                this.fail(engine, false, "Node exec failed");
                break;
            }
            case 3: {
                if (!this.graph.allow_exec()) {
                    this.fail(engine, true, "Exec refused by graph");
                    break;
                }
                if (this.arcs == null) {
                    this.done(engine, "terminal node reached");
                    break;
                }
                if (this.current_arc >= this.arcs.length) {
                    this.fail(engine, true, "All arcs traversed");
                    break;
                }
                this.exec_arc(engine);
                break;
            }
            default: {
                Core.ERROR(null, 2, (Object)this);
            }
        }
        engine = null;
        this.context = null;
    }

    private void done(Engine engine, String string) {
        Core.DEBUG(3, this.description + " done: " + string);
        this.setState(engine, 4);
        this.graph.done(engine, this);
    }

    final void fail(Engine engine, boolean bl, String string) {
        Thread.yield();
        Core.DEBUG(3, this.description + " failed: " + string);
        this.setState(engine, 5);
        Thread.yield();
        if (bl) {
            this.reset();
        }
        this.graph.failed(engine, this);
        Thread.yield();
        if (this.previous_node != null && this.graph.allow_backtrack(this)) {
            this.previous_node.nextArc(engine);
        }
    }

    protected int exec() {
        this.output = this.input;
        return 1;
    }

    protected int continue_exec() {
        this.output = this.input;
        return 1;
    }

    protected void reset() {
    }

    final void setInput(Engine engine, Object object) {
        Core.ERROR(this.state == 0, 1, (Object)this);
        this.input = object;
        this.current_arc = 0;
        this.setState(engine, 1);
    }

    protected final void exec_arc(Engine engine) {
        try {
            Class<?> clazz = Class.forName(this.arcs[this.current_arc]);
            Arc arc = (Arc)clazz.newInstance();
            engine.notifyArcMonitors(arc, this, 0);
            arc.run1(engine, this.graph, this, this.output, this.nodes[this.current_arc]);
        }
        catch (Exception exception) {
            Core.USER_ERROR("Arc " + this.arcs[this.current_arc] + " cannot be executed" + "\nException " + exception);
            this.nextArc(engine);
        }
    }

    final void nextArc(Engine engine) {
        switch (this.state) {
            case 3: 
            case 4: {
                if (!this.graph.allow_exec()) {
                    this.fail(engine, true, "Next arc disallowed by graph");
                    break;
                }
                if (this.state == 4 && this.arcs == null) {
                    this.fail(engine, true, "All arcs traversed");
                    break;
                }
                this.setState(engine, 3);
                ++this.current_arc;
                engine.add(this);
                break;
            }
            default: {
                Core.ERROR(null, 3, (Object)this);
            }
        }
    }

    final void setState(Engine engine, int n) {
        this.state = n;
        engine.notifyNodeMonitors(this, 2);
    }

    protected void finalize() throws Throwable {
        if (this.context != null) {
            this.context.Engine().notifyNodeMonitors(this, 1);
        }
        this.arcs = null;
        this.nodes = null;
        this.input = null;
        this.output = null;
        this.previous_node = null;
        this.parents = null;
        this.graph = null;
        this.description = null;
        this.msg_wait_key = null;
        this.parents_of_next_node = null;
    }

    protected Graph createGraph(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Graph graph = (Graph)clazz.newInstance();
            if (this.parents_of_next_node == null) {
                this.parents_of_next_node = new Vector();
            }
            this.parents_of_next_node.addElement(graph);
            this.context.Engine().notifyGraphMonitors(graph, 0);
            return graph;
        }
        catch (Exception exception) {
            Core.USER_ERROR("Cannot create graph: " + string + "\n" + exception);
            return null;
        }
    }

    Vector getParentsOfNextNode() {
        if (this.parents_of_next_node == null || this.parents_of_next_node.isEmpty()) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < this.parents_of_next_node.size()) {
            Graph graph = (Graph)this.parents_of_next_node.elementAt(n);
            vector = Misc.union(vector, graph.getTerminalNodes());
            ++n;
        }
        return vector.isEmpty() ? null : vector;
    }

    protected Object createObject(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            Core.USER_ERROR("Cannot create object: " + string + "\n" + exception);
            return null;
        }
    }

    final boolean hasChildGraph(Graph graph) {
        Core.DEBUG(3, "hasChildGraph: " + graph.getDescription() + " " + this.getDescription());
        boolean bl = this.parents_of_next_node != null && this.parents_of_next_node.contains(graph);
        Core.DEBUG(3, "\thasChildGraph = " + bl);
        return bl;
    }

    public String toString() {
        return this.description;
    }

    public boolean timeOut() {
        return false;
    }
}

