/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.rtn;

import java.util.Vector;
import zeus.actors.rtn.Arc;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Node;
import zeus.util.Core;

public abstract class Graph
extends Arc {
    public static final int READY = 0;
    public static final int RUNNING = 1;
    public static final int DONE = 2;
    public static final int FAILED = 3;
    private static int count = 0;
    protected String[][] nodes = null;
    protected String start_node = null;
    protected String next_node = null;
    protected Node previous_node = null;
    protected Node begin_node = null;
    protected int state = 0;
    protected String node_wakeup_key = null;
    private Node last_node = null;

    public Graph(String string, String[][] stringArray, String string2) {
        this.start_node = string2;
        this.nodes = stringArray;
        this.description = string + "-" + count++;
        Core.DEBUG(3, "New graph " + this.description + " created");
    }

    public final int getState() {
        return this.state;
    }

    void run1(Engine engine, Graph graph, Node node, Object object, String string) {
        this.context = engine.getAgentContext();
        this.graph = graph;
        this.previous_node = node;
        this.next_node = string;
        this.start(engine, object);
    }

    public void run(Engine engine, Object object) {
        this.start(engine, object);
    }

    public void run(Engine engine, Node node, Object object, String string) {
        this.node_wakeup_key = string;
        this.previous_node = node;
        this.start(engine, object);
    }

    protected void start(Engine engine, Object object) {
        this.setState(engine, 1);
        this.begin_node = this.newNode(engine, this.start_node, this.previous_node);
        if (this.begin_node == null) {
            this.fail(engine, "Start node " + this.start_node + " not found");
        } else {
            this.begin_node.setInput(engine, object);
            engine.add(this.begin_node);
        }
    }

    void done(Engine engine, Node node) {
        Core.DEBUG(3, this.description + " done");
        this.setState(engine, 2);
        if (this.graph != null) {
            Node node2 = this.graph.newNode(engine, this.next_node, node);
            if (node2 == null) {
                this.setState(engine, 1);
                node.nextArc(engine);
            } else {
                Object object = node.getOutput();
                node2.setInput(engine, object);
                engine.add(node2);
            }
        } else if (this.node_wakeup_key != null) {
            engine.wakeup(this.node_wakeup_key);
        }
    }

    void failed(Engine engine, Node node) {
        if (node == this.begin_node) {
            this.setState(engine, 3);
            if (this.node_wakeup_key != null) {
                engine.wakeup(this.node_wakeup_key);
            }
        }
    }

    protected void fail(Engine engine, String string) {
        Core.DEBUG(3, this.description + " failed: " + string);
        this.setState(engine, 3);
        if (this.node_wakeup_key != null) {
            engine.wakeup(this.node_wakeup_key);
        }
        if (this.previous_node != null) {
            this.previous_node.nextArc(engine);
        }
    }

    Vector getTerminalNodes() {
        if (this.last_node != null) {
            Vector<Node> vector = this.last_node.getParentsOfNextNode();
            if (vector != null) {
                return vector;
            }
            vector = new Vector<Node>();
            vector.addElement(this.last_node);
            return vector;
        }
        return new Vector();
    }

    Node newNode(Engine engine, String string, Node node) {
        Vector vector;
        if (node != null) {
            Core.DEBUG(3, "NewNode preamble\n\tname = " + string + "\n\tprevious = " + node + "\n\thasChild = " + node.hasChildGraph(this) + "\n\tparents = " + node.getParentsOfNextNode());
        }
        if (node != null && !node.hasChildGraph(this) && (vector = node.getParentsOfNextNode()) != null) {
            return this.newNode(engine, string, node, vector);
        }
        return this.newNode(engine, string, node, null);
    }

    Node newNode(Engine engine, String string, Node node, Vector vector) {
        Core.DEBUG(3, "NewNode:\n\tname = " + string + "\n\tprev = " + node + "\n\tparents = " + vector);
        try {
            boolean bl = false;
            String[] stringArray = null;
            String[] stringArray2 = null;
            int n = 0;
            while (n < this.nodes.length) {
                if (this.nodes[n][0].equals(string)) {
                    bl = true;
                    if (this.nodes[n].length % 2 != 1) {
                        Core.USER_ERROR("Improperly specified graph description " + this.description + "at node " + this.nodes[n][0]);
                    }
                    int n2 = 0;
                    int n3 = 1;
                    while (n3 < this.nodes[n].length) {
                        if (n3 == 1) {
                            stringArray = new String[(this.nodes[n].length - 1) / 2];
                            stringArray2 = new String[(this.nodes[n].length - 1) / 2];
                        }
                        stringArray[n2] = this.nodes[n][n3++];
                        stringArray2[n2] = this.nodes[n][n3++];
                        ++n2;
                    }
                    break;
                }
                ++n;
            }
            if (!bl) {
                Core.USER_ERROR("Improperly specified graph description " + this.description + ": No definintion for node " + string);
                return null;
            }
            Class<?> clazz = Class.forName(string);
            this.last_node = (Node)clazz.newInstance();
            if (vector != null) {
                this.last_node.set(this, stringArray, stringArray2, node, vector);
            } else {
                this.last_node.set(this, stringArray, stringArray2, node);
            }
            engine.notifyNodeMonitors(this.last_node, 0);
            return this.last_node;
        }
        catch (Exception exception) {
            Core.USER_ERROR("Error in graph specification " + this.description + "\nException: " + exception);
            return null;
        }
    }

    boolean allow_exec() {
        return this.state != 3;
    }

    boolean allow_backtrack(Node node) {
        return node != this.begin_node || this.node_wakeup_key == null;
    }

    protected boolean exec() {
        Core.ERROR(null, 1, (Object)this);
        return false;
    }

    final void setState(Engine engine, int n) {
        this.state = n;
        engine.notifyGraphMonitors(this, 2);
    }

    protected void finalize() {
        if (this.context != null) {
            this.context.Engine().notifyGraphMonitors(this, 1);
        }
    }
}

