/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.outtrays;

import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Iterator;
import javax.agent.Envelope;
import javax.naming.Context;
import javax.naming.InitialContext;
import zeus.actors.MailBox;
import zeus.actors.OutTray;
import zeus.actors.PostMan;
import zeus.actors.factories.TransportFactory;
import zeus.actors.factories.TransportFactoryMethod;
import zeus.actors.factories.TransportUnsupportedException;
import zeus.actors.outtrays.UnsuitableMessageException;
import zeus.concepts.Address;
import zeus.concepts.FIPAPerformative;
import zeus.concepts.FIPA_AID_Address;
import zeus.util.Queue;
import zeus.util.SystemProps;

public class FIPA_PostMan
extends PostMan {
    protected Context initialNamingContext = null;
    private FileWriter log;
    private File file = null;

    public FIPA_PostMan(MailBox mailBox, Queue queue, Queue queue2, Address address) {
        this.mbox = mailBox;
        this.outMail = queue;
        this.ccMail = queue2;
        this.myAddress = address;
        if (queue2 == null) {
            this.setPriority(5);
        }
        try {
            this.initialNamingContext = new InitialContext();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setName("FIPA_PostMan");
        this.start();
    }

    public void run() {
        boolean bl = false;
        this.dispatching = true;
        try {
            this.file = new File(SystemProps.getProperty("http_root") + SystemProps.getProperty("out_log"));
            this.log = new FileWriter(this.file, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (this.dispatching) {
            try {
                FIPAPerformative fIPAPerformative = (FIPAPerformative)this.outMail.dequeue();
                bl = false;
                Enumeration enumeration = fIPAPerformative.getFIPAReceivers();
                while (enumeration.hasMoreElements() && !bl) {
                    try {
                        FIPA_AID_Address fIPA_AID_Address = (FIPA_AID_Address)enumeration.nextElement();
                        System.out.println(fIPAPerformative.toString());
                        bl = this.postFIPAMsg(fIPAPerformative, fIPA_AID_Address);
                        this.file.setLastModified(System.currentTimeMillis());
                    }
                    catch (Exception exception) {
                        System.out.println("exception in address, probably proprietary/ unhandled transport");
                        System.out.println("zeus is trying next address");
                        exception.printStackTrace();
                    }
                    catch (Error error) {
                        System.out.println("error in address, probably proprietary/ unhandled transport");
                        System.out.println("zeus is trying next address");
                        error.printStackTrace();
                    }
                    System.out.println("recs = " + enumeration.toString());
                    if (bl) {
                        System.out.println("done = true");
                        continue;
                    }
                    System.out.println("done = false");
                }
                System.out.println("iterating");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
    }

    public boolean postFIPAMsg(FIPAPerformative fIPAPerformative, FIPA_AID_Address fIPA_AID_Address) {
        try {
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator = fIPA_AID_Address.iterator();
            String string = new String();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.debug("trying : " + string);
                TransportFactoryMethod transportFactoryMethod = new TransportFactoryMethod();
                TransportFactory transportFactory = transportFactoryMethod.getTransportFactory();
                transportFactory.setLog(this.file);
                try {
                    OutTray outTray = transportFactory.getTransport(string);
                    Envelope envelope = fIPAPerformative.jasEnvelope(fIPA_AID_Address, string);
                    outTray.send(envelope);
                    return true;
                }
                catch (TransportUnsupportedException transportUnsupportedException) {
                    transportUnsupportedException.printStackTrace();
                }
                catch (UnsuitableMessageException unsuitableMessageException) {
                    unsuitableMessageException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void debug(String string) {
    }
}

