/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.intrays;

import java.util.Enumeration;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.MailBox;
import zeus.actors.PostMan;
import zeus.actors.Server;
import zeus.actors.intrays.Zeus_ACC_Server;
import zeus.actors.outtrays.FIPA_PostMan;
import zeus.concepts.Address;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_AddressBook;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.HSet;
import zeus.util.KeyValue;
import zeus.util.Queue;

public class Zeus_ACC_MailBox
extends MailBox {
    private FIPA_AddressBook addressBook;
    protected Queue fipaOut = new Queue("fipaOut");
    protected Zeus_ACC_Server fipaServer;

    public Zeus_ACC_MailBox(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        this.addressBook = new FIPA_AddressBook();
        agentContext.set(this.addressBook);
        this.fipaServer = new Zeus_ACC_Server(agentContext, this);
        this.server = new Server(agentContext, this, this.inMail);
        this.myAddress = this.server.getAddress();
        this.postman = new PostMan[3];
        this.postman[0] = new PostMan(this, this.outMail, this.ccMail, this.myAddress);
        this.postman[1] = new PostMan(this, this.ccMail, this.myAddress);
        this.postman[2] = new FIPA_PostMan(this, this.fipaOut, this.ccMail, this.myAddress);
        String string = agentContext.newId();
        String[] stringArray = new String[]{"type", "inform", "in-reply-to", string};
        agentContext.MsgHandler().addRule(new MessageRuleImpl(agentContext.newId("Rule"), stringArray, 0, this, "register"));
        int n2 = 0;
        while (n2 < agentContext.nameservers().size()) {
            Address address = (Address)agentContext.nameservers().elementAt(n2);
            agentContext.AddressBook().add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string);
            performative.setContent("register");
            this.sendMsg(performative);
            ++n2;
        }
    }

    public FIPA_PostMan getFIPA_PostMan() {
        return (FIPA_PostMan)this.postman[2];
    }

    public Zeus_ACC_Server getZeus_ACC_Server() {
        return this.fipaServer;
    }

    public InTray getInTray() {
        return this.fipaServer;
    }

    public boolean is_FIPA(String string) {
        return this.addressBook.lookupFIPA(string) != null;
    }

    public FIPA_AID_Address FIPA_Lookup(String string) {
        return this.addressBook.lookupAlias(string);
    }

    public String addressSought(String string) {
        KeyValue keyValue;
        double d = this.context.now();
        Enumeration enumeration = this.asTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            keyValue = (KeyValue)this.asTable.get(string2);
            if (!(d - keyValue.value >= this.context.getAddressBookRefresh())) continue;
            this.asTable.remove(string2);
            this.context.MsgHandler().removeRule(keyValue.key);
        }
        keyValue = (KeyValue)this.asTable.get(string);
        if (keyValue == null) {
            String string3 = this.context.newId();
            String[] stringArray = new String[]{"type", "inform", "in-reply-to", string3};
            this.context.MsgHandler().addRule(new MessageRuleImpl(string3, stringArray, 0, this, "addressReceived"));
            int n = 0;
            while (n < this.context.nameservers().size()) {
                Address address = (Address)this.context.nameservers().elementAt(n);
                Performative performative = new Performative("query-ref");
                performative.setReceiver(address.getName());
                performative.setReplyWith(string3);
                performative.setContent("address_of " + string);
                this.sendMsg(performative);
                ++n;
            }
            d = this.context.now();
            if (!this.context.nameservers().isEmpty()) {
                this.asTable.put(string, new KeyValue(string3, d += this.context.getAddressTimeout()));
                return string3;
            }
            return null;
        }
        if (keyValue.value > this.context.now()) {
            return keyValue.key;
        }
        return null;
    }

    public void addressReceived(Performative performative) {
        String string = performative.getInReplyTo();
        Address address = ZeusParser.address(performative.getContent());
        this.add(address);
        this.asTable.remove(address.getName());
        int n = 0;
        while (n < this.postman.length) {
            this.postman[n].addressReceived(string);
            ++n;
        }
    }
}

