/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.intrays;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.MailBox;
import zeus.actors.MsgHandler;
import zeus.concepts.Address;
import zeus.concepts.Performative;
import zeus.concepts.PerformativeParser;
import zeus.concepts.ZeusAddress;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.Queue;
import zeus.util.Time;

public class NIOServer
extends Thread
implements InTray {
    public static final int MAX_CONNECTIONS = 1;
    public static final int MAX_QUEUE_LENGTH = 100;
    public static final int DEFAULT_PORT_MIN = 6700;
    public static final int DEFAULT_PORT_MAX = 7800;
    public int maxMessageSize = 100000;
    protected ServerSocket listenSocket;
    protected Address address;
    protected int connection_count = 0;
    protected boolean processing;
    private AgentContext context = null;
    private ByteBuffer buffer = ByteBuffer.allocate(this.maxMessageSize);
    protected long timeout = -1L;
    protected Queue inMail;
    protected MailBox mbox;
    protected MsgHandler msgHandler = null;
    Selector selector;
    ServerSocketChannel server;
    SelectionKey key;
    SelectionKey serverKey;
    private LinkedList clients;
    private Selector readSelector;
    ServerSocket socket;

    public NIOServer() {
    }

    public NIOServer(AgentContext agentContext, MailBox mailBox, Queue queue) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            Core.DEBUG(4, "Ip Address is: " + inetAddress);
            boolean bl = false;
            int n = 6700;
            while (!bl && n < 7800) {
                this.clients = new LinkedList();
                this.readSelector = Selector.open();
                this.server = ServerSocketChannel.open();
                this.socket = this.server.socket();
                this.socket.bind(new InetSocketAddress(n), 100);
                this.server.configureBlocking(false);
                bl = true;
                this.address = new ZeusAddress(agentContext.whoami(), string, n, agentContext.whatami());
                agentContext.AddressBook().add(this.address);
                ++n;
            }
            if (!bl) {
                System.err.println("Cannot get a port for listening");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mbox = mailBox;
        this.setName("Normal server");
        this.start();
    }

    public AgentContext getAgentContext() {
        return this.mbox.getAgentContext();
    }

    public synchronized void updateCount(int n) {
        this.debug("update count");
        this.connection_count += n;
        if (n < 0) {
            this.debug("notifying");
            this.notify();
        }
    }

    public void stopProcessing() {
        this.processing = false;
    }

    public void lowerStatus() {
        this.setPriority(3);
        this.timeout = 1000L;
    }

    public void normalStatus() {
        this.setPriority(5);
        this.timeout = 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.processing = true;
        while (this.processing) {
            Exception exception3;
            Object var4_2;
            this.debug("alive");
            try {
                try {
                    while (true) {
                        SocketChannel socketChannel;
                        if ((socketChannel = this.server.accept()) != null) {
                            this.registerClient(socketChannel);
                        }
                        this.serviceClients();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    Core.DEBUG(3, "Exception listening for connections: " + exception2);
                    var4_2 = null;
                    try {
                        this.server.socket().close();
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                var4_2 = null;
                try {
                    this.server.socket().close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void serviceClients() throws IOException {
        block4: {
            try {
                if (this.readSelector.select(1L) <= 0) break block4;
                Set<SelectionKey> set = this.readSelector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (!selectionKey.isReadable()) continue;
                    SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                    this.buffer.clear();
                    int n = socketChannel.read(this.buffer);
                    if (n >= 0) {
                        PerformativeParser performativeParser = new PerformativeParser(new ByteArrayInputStream(this.buffer.array()));
                        Performative performative = performativeParser.Message();
                        this.newMsg(performative);
                        continue;
                    }
                    if (n >= 0) continue;
                    this.clients.remove(socketChannel);
                    socketChannel.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void registerClient(SocketChannel socketChannel) throws IOException {
        socketChannel.configureBlocking(false);
        socketChannel.register(this.readSelector, 1);
        this.clients.add(socketChannel);
    }

    protected void finalize() {
        try {
            if (this.listenSocket != null) {
                this.listenSocket.close();
            }
        }
        catch (IOException iOException) {}
    }

    public Address getAddress() {
        return this.address;
    }

    public void newMsg(Performative performative) {
        AgentContext agentContext = this.getAgentContext();
        this.debug("1");
        Time time = agentContext.currentTime();
        if (time != null) {
            performative.setReceiveTime(time);
        }
        this.debug("2");
        Address address = performative.getAddress();
        if (address != null) {
            agentContext.AddressBook().add(address);
        }
        this.debug("3");
        if (this.msgHandler == null) {
            this.msgHandler = agentContext.getMsgHandler();
        }
        Core.DEBUG(3, "putting message from " + performative.getSender() + " on handler queue");
        this.debug("4");
        this.msgHandler.processMessage(performative);
        this.debug("5");
        this.mbox.notifyMonitors(performative, 0);
        this.debug("6");
    }

    public String getResponseAddress() {
        return this.address.toString();
    }

    public void debug(String string) {
        System.out.println("Server>> " + string);
    }
}

