/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.graphs;

import java.util.Vector;
import zeus.actors.ExternalDb;
import zeus.actors.ProtocolDbResult;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.actors.rtn.util.StrategyEvaluator;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.util.Misc;

public class SimpleInitiatorEvaluator
extends StrategyEvaluator {
    protected static final double round_time = 0.1;
    double min;
    double max;
    double noquibble;
    double cost = 0.0;
    double price = 0.0;
    double offer = 0.0;
    double start_time = 0.0;
    double end_time = 0.0;
    double rate = 0.0;

    public int evaluateFirst(Vector vector, ProtocolDbResult protocolDbResult) {
        this.goals = vector;
        this.protocolInfo = protocolDbResult;
        this.min = this.getDoubleParam("min.percent", 80.0) / 100.0;
        this.max = this.getDoubleParam("max.percent", 120.0) / 100.0;
        this.noquibble = this.getDoubleParam("noquibble.range", 2.0);
        Goal goal = (Goal)vector.elementAt(0);
        ExternalDb externalDb = this.context.ExternalDb();
        this.end_time = goal.getReplyTime().getTime() - 0.1;
        this.start_time = this.context.now();
        this.cost = goal.getCost();
        if (Misc.isZero(this.cost)) {
            Fact fact = goal.getFact();
            this.cost = fact.getNetCost();
        }
        this.min *= this.cost;
        this.max *= this.cost;
        double d = this.getDoubleParam("reservation.price", Double.MAX_VALUE);
        this.max = Math.min(this.max, d);
        this.price = (int)this.min;
        this.rate = Math.log(this.max / this.min) / (this.end_time - this.start_time);
        goal.setCost(this.price);
        return 3;
    }

    public int evaluateNext(DelegationStruct delegationStruct) {
        this.goals = delegationStruct.goals;
        if (!delegationStruct.msg_type.equals("propose")) {
            return 1;
        }
        Goal goal = (Goal)delegationStruct.goals.elementAt(0);
        this.offer = goal.getCost();
        if (this.offer < this.price + this.noquibble) {
            return 0;
        }
        double d = this.context.now() - this.start_time;
        this.price = (int)(this.min * Math.exp(this.rate * d));
        if (this.offer < this.price + this.noquibble) {
            return 0;
        }
        if (this.context.now() + 0.1 >= this.end_time) {
            if (this.offer < this.max) {
                return 0;
            }
            return 1;
        }
        goal.setCost(this.price);
        return 3;
    }
}

