/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.factories;

import zeus.actors.OutTray;
import zeus.actors.factories.NotFoundException;
import zeus.util.SystemProps;

public class ConnectionPool {
    public int MAX_CONNECTIONS = Integer.parseInt(SystemProps.getProperty("num.connections"));
    private OutTray[] connections = new OutTray[this.MAX_CONNECTIONS];
    private String[] keys = new String[this.MAX_CONNECTIONS];
    private int write = 0;

    public OutTray getConnection(String string) throws NotFoundException {
        int n = 0;
        while (n < this.MAX_CONNECTIONS) {
            if (this.keys[n] != null && this.keys[n].equals(string)) {
                return this.connections[n];
            }
            ++n;
        }
        throw new NotFoundException();
    }

    public void addConnection(String string, OutTray outTray) {
        if (this.write >= this.MAX_CONNECTIONS) {
            this.write = 0;
        }
        this.connections[this.write] = outTray;
        this.keys[this.write] = string;
        ++this.write;
    }
}

