/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors.event;

import zeus.util.Assert;

public abstract class Event {
    protected static final int FACT_FIRST = 0;
    protected static final int FACT_LAST = 3;
    protected static final int TASK_FIRST = 4;
    protected static final int TASK_LAST = 7;
    protected static final int ABILITY_FIRST = 8;
    protected static final int ABILITY_LAST = 11;
    protected static final int RELATION_FIRST = 12;
    protected static final int RELATION_LAST = 15;
    protected static final int MESSAGE_FIRST = 16;
    protected static final int MESSAGE_LAST = 19;
    protected static final int AGENT_FIRST = 20;
    protected static final int AGENT_LAST = 23;
    protected static final int PLANNING_FIRST = 24;
    protected static final int PLANNING_LAST = 26;
    protected static final int PLANSTEP_FIRST = 27;
    protected static final int PLANSTEP_LAST = 29;
    protected static final int CLOCK_FIRST = 30;
    protected static final int CLOCK_LAST = 30;
    protected static final int HANDLER_FIRST = 31;
    protected static final int HANDLER_LAST = 34;
    protected static final int NODE_FIRST = 35;
    protected static final int NODE_LAST = 38;
    protected static final int ARC_FIRST = 39;
    protected static final int ARC_LAST = 42;
    protected static final int GRAPH_FIRST = 43;
    protected static final int GRAPH_LAST = 46;
    protected static final int PROTOCOL_FIRST = 47;
    protected static final int PROTOCOL_LAST = 50;
    protected static final int CONVERSATION_FIRST = 51;
    protected static final int CONVERSATION_LAST = 52;
    protected static final int RETE_FIRST = 53;
    protected static final int RETE_LAST = 57;
    public static final int MAX_ID = 57;
    public static final long NULL_MASK = 0L;
    public static final long ALL_MASK = -1L;
    protected static final String[] event_type = new String[]{"FactAddedEvent", "FactModifiedEvent", "FactDeletedEvent", "FactAccessedEvent", "TaskAddedEvent", "TaskModifiedEvent", "TaskDeletedEvent", "TaskAccessedEvent", "AbilityAddedEvent", "AbilityModifiedEvent", "AbilityDeletedEvent", "AbilityAccessedEvent", "RelationAddedEvent", "RelationModifiedEvent", "RelationDeletedEvent", "RelationAccessedEvent", "MessageReceivedEvent", "MessageQueuedEvent", "MessageDispatchedEvent", "MessageNotDispatchedEvent", "AgentCreatedEvent", "AgentDeathEvent", "AgentSuspendedEvent", "AgentResumedEvent", "PlanningStartedEvent", "PlanningFailedEvent", "PlanningSucceededEvent", "PlanStepCreatedEvent", "PlanStepDisposedEvent", "PlanStepStateChangedEvent", "ClockTickEvent", "MessageRuleAddedEvent", "MessageRuleDeletedEvent", "MessageRuleFiredEvent", "MessageRuleFailedEvent", "NodeCreatedEvent", "NodeDisposedEvent", "NodeStateChangedEvent", "ArcCreatedEvent", "ArcDisposedEvent", "ArcFailedEvent", "ArcSucceededEvent", "GraphCreatedEvent", "GraphDisposedEvent", "GraphStateChangedEvent", "ProtocolAddedEvent", "ProtocolModifiedEvent", "ProtocolDeletedEvent", "ProtocolAccessedEvent", "ConversationInitiatedEvent", "ConversationContinuedEvent", "ReteRuleAddedEvent", "ReteRuleDeletedEvent", "ReteRuleActivatedEvent", "ReteRuleDeactivatedEvent", "ReteRuleFiredEvent"};
    protected long time = 0L;
    protected int id = -1;
    protected Object source = null;
    protected Object object = null;

    public long getTime() {
        return this.time;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return event_type[this.id];
    }

    public Object getSource() {
        return this.source;
    }

    public Object getObject() {
        return this.object;
    }

    protected Event(Object object, Object object2, int n, int n2, long l) {
        this.id = (int)(Math.log(l) / Math.log(2.0)) + n;
        Assert.notNull(object);
        Assert.notNull(object2);
        Assert.notFalse(0 <= n && n <= this.id && this.id <= n2 && n2 <= 57);
        this.time = System.currentTimeMillis();
        this.source = object;
        this.object = object2;
    }

    public String toString() {
        return this.getDescription() + ":\n\tTime: " + this.time + "\n\tSource: " + this.source + "\n\tObject: " + this.object;
    }
}

