/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.OrganisationDb;
import zeus.actors.event.TaskEvent;
import zeus.actors.event.TaskMonitor;
import zeus.concepts.AbilitySpec;
import zeus.concepts.AttributeList;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.Task;
import zeus.concepts.fn.ArithmeticFn;
import zeus.concepts.fn.ConstraintFn;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.HSet;
import zeus.util.SystemProps;

public class TaskDb
extends Hashtable {
    protected HSet[] eventMonitor = new HSet[4];
    public static final int MODIFY = 0;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int ACCESS = 3;
    public static final int NONE = 4;
    protected static Random rand = new Random(System.currentTimeMillis());
    protected static int CMIN = 10;
    protected static int CMAX = 50;
    protected boolean demo_version = false;
    protected String agentName = null;
    protected OrganisationDb orgDb = null;
    protected AgentContext context = null;
    protected GenSym gensym = null;

    public TaskDb() {
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        String string = SystemProps.getProperty("demo.version");
        this.demo_version = Boolean.valueOf(string);
    }

    public TaskDb(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        this.agentName = agentContext.whoami();
        this.orgDb = agentContext.getOrganisationDb();
        this.gensym = agentContext.getGenSym();
        agentContext.set(this);
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        String string = SystemProps.getProperty("demo.version");
        this.demo_version = Boolean.valueOf(string);
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void add(Task task) {
        Assert.notNull(task);
        this.debug("LOADED TASK NAME " + task.getName());
        Fact[] factArray = task.getPostconditions();
        Fact[] factArray2 = task.getPreconditions();
        this.resolvePreconditions(task, factArray2, factArray);
        this.resolveCostAndTime(task, factArray2, factArray);
        int n = this.addItem(factArray, task);
        if (n != 4) {
            this.notifyMonitors(task, n);
        }
    }

    public void resolveCostAndTime(Task task, Fact[] factArray, Fact[] factArray2) {
        ValueFunction valueFunction = task.getTimeFn();
        ValueFunction valueFunction2 = task.getCostFn();
        this.debug("time = " + valueFunction.getClass().toString());
        this.debug("cost = " + valueFunction2.getClass().toString());
        if (valueFunction instanceof ArithmeticFn) {
            this.resolveall((ArithmeticFn)valueFunction, task, factArray);
            this.resolveall((ArithmeticFn)valueFunction, task, factArray2);
        }
        if (valueFunction2 instanceof ArithmeticFn) {
            this.resolveall((ArithmeticFn)valueFunction2, task, factArray);
            this.resolveall((ArithmeticFn)valueFunction2, task, factArray2);
        }
    }

    public void resolveall(ArithmeticFn arithmeticFn, Task task, Fact[] factArray) {
        this.debug("in resolveall");
        int n = 0;
        while (n < factArray.length) {
            Fact fact = factArray[n];
            this.debug("doing " + fact.toString());
            AttributeList attributeList = fact.getAttributeList();
            String[] stringArray = attributeList.getNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                arithmeticFn.resolve(fact.ID() + "." + stringArray[n2], fact.getFn(stringArray[n2]));
                this.debug(arithmeticFn.toString());
                ++n2;
            }
            ++n;
        }
    }

    public void resolvePreconditions(Task task, Fact[] factArray, Fact[] factArray2) {
        int n = 0;
        while (n < factArray.length) {
            Fact fact = factArray[n];
            AttributeList attributeList = fact.getAttributeList();
            String[] stringArray = attributeList.getNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.debug("before checknmap" + attributeList.toString());
                this.checkAndMapValue(stringArray[n2], attributeList, factArray2);
                this.debug("after checknmap " + attributeList.toString());
                ++n2;
            }
            ++n;
        }
        if (task instanceof PrimitiveTask) {
            ((PrimitiveTask)task).setPreconditions(factArray);
            ((PrimitiveTask)task).setPostconditions(factArray2);
        }
    }

    public void checkAndMapValue(String string, AttributeList attributeList, Fact[] factArray) {
        String string2 = attributeList.getValue(string);
        if (string2.startsWith("?var")) {
            return;
        }
        int n = 0;
        while (n < factArray.length) {
            Fact fact = factArray[n];
            String string3 = fact.getId();
            this.debug(string3 + " - " + string2);
            int n2 = 0;
            while (n2 < string2.length() - string3.length()) {
                if (string2.regionMatches(n2, string3, 0, string3.length())) {
                    this.debug("match");
                    String string4 = string2.substring(n2 + string3.length() + 1, string2.length());
                    string4 = string4.replace(')', ' ');
                    string4 = string4.trim();
                    String string5 = string2.substring(0, n2);
                    String string6 = fact.getValue(string4);
                    ValueFunction valueFunction = fact.getFn(string4);
                    this.debug("postVal = " + string6);
                    if (string6 != null) {
                        Object object;
                        ValueFunction valueFunction2;
                        ValueFunction valueFunction3 = attributeList.getFn(string);
                        if (valueFunction3 instanceof VarFn) {
                            ((VarFn)valueFunction3).arg = string6;
                            attributeList.remove(string);
                            attributeList.setValue(string, valueFunction3);
                        } else if (valueFunction3 instanceof ConstraintFn) {
                            valueFunction2 = (ConstraintFn)valueFunction3;
                            ((ConstraintFn)valueFunction2).arg = valueFunction;
                            int n3 = ((ConstraintFn)valueFunction2).getOperator();
                            object = ConstraintFn.operators[n3];
                            ConstraintFn constraintFn = new ConstraintFn((String)object, ((ConstraintFn)valueFunction2).arg);
                            this.debug(constraintFn.toString());
                            attributeList.remove(string);
                            attributeList.setValue(string, constraintFn);
                        } else if (valueFunction3 instanceof ArithmeticFn) {
                            valueFunction2 = (ArithmeticFn)valueFunction3;
                            ((ArithmeticFn)valueFunction2).resolve(string6, valueFunction);
                            ValueFunction valueFunction4 = ((ArithmeticFn)valueFunction2).getLHS();
                            this.debug("LHS = " + valueFunction4.toString() + " class " + valueFunction4.getClass());
                            object = ((ArithmeticFn)valueFunction2).getRHS();
                            this.debug("RHS = " + object.toString() + " class " + object.getClass());
                            int n4 = ((ArithmeticFn)valueFunction2).getOperator();
                            String string7 = ArithmeticFn.operators[n4];
                            ArithmeticFn arithmeticFn = new ArithmeticFn(valueFunction4, (ValueFunction)object, string7);
                            attributeList.remove(string);
                            attributeList.setValue(string, arithmeticFn);
                        } else {
                            this.debug("NOT recognised >>>" + valueFunction3.getClass().toString());
                        }
                        this.debug("attrs in checknmap " + attributeList.toString());
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void add(Vector vector) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.add((Task)vector.elementAt(n));
            ++n;
        }
    }

    public void add(Task[] taskArray) {
        int n = 0;
        while (taskArray != null && n < taskArray.length) {
            this.add(taskArray[n]);
            ++n;
        }
    }

    protected int addItem(Vector vector, Task task) {
        int n = 4;
        int n2 = 0;
        while (n2 < vector.size()) {
            n = Math.min(n, this.addItem((Fact)vector.elementAt(n2), task));
            ++n2;
        }
        return n;
    }

    protected int addItem(Fact[] factArray, Task task) {
        int n = 4;
        int n2 = 0;
        while (n2 < factArray.length) {
            n = Math.min(n, this.addItem(factArray[n2], task));
            ++n2;
        }
        return n;
    }

    protected int addItem(Fact fact, Task task) {
        int n = 4;
        if (fact.isLocal()) {
            return n;
        }
        String string = fact.getType();
        Hashtable<String, Task> hashtable = (Hashtable<String, Task>)this.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Task>();
            this.put(string, hashtable);
        }
        int n2 = n = hashtable.put(task.getName(), task) != null ? 0 : 1;
        if (this.orgDb != null) {
            AbilitySpec abilitySpec = new AbilitySpec(task.getName(), fact, 0, 0.0);
            OrganisationDb organisationDb = this.orgDb;
            organisationDb.add(this.agentName, abilitySpec);
        }
        return n;
    }

    public void del(Task task) {
        Assert.notNull(task);
        Fact[] factArray = task.getPostconditions();
        int n = this.deleteItem(factArray, task);
        if (n != 4) {
            this.notifyMonitors(task, n);
        }
    }

    public void del(Vector vector) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.del((Task)vector.elementAt(n));
            ++n;
        }
    }

    public void del(Task[] taskArray) {
        int n = 0;
        while (taskArray != null && n < taskArray.length) {
            this.del(taskArray[n]);
            ++n;
        }
    }

    protected int deleteItem(Vector vector, Task task) {
        int n = 4;
        int n2 = 0;
        while (n2 < vector.size()) {
            n = Math.min(n, this.deleteItem((Fact)vector.elementAt(n2), task));
            ++n2;
        }
        return n;
    }

    protected int deleteItem(Fact[] factArray, Task task) {
        int n = 4;
        int n2 = 0;
        while (n2 < factArray.length) {
            n = Math.min(n, this.deleteItem(factArray[n2], task));
            ++n2;
        }
        return n;
    }

    protected int deleteItem(Fact fact, Task task) {
        int n = 4;
        String string = fact.getType();
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            return n;
        }
        int n2 = n = hashtable.remove(task.getName()) != null ? 2 : 4;
        if (hashtable.isEmpty()) {
            this.remove(string);
        }
        if (this.orgDb != null) {
            AbilitySpec abilitySpec = new AbilitySpec(task.getName(), fact, 0, 0.0);
            OrganisationDb organisationDb = this.orgDb;
            organisationDb.del(this.agentName, abilitySpec);
        }
        return n;
    }

    public Task getTask(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Task task = (Task)hashtable.get(string);
            this.notifyMonitors(task, 3);
            if (task == null) continue;
            Task task2 = (Task)task.duplicate("var", this.gensym);
            this.debug("Duplicate = " + task2.toString());
            this.debug("Original = " + task.toString());
            return task;
        }
        return null;
    }

    public void deleteTask(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Task task = (Task)hashtable.remove(string);
            if (task == null) continue;
            this.notifyMonitors(task, 2);
        }
    }

    public Task findOne(Fact fact) {
        Task task = null;
        Vector vector = this.findAll(fact);
        if (!vector.isEmpty()) {
            int n = (int)(Math.random() * (double)vector.size());
            task = (Task)vector.elementAt(n);
            this.notifyMonitors(task, 3);
        }
        vector = null;
        return task;
    }

    public Vector findAll(Fact fact) {
        Hashtable hashtable = (Hashtable)this.get(fact.getType());
        if (hashtable == null) {
            return new Vector();
        }
        return this.reduce(hashtable, fact);
    }

    public Vector findAll(Fact fact, Vector vector) {
        Core.DEBUG(3, "TaskDb findAll(2)");
        Core.DEBUG(3, "tFact = " + fact);
        Core.DEBUG(3, "tPath = " + vector);
        Vector vector2 = this.findAll(fact);
        return this.checkPath(vector2, vector);
    }

    public Vector findAll(Fact[] factArray, Fact[] factArray2, Vector vector) {
        Core.DEBUG(3, "TaskDb findAll(3)");
        Assert.notFalse(factArray2.length > 0);
        Core.DEBUG(3, factArray);
        Core.DEBUG(3, factArray2);
        Core.DEBUG(3, vector);
        int n = -1;
        int n2 = 0;
        while (n == -1 && n2 < factArray2.length) {
            if (!factArray2[n2].isSideEffect()) {
                n = n2;
            }
            ++n2;
        }
        Assert.notFalse(n != -1);
        Vector vector2 = this.findAll(factArray2[n]);
        Vector<Task> vector3 = new Vector<Task>();
        int n3 = 0;
        while (n3 < vector2.size()) {
            Task task = (Task)vector2.elementAt(n3);
            Fact[] factArray3 = task.getPreconditions();
            Fact[] factArray4 = task.getPostconditions();
            if (this.hasCondition(factArray, factArray3) && this.hasCondition(factArray2, factArray4)) {
                vector3.addElement(task);
            }
            ++n3;
        }
        return this.checkPath(vector3, vector);
    }

    protected boolean hasCondition(Fact[] factArray, Fact[] factArray2) {
        boolean bl = true;
        int n = 0;
        while (bl && n < factArray.length) {
            bl &= this.hasCondition(factArray[n], factArray2);
            ++n;
        }
        return bl;
    }

    protected boolean hasCondition(Fact fact, Fact[] factArray) {
        Bindings bindings = new Bindings(this.agentName);
        int n = 0;
        while (n < factArray.length) {
            if (factArray[n].unifiesWith(fact, bindings)) {
                return true;
            }
            ++n;
            bindings.clear();
        }
        return false;
    }

    protected Vector checkPath(Vector vector, Vector vector2) {
        Core.DEBUG(3, "Checking path...");
        Core.DEBUG(3, "tprior = " + vector);
        if (vector.isEmpty()) {
            return vector;
        }
        Vector<Task> vector3 = new Vector<Task>();
        Bindings bindings = new Bindings(this.agentName);
        int n = 0;
        while (n < vector.size()) {
            Task task = (Task)vector.elementAt(n);
            this.notifyMonitors(task, 3);
            boolean bl = true;
            Fact[] factArray = task.getPreconditions();
            int n2 = 0;
            while (bl && n2 < factArray.length) {
                int n3 = 0;
                while (bl && n3 < vector2.size()) {
                    Fact fact = (Fact)vector2.elementAt(n3);
                    bl = bl && !factArray[n2].unifiesWith(fact, bindings);
                    ++n3;
                    bindings.clear();
                }
                ++n2;
            }
            if (bl) {
                vector3.addElement(task);
            }
            ++n;
        }
        vector = null;
        Core.DEBUG(3, "posterior = " + vector3);
        return vector3;
    }

    protected Vector reduce(Hashtable hashtable, Fact fact) {
        Vector<Task> vector = new Vector<Task>();
        Bindings bindings = new Bindings(this.agentName);
        Enumeration enumeration = hashtable.elements();
        block0: while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            this.notifyMonitors(task, 3);
            Task task2 = (Task)task.duplicate("var", this.gensym);
            Fact[] factArray = task2.getPostconditions();
            Core.DEBUG(3, "TASK_IS\n" + task2.pprint());
            int n = 0;
            while (n < factArray.length) {
                Core.DEBUG(3, "TaskDb reduce(): unifying\n\trequired =\n" + fact.pprint() + "\n\tproduced =\n" + factArray[n].pprint());
                if (factArray[n].unifiesWith(fact, bindings) && task2.applyConstraints(bindings)) {
                    Core.DEBUG(3, "After apply Constraints:\n" + task2);
                    Core.DEBUG(3, "Bindings is\n" + bindings);
                    if (task2.isPrimitive()) {
                        ((PrimitiveTask)task2).setActiveEffect(n);
                    }
                    vector.addElement(task2);
                    if (!this.demo_version || !task2.isPrimitive()) continue block0;
                    task2.setCostFn(Integer.toString(CMIN + Math.abs(rand.nextInt() % (CMAX - CMIN))));
                    continue block0;
                }
                ++n;
                bindings.clear();
            }
        }
        this.sort(vector);
        return vector;
    }

    protected void sort(Vector vector) {
        Vector<Task> vector2 = new Vector<Task>();
        int n = 0;
        while (n < vector.size()) {
            Task task = (Task)vector.elementAt(n);
            this.notifyMonitors(task, 3);
            if (task.isPrimitive()) {
                vector2.addElement(task);
                vector.removeElementAt(n--);
            }
            ++n;
        }
        this.sort_basic(vector);
        this.sort_basic(vector2);
        int n2 = 0;
        while (n2 < vector2.size()) {
            vector.addElement(vector2.elementAt(n2));
            ++n2;
        }
        vector2 = null;
    }

    protected void sort_basic(Vector vector) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < vector.size() - 1) {
                Task task = (Task)vector.elementAt(n);
                this.notifyMonitors(task, 3);
                Task task2 = (Task)vector.elementAt(n + 1);
                this.notifyMonitors(task2, 3);
                if (task.getCost() > task2.getCost() || task.getCost() == task2.getCost() && task.getTime() > task2.getTime()) {
                    vector.setElementAt(task2, n);
                    vector.setElementAt(task, n + 1);
                    bl = true;
                }
                ++n;
            }
        }
    }

    public void addTaskMonitor(TaskMonitor taskMonitor, long l, boolean bl) {
        this.addTaskMonitor(taskMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                Task task = (Task)enumeration2.nextElement();
                TaskEvent taskEvent = new TaskEvent(this, task, 8L);
                taskMonitor.taskAccessedEvent(taskEvent);
                taskEvent = new TaskEvent(this, task, 1L);
                taskMonitor.taskAddedEvent(taskEvent);
            }
        }
    }

    public void addTaskMonitor(TaskMonitor taskMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[1].add(taskMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[0].add(taskMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(taskMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(taskMonitor);
        }
    }

    public void removeTaskMonitor(TaskMonitor taskMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[1].remove(taskMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[0].remove(taskMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(taskMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(taskMonitor);
        }
    }

    protected void notifyMonitors(Task task, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 1: {
                TaskEvent taskEvent = new TaskEvent(this, task, 1L);
                while (enumeration.hasMoreElements()) {
                    TaskMonitor taskMonitor = (TaskMonitor)enumeration.nextElement();
                    taskMonitor.taskAddedEvent(taskEvent);
                }
                break;
            }
            case 0: {
                TaskEvent taskEvent = new TaskEvent(this, task, 2L);
                while (enumeration.hasMoreElements()) {
                    TaskMonitor taskMonitor = (TaskMonitor)enumeration.nextElement();
                    taskMonitor.taskModifiedEvent(taskEvent);
                }
                break;
            }
            case 2: {
                TaskEvent taskEvent = new TaskEvent(this, task, 4L);
                while (enumeration.hasMoreElements()) {
                    TaskMonitor taskMonitor = (TaskMonitor)enumeration.nextElement();
                    taskMonitor.taskDeletedEvent(taskEvent);
                }
                break;
            }
            case 3: {
                TaskEvent taskEvent = new TaskEvent(this, task, 8L);
                while (enumeration.hasMoreElements()) {
                    TaskMonitor taskMonitor = (TaskMonitor)enumeration.nextElement();
                    taskMonitor.taskAccessedEvent(taskEvent);
                }
                break;
            }
        }
    }

    private void debug(String string) {
    }
}

