/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.DataRec;
import zeus.actors.ExternalDb;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.actors.event.FactEvent;
import zeus.actors.event.FactMonitor;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ResourceItem;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.HSet;

public class ResourceDb
extends Hashtable {
    private HSet[] eventMonitor = new HSet[4];
    private static final int ADD = 0;
    private static final int MODIFY = 1;
    private static final int DELETE = 2;
    private static final int ACCESS = 3;
    protected AgentContext context = null;
    protected String name = null;
    protected Planner planner = null;
    protected OntologyDb ontologyDb = null;
    protected GenSym gensym = null;

    public ResourceDb() {
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
    }

    public ResourceDb(AgentContext agentContext) {
        this.context = agentContext;
        this.name = agentContext.whoami();
        this.gensym = agentContext.GenSym();
        this.planner = agentContext.getPlanner();
        this.ontologyDb = agentContext.getOntologyDb();
        agentContext.set(this);
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGenSym(GenSym genSym) {
        this.gensym = genSym;
    }

    public void setOntologyDb(OntologyDb ontologyDb) {
        this.ontologyDb = ontologyDb;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public boolean isGenSymSet() {
        return this.gensym != null;
    }

    public boolean isPlannerSet() {
        return this.planner != null;
    }

    public boolean isOntologyDbSet() {
        return this.ontologyDb != null;
    }

    public boolean isContextSet() {
        return this.context != null;
    }

    public boolean isSet() {
        if (this.isContextSet()) {
            return true;
        }
        if (!this.isGenSymSet()) {
            System.out.println("gensym not set");
            return false;
        }
        if (!this.isPlannerSet()) {
            System.out.println("planner not set");
            return false;
        }
        if (!this.isOntologyDbSet()) {
            System.out.println("ontologydb not set");
            return false;
        }
        if (!this.isNameSet()) {
            System.out.println("name not set");
            return false;
        }
        return true;
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public synchronized ResourceItem add(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.add((Fact)vector.elementAt(n));
            ++n;
        }
        return null;
    }

    public synchronized ResourceItem add(Fact[] factArray) {
        int n = 0;
        while (n < factArray.length) {
            this.add(factArray[n]);
            ++n;
        }
        return null;
    }

    public synchronized ResourceItem add(Fact fact) {
        ResourceItem resourceItem;
        String string = fact.getType();
        Vector<ResourceItem> vector = (Vector<ResourceItem>)this.get(string);
        if (vector == null) {
            vector = new Vector<ResourceItem>();
            this.put(string, vector);
        }
        if (string.equals("Money") && !vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                resourceItem = (ResourceItem)vector.elementAt(n);
                this.notifyMonitors(resourceItem, 3);
                if (!resourceItem.isReserved()) {
                    Fact fact2 = resourceItem.getFact();
                    fact2.resolve(new Bindings(this.name));
                    PrimitiveNumericFn primitiveNumericFn = (PrimitiveNumericFn)((Object)fact2.getFn("amount"));
                    double d = primitiveNumericFn.doubleValue();
                    fact.resolve(new Bindings(this.name));
                    primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
                    double d3 = primitiveNumericFn.doubleValue();
                    double d4 = d + d3;
                    if (d4 == 0.0) {
                        vector.removeElementAt(n--);
                        resourceItem.deleted();
                        this.notifyMonitors(resourceItem, 2);
                        if (vector.isEmpty()) {
                            this.remove(string);
                        }
                        return null;
                    }
                    vector.removeElementAt(n--);
                    resourceItem.deleted();
                    this.notifyMonitors(resourceItem, 2);
                    fact2.setValue("amount", d4);
                    fact2.resolve(new Bindings(this.name));
                    vector.addElement(resourceItem);
                    this.notifyMonitors(resourceItem, 0);
                    return resourceItem;
                }
                ++n;
            }
        }
        resourceItem = new ResourceItem(fact);
        vector.addElement(resourceItem);
        this.notifyMonitors(resourceItem, 0);
        return resourceItem;
    }

    synchronized void replaceOrAdd(Fact fact) {
        ExternalDb externalDb = this.context.ExternalDb();
        if (externalDb == null || !externalDb.put(fact)) {
            this.add(fact);
        }
    }

    public synchronized void del(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.del((Fact)vector.elementAt(n));
            ++n;
        }
    }

    public synchronized void del(Fact[] factArray) {
        int n = 0;
        while (n < factArray.length) {
            this.del(factArray[n]);
            ++n;
        }
    }

    public synchronized void del(Fact fact) {
        String string = fact.getType();
        Vector vector = (Vector)this.get(string);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(n);
            Fact fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (fact2.equals(fact)) {
                vector.removeElementAt(n--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
            }
            ++n;
        }
        if (vector.isEmpty()) {
            this.remove(string);
        }
    }

    public synchronized void modify(Fact fact, Fact fact2) {
        this.del(fact);
        this.add(fact2);
    }

    public void free(DataRec dataRec) {
        if (dataRec == null) {
            return;
        }
        Vector vector = dataRec.available();
        ExternalDb externalDb = this.context.ExternalDb();
        int n = 0;
        while (n < vector.size()) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(n);
            resourceItem.cancelReservation(dataRec);
            Fact fact = resourceItem.getFact();
            if (externalDb != null && !resourceItem.isReserved() && externalDb.put(fact)) {
                vector.removeElementAt(n--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
            }
            ++n;
        }
        dataRec.free();
    }

    public void consume(DataRec dataRec) {
        if (dataRec == null) {
            return;
        }
        Vector vector = dataRec.available();
        int n = 0;
        while (n < vector.size()) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(n);
            Fact fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            this.notifyMonitors(resourceItem, 2);
            Vector vector2 = (Vector)this.get(fact.getType());
            switch (resourceItem.consumed(dataRec)) {
                case 0: {
                    this.notifyMonitors(resourceItem, 0);
                    break;
                }
                case 1: {
                    this.notifyMonitors(resourceItem, 0);
                    break;
                }
                case 2: {
                    vector2.removeElement(resourceItem);
                    if (!vector2.isEmpty()) break;
                    this.remove(resourceItem.getFact().getType());
                }
            }
            ++n;
        }
    }

    public int findAll(PlanRecord planRecord, int n, int n2) {
        Core.ERROR(n2 > 0, 1001, (Object)this);
        DataRec dataRec = planRecord.getDatarec(n);
        int n3 = planRecord.getStartTime();
        return this.reserve(dataRec, planRecord, n3, n2);
    }

    public int reserve(DataRec dataRec, PlanRecord planRecord, int n, int n2) {
        int n3;
        Fact fact;
        ResourceItem resourceItem;
        ExternalDb externalDb = this.context.ExternalDb();
        Fact fact2 = dataRec.getFact();
        boolean bl = !fact2.isReadOnly();
        Vector vector = (Vector)this.get(fact2.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Bindings bindings = new Bindings(this.name);
        int n4 = 0;
        while (n2 > 0 && n4 < vector.size()) {
            resourceItem = (ResourceItem)vector.elementAt(n4);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            Core.DEBUG(2, "Fact before test \n" + fact);
            bindings.clear();
            int n5 = resourceItem.unreservedAmount(n, bl);
            if (n5 > 0 && fact.unifiesWith(fact2, bindings) && planRecord.applyConstraints(bindings)) {
                n3 = Math.min(n5, n2);
                Core.ERROR(dataRec.add(resourceItem, n, n3), 1002, (Object)this);
                if (bl) {
                    planRecord.updateCost((double)n3 * fact.getUnitCost());
                }
                n2 -= n3;
                Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
            }
            ++n4;
        }
        if (n2 > 0 && externalDb != null) {
            Enumeration enumeration = externalDb.all(fact2);
            while (enumeration != null && enumeration.hasMoreElements() && n2 > 0) {
                fact = (Fact)enumeration.nextElement();
                bindings.clear();
                if (!fact.unifiesWith(fact2, bindings) || !planRecord.applyConstraints(bindings)) continue;
                int n6 = fact.getNumber();
                Fact fact3 = externalDb.remove(fact);
                if (fact3 != null) {
                    resourceItem = this.add(fact3);
                    n3 = Math.min(n6, n2);
                    Core.ERROR(dataRec.add(resourceItem, n, n3), 1003, (Object)this);
                    if (bl) {
                        planRecord.updateCost((double)n3 * fact3.getUnitCost());
                    }
                    n2 -= n3;
                    Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                    Core.DEBUG(2, "Fact:\n" + fact3 + "\nassigned to datarec " + dataRec.getId());
                    continue;
                }
                Core.USER_ERROR("Improperly defined externalDb: fact \"" + fact + "\" should be in externaldb, but not found");
            }
        }
        return n2;
    }

    public synchronized int reserve(DataRec dataRec, int n, int n2) {
        int n3;
        Object object;
        Fact fact;
        ResourceItem resourceItem;
        ExternalDb externalDb = this.context.ExternalDb();
        Fact fact2 = dataRec.getFact();
        boolean bl = !fact2.isReadOnly();
        Vector vector = (Vector)this.get(fact2.getType());
        if (vector == null) {
            vector = new Vector();
        }
        int n4 = 0;
        while (n2 > 0 && n4 < vector.size()) {
            resourceItem = (ResourceItem)vector.elementAt(n4);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            object = new Bindings(this.name);
            int n5 = resourceItem.unreservedAmount(n, bl);
            if (n5 > 0 && fact.unifiesWith(fact2, (Bindings)object)) {
                n3 = Math.min(n5, n2);
                Core.ERROR(dataRec.add(resourceItem, n, n3), 1005, (Object)this);
                n2 -= n3;
                Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
            }
            ++n4;
        }
        if (n2 > 0 && externalDb != null) {
            object = externalDb.all(fact2);
            while (object.hasMoreElements() && n2 > 0) {
                Bindings bindings;
                fact = (Fact)object.nextElement();
                if (!fact.unifiesWith(fact2, bindings = new Bindings(this.name))) continue;
                int n6 = fact.getNumber();
                fact = externalDb.remove(fact);
                resourceItem = this.add(fact);
                n3 = Math.min(n6, n2);
                Core.ERROR(dataRec.add(resourceItem, n, n3), 1006, (Object)this);
                n2 -= n3;
                Core.DEBUG(2, "Required to find Fact:\n" + fact2);
                Core.DEBUG(2, "Fact:\n" + fact + "\nassigned to datarec " + dataRec.getId());
            }
        }
        return n2;
    }

    public Vector allocateResources(PlanRecord planRecord) {
        Vector<Goal> vector = new Vector<Goal>();
        PrimitiveTask primitiveTask = planRecord.getTask();
        Fact[][] factArray = primitiveTask.orderPreconditions();
        int n = 0;
        while (n < factArray.length) {
            int n2 = 0;
            while (n2 < factArray[n].length) {
                Goal goal;
                int n3;
                int n4;
                if (!factArray[n][n2].isNegative() && (n4 = planRecord.noRequiredItems(n3 = primitiveTask.getConsumedPos(factArray[n][n2]))) > 0 && (goal = this.allocateResource(planRecord, n3, n4)) != null) {
                    vector.addElement(goal);
                }
                ++n2;
            }
            if (!vector.isEmpty()) break;
            ++n;
        }
        return vector;
    }

    public Goal allocateResource(PlanRecord planRecord, int n, int n2) {
        if ((n2 = this.findAll(planRecord, n, n2)) > 0) {
            if (!this.isPlannerSet()) {
                if (!this.isContextSet()) {
                    try {
                        throw new Exception("Planner and AgentContext not set in ResourceDb.\n Agent is improperly initialised, sorry");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.planner = this.context.getPlanner();
                }
            }
            Planner planner = this.planner;
            this.debug("planner = " + planner);
            DataRec dataRec = planRecord.getDatarec(n);
            Fact fact = dataRec.getFact();
            int n3 = planner.anySideEffect(fact, planRecord, n, n2);
            if (n3 != 0) {
                Fact fact2 = new Fact(fact);
                fact2.setNumber(n3);
                return planRecord.createSubgoal(fact2, n);
            }
        }
        return null;
    }

    public synchronized Fact debit(double d) {
        PrimitiveNumericFn primitiveNumericFn;
        Fact fact;
        ResourceItem resourceItem;
        Core.DEBUG(3, "About to debit: " + d);
        Core.ERROR(d >= 0.0, 1006, (Object)this);
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact2 = ontologyDb.getFact(false, "Money");
        fact2.setValue("amount", d);
        Vector vector = (Vector)this.get("Money");
        int n = 0;
        while (vector != null && d > 0.0 && n < vector.size()) {
            resourceItem = (ResourceItem)vector.elementAt(n);
            this.notifyMonitors(resourceItem, 3);
            if (!resourceItem.isReserved()) {
                fact = resourceItem.getFact();
                fact.resolve(new Bindings(this.name));
                primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
                double d3 = primitiveNumericFn.doubleValue();
                if (d3 > d) {
                    Fact fact3 = fact.duplicate("var", this.gensym);
                    fact3.setValue("amount", d3 - d);
                    fact3.resolve(new Bindings(this.name));
                    vector.removeElementAt(n--);
                    resourceItem.deleted();
                    this.notifyMonitors(resourceItem, 2);
                    fact.setValue("amount", d);
                    ResourceItem resourceItem2 = new ResourceItem(fact3);
                    vector.addElement(resourceItem2);
                    this.notifyMonitors(resourceItem2, 0);
                    Core.DEBUG(3, "Debit completed: " + fact2);
                    return fact2;
                }
                if (d3 >= 0.0) {
                    vector.removeElementAt(n--);
                    resourceItem.deleted();
                    this.notifyMonitors(resourceItem, 2);
                    d -= d3;
                }
            }
            ++n;
        }
        if (d > 0.0) {
            boolean bl = false;
            int n2 = 0;
            while (vector != null && !bl && n2 < vector.size()) {
                resourceItem = (ResourceItem)vector.elementAt(n2);
                this.notifyMonitors(resourceItem, 3);
                if (!resourceItem.isReserved()) {
                    fact = resourceItem.getFact();
                    fact.resolve(new Bindings(this.name));
                    primitiveNumericFn = (PrimitiveNumericFn)((Object)fact.getFn("amount"));
                    double d4 = primitiveNumericFn.doubleValue();
                    vector.removeElementAt(n2--);
                    resourceItem.deleted();
                    this.notifyMonitors(resourceItem, 2);
                    fact.setValue("amount", d4 - d);
                    fact.resolve(new Bindings(this.name));
                    vector.addElement(resourceItem);
                    this.notifyMonitors(resourceItem, 0);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                fact = ontologyDb.getFact(false, "Money");
                fact.setValue("amount", 0.0 - d);
                fact.resolve(new Bindings(this.name));
                this.add(fact);
            }
        }
        Core.DEBUG(3, "Debit completed: " + fact2);
        return fact2;
    }

    public synchronized Fact evalLocal(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray.length == 0) {
            return null;
        }
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact2 = new Fact(factArray[0]);
        int n = 1;
        while (n < factArray.length) {
            Core.ERROR(fact2.disjoin(factArray[n]), 1008, (Object)this);
            ++n;
        }
        return fact2;
    }

    public synchronized boolean evalNegative(Fact fact) {
        Fact[] factArray = this.all(fact);
        return factArray.length == 0;
    }

    public synchronized Fact[] all(String string) {
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact = ontologyDb.getFact(true, string);
        return this.all(fact);
    }

    public synchronized Fact[] all(Fact fact) {
        Fact[] factArray;
        ExternalDb externalDb = this.context.ExternalDb();
        Vector vector = (Vector)this.get(fact.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Vector<Fact> vector2 = new Vector<Fact>();
        Bindings bindings = new Bindings(this.name);
        int n = 0;
        while (n < vector.size()) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(n);
            Fact fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (fact2.unifiesWith(fact, bindings)) {
                vector2.addElement(fact2);
            }
            ++n;
            bindings.clear();
        }
        if (externalDb != null) {
            factArray = externalDb.all(fact);
            while (factArray.hasMoreElements()) {
                vector2.addElement((Fact)factArray.nextElement());
            }
        }
        factArray = new Fact[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            factArray[n2] = (Fact)vector2.elementAt(n2);
            ++n2;
        }
        return factArray;
    }

    public synchronized void deleteAll(String string) {
        Fact fact;
        ResourceItem resourceItem;
        Vector vector = (Vector)this.get(string);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            resourceItem = (ResourceItem)vector.elementAt(n);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            if (!resourceItem.isReserved()) {
                vector.removeElementAt(n--);
                resourceItem.deleted();
                this.notifyMonitors(resourceItem, 2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            resourceItem = (ResourceItem)vector.elementAt(n2);
            fact = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            vector.removeElementAt(n2--);
            resourceItem.deleted();
            this.notifyMonitors(resourceItem, 2);
            ++n2;
        }
    }

    public synchronized Fact any(String string) {
        OntologyDb ontologyDb = this.ontologyDb;
        Fact fact = ontologyDb.getFact(true, string);
        return this.any(fact);
    }

    public synchronized Fact any(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray == null) {
            return null;
        }
        int n = (int)(Math.random() * (double)factArray.length);
        if (n > factArray.length - 1) {
            return fact;
        }
        return factArray[n];
    }

    public synchronized boolean contains(Fact fact, int n) {
        int n2;
        Fact fact2;
        ExternalDb externalDb = this.context.ExternalDb();
        Vector vector = (Vector)this.get(fact.getType());
        if (vector == null) {
            vector = new Vector();
        }
        Bindings bindings = new Bindings(this.name);
        int n3 = fact.getNumber();
        boolean bl = !fact.isReadOnly();
        int n4 = 0;
        while (n3 > 0 && n4 < vector.size()) {
            ResourceItem resourceItem = (ResourceItem)vector.elementAt(n4);
            fact2 = resourceItem.getFact();
            this.notifyMonitors(resourceItem, 3);
            n2 = resourceItem.unreservedAmount(n, bl);
            if (n2 > 0 && fact2.unifiesWith(fact, bindings)) {
                n3 -= Math.min(n2, n3);
            }
            ++n4;
            bindings.clear();
        }
        if (n3 > 0 && externalDb != null) {
            Enumeration enumeration = externalDb.all(fact);
            while (enumeration.hasMoreElements() && n3 > 0) {
                fact2 = (Fact)enumeration.nextElement();
                n2 = fact2.getNumber();
                n3 -= Math.min(n2, n3);
            }
        }
        return n3 <= 0;
    }

    public void addFactMonitor(FactMonitor factMonitor, long l, boolean bl) {
        this.addFactMonitor(factMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            int n = 0;
            while (n < vector.size()) {
                ResourceItem resourceItem = (ResourceItem)vector.elementAt(n);
                FactEvent factEvent = new FactEvent(this, resourceItem, 8L);
                factMonitor.factAccessedEvent(factEvent);
                factEvent = new FactEvent(this, resourceItem, 1L);
                factMonitor.factAddedEvent(factEvent);
                ++n;
            }
        }
    }

    public void addFactMonitor(FactMonitor factMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(factMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(factMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(factMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(factMonitor);
        }
    }

    public void removeFactMonitor(FactMonitor factMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(factMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(factMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(factMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(factMonitor);
        }
    }

    private void notifyMonitors(ResourceItem resourceItem, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 1L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factAddedEvent(factEvent);
                }
                break;
            }
            case 1: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 2L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factModifiedEvent(factEvent);
                }
                break;
            }
            case 2: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 4L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factDeletedEvent(factEvent);
                }
                break;
            }
            case 3: {
                FactEvent factEvent = new FactEvent(this, resourceItem, 8L);
                while (enumeration.hasMoreElements()) {
                    FactMonitor factMonitor = (FactMonitor)enumeration.nextElement();
                    factMonitor.factAccessedEvent(factEvent);
                }
                break;
            }
        }
    }

    private void debug(String string) {
    }
}

