/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.OrganisationDb;
import zeus.actors.ProtocolDbNode;
import zeus.actors.ProtocolDbResult;
import zeus.actors.event.ProtocolEvent;
import zeus.actors.event.ProtocolMonitor;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.StrategyInfo;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.Tree;
import zeus.util.TreeNode;

public class ProtocolDb
extends Tree {
    protected Hashtable factIndex;
    private HSet[] eventMonitor = new HSet[4];
    private static final int ADD = 0;
    private static final int MODIFY = 1;
    private static final int DELETE = 2;
    private static final int ACCESS = 3;
    private static final int FAIL = 0;
    private static final int ANY = 1;
    private static final int RELATION = 2;
    private static final int AGENT = 4;
    Hashtable protocolInfoList;
    AgentContext context;

    public ProtocolDb() {
        super(new ProtocolDbNode("dummy"));
    }

    public ProtocolDb(OntologyDb ontologyDb) {
        super(new ProtocolDbNode(ontologyDb.getRoot().toString()));
        String string = ontologyDb.getRoot().toString();
        this.factIndex = new Hashtable();
        this.factIndex.put(string, this.root);
        this.createTree(this.getRoot(), ontologyDb.getRoot());
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        this.protocolInfoList = new Hashtable();
    }

    public ProtocolDb(AgentContext agentContext) {
        super(new ProtocolDbNode(agentContext.OntologyDb().getRoot().toString()));
        this.context = agentContext;
        agentContext.set(this);
        String string = agentContext.OntologyDb().getRoot().toString();
        this.factIndex = new Hashtable();
        this.factIndex.put(string, this.root);
        this.createTree(this.getRoot(), agentContext.OntologyDb().getRoot());
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        this.protocolInfoList = new Hashtable();
    }

    protected void createTree(TreeNode treeNode, TreeNode treeNode2) {
        Vector vector = treeNode2.getChildren();
        int n = 0;
        while (n < vector.size()) {
            TreeNode treeNode3 = (TreeNode)vector.elementAt(n);
            TreeNode treeNode4 = new TreeNode(new ProtocolDbNode(treeNode3.toString()));
            treeNode.addChild(treeNode4);
            this.factIndex.put(treeNode3.toString(), treeNode4);
            this.createTree(treeNode4, treeNode3);
            ++n;
        }
    }

    public void addProtocol(ProtocolInfo protocolInfo) {
        this.addProtocol(protocolInfo, false);
    }

    public void addProtocol(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.addProtocol((ProtocolInfo)vector.elementAt(n), false);
            ++n;
        }
    }

    private void addProtocol(ProtocolInfo protocolInfo, boolean bl) {
        Core.DEBUG(3, "addProtocol");
        Core.DEBUG(3, protocolInfo);
        StrategyInfo[] strategyInfoArray = protocolInfo.getConstraints();
        int n = 0;
        while (n < strategyInfoArray.length) {
            String string = strategyInfoArray[n].getFact().getType();
            TreeNode treeNode = (TreeNode)this.factIndex.get(string);
            Core.DEBUG(3, "a_node = " + treeNode);
            ProtocolDbNode protocolDbNode = (ProtocolDbNode)treeNode.getValue();
            protocolDbNode.addProtocol(protocolInfo.getName(), strategyInfoArray[n]);
            ++n;
        }
        this.protocolInfoList.put(protocolInfo.getName(), protocolInfo);
        if (!bl) {
            this.notifyMonitors(protocolInfo, 0);
            this.notifyMonitors(protocolInfo, 3);
        }
    }

    public void removeProtocol(ProtocolInfo protocolInfo) {
        this.removeProtocol(protocolInfo, false);
    }

    public void removeProtocol(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.removeProtocol((ProtocolInfo)vector.elementAt(n), false);
            ++n;
        }
    }

    private void removeProtocol(ProtocolInfo protocolInfo, boolean bl) {
        String string = protocolInfo.getName();
        Enumeration enumeration = this.values();
        while (enumeration.hasMoreElements()) {
            ProtocolDbNode protocolDbNode = (ProtocolDbNode)enumeration.nextElement();
            protocolDbNode.deleteProtocol(string);
        }
        this.protocolInfoList.remove(string);
        if (!bl) {
            this.notifyMonitors(protocolInfo, 2);
            this.notifyMonitors(protocolInfo, 3);
        }
    }

    public void modifyProtocol(ProtocolInfo protocolInfo) {
        this.removeProtocol(protocolInfo, true);
        this.addProtocol(protocolInfo, true);
        this.notifyMonitors(protocolInfo, 1);
        this.notifyMonitors(protocolInfo, 3);
    }

    public Vector getProtocols(Fact fact, String[] stringArray, String string) {
        Core.DEBUG(3, "getProtocols");
        Core.DEBUG(3, fact);
        Core.DEBUG(3, stringArray);
        Core.DEBUG(3, string);
        TreeNode treeNode = (TreeNode)this.factIndex.get(fact.getType());
        Hashtable hashtable = new Hashtable();
        Core.DEBUG(3, "a_node0 = " + treeNode);
        while (treeNode != null) {
            Core.DEBUG(3, "a_node = " + treeNode);
            ProtocolDbNode protocolDbNode = (ProtocolDbNode)treeNode.getValue();
            Vector vector = protocolDbNode.getProtocols();
            Core.DEBUG(3, vector);
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                Vector vector2 = protocolDbNode.getStrategy(string2);
                Core.DEBUG(3, vector2);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    StrategyInfo strategyInfo = (StrategyInfo)vector2.elementAt(n2);
                    Core.DEBUG(3, strategyInfo);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        int n4;
                        ProtocolInfo protocolInfo = (ProtocolInfo)this.protocolInfoList.get(string2);
                        if (protocolInfo.getType().equals(string) && (n4 = this.constraintsOK(fact, stringArray[n3], strategyInfo)) != 0) {
                            if (strategyInfo.getType() == 0) {
                                this.addToResultSet(new ProtocolDbResult(stringArray[n3], string2, strategyInfo.getStrategy(), strategyInfo.getParameters()), n4, hashtable);
                            } else {
                                this.removeFromResultSet(stringArray[n3], string2, hashtable);
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            treeNode = treeNode.getParent();
        }
        return this.sortResultSet(hashtable);
    }

    private int constraintsOK(Fact fact, String string, StrategyInfo strategyInfo) {
        String[] stringArray;
        Core.DEBUG(3, "constraintsOK");
        Core.DEBUG(3, fact);
        Core.DEBUG(3, string);
        Core.DEBUG(3, strategyInfo);
        OrganisationDb organisationDb = this.context.OrganisationDb();
        Bindings bindings = this.context != null ? new Bindings(this.context.whoami()) : new Bindings();
        Fact fact2 = strategyInfo.getFact();
        if (!fact2.unifiesWithChild(fact, bindings)) {
            Core.DEBUG(3, "unifiesWithChild failed");
            Core.DEBUG(3, fact2);
            return 0;
        }
        int n = 1;
        String[] stringArray2 = strategyInfo.getAgents();
        if (stringArray2.length > 0) {
            if (!Misc.member(string, stringArray2)) {
                return 0;
            }
            n *= 4;
        }
        if ((stringArray = strategyInfo.getRelations()).length > 0) {
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < stringArray.length) {
                bl |= organisationDb.hasRelation(string, stringArray[n2]);
                ++n2;
            }
            if (!bl) {
                return 0;
            }
            n *= 2;
        }
        return n;
    }

    private void removeFromResultSet(String string, String string2, Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            int n = 0;
            while (n < vector.size()) {
                ProtocolDbResult protocolDbResult = (ProtocolDbResult)vector.elementAt(n);
                if (protocolDbResult.agent.equals(string) && protocolDbResult.protocol.equals(string2)) {
                    vector.removeElementAt(n--);
                }
                ++n;
            }
        }
    }

    private void addToResultSet(ProtocolDbResult protocolDbResult, int n, Hashtable hashtable) {
        String string = Integer.toString(n);
        Vector<ProtocolDbResult> vector = (Vector<ProtocolDbResult>)hashtable.get(string);
        if (vector == null) {
            vector = new Vector<ProtocolDbResult>();
            hashtable.put(string, vector);
        }
        vector.addElement(protocolDbResult);
    }

    private Vector sortResultSet(Hashtable hashtable) {
        Vector vector = new Vector();
        int n = 8;
        while (n > 0) {
            String string = Integer.toString(n);
            Vector vector2 = (Vector)hashtable.get(string);
            if (vector2 != null) {
                vector = Misc.union(vector, vector2);
            }
            n /= 2;
        }
        return vector;
    }

    public void addProtocolMonitor(ProtocolMonitor protocolMonitor, long l, boolean bl) {
        this.addProtocolMonitor(protocolMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.protocolInfoList.elements();
        while (enumeration.hasMoreElements()) {
            ProtocolInfo protocolInfo = (ProtocolInfo)enumeration.nextElement();
            ProtocolEvent protocolEvent = new ProtocolEvent(this, protocolInfo, 8L);
            protocolMonitor.protocolAccessedEvent(protocolEvent);
            protocolEvent = new ProtocolEvent(this, protocolInfo, 1L);
            protocolMonitor.protocolAddedEvent(protocolEvent);
        }
    }

    public void addProtocolMonitor(ProtocolMonitor protocolMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(protocolMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(protocolMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(protocolMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(protocolMonitor);
        }
    }

    public void removeProtocolMonitor(ProtocolMonitor protocolMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(protocolMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(protocolMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(protocolMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(protocolMonitor);
        }
    }

    private void notifyMonitors(ProtocolInfo protocolInfo, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                ProtocolEvent protocolEvent = new ProtocolEvent(this, protocolInfo, 1L);
                while (enumeration.hasMoreElements()) {
                    ProtocolMonitor protocolMonitor = (ProtocolMonitor)enumeration.nextElement();
                    protocolMonitor.protocolAddedEvent(protocolEvent);
                }
                break;
            }
            case 1: {
                ProtocolEvent protocolEvent = new ProtocolEvent(this, protocolInfo, 2L);
                while (enumeration.hasMoreElements()) {
                    ProtocolMonitor protocolMonitor = (ProtocolMonitor)enumeration.nextElement();
                    protocolMonitor.protocolModifiedEvent(protocolEvent);
                }
                break;
            }
            case 2: {
                ProtocolEvent protocolEvent = new ProtocolEvent(this, protocolInfo, 4L);
                while (enumeration.hasMoreElements()) {
                    ProtocolMonitor protocolMonitor = (ProtocolMonitor)enumeration.nextElement();
                    protocolMonitor.protocolDeletedEvent(protocolEvent);
                }
                break;
            }
            case 3: {
                ProtocolEvent protocolEvent = new ProtocolEvent(this, protocolInfo, 8L);
                while (enumeration.hasMoreElements()) {
                    ProtocolMonitor protocolMonitor = (ProtocolMonitor)enumeration.nextElement();
                    protocolMonitor.protocolAccessedEvent(protocolEvent);
                }
                break;
            }
        }
    }
}

