/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.StringTokenizer;
import java.util.Vector;
import zeus.actors.EffectChain;
import zeus.actors.PlanRecord;
import zeus.actors.ResourceDb;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.Bindings;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.Fact;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.PrimitiveTask;
import zeus.util.Assert;
import zeus.util.Core;

public class ProducedDb {
    protected Vector[] data = null;
    protected int[] produced = null;
    protected PlanRecord owner = null;

    public ProducedDb() {
    }

    public ProducedDb(PlanRecord planRecord, PrimitiveTask primitiveTask) {
        Assert.notNull(planRecord);
        this.produced = primitiveTask.numPostconditions();
        this.owner = planRecord;
        this.data = new Vector[this.produced.length];
    }

    public synchronized void add(int n, PlanRecord planRecord, int n2, String string, boolean bl) {
        EffectChain effectChain;
        Assert.notFalse(n >= 0 && n < this.data.length);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        if (planRecord != null) {
            int n3 = planRecord.getConsumedPosition(string);
            int n4 = planRecord.getStartTime();
            Assert.notFalse(this.availableItems(n, n4, bl) >= n2);
            effectChain = new EffectChain(planRecord, n3, n2, n4, bl);
            planRecord.replacePrecondition(string, this.owner, n, n2);
        } else {
            int n5 = this.owner.getEndTime();
            Assert.notFalse(this.availableItems(n, n5, bl) >= n2);
            effectChain = new EffectChain(string, n2, n5, bl);
        }
        this.data[n].addElement(effectChain);
    }

    public synchronized void add(int n, EffectChain effectChain) {
        Assert.notFalse(n >= 0 && n < this.data.length);
        Assert.notFalse(this.availableItems(n, effectChain.start, effectChain.consumed) >= effectChain.amount);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        this.data[n].addElement(effectChain);
    }

    public int noItemsProduced(int n) {
        return this.produced[n];
    }

    protected synchronized int availableItems(int n, int n2, boolean bl) {
        if (this.data[n] == null) {
            return this.produced[n];
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.data[n].size()) {
            EffectChain effectChain = (EffectChain)this.data[n].elementAt(n4);
            if (bl) {
                if (effectChain.consumed || effectChain.start > n2) {
                    n3 += effectChain.amount;
                }
            } else if (effectChain.consumed && effectChain.start <= n2) {
                n3 += effectChain.amount;
            }
            ++n4;
        }
        return this.produced[n] - n3;
    }

    public synchronized int anySideEffect(int n, PlanRecord planRecord, Object object, int n2) {
        int n3 = -1;
        String string = null;
        boolean bl = false;
        if (object instanceof String) {
            string = (String)object;
            n3 = planRecord.getConsumedPosition(string);
            bl = true;
        } else {
            n3 = (Integer)object;
        }
        int n4 = planRecord.getStartTime();
        boolean bl2 = planRecord.isPreconditionConsumed(n3);
        int n5 = this.availableItems(n, n4, bl2);
        if (n5 == 0) {
            return n2;
        }
        Core.DEBUG(2, "ProducedDb checking for serendipitous effects");
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        int n6 = n5 >= n2 ? n2 : n5;
        EffectChain effectChain = new EffectChain(planRecord, n3, n6, n4, bl2);
        this.data[n].addElement(effectChain);
        if (bl) {
            planRecord.replacePrecondition(string, this.owner, n, n6);
        } else {
            planRecord.chainPrecondition(this.owner, n, n6, n3);
        }
        return n2 - n6;
    }

    public synchronized void hardChain(int n, int n2, PlanRecord planRecord, int n3) {
        Core.DEBUG(2, "ProducedDb hardChain effects ...1");
        Core.DEBUG(2, this.owner.toString() + "::" + n);
        Core.DEBUG(2, " ==");
        Core.DEBUG(2, planRecord.toString() + "::" + n3);
        int n4 = planRecord.getStartTime();
        boolean bl = planRecord.isPreconditionConsumed(n3);
        int n5 = this.availableItems(n, n4, bl);
        if (n5 == 0) {
            System.err.println("ProducedDb hardChain effects: available == 0");
            return;
        }
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        int n6 = n5 >= n2 ? n2 : n5;
        EffectChain effectChain = new EffectChain(planRecord, n3, n6, n4, bl);
        this.data[n].addElement(effectChain);
        planRecord.chainPrecondition(this.owner, n, n6, n3);
    }

    public synchronized void hardChain(int n, String string, int n2, int n3, boolean bl) {
        Core.DEBUG(2, "ProducedDb hardChain effects ...2");
        Core.DEBUG(2, "effect_position: " + n);
        Core.DEBUG(2, "key: " + string);
        Core.DEBUG(2, "amount: " + n2);
        Core.DEBUG(2, "start: " + n3);
        Core.DEBUG(2, "consumed: " + bl);
        Assert.notFalse(n >= 0 && n < this.data.length);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        Core.DEBUG(2, "Current chains...");
        Core.DEBUG(2, this.data[n]);
        Assert.notFalse(this.availableItems(n, n3, bl) >= n2);
        EffectChain effectChain = new EffectChain(string, n2, n3, bl);
        this.data[n].addElement(effectChain);
    }

    public void allocatePostconditions(Fact[][] factArray) {
        this.debug(factArray.toString());
        int n = 0;
        while (n < factArray.length) {
            this.debug(factArray[n].toString());
            this.allocatePostcondition(n, factArray[n]);
            ++n;
        }
    }

    protected void allocatePostcondition(int n, Fact[] factArray) {
        Fact fact;
        EffectChain effectChain;
        Fact fact2 = factArray[0];
        this.debug("in producedDB " + String.valueOf(n));
        this.debug("in producedDB " + fact2.toString());
        int n2 = fact2.getNumber();
        if (n2 == 0) {
            Core.USER_ERROR("Warning: integer expected in .fact.no field.\nEnsure 'number' constraints are defined in all task specifications");
            return;
        }
        if (n2 < this.produced[n]) {
            Core.USER_ERROR("\nWarning: fewer items produced: " + n2 + " than expected " + this.produced[n]);
            Core.USER_ERROR(fact2.pprint());
        }
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        if (this.data[n] == null) {
            resourceDb.replaceOrAdd(fact2);
            return;
        }
        Engine engine = this.owner.getAgentContext().Engine();
        int n3 = 0;
        while (n2 > 0 && n3 < this.data[n].size()) {
            effectChain = (EffectChain)this.data[n].elementAt(n3);
            if (effectChain.isExternal() && n2 >= effectChain.amount) {
                if (effectChain.consumed) {
                    n2 -= effectChain.amount;
                }
                fact = new Fact(false, fact2);
                fact.setNumber(effectChain.amount);
                DelegationStruct delegationStruct = new DelegationStruct(this.owner.getAgentContext().whoami(), "result", effectChain.key, fact);
                this.debug(delegationStruct.toString());
                engine.add(delegationStruct);
            }
            ++n3;
        }
        if (n2 > 0) {
            fact2.setNumber(n2);
            resourceDb.replaceOrAdd(fact2);
        }
        int n4 = 0;
        while (n4 < this.data[n].size()) {
            effectChain = (EffectChain)this.data[n].elementAt(n4);
            if (!effectChain.isExternal()) {
                fact = new Fact(true, fact2);
                fact.setNumber(effectChain.amount);
                effectChain.record.preconditionExists(this.owner, n, effectChain.amount, effectChain.position);
            }
            ++n4;
        }
    }

    public boolean constrain(Bindings bindings) {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.data.length) {
            Vector vector = this.data[n];
            int n2 = 0;
            while (bl && vector != null && n2 < vector.size()) {
                EffectChain effectChain = (EffectChain)vector.elementAt(n2);
                if (!effectChain.isExternal()) {
                    bl &= effectChain.record.applyConstraints(bindings);
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public PlanRecord getOwner() {
        return this.owner;
    }

    public synchronized void share(ProducedDb producedDb, PlanRecord planRecord, String string, PlanRecord planRecord2, String string2) {
        int n = 0;
        while (n < this.produced.length) {
            int n2 = producedDb.noItemsProduced(n);
            int n3 = 0;
            while (n2 > 0 && n3 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n3);
                if (effectChain.amount <= n2) {
                    this.data[n].removeElementAt(n3--);
                    n2 -= effectChain.amount;
                } else {
                    effectChain.amount -= n2;
                    effectChain = new EffectChain(effectChain);
                    effectChain.amount = n2;
                    n2 = 0;
                }
                if (effectChain.isExternal()) {
                    if (effectChain.key.equals(string2)) {
                        effectChain.key = string;
                    }
                } else if (effectChain.record == planRecord2) {
                    effectChain.record = planRecord;
                }
                producedDb.add(n, effectChain);
                ++n3;
            }
            ++n;
        }
    }

    public synchronized boolean update(PlanRecord planRecord, PlanRecord planRecord2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (!effectChain.isExternal() && effectChain.record == planRecord2) {
                    effectChain.record = planRecord;
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean update(String string, String string2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (effectChain.isExternal() && effectChain.key.equals(string2)) {
                    effectChain.key = string;
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean replaceOrAdd(String string, String string2, int n, int n2, boolean bl) {
        EffectChain effectChain;
        int n3 = 0;
        while (n3 < this.data.length) {
            int n4 = 0;
            while (this.data[n3] != null && n4 < this.data[n3].size()) {
                effectChain = (EffectChain)this.data[n3].elementAt(n4);
                if (effectChain.isExternal() && effectChain.key.equals(string)) {
                    Core.DEBUG(2, effectChain);
                    if (effectChain.start == n && effectChain.amount == n2 && effectChain.consumed == bl) {
                        effectChain.key = string2;
                        return true;
                    }
                    if (effectChain.start <= n && effectChain.amount == n2 && effectChain.consumed && bl) {
                        effectChain.key = string2;
                        effectChain.start = n;
                        return true;
                    }
                    effectChain = new EffectChain(string2, n2, n, bl);
                    this.add(n3, effectChain);
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        effectChain = new EffectChain(string2, n2, n, bl);
        this.add(this.owner.getTask().getActiveEffectPos(), effectChain);
        return true;
    }

    public synchronized boolean hasAtMostOneParent(PlanRecord planRecord, String string) {
        Vector<PlanRecord> vector = new Vector<PlanRecord>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (effectChain.isExternal()) {
                    if (!vector2.contains(effectChain.key)) {
                        vector2.addElement(effectChain.key);
                    }
                } else if (!vector.contains(effectChain.record)) {
                    vector.addElement(effectChain.record);
                }
                ++n2;
            }
            ++n;
        }
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: parent = " + planRecord + " key = " + string);
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: records = " + vector);
        Core.DEBUG(3, "ProducedDb hasAtMostOneParent: keys = " + vector2);
        if (planRecord != null) {
            return vector2.isEmpty() && vector.size() == 1 && vector.contains(planRecord);
        }
        return vector.isEmpty() && vector2.size() == 1 && (vector2.contains(string) || vector2.contains(this.owner.getGoal().getId()));
    }

    public synchronized void remove(int n, PlanRecord planRecord, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.data[n].size()) {
            EffectChain effectChain = (EffectChain)this.data[n].elementAt(n4);
            if (effectChain.record == planRecord && effectChain.position == n2 && effectChain.amount == n3) {
                this.data[n].removeElementAt(n4--);
                return;
            }
            ++n4;
        }
        Assert.notNull(null);
    }

    public synchronized boolean references(PlanRecord planRecord) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (!effectChain.isExternal() && effectChain.record == planRecord) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized PlanRecord firstParent() {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (!effectChain.isExternal()) {
                    return effectChain.record;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public synchronized String firstKey() {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (effectChain.isExternal()) {
                    return effectChain.key;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public synchronized int firstPosition(PlanRecord planRecord) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (!effectChain.isExternal() && effectChain.record == planRecord) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        Assert.notNull(null);
        return -1;
    }

    public synchronized Vector getAllParents() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (!effectChain.isExternal()) {
                    vector.addElement(effectChain.record.getGoal().getId());
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(effectChain.key, "/");
                    vector.addElement(stringTokenizer.nextToken());
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public synchronized void notifyFailed(Vector vector, Vector vector2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                this.data[n].removeElementAt(n2--);
                if (effectChain.isExternal()) {
                    this.owner.raiseException(n, effectChain.key, effectChain.amount);
                } else if (effectChain.record == this.owner.getParent()) {
                    effectChain.record.reallocateResource(effectChain.position, this.owner, n, effectChain.amount, vector, vector2);
                } else {
                    effectChain.record.reallocateResource(effectChain.position, this.owner, n, effectChain.amount, null, null);
                }
                ++n2;
            }
            ++n;
        }
    }

    public synchronized void softNotifyFailed(Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, int n) {
        int n2 = 0;
        while (n2 < this.data.length) {
            int n3 = 0;
            while (this.data[n2] != null && n3 < this.data[n2].size()) {
                EffectChain effectChain = (EffectChain)this.data[n2].elementAt(n3);
                this.data[n2].removeElementAt(n3--);
                if (effectChain.isExternal()) {
                    this.owner.softRaiseException(n2, effectChain.key, effectChain.amount, plannerQueryStruct, n);
                } else if (effectChain.record == this.owner.getParent()) {
                    effectChain.record.softReallocateResource(effectChain.position, this.owner, n2, effectChain.amount, vector, vector2, plannerQueryStruct, n);
                } else {
                    effectChain.record.softReallocateResource(effectChain.position, this.owner, n2, effectChain.amount, null, null, plannerQueryStruct, n);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public String toString() {
        String string = "ProducedDb(\n" + this.owner + "\n";
        int n = 0;
        while (n < this.data.length) {
            if (this.data[n] != null) {
                string = string + "data[" + n + "]: " + this.data[n] + "\n";
            }
            ++n;
        }
        string = string + ")";
        return string;
    }

    public synchronized boolean setConsumers(String string, Vector vector) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                EffectChain effectChain = (EffectChain)this.data[n].elementAt(n2);
                if (effectChain.isExternal() && effectChain.key.equals(string)) {
                    if (!this.checkConsumers(effectChain.start, effectChain.amount, effectChain.consumed, vector)) {
                        return false;
                    }
                    this.data[n].removeElementAt(n2--);
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(n3);
                        effectChain = new EffectChain(consumerRecord.consumer_id, consumerRecord.amount, consumerRecord.start, consumerRecord.consumed);
                        this.data[n].addElement(effectChain);
                        ++n3;
                    }
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    protected synchronized boolean checkConsumers(int n, int n2, boolean bl, Vector vector) {
        Vector<ConsumerRecord> vector2 = new Vector<ConsumerRecord>();
        int n3 = 0;
        while (n3 < vector.size()) {
            ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(n3);
            if (consumerRecord.start < n || !this.checkCurrent(n2, vector2, consumerRecord.start, consumerRecord.consumed, consumerRecord.amount)) {
                return false;
            }
            vector2.addElement(consumerRecord);
            ++n3;
        }
        vector2 = null;
        return true;
    }

    protected synchronized boolean checkCurrent(int n, Vector vector, int n2, boolean bl, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector.size()) {
            ConsumerRecord consumerRecord = (ConsumerRecord)vector.elementAt(n5);
            if (bl) {
                if (consumerRecord.consumed || consumerRecord.start > n2) {
                    n4 += consumerRecord.amount;
                }
            } else if (consumerRecord.consumed && consumerRecord.start <= n2) {
                n4 += consumerRecord.amount;
            }
            ++n5;
        }
        return n - n4 >= n3;
    }

    public void debug(String string) {
    }
}

