/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ConsumedDb;
import zeus.actors.Decomposition;
import zeus.actors.ExecutionMonitor;
import zeus.actors.PlanDb;
import zeus.actors.PlanRecord;
import zeus.actors.ProducedDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.event.PlanStepEvent;
import zeus.actors.event.PlanStepMonitor;
import zeus.actors.event.PlanningEvent;
import zeus.actors.event.PlanningMonitor;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.BindResults;
import zeus.concepts.Bindings;
import zeus.concepts.ConsumerRecord;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PlannerEnactStruct;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ProducerRecord;
import zeus.concepts.SummaryTask;
import zeus.concepts.SuppliedDb;
import zeus.concepts.Task;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.Selector;
import zeus.util.Time;

public class Planner
extends PlanDb {
    private HSet[] eventMonitor = new HSet[6];
    public static final int START = 0;
    public static final int FAIL = 1;
    public static final int SUCCEED = 2;
    public static final int CREATE = 3;
    public static final int DISPOSE = 4;
    public static final int STATE_CHANGE = 5;
    public static final boolean EXPAND = true;
    public static final int REPLAN = 0;
    public static final int PLAN = 1;
    protected PlanRecord[][] table;
    protected int plannerWidth;
    protected int plannerLength;
    protected int now;
    protected Hashtable BindTable;
    protected boolean user_responded = false;
    protected long USER_TIME_OUT = 0L;
    protected AgentContext context = null;

    public Planner() {
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
    }

    public Planner(AgentContext agentContext, int n, int n2) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        agentContext.set(this);
        Core.ERROR(n2 > 0 && n > 0, 1005, (Object)this);
        this.table = new PlanRecord[n][n2];
        this.plannerLength = n2;
        this.plannerWidth = n;
        this.now = (int)this.now();
        this.BindTable = new Hashtable();
        int n3 = 0;
        while (n3 < this.eventMonitor.length) {
            this.eventMonitor[n3] = new HSet();
            ++n3;
        }
        this.USER_TIME_OUT = (long)(0.5 * (double)agentContext.getClockStep());
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public int getPlannerWidth() {
        return this.plannerWidth;
    }

    public int getPlannerLength() {
        return this.plannerLength;
    }

    int anySideEffect(Fact fact, PlanRecord planRecord, int n, int n2) {
        return this.anySideEffect(fact, planRecord, new Integer(n), n2);
    }

    int anySideEffect(Fact fact, PlanRecord planRecord, Object object, int n) {
        if (!this.context.getSharePlan()) {
            return n;
        }
        Core.DEBUG(2, "checking for serendipitous side-effects for " + fact);
        int n2 = fact.getNumber();
        int n3 = planRecord.getStartTime();
        if (fact.isa("Entity")) {
            fact.setNumber(fact.newVar());
        }
        Enumeration enumeration = this.elements();
        while (n > 0 && enumeration.hasMoreElements()) {
            PlanRecord planRecord2 = (PlanRecord)enumeration.nextElement();
            if (planRecord2 == planRecord || planRecord2.getEndTime() > n3) continue;
            n = planRecord2.anySideEffect(fact, planRecord, object, n);
        }
        fact.setNumber(n2);
        return n;
    }

    public PlannerQueryStruct canAchieve(Vector vector, String string) {
        Goal goal;
        Core.DEBUG(3, "\nCanAchieve:\n" + vector + "\n");
        PlannerQueryStruct plannerQueryStruct = new PlannerQueryStruct(vector);
        int n = 0;
        while (n < vector.size()) {
            goal = (Goal)vector.elementAt(n);
            this.notifyMonitors(goal, 0, 0);
            ++n;
        }
        plannerQueryStruct.timeout = this.context.getAcceptTimeout();
        if (this.loopFound(vector)) {
            Core.DEBUG(0, "CanAchieve loop found = " + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        double d = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < vector.size()) {
            goal = (Goal)vector.elementAt(n2);
            d = Math.min(d, goal.getConfirmTime().getTime());
            if (goal.getReplyTime() != null) {
                d3 = Math.min(d3, goal.getReplyTime().getTime());
            }
            ++n2;
        }
        double d4 = this.now();
        if (d4 >= Math.min(d, d3)) {
            Core.DEBUG(0, "CanAchieve rt/ct problem: " + d4 + "\n" + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        plannerQueryStruct.internal = this.schedule(string, null, new Vector(), vector, plannerQueryStruct, true);
        if (plannerQueryStruct.internal.isEmpty()) {
            Core.DEBUG(0, "CanAchieve = " + plannerQueryStruct);
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        double d5 = this.latestConfirmTime(vector);
        if (d5 < d) {
            Core.DEBUG(0, "CanAchieve lct < ct " + d4 + "\n" + plannerQueryStruct);
            this.reject(plannerQueryStruct.goals, plannerQueryStruct.internal);
            plannerQueryStruct.internal = new Vector();
            this.index(plannerQueryStruct);
            return plannerQueryStruct;
        }
        if (!plannerQueryStruct.internal.isEmpty() && !plannerQueryStruct.external.isEmpty()) {
            double d6 = Math.min(d, d3);
            d6 -= this.now();
            plannerQueryStruct.timeout = d6 = d6 / 2.0 * (double)plannerQueryStruct.external.size();
        }
        this.index(plannerQueryStruct);
        Core.DEBUG(0, "canAchieve = " + plannerQueryStruct);
        return plannerQueryStruct;
    }

    protected boolean loopFound(Vector vector) {
        Enumeration enumeration = this.BindTable.elements();
        Bindings bindings = new Bindings(this.context.whoami());
        while (enumeration.hasMoreElements()) {
            PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)enumeration.nextElement();
            Vector vector2 = plannerQueryStruct.goals;
            int n = 0;
            while (n < vector.size()) {
                Goal goal = (Goal)vector.elementAt(n);
                Fact fact = goal.getFact();
                String string = goal.getRootId();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Goal goal2 = (Goal)vector2.elementAt(n2);
                    if (goal2.getDesiredBy().equals(this.context.whoami())) {
                        Fact fact2 = goal2.getFact();
                        String string2 = goal2.getRootId();
                        if (string.equals(string2) && fact.unifiesWith(fact2, bindings)) {
                            Core.DEBUG(0, "Loop found: " + goal + "\n" + goal2);
                            return true;
                        }
                    }
                    ++n2;
                    bindings.clear();
                }
                ++n;
            }
        }
        return false;
    }

    public PlannerQueryStruct clear_bind(Vector vector) {
        if (vector.isEmpty()) {
            return null;
        }
        Core.DEBUG(3, "Entering Clear Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        return (PlannerQueryStruct)this.BindTable.remove(string);
    }

    public void reset_bind(Vector vector, PlannerQueryStruct plannerQueryStruct) {
        Core.DEBUG(3, "Entering Reset Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        Core.ERROR(this.BindTable.put(string, plannerQueryStruct) == null, 1009, (Object)this);
    }

    public Vector bind(Vector vector) {
        PlanRecord planRecord;
        Core.DEBUG(3, "Entering Final Bind goals\n" + vector + "\n");
        String string = this.makeIndex(vector);
        PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)this.BindTable.get(string);
        Core.DEBUG(3, "Final Bind checking record");
        int n = 0;
        while (n < plannerQueryStruct.internal.size()) {
            planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n);
            Bindings bindings = planRecord.getBindings();
            Core.ERROR(plannerQueryStruct.bindings.add(bindings), 1010, (Object)this);
            ++n;
        }
        Vector<Goal> vector2 = new Vector<Goal>();
        Core.DEBUG(3, "Final Bind checking costs");
        int n2 = 0;
        while (n2 < vector.size()) {
            Goal goal = new Goal((Goal)vector.elementAt(n2));
            goal.constrain(plannerQueryStruct.bindings);
            planRecord = this.lookUp(goal);
            goal.setCost(planRecord.getCost());
            vector2.addElement(goal);
            ++n2;
        }
        Core.DEBUG(3, "Exiting Final Bind goals\n" + vector2 + "\n");
        return vector2;
    }

    public synchronized void userResponded() {
        this.user_responded = true;
    }

    public BindResults bind(Vector vector, Vector vector2, int n) {
        Goal goal;
        PlanRecord planRecord;
        int n2;
        Goal goal2;
        Core.DEBUG(3, "Entering bind...");
        String string = this.makeIndex(vector);
        PlannerQueryStruct plannerQueryStruct = (PlannerQueryStruct)this.BindTable.get(string);
        Object[] objectArray = new Vector[plannerQueryStruct.external.size()];
        Bindings bindings = new Bindings(this.context.whoami());
        BindResults bindResults = new BindResults();
        boolean bl = false;
        Vector<Goal> vector3 = new Vector<Goal>();
        Vector<Goal> vector4 = new Vector<Goal>();
        int n3 = 0;
        while (n3 < plannerQueryStruct.external.size()) {
            goal2 = (Goal)plannerQueryStruct.external.elementAt(n3);
            objectArray[n3] = this.sortFeasible(goal2.getId(), vector2);
            if (objectArray[n3].isEmpty()) {
                vector3.addElement(goal2);
            } else {
                vector4.addElement(goal2);
            }
            ++n3;
        }
        if (!vector3.isEmpty()) {
            Core.DEBUG(3, "From bind...");
            Core.DEBUG(3, "PlannerQueryStruct = " + plannerQueryStruct);
            Core.DEBUG(3, "absent = " + vector3);
            n2 = 0;
            while (n2 < plannerQueryStruct.internal.size()) {
                planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n2);
                Core.DEBUG(3, planRecord.getConsumedDb());
                ++n2;
            }
            this.softFailParentOf(vector3, plannerQueryStruct, n);
            int n4 = 0;
            while (n4 < vector4.size()) {
                goal = (Goal)vector4.elementAt(n4);
                bl = false;
                int n5 = 0;
                while (!bl && n5 < plannerQueryStruct.external.size()) {
                    goal2 = (Goal)plannerQueryStruct.external.elementAt(n5);
                    boolean bl2 = bl = bl || goal2.getId().equals(goal.getId());
                    if (bl) {
                        plannerQueryStruct.external.removeElementAt(n5--);
                    }
                    ++n5;
                }
                if (!bl) {
                    vector4.removeElementAt(n4--);
                }
                ++n4;
            }
        }
        Core.DEBUG(3, "Present = " + vector4);
        Core.DEBUG(3, "Struct = " + plannerQueryStruct);
        if (vector4.isEmpty()) {
            bindResults.rejection = vector2;
            bindResults.ok = !plannerQueryStruct.internal.isEmpty() || !plannerQueryStruct.decompositions.isEmpty();
            bindResults.external = Misc.copyVector(plannerQueryStruct.external);
            return bindResults;
        }
        if (vector4.size() != objectArray.length) {
            objectArray = new Vector[vector4.size()];
            n2 = 0;
            while (n2 < vector4.size()) {
                goal2 = (Goal)vector4.elementAt(n2);
                objectArray[n2] = this.sortFeasible(goal2.getId(), vector2);
                ++n2;
            }
        }
        DelegationStruct[] delegationStructArray = new DelegationStruct[vector4.size()];
        Selector selector = new Selector(objectArray);
        bindResults.ok = false;
        while (!bindResults.ok && selector.hasMoreElements()) {
            Object[] objectArray2 = (Object[])selector.nextElement();
            bindings.clear();
            bindResults.ok = true;
            int n6 = 0;
            while (n6 < objectArray2.length) {
                delegationStructArray[n6] = (DelegationStruct)objectArray2[n6];
                goal = (Goal)delegationStructArray[n6].goals.elementAt(0);
                goal2 = (Goal)vector4.elementAt(n6);
                Fact fact = goal2.getFact();
                Fact fact2 = goal.getFact();
                bindResults.ok = fact2.unifiesWith(fact, bindings);
                if (!bindResults.ok) break;
                ++n6;
            }
            Core.DEBUG(3, "Current selection ... ");
            Core.DEBUG(3, delegationStructArray);
            boolean bl3 = bindResults.ok = bindResults.ok && bindings.add(plannerQueryStruct.bindings);
            if (!bindResults.ok) continue;
            int n7 = 0;
            while (n7 < plannerQueryStruct.internal.size()) {
                planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n7);
                Core.ERROR(planRecord.applyConstraints(bindings), 1011, (Object)this);
                ++n7;
            }
            plannerQueryStruct.bindings = bindings;
            int n8 = 0;
            while (n8 < objectArray2.length) {
                delegationStructArray[n8] = (DelegationStruct)objectArray2[n8];
                bindResults.selection.addElement(delegationStructArray[n8]);
                ++n8;
            }
        }
        if (bindResults.ok) {
            bindResults.rejection = Misc.difference(vector2, bindResults.selection);
            this.resume_planning(delegationStructArray, plannerQueryStruct);
        } else {
            bindResults.rejection = vector2;
            this.softFailParentOf(plannerQueryStruct.external, plannerQueryStruct, n);
            bindResults.ok = !plannerQueryStruct.internal.isEmpty() || !plannerQueryStruct.decompositions.isEmpty();
        }
        bindResults.external = Misc.copyVector(plannerQueryStruct.external);
        Core.DEBUG(3, " Bind struct\n" + plannerQueryStruct);
        Core.DEBUG(3, " Bind goals\n" + vector);
        Core.DEBUG(3, " Bind bindings\n" + plannerQueryStruct.bindings);
        Core.DEBUG(3, " Bind result\n" + bindResults + "\n");
        return bindResults;
    }

    protected Vector sortFeasible(String string, Vector vector) {
        Goal goal;
        DelegationStruct delegationStruct;
        Core.DEBUG(3, "sortFeasible input " + string + "\n" + vector);
        Vector<DelegationStruct> vector2 = new Vector<DelegationStruct>();
        int n = 0;
        while (n < vector.size()) {
            delegationStruct = (DelegationStruct)vector.elementAt(n);
            goal = (Goal)delegationStruct.goals.elementAt(0);
            if (string.equals(goal.getId())) {
                vector2.addElement(delegationStruct);
            }
            ++n;
        }
        Core.DEBUG(3, "sortFeasible reduced " + string + "\n" + vector2);
        boolean bl = true;
        while (bl) {
            bl = false;
            int n2 = 0;
            while (n2 < vector2.size() - 1) {
                delegationStruct = (DelegationStruct)vector2.elementAt(n2);
                goal = (Goal)delegationStruct.goals.elementAt(0);
                delegationStruct = (DelegationStruct)vector2.elementAt(n2 + 1);
                Goal goal2 = (Goal)delegationStruct.goals.elementAt(0);
                if (goal.getCost() > goal2.getCost()) {
                    Object e = vector2.elementAt(n2);
                    vector2.setElementAt((DelegationStruct)vector2.elementAt(n2 + 1), n2);
                    vector2.setElementAt((DelegationStruct)e, n2 + 1);
                    bl = true;
                }
                ++n2;
            }
        }
        Core.DEBUG(3, "sortFeasible results " + string + "\n" + vector2);
        return vector2;
    }

    public PlannerEnactStruct enact(Goal goal, Goal goal2) {
        PlannerEnactStruct plannerEnactStruct = new PlannerEnactStruct();
        this.notifyMonitors(goal, 0, 1);
        PlanRecord planRecord = this.lookUp(goal2);
        if (planRecord == null) {
            plannerEnactStruct.ok = false;
            this.notifyMonitors(goal, 1, 1);
            Core.DEBUG(3, "PlannerEnactStruct no sla found for\n" + goal2);
            return plannerEnactStruct;
        }
        planRecord.enact(plannerEnactStruct, goal, null, goal.getId(), new Hashtable());
        if (plannerEnactStruct.ok) {
            int n = 0;
            while (n < plannerEnactStruct.images.size()) {
                PlanRecord planRecord2 = (PlanRecord)plannerEnactStruct.images.elementAt(n);
                planRecord2.setState(3);
                ++n;
            }
            if (!planRecord.hasMoreEnactments()) {
                planRecord.dispose();
            }
            this.notifyMonitors(goal, 2, 1);
        } else {
            this.notifyMonitors(goal, 1, 1);
        }
        Core.DEBUG(3, "Final PlannerEnactStruct\n" + plannerEnactStruct);
        return plannerEnactStruct;
    }

    int latestConfirmTime(Vector vector) {
        Core.ERROR(vector, 1012, (Object)this);
        Core.ERROR(!vector.isEmpty(), 1013, (Object)this);
        int n = this.now + this.plannerLength;
        int n2 = 0;
        while (n2 < vector.size()) {
            n = Math.min(n, this.latestConfirmTime((Goal)vector.elementAt(n2)));
            ++n2;
        }
        return n;
    }

    int latestConfirmTime(Goal goal) {
        PlanRecord planRecord = this.lookUp(goal);
        return planRecord.latestConfirmTime();
    }

    protected String makeIndex(Vector vector) {
        Core.ERROR(vector, 1014, (Object)this);
        if (vector.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = ((Goal)vector.elementAt(n)).getId();
            ++n;
        }
        Misc.sort(stringArray);
        String string = new String();
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            string = string + stringArray[n2] + "/";
            ++n2;
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    protected void index(PlannerQueryStruct plannerQueryStruct) {
        String string = this.makeIndex(plannerQueryStruct.goals);
        Core.ERROR(this.BindTable.put(string, plannerQueryStruct) == null, 1015, (Object)this);
    }

    protected void removeFromIndexTable(Vector vector) {
        Core.DEBUG(3, "Planner removeFromIndexTable");
        String string = this.makeIndex(vector);
        this.BindTable.remove(string);
    }

    public void book(int n, Vector vector, Vector vector2) {
        PlanRecord planRecord;
        Vector<PlanRecord> vector3 = new Vector<PlanRecord>();
        int n2 = 0;
        while (n2 < vector2.size()) {
            planRecord = ((PlanRecord)vector2.elementAt(n2)).getRoot();
            if (!vector3.contains(planRecord)) {
                vector3.addElement(planRecord);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            Goal goal = (Goal)vector.elementAt(n3);
            this.book(n, goal, vector3);
            if (n == 3) {
                this.notifyMonitors(goal, 2, 0);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < vector3.size()) {
            planRecord = (PlanRecord)vector3.elementAt(n4);
            planRecord.setState(n);
            ++n4;
        }
    }

    protected void book(int n, Goal goal, Vector vector) {
        PlanRecord planRecord = this.lookUp(goal);
        if (planRecord != null) {
            planRecord.setState(n);
            vector.removeElement(planRecord);
        }
    }

    public void reject(Vector vector, Vector vector2) {
        PlanRecord planRecord;
        Core.DEBUG(3, "Planner Reject goals called " + vector);
        this.removeFromIndexTable(vector);
        Vector<PlanRecord> vector3 = new Vector<PlanRecord>();
        int n = 0;
        while (n < vector2.size()) {
            planRecord = ((PlanRecord)vector2.elementAt(n)).getRoot();
            if (!vector3.contains(planRecord)) {
                vector3.addElement(planRecord);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Goal goal = (Goal)vector.elementAt(n2);
            this.reject(goal, vector3);
            this.notifyMonitors(goal, 1, 0);
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            planRecord = (PlanRecord)vector3.elementAt(n3);
            planRecord.dispose();
            ++n3;
        }
    }

    protected void reject(Goal goal, Vector vector) {
        PlanRecord planRecord = this.lookUp(goal);
        if (planRecord != null) {
            planRecord.dispose();
            vector.removeElement(planRecord);
        }
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule: 0");
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector2.size()) {
            Goal goal = (Goal)vector2.elementAt(n);
            Vector vector4 = Misc.copyVector(vector);
            Vector vector5 = this.schedule(string, planRecord, vector4, goal, plannerQueryStruct, bl);
            vector3 = Misc.union(vector3, vector5);
            ++n;
        }
        return vector3;
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Goal goal, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Object object;
        Core.DEBUG(3, "schedule: 1");
        if (planRecord != null) {
            goal = new Goal(goal);
            object = goal.getFact();
            int n = ((Fact)object).getNumber();
            n = this.anySideEffect((Fact)object, planRecord, goal.getId(), n);
            if (n == 0) {
                return new Vector();
            }
            ((Fact)object).setNumber(n);
            goal.setFact((Fact)object);
        }
        if (!this.validTime(goal.getEndTime())) {
            this.addToExternal(plannerQueryStruct.external, goal);
            return new Vector();
        }
        object = this.context.TaskDb().findAll(goal.getFact(), vector);
        Core.DEBUG(3, "Tasks for: " + goal.getFactType());
        Core.DEBUG(3, object);
        return this.schedule(string, planRecord, vector, goal, (Vector)object, plannerQueryStruct, bl);
    }

    protected void addToExternal(Vector vector, Goal goal) {
        Core.DEBUG(3, "Adding to external ... attempt");
        String string = goal.getId();
        int n = 0;
        while (n < vector.size()) {
            Goal goal2 = (Goal)vector.elementAt(n);
            if (string.equals(goal2.getId())) {
                return;
            }
            ++n;
        }
        Core.DEBUG(3, "Adding to external ... done");
        vector.addElement(goal);
    }

    Vector schedule(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule: 2");
        Core.DEBUG(3, "schedule: 2 Path0 = " + vector);
        if (vector2 == null) {
            vector2 = this.context.TaskDb().findAll(goal.getFact(), vector);
        }
        Core.DEBUG(3, "schedule: 2 Path1 = " + vector);
        while (!vector2.isEmpty()) {
            Vector vector3;
            Task task = (Task)vector2.firstElement();
            Vector vector4 = vector3 = task.isPrimitive() ? this.schedule_primitive(string, planRecord, vector, goal, vector2, plannerQueryStruct, bl) : this.schedule_summary(string, planRecord, vector, goal, vector2, plannerQueryStruct, bl);
            if (vector3.isEmpty()) continue;
            return vector3;
        }
        this.addToExternal(plannerQueryStruct.external, goal);
        return new Vector();
    }

    Vector schedule_summary(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Core.DEBUG(3, "schedule_summary");
        Core.DEBUG(3, "schedule_summary: Path = " + vector);
        SummaryTask summaryTask = (SummaryTask)vector2.firstElement();
        vector2.removeElementAt(0);
        Decomposition decomposition = new Decomposition(this, string, planRecord, vector, goal, summaryTask);
        Vector vector3 = this.expand_summary(decomposition, plannerQueryStruct, bl);
        Core.DEBUG(3, "schedule_summary end:");
        Core.DEBUG(3, plannerQueryStruct);
        return vector3;
    }

    Vector expand_summary(Decomposition decomposition, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Vector vector;
        String string;
        Vector vector2;
        String string2;
        Core.DEBUG(3, "expand_summary");
        Vector vector3 = new Vector();
        TaskDb taskDb = this.context.TaskDb();
        decomposition.reset();
        while ((string2 = decomposition.nextNode()) != null) {
            Core.DEBUG(3, "expand_summary node ... " + string2);
            if (decomposition.isScheduled(string2) || decomposition.isQueued(string2)) continue;
            Fact[] factArray = decomposition.getPreconditions(string2);
            Fact[] factArray2 = decomposition.getPostconditions(string2);
            vector2 = decomposition.getPath(string2);
            Goal goal = decomposition.getGoal(string2);
            Core.DEBUG(3, "expand_summary: goal = " + goal);
            Vector vector4 = taskDb.findAll(factArray, factArray2, vector2);
            string = decomposition.getKey(string2);
            PlanRecord planRecord = decomposition.getParentRecord(string2);
            vector = this.schedule(string, planRecord, vector2, goal, vector4, plannerQueryStruct, false);
            Core.DEBUG(3, "expand_summary record:");
            Core.DEBUG(3, vector);
            if (!vector.isEmpty()) {
                decomposition.setRecords(string2, vector);
                vector3 = Misc.union(vector3, vector);
                continue;
            }
            plannerQueryStruct.decompositions.put(goal.getId(), decomposition);
            SuppliedDb suppliedDb = decomposition.getSuppliedDb(string2);
            goal.setSuppliedDb(suppliedDb);
            decomposition.setQueued(string2, true);
        }
        if (decomposition.allNodesScheduled()) {
            decomposition.enforceLinks();
            decomposition.reset();
            while ((string2 = decomposition.nextNode()) != null) {
                Core.DEBUG(3, "expand_summary node: " + string2);
                PlanRecord planRecord = decomposition.getRecord(string2);
                Core.DEBUG(3, "expand_summary getRecord: " + planRecord);
                if (planRecord == null) continue;
                string = decomposition.getKey(string2);
                vector2 = decomposition.getPath(string2);
                vector = this.schedule_children(string, planRecord, vector2, plannerQueryStruct, bl);
                vector3 = Misc.union(vector3, vector);
            }
        }
        Core.DEBUG(3, "expand_summary end");
        Core.DEBUG(3, plannerQueryStruct);
        return vector3;
    }

    Vector schedule_primitive(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        int n;
        int n2;
        Core.DEBUG(3, "schedule_primitive");
        PrimitiveTask primitiveTask = (PrimitiveTask)vector2.firstElement();
        vector2.removeElementAt(0);
        Vector vector3 = new Vector();
        ResourceDb resourceDb = this.context.ResourceDb();
        SuppliedDb suppliedDb = goal.getSuppliedDb();
        int n3 = goal.getEndTime();
        int n4 = primitiveTask.getTime();
        if (goal.isContinuous()) {
            int n5 = goal.getStartTime();
            n2 = n5 - n4;
            n = n3 - n2;
            if (n / n4 < goal.getInvocations()) {
                return vector3;
            }
        } else {
            n2 = n3 - n4;
            n = n4;
        }
        if (!this.validTime(n3)) {
            return vector3;
        }
        if (!this.validTime(n2)) {
            return vector3;
        }
        int n6 = 0;
        while (n6 < primitiveTask.countPreconditions()) {
            Fact fact = primitiveTask.getPrecondition(n6);
            if (fact.isLocal()) {
                Core.DEBUG(3, "Checking consumed:\n" + fact.pprint());
                Core.DEBUG(3, "IsLocal: true");
                Fact fact2 = null;
                Fact fact3 = null;
                Fact fact4 = null;
                if (suppliedDb != null) {
                    fact2 = suppliedDb.evalLocal(fact);
                    Core.DEBUG(3, "SuppliedDb contains fact:\n" + fact2.pprint());
                }
                fact3 = resourceDb.evalLocal(fact);
                if (fact2 == null && fact3 == null) {
                    return vector3;
                }
                if (fact2 != null && fact3 != null) {
                    Core.ERROR(fact2.disjoin(fact3), 1016, (Object)this);
                    fact4 = fact2;
                } else {
                    fact4 = fact2 == null ? fact3 : fact2;
                }
                Core.DEBUG(3, "Db contains fact:\n" + fact4.pprint());
                Bindings bindings = new Bindings(this.context.whoami());
                fact.unifiesWith(fact4, bindings);
                primitiveTask.resolve(bindings);
                Core.DEBUG(3, "IsLocal bindings: " + bindings);
            } else if (fact.isNegative()) {
                Core.DEBUG(3, "Checking negative:\n" + fact.pprint());
                Core.DEBUG(3, "IsNegative: true");
                if (!resourceDb.evalNegative(fact)) {
                    return vector3;
                }
                Core.DEBUG(3, "Db does not contain fact:\n" + fact.pprint());
            }
            ++n6;
        }
        int n7 = n3 - 1;
        while (this.validTime(n7 - n)) {
            int n8 = 0;
            while (n8 < this.plannerWidth) {
                boolean bl2 = true;
                int n9 = n7;
                while (bl2 && n9 > n7 - n) {
                    bl2 = this.isFreeCell(n8, n9) & bl2;
                    --n9;
                }
                if (bl2) {
                    PlanRecord planRecord2 = new PlanRecord(this, string, planRecord, goal, primitiveTask, n8, n7 - n + 1, n7 + 1);
                    planRecord2.setPath(Misc.copyVector(vector));
                    planRecord2.setAlternativeTasks(vector2);
                    int n10 = n7;
                    while (n10 > n7 - n) {
                        this.assignCell(n8, n10, planRecord2);
                        --n10;
                    }
                    plannerQueryStruct.internal.addElement(planRecord2);
                    vector3.addElement(planRecord2);
                    vector.addElement(goal.getFact());
                    Vector vector4 = this.schedule_children(string, planRecord2, vector, plannerQueryStruct, bl);
                    vector3 = Misc.union(vector3, vector4);
                    return vector3;
                }
                ++n8;
            }
            --n7;
        }
        Core.DEBUG(3, "Space not found for: " + goal.getFactType());
        Core.DEBUG(3, "tduration = " + n);
        Core.DEBUG(3, "tetime = " + n3);
        Core.DEBUG(3, "tlstime = " + n2);
        return vector3;
    }

    protected Vector schedule_children(String string, PlanRecord planRecord, Vector vector, PlannerQueryStruct plannerQueryStruct, boolean bl) {
        Vector vector2 = new Vector();
        ResourceDb resourceDb = this.context.ResourceDb();
        SuppliedDb suppliedDb = planRecord.getSuppliedDb();
        if (bl) {
            Vector vector3;
            Vector vector4 = plannerQueryStruct.external;
            plannerQueryStruct.external = new Vector();
            do {
                if (suppliedDb != null) {
                    suppliedDb.allocateResources(planRecord);
                }
                if ((vector3 = resourceDb.allocateResources(planRecord)).isEmpty()) continue;
                Vector vector5 = Misc.copyVector(vector);
                Vector vector6 = this.schedule(string, planRecord, vector5, vector3, plannerQueryStruct, bl);
                vector2 = Misc.union(vector2, vector6);
            } while (plannerQueryStruct.external.isEmpty() && !vector3.isEmpty());
            plannerQueryStruct.external = Misc.union(plannerQueryStruct.external, vector4);
        }
        return vector2;
    }

    protected void resume_planning(DelegationStruct[] delegationStructArray, PlannerQueryStruct plannerQueryStruct) {
        Decomposition decomposition = null;
        PlanRecord planRecord = null;
        Core.DEBUG(3, "resume_planning ... ds/struct");
        Core.DEBUG(3, delegationStructArray);
        Core.DEBUG(3, plannerQueryStruct);
        plannerQueryStruct.external.removeAllElements();
        int n = 0;
        while (n < delegationStructArray.length) {
            Goal goal = (Goal)delegationStructArray[n].goals.elementAt(0);
            decomposition = (Decomposition)plannerQueryStruct.decompositions.remove(goal.getId());
            if (decomposition == null) {
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < plannerQueryStruct.internal.size()) {
                    planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n2);
                    bl = planRecord.hasSubgoal(goal.getId());
                    ++n2;
                }
                Core.ERROR(bl, 1017, (Object)this);
                String string = delegationStructArray[n].agent;
                String string2 = goal.getId();
                String string3 = this.context.whoami();
                String string4 = planRecord.getGoal().getId();
                String string5 = this.context.newId("used");
                int n3 = planRecord.getStartTime();
                int n4 = planRecord.getConsumedPosition(string2);
                boolean bl2 = planRecord.isPreconditionConsumed(n4);
                int n5 = planRecord.getAmountUsed(n4);
                Core.ERROR(n5 > 0, 1031, (Object)this);
                goal.addConsumer(string, string2, string3, string4, string5, delegationStructArray[n].key, n3, n5, bl2);
                planRecord.getConsumedDb().update(string2 + "/" + string5, string2);
                Vector vector = planRecord.getChildPath();
                String string6 = planRecord.getKey();
                this.schedule_children(string6, planRecord, vector, plannerQueryStruct, true);
            } else {
                String string = decomposition.getNodeWithGoalId(goal.getId());
                Core.DEBUG(3, "getNodeWithGoalId " + goal.getId() + " " + string);
                decomposition.setImage(string, goal, delegationStructArray[n].agent, delegationStructArray[n].key);
                this.expand_summary(decomposition, plannerQueryStruct, true);
            }
            ++n;
        }
    }

    public void goalConfirmed(Vector vector, Vector vector2, Vector vector3) {
        int n = 0;
        while (n < vector2.size()) {
            Goal goal;
            DelegationStruct delegationStruct;
            int n2;
            boolean bl;
            PlanRecord planRecord;
            Goal goal2 = (Goal)vector2.elementAt(n);
            Vector vector4 = goal2.getProducerRecords();
            int n3 = 0;
            while (vector4 != null && n3 < vector4.size()) {
                ProducerRecord producerRecord = (ProducerRecord)vector4.elementAt(n3);
                if (producerRecord.consumer.equals(this.context.whoami())) {
                    planRecord = (PlanRecord)this.get(producerRecord.consumer_id);
                    Core.ERROR(planRecord, 1001, (Object)this);
                    ConsumedDb consumedDb = planRecord.getConsumedDb();
                    bl = consumedDb.update(producerRecord.producer_id + "/" + producerRecord.use_ref, producerRecord.use_ref);
                    Core.ERROR(bl, 1002, (Object)this);
                } else {
                    n2 = 0;
                    while (n2 < vector3.size()) {
                        delegationStruct = (DelegationStruct)vector3.elementAt(n2);
                        goal = (Goal)delegationStruct.goals.elementAt(0);
                        SuppliedDb suppliedDb = goal.getSuppliedDb();
                        if (suppliedDb != null && suppliedDb.isReserved(producerRecord.supply_ref)) {
                            goal.addProducer(producerRecord);
                        }
                        ++n2;
                    }
                }
                ++n3;
            }
            vector4 = goal2.getConsumerRecords();
            n2 = 0;
            while (vector4 != null && n2 < vector4.size()) {
                ConsumerRecord consumerRecord = (ConsumerRecord)vector4.elementAt(n2);
                if (consumerRecord.producer.equals(this.context.whoami())) {
                    planRecord = (PlanRecord)this.get(consumerRecord.producer_id);
                    Core.ERROR(planRecord, 1003, (Object)this);
                    ProducedDb producedDb = planRecord.getProducedDb();
                    Core.DEBUG(3, "CdB replacing " + consumerRecord.producer_id + " with " + consumerRecord.consumer_id + "/" + consumerRecord.use_ref);
                    Core.DEBUG(3, vector4);
                    Core.DEBUG(3, planRecord);
                    bl = producedDb.replaceOrAdd(consumerRecord.producer_id, consumerRecord.consumer_id + "/" + consumerRecord.use_ref, consumerRecord.start, consumerRecord.amount, consumerRecord.consumed);
                    Core.DEBUG(3, "Replacement is " + bl);
                    Core.ERROR(bl, 1004, (Object)this);
                } else {
                    int n4 = 0;
                    while (n4 < vector3.size()) {
                        delegationStruct = (DelegationStruct)vector3.elementAt(n4);
                        goal = (Goal)delegationStruct.goals.elementAt(0);
                        goal.addConsumer(consumerRecord);
                        ++n4;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected boolean validTime(int n) {
        return this.now + this.plannerLength >= n && n >= this.now;
    }

    protected boolean validProc(int n) {
        return n >= 0 && n < this.plannerWidth;
    }

    protected boolean isFreeCell(int n, int n2) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1018, (Object)this);
        Core.ERROR(this.now + this.plannerLength > n2 && n2 >= this.now, 1019, (Object)this);
        return this.table[n][n2 - this.now] == null;
    }

    public void shuffle() {
        this.checkRecords();
        int n = 0;
        while (n < this.plannerWidth) {
            int n2 = 0;
            while (n2 < this.plannerLength - 1) {
                this.assignCell(n, n2 + this.now, this.table[n][n2 + 1]);
                ++n2;
            }
            this.assignCell(n, this.plannerLength - 1 + this.now, null);
            ++n;
        }
        ++this.now;
    }

    synchronized void executeEarliest() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (planRecord.getState() != 3 || !planRecord.isDiscrete() || planRecord.getStartTime() <= this.now || !planRecord.hasEnoughResources()) continue;
            this.executeEarliest(planRecord);
        }
    }

    synchronized void executeEarliest(PlanRecord planRecord) {
        int n = planRecord.getEndTime();
        int n2 = planRecord.getStartTime();
        int n3 = n - n2;
        if (!this.validTime(n)) {
            return;
        }
        if (!this.validTime(n2)) {
            return;
        }
        int n4 = this.now + 1;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < this.plannerWidth) {
                boolean bl = true;
                int n6 = n4;
                while (n6 < n4 + n3) {
                    boolean bl2 = bl = bl && (this.isFreeCell(n5, n6) || planRecord.isOnCell(n5, n6));
                    if (!bl) break;
                    ++n6;
                }
                if (bl) {
                    Core.DEBUG(3, "Reassigning rec " + planRecord.getId() + " from [" + n2 + "," + n + "] to [" + n4 + "," + (n4 + n3) + "]");
                    planRecord.reassign(n5, n4);
                    int n7 = n4;
                    while (n7 < n4 + n3) {
                        this.assignCell(n5, n7, planRecord);
                        ++n7;
                    }
                    return;
                }
                ++n5;
            }
            ++n4;
        }
    }

    synchronized boolean incrementProcessorTime(PlanRecord planRecord, int n) {
        if (!this.validTime(n)) {
            return false;
        }
        if (this.isFreeCell(planRecord.getProc(), n)) {
            planRecord.incrementTime(n);
            this.assignCell(planRecord.getProc(), n, planRecord);
            return true;
        }
        return false;
    }

    public synchronized void checkRecords() {
        ExecutionMonitor executionMonitor = this.context.ExecutionMonitor();
        int n = 0;
        while (n < this.plannerWidth) {
            PlanRecord planRecord = this.table[n][0];
            if (planRecord != null) {
                switch (planRecord.getState()) {
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        PlanRecord planRecord2 = planRecord.getRoot();
                        planRecord2.dispose();
                        break;
                    }
                    case 3: {
                        if (!planRecord.exec()) break;
                        break;
                    }
                    case 4: {
                        if (!planRecord.overRun()) break;
                    }
                    case 5: {
                        PlanRecord planRecord2 = planRecord.getRoot();
                        planRecord2.dispose();
                        break;
                    }
                    case 6: {
                        planRecord.dispose();
                    }
                }
            }
            ++n;
        }
        if (this.context.getExecuteEarliest()) {
            this.executeEarliest();
        }
    }

    public void notifyReceived(Fact fact, String string, String string2) {
        try {
            Core.DEBUG(3, "NotifyReceived...\n" + fact.pprint());
            PlanRecord planRecord = (PlanRecord)this.get(string);
            Core.ERROR(planRecord, 1020, (Object)this);
            this.context.ResourceDb().add(fact);
            planRecord.preconditionExists(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void assignCell(int n, int n2, PlanRecord planRecord) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1021, (Object)this);
        Core.ERROR(this.now + this.plannerLength > n2 && n2 >= this.now, 1022, (Object)this);
        this.table[n][n2 - this.now] = planRecord;
    }

    void freeCell(int n, int n2) {
        Core.ERROR(n >= 0 && n < this.plannerWidth, 1023, (Object)this);
        if (this.now + this.plannerLength > n2 && n2 >= this.now) {
            this.table[n][n2 - this.now] = null;
        }
    }

    void freeCells(int n, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            this.freeCell(n, n4);
            ++n4;
        }
    }

    public Goal recreateSubgoal(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (!planRecord.hasSubgoal(string)) continue;
            return planRecord.recreateSubgoal(goal);
        }
        Goal goal2 = new Goal(goal);
        goal2.setId(this.context.newId("subgoal"));
        goal2.setImage(goal.getId());
        goal2.setConfirmTime(new Time(this.now() + this.context.getReplanPeriod()));
        return goal2;
    }

    public void reconfirmParentOf(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.reconfirmParentOf((Goal)vector.elementAt(n));
            ++n;
        }
    }

    public void reconfirmParentOf(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (planRecord.hasSubgoal(string)) {
                planRecord.reconfirm();
                return;
            }
            if (!planRecord.getGoal().getId().equals(string) || planRecord.getParent() == null) continue;
            planRecord.getParent().reconfirm();
            return;
        }
        Core.DEBUG(3, "reconfirmParentOf error ...  " + goal);
        Core.ERROR(null, 1024, (Object)this);
    }

    public void failParentOf(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.failParentOf((Goal)vector.elementAt(n));
            ++n;
        }
    }

    public void failParentOf(Goal goal) {
        String string = goal.getId();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            if (!planRecord.hasSubgoal(string)) continue;
            planRecord.setState(5);
            return;
        }
        Core.DEBUG(3, "failParentOf error ...  " + goal);
    }

    void softFailParentOf(Vector vector, PlannerQueryStruct plannerQueryStruct, int n) {
        boolean bl;
        int n2;
        String string;
        Core.DEBUG(3, "softFailParentOf Goal = " + vector);
        Core.DEBUG(3, "softFailParentOf PlannerQueryStruct = " + plannerQueryStruct);
        PlanRecord planRecord = null;
        Goal goal = null;
        int n3 = 0;
        while (n3 < vector.size()) {
            Goal goal2 = (Goal)vector.elementAt(n3);
            string = goal2.getId();
            n2 = 0;
            while (n2 < plannerQueryStruct.external.size()) {
                goal = (Goal)plannerQueryStruct.external.elementAt(n2);
                if (string.equals(goal.getId())) {
                    plannerQueryStruct.external.removeElementAt(n2--);
                    break;
                }
                ++n2;
            }
            Decomposition decomposition = (Decomposition)plannerQueryStruct.decompositions.remove(goal2.getId());
            if (decomposition == null) {
                bl = false;
                int n4 = 0;
                while (!bl && n4 < plannerQueryStruct.internal.size()) {
                    planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n4);
                    bl = planRecord.hasSubgoal(string);
                    ++n4;
                }
                if (bl) {
                    planRecord.softFail(plannerQueryStruct, n);
                }
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < plannerQueryStruct.internal.size()) {
            planRecord = (PlanRecord)plannerQueryStruct.internal.elementAt(n2);
            if (!this.containsRecord(planRecord)) {
                plannerQueryStruct.internal.removeElementAt(n2--);
            }
            ++n2;
        }
        Enumeration enumeration = plannerQueryStruct.decompositions.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            bl = false;
            int n5 = 0;
            while (!bl && n5 < plannerQueryStruct.external.size()) {
                goal = (Goal)plannerQueryStruct.external.elementAt(n5);
                bl = string.equals(goal.getId());
                ++n5;
            }
            if (bl) continue;
            plannerQueryStruct.decompositions.remove(string);
        }
    }

    public void addPlanningMonitor(PlanningMonitor planningMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(planningMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(planningMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(planningMonitor);
        }
    }

    public void removePlanningMonitor(PlanningMonitor planningMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(planningMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(planningMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(planningMonitor);
        }
    }

    public void addPlanStepMonitor(PlanStepMonitor planStepMonitor, long l, boolean bl) {
        this.addPlanStepMonitor(planStepMonitor, l);
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PlanRecord planRecord = (PlanRecord)enumeration.nextElement();
            PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 1L);
            planStepMonitor.planStepCreatedEvent(planStepEvent);
        }
    }

    public void addPlanStepMonitor(PlanStepMonitor planStepMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[3].add(planStepMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[4].add(planStepMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[5].add(planStepMonitor);
        }
    }

    public void removePlanStepMonitor(PlanStepMonitor planStepMonitor, long l) {
        if ((l & 1L) != 0L) {
            this.eventMonitor[3].remove(planStepMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[4].remove(planStepMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[5].remove(planStepMonitor);
        }
    }

    void notifyMonitors(Goal goal, int n, int n2) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 1L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningStartedEvent(planningEvent);
                }
                break;
            }
            case 1: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 2L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningFailedEvent(planningEvent);
                }
                break;
            }
            case 2: {
                PlanningEvent planningEvent = new PlanningEvent(this, goal, 4L, n2);
                while (enumeration.hasMoreElements()) {
                    PlanningMonitor planningMonitor = (PlanningMonitor)enumeration.nextElement();
                    planningMonitor.planningSucceededEvent(planningEvent);
                }
                break;
            }
        }
    }

    void notifyMonitors(PlanRecord planRecord, int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        Core.ERROR(enumeration, 2001, (Object)this);
        switch (n) {
            case 3: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 1L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepCreatedEvent(planStepEvent);
                }
                break;
            }
            case 4: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 2L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepDisposedEvent(planStepEvent);
                }
                break;
            }
            case 5: {
                PlanStepEvent planStepEvent = new PlanStepEvent(this, planRecord, 4L);
                while (enumeration.hasMoreElements()) {
                    PlanStepMonitor planStepMonitor = (PlanStepMonitor)enumeration.nextElement();
                    planStepMonitor.planStepStateChangedEvent(planStepEvent);
                }
                break;
            }
        }
    }

    protected double now() {
        return this.context.now();
    }
}

