/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ConsumedDb;
import zeus.actors.DataRec;
import zeus.actors.Planner;
import zeus.actors.ProducedDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.ZeusTask;
import zeus.actors.rtn.util.DelegationStruct;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PlannerEnactStruct;
import zeus.concepts.PlannerQueryStruct;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ReportRec;
import zeus.concepts.SuppliedDb;
import zeus.concepts.SuppliedItem;
import zeus.concepts.SuppliedRequester;
import zeus.concepts.Task;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.Time;

public class PlanRecord
implements SuppliedRequester {
    public static final int FREE = 0;
    public static final int TEMP = 1;
    public static final int TENTATIVE = 2;
    public static final int FIRM = 3;
    public static final int RUNNING = 4;
    public static final int FAILED = 5;
    public static final int COMPLETED = 6;
    public static final int JEOPARDY = 7;
    public static final int AGREEMENT = 8;
    protected static final boolean BOOKED = true;
    public static final Color[] color = new Color[]{Color.lightGray, Color.orange, Color.yellow, Color.cyan, Color.green, Color.red, Color.white, Color.magenta, Color.blue};
    public static final String[] state_string = new String[]{"Free", "Temporary", "Tentative", "Firm", "Running", "Failed", "Completed", "Jeopardy", "Service-Agreement"};
    protected Planner planner;
    protected int state = 1;
    protected PlanRecord parent;
    protected String id;
    protected Goal goal;
    protected PrimitiveTask task;
    protected int proc;
    protected int start_time;
    protected int lstart_time;
    protected int end_time;
    protected double cost;
    protected ZeusTask thread = null;
    protected String diagnostic = null;
    protected String key = null;
    protected boolean is_disposed = false;
    protected ConsumedDb consumedDb = null;
    protected ProducedDb producedDb = null;
    protected int reconfirm_count = 0;
    protected Vector other_tasks = null;
    protected Vector path = null;
    protected PlanRecord original = null;
    protected int noAllowedInvocations = 1;
    protected int noAvailableItems = 0;
    protected boolean[] slots = null;
    protected Vector images = null;

    public PlanRecord() {
    }

    protected void init(Planner planner, String string, PlanRecord planRecord, Goal goal, PrimitiveTask primitiveTask, int n, int n2, int n3) {
        Assert.notNull(string);
        Assert.notNull(goal);
        Assert.notNull(primitiveTask);
        Assert.notFalse(n2 >= 0);
        Assert.notFalse(n3 >= 0);
        Assert.notFalse(n >= 0);
        this.planner = planner;
        this.key = string;
        this.parent = planRecord;
        this.id = planner.getAgentContext().newId("PlanRecord");
        this.goal = goal;
        this.task = primitiveTask;
        this.start_time = n2;
        this.lstart_time = n2;
        this.end_time = n3;
        this.proc = n;
        this.cost = primitiveTask.getCost();
        this.noAvailableItems = goal.getFact().getNumber();
        if (this.noAvailableItems == 0) {
            Core.USER_ERROR("Integer expected in goal.fact.no field.\nEnsure \"no\" constraints are defined in all task specifications");
            this.noAvailableItems = 1;
        }
        primitiveTask.preprocess();
        this.consumedDb = new ConsumedDb(this, primitiveTask);
        this.producedDb = new ProducedDb(this, primitiveTask);
        Core.DEBUG(3, "PlanRecord created: " + this);
    }

    public PlanRecord(Planner planner, String string, PlanRecord planRecord, Goal goal, PrimitiveTask primitiveTask, int n, int n2, int n3) {
        this.init(planner, string, planRecord, goal, primitiveTask, n, n2, n3);
        this.producedDb.add(primitiveTask.getActiveEffectPos(), planRecord, this.noAvailableItems, goal.getId(), !goal.getFact().isReadOnly());
        if (planRecord != null) {
            planRecord.updateCost(this.cost);
        }
        planner.add(this);
        planner.notifyMonitors(this, 3);
    }

    protected PlanRecord(Planner planner, PlanRecord planRecord, String string, PlanRecord planRecord2, Goal goal, PrimitiveTask primitiveTask, int n, int n2, int n3) {
        Assert.notNull(planRecord);
        Assert.notFalse(goal.whichType());
        this.init(planner, string, planRecord2, goal, primitiveTask, n, n2, n3);
        this.original = planRecord;
        planner.add(this);
        planner.notifyMonitors(this, 3);
    }

    public String getId() {
        return this.id;
    }

    public int getProc() {
        return this.proc;
    }

    public int getState() {
        return this.state;
    }

    public int getStartTime() {
        return this.start_time;
    }

    public int getLatestStartTime() {
        return this.lstart_time;
    }

    public int getEndTime() {
        return this.end_time;
    }

    public PrimitiveTask getTask() {
        return this.task;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public PlanRecord getParent() {
        return this.parent;
    }

    public String getKey() {
        return this.key;
    }

    public double getCost() {
        return this.cost;
    }

    public ConsumedDb getConsumedDb() {
        return this.consumedDb;
    }

    public ProducedDb getProducedDb() {
        return this.producedDb;
    }

    public AgentContext getAgentContext() {
        return this.planner.getAgentContext();
    }

    public SuppliedDb getSuppliedDb() {
        return this.goal.getSuppliedDb();
    }

    public int anySideEffect(Fact fact, PlanRecord planRecord, Object object, int n) {
        boolean bl = this.isDiscrete() && (this.state == 3 || this.state == 4);
        if (!(bl |= this.getRoot() == planRecord.getRoot())) {
            return n;
        }
        Fact[] factArray = this.task.getPostconditions();
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        int n2 = 0;
        while (n > 0 && n2 < factArray.length) {
            if (factArray[n2].unifiesWith(fact, bindings)) {
                n = this.producedDb.anySideEffect(n2, planRecord, object, n);
            }
            ++n2;
            bindings.clear();
        }
        return n;
    }

    public void setAlternativeTasks(Vector vector) {
        this.other_tasks = vector;
    }

    public void setPath(Vector vector) {
        this.path = vector;
    }

    public Vector getChildPath() {
        Vector vector = Misc.copyVector(this.path);
        vector.addElement(this.goal.getFact());
        return vector;
    }

    public PlanRecord[] getChildren() {
        return this.consumedDb.getChildren();
    }

    public boolean hasAtMostOneParent(PlanRecord planRecord, String string) {
        return this.producedDb.hasAtMostOneParent(planRecord, string);
    }

    public DataRec getDatarec(int n) {
        return this.consumedDb.getDatarec(n);
    }

    public int getConsumedPosition(String string) {
        return this.consumedDb.getPosition(string);
    }

    public boolean isPreconditionConsumed(int n) {
        Fact fact = this.task.getPrecondition(n);
        return !fact.isReadOnly();
    }

    public int noRequiredItems(int n) {
        return this.consumedDb.requiredItems(n);
    }

    public int getAmountUsed(int n) {
        return this.consumedDb.amountUsed(n);
    }

    public boolean setSupplier(int n, int n2, SuppliedItem suppliedItem) {
        boolean bl;
        String string = this.planner.getAgentContext().newId("used");
        boolean bl2 = suppliedItem.reserve(string, this.start_time, bl = this.isPreconditionConsumed(n), n2, this.planner.getAgentContext().whoami(), this.goal.getId(), this.key);
        if (bl2) {
            this.consumedDb.add(n, string, n2);
        }
        return bl2;
    }

    public void chainPrecondition(PlanRecord planRecord, int n, int n2, int n3) {
        this.consumedDb.add(n3, planRecord, n, n2);
    }

    public void preconditionExists(PlanRecord planRecord, int n, int n2, int n3) {
        this.consumedDb.factExists(n3, planRecord, n, n2);
    }

    public void preconditionExists(String string) {
        this.consumedDb.factExists(string);
    }

    public void replacePrecondition(String string, PlanRecord planRecord, int n, int n2) {
        this.consumedDb.replace(string, planRecord, n, n2);
    }

    public void breakEffectChain(int n, PlanRecord planRecord, int n2, int n3) {
        this.producedDb.remove(n, planRecord, n2, n3);
        if (this.parent == planRecord && !this.producedDb.references(this.parent)) {
            this.parent = this.producedDb.firstParent();
            if (this.parent != null) {
                int n4 = this.producedDb.firstPosition(this.parent);
                this.task.setActiveEffect(n4);
                this.goal.setFact(this.task.getActiveEffect());
                this.setKey(this.parent.getKey());
            } else {
                String string = this.producedDb.firstKey();
                if (string != null) {
                    this.setKey(string);
                }
            }
        }
    }

    public Goal recreateSubgoal(Goal goal) {
        int n = this.consumedDb.getPosition(goal.getId());
        Fact fact = this.consumedDb.remove(goal.getId());
        Goal goal2 = this.createSubgoal(fact, n);
        double d = this.planner.getAgentContext().now() + this.planner.getAgentContext().getReplanPeriod();
        goal2.setConfirmTime(new Time(d));
        goal2.setSuppliedDb(this.goal.getSuppliedDb());
        this.setState(7);
        return goal2;
    }

    public void reconfirm() {
        Assert.notFalse(this.state == 7);
        Core.DEBUG(2, "Decrementing reconfirm from: " + this.reconfirm_count);
        if (--this.reconfirm_count == 0) {
            this.setState(3);
        }
    }

    public void setKey(String string) {
        Core.DEBUG(3, "PlanRecord: " + this + "\n\tsetKey: " + string);
        if (this.parent == null || string.equals(this.parent.getKey())) {
            this.consumedDb.update(string, this.key);
            this.key = string;
            PlanRecord[] planRecordArray = this.consumedDb.getChildren();
            int n = 0;
            while (n < planRecordArray.length) {
                planRecordArray[n].setKey(string);
                ++n;
            }
        }
    }

    public boolean isDiscrete() {
        return this.goal.whichType();
    }

    public boolean isContinuous() {
        return !this.goal.whichType();
    }

    public boolean hasMoreEnactments() {
        Assert.notFalse(!this.goal.whichType());
        return this.noAvailableItems > 0;
    }

    public boolean hasEnoughResources() {
        return this.consumedDb.hasEnoughResources();
    }

    public void updateCost(double d) {
        this.cost += d;
        if (this.parent != null) {
            this.parent.updateCost(d);
        }
    }

    public boolean applyConstraints(Bindings bindings) {
        if (!this.task.applyConstraints(bindings)) {
            return false;
        }
        return this.producedDb.constrain(bindings);
    }

    public Bindings getBindings() {
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        Fact fact = this.goal.getFact();
        Fact fact2 = this.task.getActiveEffect();
        Assert.notFalse(fact2.unifiesWith(fact, bindings));
        return bindings;
    }

    public boolean isOnCell(int n, int n2) {
        return this.proc == n && n2 >= this.start_time && n2 < this.end_time;
    }

    protected void vacatingPosition(int n, int n2, int n3) {
        Assert.notFalse(!this.goal.whichType());
        Assert.notFalse(n == this.proc);
        int n4 = n2 - this.start_time;
        while (n4 < n3 - this.start_time) {
            this.slots[n4] = false;
            ++n4;
        }
        int n5 = n2;
        while (n5 < n3) {
            this.planner.assignCell(n, n5, this);
            ++n5;
        }
    }

    protected void originalDisposed() {
        Assert.notNull(this.original);
        this.original = null;
    }

    public void reassign(int n, int n2) {
        if (this.original != null) {
            this.original.vacatingPosition(this.proc, this.start_time, this.end_time);
        } else {
            this.planner.freeCells(this.proc, this.start_time, this.end_time);
        }
        this.proc = n;
        this.start_time = n2;
        this.end_time = n2 + this.task.getTime();
        this.consumedDb.newStartTime(this.start_time);
    }

    public void incrementTime(int n) {
        this.planner.freeCell(this.proc, this.end_time - 1);
        this.end_time = n + 1;
    }

    public String diagnostic() {
        return this.diagnostic;
    }

    public Fact[][] mapPreToPost(Fact[][] factArray, Fact[] factArray2) {
        Core.DEBUG(1, "in mapPreToPost");
        AgentContext agentContext = this.getAgentContext();
        TaskDb taskDb = agentContext.getTaskDb();
        String string = this.task.getName();
        Task task = taskDb.getTask(string);
        Fact[] factArray3 = task.getPreconditions();
        Fact[] factArray4 = task.getPostconditions();
        this.debug("\nTask from DB = " + task.toString());
        this.debug("\nThis task = " + this.task.toString());
        Fact[][] factArray5 = new Fact[factArray2.length][1];
        this.debug(String.valueOf(factArray.length));
        int n = 0;
        while (n < factArray.length) {
            this.debug(String.valueOf(factArray2.length));
            int n2 = 0;
            while (n2 < factArray2.length) {
                factArray5[n2][0] = factArray2[n2];
                String[] stringArray = factArray4[n2].buildMap(factArray3[n]);
                factArray5[n2][0].doMap(factArray[n][0], stringArray);
                this.debug("in = " + factArray[n][0] + " out = " + factArray5[n2][0]);
                ++n2;
            }
            ++n;
        }
        return factArray5;
    }

    public void mapCostAndTime() {
        AgentContext agentContext = this.getAgentContext();
        TaskDb taskDb = agentContext.getTaskDb();
        String string = this.task.getName();
        Task task = taskDb.getTask(string);
        Fact[] factArray = task.getPostconditions();
        Fact[] factArray2 = this.task.getPostconditions();
        Fact[] factArray3 = task.getPreconditions();
        Fact[] factArray4 = this.task.getPreconditions();
        ValueFunction valueFunction = this.task.getTimeFn();
        ValueFunction valueFunction2 = this.task.getCostFn();
        int n = 0;
        while (n < factArray.length) {
            this.map(valueFunction, factArray[n], factArray2[n]);
            this.map(valueFunction2, factArray[n], factArray2[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < factArray3.length) {
            this.map(valueFunction, factArray3[n2], factArray4[n2]);
            this.map(valueFunction2, factArray3[n2], factArray4[n2]);
            ++n2;
        }
    }

    public void map(ValueFunction valueFunction, Fact fact, Fact fact2) {
        this.debug("val = " + valueFunction.toString() + "\nlhs = " + fact.toString() + "\nrhs = " + fact2.toString());
    }

    public boolean exec() {
        this.diagnostic = null;
        PrimitiveTask primitiveTask = new PrimitiveTask(this.task);
        if (!this.goal.whichType() || this.thread != null) {
            return false;
        }
        if (!this.consumedDb.hasEnoughResources()) {
            this.setState(5);
            this.diagnostic = "1: Cannot exec - inadequate resources";
            Core.DEBUG(2, this.diagnostic);
            return true;
        }
        try {
            String string = this.task.getName();
            if (string.startsWith("GenTask")) {
                string = "GenTask";
            }
            Class<?> clazz = Class.forName(string);
            this.thread = (ZeusTask)clazz.newInstance();
            Fact[][] factArray = this.consumedDb.getInputData();
            this.consumedDb.consumeResources();
            System.out.println(this.task.pprint());
            this.thread.setInputArgs(factArray);
            this.thread.setExpectedOutputArgs(this.task.getOriginalPostconditions());
            Fact[] factArray2 = this.task.getPreconditions();
            this.thread.setExpectedInputArgs(factArray2);
            this.thread.setMedia(this.goal.getTargetMedia());
            this.thread.setContext(this.getAgentContext());
            Fact[] factArray3 = this.task.getOriginalPostconditions();
            Fact[][] factArray4 = null;
            if (factArray.length > 0) {
                factArray4 = this.mapPreToPost(factArray, factArray3);
            } else {
                factArray4 = new Fact[factArray3.length][1];
                int n = 0;
                while (n < factArray3.length) {
                    factArray4[n][0] = factArray3[n];
                    ++n;
                }
            }
            this.mapCostAndTime();
            Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
            this.task.resolve(bindings);
            this.thread.setOutputArgs(factArray4);
            int n = 0;
            while (n < factArray4.length) {
                factArray3[n] = factArray4[n][0];
                ++n;
            }
            this.thread.setExpectedOutputArgs(factArray3);
            Fact[][] factArray5 = new Fact[this.task.getOriginalPostconditions().length][1];
            Fact[][] factArray6 = new Fact[this.task.getOriginalPostconditions().length][1];
            int n2 = 0;
            while (n2 < factArray5.length) {
                factArray5[n2][0] = factArray3[n2];
                ++n2;
            }
            int n3 = 0;
            while (n3 < factArray5.length) {
                this.debug("user_out[" + String.valueOf(n3) + "] = " + factArray5[n3].toString());
                factArray6[n3] = factArray5[n3];
                ++n3;
            }
            this.task.relaxNumberFields();
            this.thread.start();
            this.setState(4);
            this.diagnostic = "Running started ... ";
            Core.DEBUG(2, this.diagnostic);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setState(5);
            this.diagnostic = "2: Cannot exec - ClassNotFoundException";
            Core.DEBUG(2, this.diagnostic);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.setState(5);
            this.diagnostic = "3: Cannot exec - IllegalAccessException";
            Core.DEBUG(2, this.diagnostic);
        }
        catch (InstantiationException instantiationException) {
            this.setState(5);
            this.diagnostic = "4: Cannot exec - InstantiationException";
            Core.DEBUG(2, this.diagnostic);
        }
        return true;
    }

    public boolean overRun() {
        ResourceDb resourceDb = this.getAgentContext().getResourceDb();
        if (this.thread.isFinished()) {
            Fact[][] factArray = this.thread.getOutputArgs();
            if (factArray != null && factArray.length > 0) {
                Fact[][] factArray2 = this.thread.outputArgs;
                Fact[][] factArray3 = this.thread.getInputArgs();
                Fact[] factArray4 = this.thread.getExpectedInputArgs();
                int n = factArray.length;
                int n2 = 0;
                while (n2 < factArray4.length) {
                    if (factArray4[n2].isReplaced()) {
                        resourceDb.add(factArray3[n2]);
                    }
                    ++n2;
                }
                if (factArray2 != null) {
                    this.producedDb.allocatePostconditions(factArray2);
                }
                this.setState(6);
                return false;
            }
            this.setState(5);
            this.diagnostic = "5: Failed - task execution did not produce output";
            return false;
        }
        double d = this.planner.getAgentContext().now();
        if (d >= (double)this.end_time) {
            if (d < (double)this.goal.getEndTime() && this.planner.incrementProcessorTime(this, (int)d)) {
                return false;
            }
            this.setState(5);
            this.diagnostic = "5: Failed - overrun allocated time: " + d + " > " + this.end_time;
            this.thread.abort();
            return true;
        }
        return false;
    }

    protected void setState(int n, PlanRecord planRecord) {
        if (planRecord == this.parent) {
            this.setState(n);
        }
    }

    public void setState(int n) {
        Assert.notFalse(n >= 1 && n <= 8);
        Core.DEBUG(3, "Setting state for rec " + this.id + " from " + state_string[this.state] + " to " + state_string[n]);
        this.state = n;
        this.planner.notifyMonitors(this, 5);
        switch (this.state) {
            case 1: 
            case 2: {
                PlanRecord[] planRecordArray = this.getChildren();
                int n2 = 0;
                while (n2 < planRecordArray.length) {
                    planRecordArray[n2].setState(n, this);
                    ++n2;
                }
                break;
            }
            case 3: {
                Core.DEBUG(3, this);
                Core.DEBUG(3, this.producedDb);
                Core.DEBUG(3, this.consumedDb);
                this.goal.setSuppliedDb(null);
                if (!this.goal.whichType()) {
                    this.setState(8);
                    return;
                }
                PlanRecord[] planRecordArray = this.getChildren();
                int n3 = 0;
                while (n3 < planRecordArray.length) {
                    planRecordArray[n3].setState(n, this);
                    ++n3;
                }
                break;
            }
            case 8: {
                int n4;
                this.goal.setSuppliedDb(null);
                Assert.notFalse(!this.goal.whichType());
                if (this.slots == null) {
                    this.noAllowedInvocations = this.goal.getInvocations();
                    this.slots = new boolean[this.end_time - this.start_time];
                    n4 = 0;
                    while (n4 < this.slots.length) {
                        this.slots[n4] = false;
                        ++n4;
                    }
                    this.images = new Vector();
                }
                PlanRecord[] planRecordArray = this.getChildren();
                n4 = 0;
                while (n4 < planRecordArray.length) {
                    planRecordArray[n4].setState(n, this);
                    ++n4;
                }
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                this.dispose(this.parent, this.key);
                this.producedDb.notifyFailed(this.other_tasks, this.path);
                break;
            }
            case 7: {
                ++this.reconfirm_count;
                break;
            }
        }
    }

    public void softFail(PlannerQueryStruct plannerQueryStruct, int n) {
        Goal goal;
        Core.DEBUG(2, "softFail..." + plannerQueryStruct);
        if (n == 0) {
            this.state = 5;
            this.planner.notifyMonitors(this, 5);
        }
        Vector vector = this.descendantSubgoals();
        vector.addElement(this.goal.getId());
        int n2 = 0;
        while (n2 < plannerQueryStruct.external.size()) {
            goal = (Goal)plannerQueryStruct.external.elementAt(n2);
            if (vector.contains(goal.getId())) {
                plannerQueryStruct.external.removeElementAt(n2--);
            }
            ++n2;
        }
        this.dispose(this.parent, this.key);
        if (n == 0) {
            this.planner.clear_bind(plannerQueryStruct.goals);
            int n3 = 0;
            while (n3 < plannerQueryStruct.goals.size()) {
                goal = (Goal)plannerQueryStruct.goals.elementAt(n3);
                if (vector.contains(goal.getId())) {
                    plannerQueryStruct.goals.removeElementAt(n3--);
                }
                ++n3;
            }
        }
        this.producedDb.softNotifyFailed(this.other_tasks, this.path, plannerQueryStruct, n);
    }

    public Vector descendantSubgoals() {
        Vector vector = this.consumedDb.currentSubgoals();
        PlanRecord[] planRecordArray = this.consumedDb.getChildren();
        int n = 0;
        while (n < planRecordArray.length) {
            Vector vector2 = planRecordArray[n].descendantSubgoals();
            vector = Misc.union(vector, vector2);
            ++n;
        }
        return vector;
    }

    public int latestConfirmTime() {
        int n = this.start_time;
        PlanRecord[] planRecordArray = this.consumedDb.getChildren();
        int n2 = 0;
        while (n2 < planRecordArray.length) {
            n = Math.min(n, planRecordArray[n2].latestConfirmTime());
            ++n2;
        }
        return n;
    }

    public void dispose() {
        this.dispose(this.parent, this.key, this.goal.getSuppliedDb());
    }

    public void dispose(PlanRecord planRecord, String string) {
        this.dispose(planRecord, string, this.goal.getSuppliedDb());
    }

    protected void dispose(PlanRecord planRecord, String string, SuppliedDb suppliedDb) {
        if (this.is_disposed) {
            return;
        }
        Core.DEBUG(3, "Dispose rec " + this.id + "-" + this.goal.getFactType() + ":  " + state_string[this.state]);
        switch (this.state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                if (!this.producedDb.hasAtMostOneParent(planRecord, string)) break;
                Core.DEBUG(3, "rec " + this.id + " hasAtMostOneParent");
                this.planner.freeCells(this.proc, this.start_time, this.end_time);
                if (this.thread != null) {
                    this.thread.abort();
                }
                this.thread = null;
                PlanRecord[] planRecordArray = this.consumedDb.getChildren();
                int n = 0;
                while (n < planRecordArray.length) {
                    planRecordArray[n].dispose(this, this.key);
                    ++n;
                }
                this.consumedDb.releaseResources(suppliedDb);
                Core.DEBUG(3, "Calling planner.del: " + this);
                this.planner.del(this);
                this.is_disposed = true;
                this.planner.notifyMonitors(this, 4);
                break;
            }
            case 8: {
                int n = 0;
                while (this.images != null && n < this.images.size()) {
                    PlanRecord planRecord2 = (PlanRecord)this.images.elementAt(n);
                    planRecord2.originalDisposed();
                    ++n;
                }
            }
            case 5: 
            case 6: {
                int n;
                if (this.thread != null) {
                    this.thread.abort();
                }
                this.thread = null;
                if (!this.goal.whichType()) {
                    n = 0;
                    while (n < this.slots.length) {
                        if (!this.slots[n]) {
                            this.planner.freeCell(this.proc, n + this.start_time);
                        }
                        ++n;
                    }
                } else {
                    this.planner.freeCells(this.proc, this.start_time, this.end_time);
                }
                PlanRecord[] planRecordArray = this.consumedDb.getChildren();
                n = 0;
                while (n < planRecordArray.length) {
                    planRecordArray[n].dispose(this, this.key);
                    ++n;
                }
                this.consumedDb.releaseResources(suppliedDb);
                this.planner.del(this);
                this.is_disposed = true;
                this.planner.notifyMonitors(this, 4);
                break;
            }
            default: {
                Assert.notNull(null);
            }
        }
    }

    public boolean hasAncestor(PlanRecord planRecord) {
        PlanRecord planRecord2 = this;
        while (planRecord2 != null) {
            if (planRecord2 == planRecord) {
                return true;
            }
            planRecord2 = planRecord2.getParent();
        }
        return false;
    }

    public PlanRecord getRoot() {
        PlanRecord planRecord = this;
        while (planRecord.getParent() != null) {
            planRecord = planRecord.getParent();
        }
        return planRecord;
    }

    public void reallocateResource(int n, int n2) {
        this.reallocateResource(n, n2, null, null);
    }

    public void reallocateResource(int n, PlanRecord planRecord, int n2, int n3, Vector vector, Vector vector2) {
        this.consumedDb.remove(n, planRecord, n2, n3);
        this.reallocateResource(n, n3, vector, vector2);
    }

    public void reallocateResource(int n, int n2, Vector vector, Vector vector2) {
        ResourceDb resourceDb = this.planner.getAgentContext().ResourceDb();
        Core.DEBUG(3, "Attempting reallocation...");
        SuppliedDb suppliedDb = this.goal.getSuppliedDb();
        if (suppliedDb != null) {
            n2 = suppliedDb.allocateResource(this, n, n2);
        }
        if (n2 == 0) {
            return;
        }
        Goal goal = resourceDb.allocateResource(this, n, n2);
        if (goal == null) {
            return;
        }
        this.diagnostic = "Required resource unavailable - replanning";
        this.setState(7);
        double d = this.planner.getAgentContext().now() + this.planner.getAgentContext().getReplanPeriod();
        goal.setConfirmTime(new Time(d));
        Core.DEBUG(3, "Reallocation failed... internal replanning");
        if (this.path == null) {
            this.path = Misc.copyVector(this.path);
        }
        PlannerQueryStruct plannerQueryStruct = new PlannerQueryStruct(goal);
        plannerQueryStruct.internal.addElement(this);
        this.planner.schedule(this.key, this, this.path, goal, vector, plannerQueryStruct, true);
        if (!plannerQueryStruct.external.isEmpty()) {
            Core.DEBUG(3, "Reallocation failed... external replanning");
            this.planner.index(plannerQueryStruct);
            this.planner.getAgentContext().Engine().replan(plannerQueryStruct, this.key);
        } else if (!plannerQueryStruct.internal.isEmpty()) {
            this.reconfirm();
        }
    }

    public void raiseException(int n, String string, int n2) {
        Goal goal = new Goal(this.goal);
        goal.setId(this.planner.getAgentContext().newId("subgoal"));
        goal.setImage(this.goal.getId());
        Fact fact = this.task.getPostcondition(n);
        fact.setNumber(n2);
        goal.setFact(fact);
        goal.setDesiredBy(this.planner.getAgentContext().whoami());
        double d = this.planner.getAgentContext().now() + this.planner.getAgentContext().getReplanPeriod();
        goal.setConfirmTime(new Time(d));
        Core.DEBUG(3, "Top goal... internal replanning");
        PlannerQueryStruct plannerQueryStruct = new PlannerQueryStruct(goal);
        this.planner.schedule(this.key, null, this.path, goal, this.other_tasks, plannerQueryStruct, true);
        if (!plannerQueryStruct.internal.isEmpty()) {
            if (!plannerQueryStruct.external.isEmpty()) {
                Core.DEBUG(3, "Top goal... external replanning");
                this.planner.index(plannerQueryStruct);
                this.planner.getAgentContext().Engine().replan(plannerQueryStruct, this.key);
            } else {
                this.planner.book(3, goal, plannerQueryStruct.internal);
            }
        } else {
            Vector<Goal> vector = new Vector<Goal>();
            vector.addElement(this.goal);
            DelegationStruct delegationStruct = new DelegationStruct(this.planner.getAgentContext().whoami(), "failure", string, vector);
            this.planner.getAgentContext().Engine().add(delegationStruct);
        }
    }

    public void softReallocateResource(int n, PlanRecord planRecord, int n2, int n3, Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, int n4) {
        this.consumedDb.remove(n, planRecord, n2, n3);
        this.softReallocateResource(n, n3, vector, vector2, plannerQueryStruct, n4);
    }

    public void softReallocateResource(int n, int n2, Vector vector, Vector vector2, PlannerQueryStruct plannerQueryStruct, int n3) {
        ResourceDb resourceDb = this.planner.getAgentContext().ResourceDb();
        if (this.path == null) {
            this.path = Misc.copyVector(this.path);
        }
        Core.DEBUG(3, "Attempting soft reallocation...");
        SuppliedDb suppliedDb = this.goal.getSuppliedDb();
        if (suppliedDb != null) {
            n2 = suppliedDb.allocateResource(this, n, n2);
        }
        if (n2 == 0) {
            return;
        }
        Goal goal = resourceDb.allocateResource(this, n, n2);
        if (goal == null) {
            return;
        }
        this.diagnostic = "Required resource unavailable - replanning";
        if (n3 == 0) {
            plannerQueryStruct.goals.addElement(goal);
            this.planner.index(plannerQueryStruct);
            this.setState(7);
            double d = this.planner.getAgentContext().now() + this.planner.getAgentContext().getReplanPeriod();
            goal.setConfirmTime(new Time(d));
        } else {
            goal.setConfirmTime(this.goal.getConfirmTime());
        }
        Core.DEBUG(3, "Soft reallocation failed... internal replanning");
        if (!plannerQueryStruct.internal.contains(this)) {
            plannerQueryStruct.internal.addElement(this);
        }
        this.planner.schedule(this.key, this, this.path, goal, vector, plannerQueryStruct, true);
    }

    public void softRaiseException(int n, String string, int n2, PlannerQueryStruct plannerQueryStruct, int n3) {
        Goal goal;
        Fact fact = this.task.getPostcondition(n);
        fact.setNumber(n2);
        if (n3 == 0) {
            goal = new Goal(this.goal);
            goal.setId(this.planner.getAgentContext().newId("subgoal"));
            goal.setImage(this.goal.getId());
            goal.setDesiredBy(this.planner.getAgentContext().whoami());
            goal.setFact(fact);
            double d = this.planner.getAgentContext().now() + this.planner.getAgentContext().getReplanPeriod();
            goal.setConfirmTime(new Time(d));
            goal.setSuppliedDb(null);
        } else {
            goal = this.goal;
        }
        Core.DEBUG(3, "Top goal... soft internal replanning");
        this.removeRecordTree(plannerQueryStruct.internal);
        this.planner.schedule(this.key, null, this.path, goal, this.other_tasks, plannerQueryStruct, true);
        if (plannerQueryStruct.internal.isEmpty() && n3 == 0) {
            Vector<Goal> vector = new Vector<Goal>();
            vector.addElement(this.goal);
            DelegationStruct delegationStruct = new DelegationStruct(this.planner.getAgentContext().whoami(), "failure", string, vector);
            this.planner.getAgentContext().Engine().add(delegationStruct);
        }
    }

    public void removeRecordTree(Vector vector) {
        vector.removeElement(this);
        PlanRecord[] planRecordArray = this.getChildren();
        int n = 0;
        while (n < planRecordArray.length) {
            planRecordArray[n].removeRecordTree(vector);
            ++n;
        }
    }

    public ReportRec report() {
        String string = this.parent != null ? this.parent.getGoal().getId() : null;
        Vector<String> vector = new Vector<String>();
        if (this.goal.getImage() != null) {
            vector.addElement(this.goal.getImage());
        }
        Vector vector2 = this.producedDb.getAllParents();
        vector2.removeElement(this.goal.getId());
        ReportRec reportRec = new ReportRec(this.goal.getId(), this.goal.getFactType(), this.task.getName(), this.planner.getAgentContext().whoami(), this.state, this.goal.getDesiredBy(), this.goal.getRootId(), string, this.start_time, this.end_time, this.cost, this.consumedDb.allSubgoals(), vector, vector2, this.task.getPreconditions(), this.task.getPostconditions());
        return reportRec;
    }

    public Goal createSubgoal(Fact fact, int n) {
        String string = this.planner.getAgentContext().newId("subgoal");
        String string2 = this.planner.getAgentContext().whoami();
        Goal goal = new Goal(this.goal.whichType(), string, fact, string2);
        if (!this.goal.whichType()) {
            goal.setStartTime(this.start_time);
            goal.setEndTime(this.end_time - this.task.getTime());
            goal.setInvocations(this.goal.getInvocations());
        } else {
            goal.setEndTime(this.start_time);
        }
        goal.setConfirmTime(this.goal.getConfirmTime());
        goal.setPriority(this.goal.getPriority());
        goal.setCost(0.0);
        goal.setRootId(this.goal.getRootId());
        goal.setSuppliedDb(this.goal.getSuppliedDb());
        this.consumedDb.add(n, goal.getId(), fact.getNumber());
        return goal;
    }

    public boolean hasSubgoal(String string) {
        return this.consumedDb.currentSubgoals().contains(string);
    }

    public boolean hasSubgoal(Goal goal) {
        return this.consumedDb.currentSubgoals().contains(goal.getId());
    }

    public boolean equals(PlanRecord planRecord) {
        return this.id.equals(planRecord.getId()) && this.goal.equals(planRecord.getGoal()) && this.task.equals(planRecord.getTask());
    }

    public PlanRecord enact(PlannerEnactStruct plannerEnactStruct, Goal goal, PlanRecord planRecord, String string, Hashtable hashtable) {
        System.out.println("ENACTING....");
        Fact fact = goal.getFact();
        int n = fact.getNumber();
        int n2 = goal.getEndTime();
        int n3 = this.task.getTime();
        n2 = n2 <= 0 ? this.end_time + n2 : n2;
        goal.setEndTime(n2);
        Core.DEBUG(4, "required = " + n);
        Core.DEBUG(4, "noAllowedInvocations = " + this.noAllowedInvocations);
        Core.DEBUG(4, "noAvailableItems = " + this.noAvailableItems);
        Core.DEBUG(4, "etime = " + n2);
        Core.DEBUG(4, "end_time = " + this.end_time);
        Core.DEBUG(4, "start_time = " + this.start_time);
        Core.DEBUG(4, "duration = " + n3);
        boolean bl = plannerEnactStruct.ok = plannerEnactStruct.ok && !this.goal.whichType() && goal.whichType() && n2 <= this.end_time && n2 >= this.start_time + n3 && this.noAllowedInvocations > 0 && n <= this.noAvailableItems;
        if (!plannerEnactStruct.ok) {
            Core.DEBUG(4, "Failed here");
            return null;
        }
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 - this.start_time - 1;
        while (!bl2 && n6 >= n3 - 1) {
            bl2 = true;
            n4 = n6;
            n5 = n4 - n3 + 1;
            int n7 = n4;
            while (n7 >= n5) {
                bl2 = bl2 && !this.slots[n7];
                --n7;
            }
            --n6;
        }
        if (!bl2) {
            plannerEnactStruct.ok = false;
            return null;
        }
        System.out.println("ENACTING");
        PrimitiveTask primitiveTask = new PrimitiveTask(this.task);
        primitiveTask.relaxNumberFields();
        Core.DEBUG(4, "TaskImage Before = \n" + primitiveTask.pprint());
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        Fact fact2 = primitiveTask.getActiveEffect();
        plannerEnactStruct.ok = plannerEnactStruct.ok && fact2.unifiesWith(fact, bindings) && bindings.add(plannerEnactStruct.bindings) && primitiveTask.applyConstraints(bindings);
        Core.DEBUG(4, "TaskImage After = \n" + primitiveTask.pprint());
        if (!plannerEnactStruct.ok) {
            return null;
        }
        PlanRecord planRecord2 = new PlanRecord(this.planner, this, string, planRecord, goal, primitiveTask, this.proc, this.start_time + n5, this.start_time + n4 + 1);
        this.images.addElement(planRecord2);
        planRecord2.setAlternativeTasks(Misc.copyVector(this.other_tasks));
        planRecord2.setPath(Misc.copyVector(this.path));
        int n8 = this.start_time + n4;
        while (n8 > this.start_time + n4 - n3) {
            Core.DEBUG(4, "Assigning cell[" + this.proc + "][" + n8 + "] to " + planRecord2);
            this.planner.assignCell(this.proc, n8, planRecord2);
            --n8;
        }
        hashtable.put(this, planRecord2);
        plannerEnactStruct.images.addElement(planRecord2);
        this.producedDb.share(planRecord2.getProducedDb(), planRecord, string, this.parent, this.key);
        this.consumedDb.share(planRecord2.getConsumedDb());
        int n9 = n2 - this.end_time;
        Hashtable hashtable2 = planRecord2.getConsumedDb().getAllChildren();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Fact fact3 = (Fact)enumeration.nextElement();
            Object v = hashtable2.get(fact3);
            String string2 = this.planner.getAgentContext().newId("subgoal");
            String string3 = this.planner.getAgentContext().whoami();
            Goal goal2 = new Goal(true, string2, fact3, string3);
            goal2.setEndTime(n9);
            goal2.setPriority(this.goal.getPriority());
            goal2.setCost(0.0);
            goal2.setRootId(goal.getRootId());
            if (v instanceof String) {
                String string4 = (String)v;
                planRecord2.getConsumedDb().update(goal2.getId(), string4);
                plannerEnactStruct.external.addElement(goal2);
                plannerEnactStruct.table.put(goal2.getId(), string4);
                continue;
            }
            PlanRecord planRecord3 = (PlanRecord)v;
            PlanRecord planRecord4 = (PlanRecord)hashtable.get(planRecord3);
            if (planRecord4 == null) {
                planRecord4 = planRecord3.enact(plannerEnactStruct, goal2, planRecord2, string, hashtable);
            }
            Assert.notNull(planRecord4);
            planRecord2.getConsumedDb().update(planRecord4, planRecord3);
        }
        int n10 = n4;
        while (n10 >= n5) {
            this.slots[n10] = true;
            --n10;
        }
        --this.noAllowedInvocations;
        this.noAvailableItems -= n;
        return planRecord2;
    }

    public String toString() {
        return this.id + "/" + this.goal.getFactType() + "/" + this.goal.getFactId() + "/" + this.key;
    }

    public void debug(String string) {
    }
}

