/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.DecompositionStruct;
import zeus.actors.LinkInfo;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.SummaryTask;
import zeus.concepts.SuppliedDb;
import zeus.concepts.SuppliedItem;
import zeus.concepts.Task;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.KeyValue;
import zeus.util.Misc;

public class Decomposition
extends Hashtable {
    protected Vector constraints;
    protected Vector links;
    protected int node_pointer = -1;
    protected String root = null;
    protected Vector nodeList = new Vector();
    protected Planner planner = null;

    public Decomposition() {
    }

    public Decomposition(Planner planner, String string, PlanRecord planRecord, Vector vector, Goal goal, SummaryTask summaryTask) {
        int n;
        TaskLink taskLink;
        Enumeration<Object> enumeration;
        this.planner = planner;
        this.links = summaryTask.links();
        this.constraints = summaryTask.constraints();
        boolean bl = true;
        Hashtable<String, KeyValue> hashtable = new Hashtable<String, KeyValue>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("end");
        int n2 = 0;
        while (!vector2.isEmpty()) {
            Vector<String> vector3 = new Vector<String>();
            enumeration = this.links.elements();
            while (enumeration.hasMoreElements()) {
                KeyValue keyValue;
                String string2;
                taskLink = (TaskLink)enumeration.nextElement();
                String string3 = taskLink.getRightNode();
                if (!vector2.contains(string3) || (string2 = taskLink.getLeftNode()).equals("begin")) continue;
                if (!vector3.contains(string2)) {
                    vector3.addElement(string2);
                }
                if (!this.containsKey(string2)) {
                    this.add(summaryTask.getNode(string2));
                    keyValue = new KeyValue(string2, n2++);
                    Assert.notFalse(hashtable.put(keyValue.key, keyValue) == null);
                } else {
                    keyValue = (KeyValue)hashtable.get(string2);
                    keyValue.value = n2++;
                }
                this.addParentNode(string2, string3);
            }
            if (bl) {
                this.determineRoot(string, planRecord, vector, goal, vector3);
                bl = false;
            }
            vector2 = vector3;
        }
        enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.referencesNode("begin") && !taskLink.referencesNode("end")) continue;
            this.links.removeElement(taskLink);
        }
        KeyValue keyValue = new KeyValue();
        KeyValue[] keyValueArray = new KeyValue[hashtable.size()];
        enumeration = hashtable.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            keyValueArray[n3] = (KeyValue)enumeration.nextElement();
            ++n3;
        }
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            n = 0;
            while (n < keyValueArray.length - 1) {
                if (keyValueArray[n].value > keyValueArray[n + 1].value) {
                    keyValue.set(keyValueArray[n]);
                    keyValueArray[n].set(keyValueArray[n + 1]);
                    keyValueArray[n + 1].set(keyValue);
                    bl2 = true;
                }
                ++n;
            }
        }
        n = 0;
        while (n < keyValueArray.length) {
            this.nodeList.addElement(keyValueArray[n].key);
            ++n;
        }
        this.node_pointer = 0;
    }

    protected void determineRoot(String string, PlanRecord planRecord, Vector vector, Goal goal, Vector vector2) {
        Assert.notFalse(vector2.size() == 1);
        Fact fact = goal.getFact();
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string2);
            Fact[] factArray = decompositionStruct.node.getPostconditions();
            int n2 = 0;
            while (n2 < factArray.length) {
                if (!factArray[n2].isSideEffect() && factArray[n2].unifiesWith(fact, bindings)) {
                    decompositionStruct.node.resolve(bindings);
                    this.root = string2;
                    decompositionStruct.key = string;
                    decompositionStruct.goal = new Goal(goal);
                    decompositionStruct.parent_record = planRecord;
                    decompositionStruct.path = vector;
                    return;
                }
                ++n2;
                bindings.clear();
            }
            ++n;
        }
    }

    protected void add(TaskNode taskNode) {
        DecompositionStruct decompositionStruct = new DecompositionStruct(this.planner.getAgentContext().whoami(), taskNode);
        Assert.notFalse(this.put(taskNode.getName(), decompositionStruct) == null);
    }

    protected void addParentNode(String string, String string2) {
        if (string2.equals("end")) {
            return;
        }
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (!decompositionStruct.parents.contains(string2)) {
            decompositionStruct.parents.addElement(string2);
            this.addChildNode(string2, string);
        }
    }

    protected void addChildNode(String string, String string2) {
        if (string2.equals("begin")) {
            return;
        }
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (!decompositionStruct.children.contains(string2)) {
            decompositionStruct.children.addElement(string2);
        }
    }

    public synchronized String nextNode() {
        if (this.node_pointer < this.nodeList.size()) {
            String string = (String)this.nodeList.elementAt(this.node_pointer++);
            Core.DEBUG(2, "nextNode(): id = " + string);
            return this.allParentsScheduled(string) ? string : this.nextNode();
        }
        return null;
    }

    public synchronized void reset() {
        this.node_pointer = 0;
    }

    protected TaskLink findLink(String string, String string2) {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.getLeftNode().equals(string) || !taskLink.getRightNode().equals(string2)) continue;
            return taskLink;
        }
        return null;
    }

    protected boolean allParentsScheduled(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        DecompositionStruct decompositionStruct;
        String string2 = null;
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(string);
        int n5 = 0;
        while (n5 < decompositionStruct2.parents.size()) {
            string2 = (String)decompositionStruct2.parents.elementAt(n5);
            decompositionStruct = (DecompositionStruct)this.get(string2);
            Core.DEBUG(2, "allParentsScheduled(): nodeId = " + string + " parentId = " + string2 + " parent.scheduled = " + decompositionStruct.scheduled);
            if (!decompositionStruct.scheduled) {
                return false;
            }
            ++n5;
        }
        if (decompositionStruct2.parents.isEmpty() || decompositionStruct2.goal != null) {
            return true;
        }
        decompositionStruct2.current_parent = (String)decompositionStruct2.parents.elementAt(0);
        DecompositionStruct decompositionStruct3 = (DecompositionStruct)this.get(decompositionStruct2.current_parent);
        decompositionStruct2.parent_record = decompositionStruct3.record;
        decompositionStruct2.key = decompositionStruct3.key;
        TaskLink taskLink = this.findLink(string, decompositionStruct2.current_parent);
        decompositionStruct2.parent_link = taskLink.getId();
        Fact fact = null;
        fact = decompositionStruct3.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
        if (decompositionStruct3.record == null) {
            decompositionStruct2.goal = new Goal(decompositionStruct3.image.whichType(), this.planner.getAgentContext().newId("subgoal"), fact, this.planner.getAgentContext().whoami());
            if (decompositionStruct3.image.isContinuous()) {
                n4 = decompositionStruct3.image.getStartTime();
                n3 = decompositionStruct3.image.getEndTime();
                int n6 = decompositionStruct3.image.getInvocations();
                n2 = (n3 - n4) / n6;
                decompositionStruct2.goal.setStartTime(n4);
                decompositionStruct2.goal.setEndTime(n3 - n2);
                decompositionStruct2.goal.setInvocations(n6);
            } else {
                decompositionStruct2.goal.setEndTime(this.getStartTime(taskLink, decompositionStruct3));
            }
            decompositionStruct2.goal.setConfirmTime(decompositionStruct3.image.getConfirmTime());
            decompositionStruct2.goal.setPriority(decompositionStruct3.image.getPriority());
            decompositionStruct2.goal.setCost(0.0);
            decompositionStruct2.goal.setRootId(decompositionStruct3.image.getRootId());
        } else {
            PrimitiveTask primitiveTask = decompositionStruct3.record.getTask();
            Fact[] factArray = ((Task)primitiveTask).getPreconditions();
            Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
            n2 = 0;
            n = 0;
            while (n2 == 0 && n < factArray.length) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    decompositionStruct2.goal = decompositionStruct3.record.createSubgoal(factArray[n], n);
                    n2 = 1;
                }
                ++n;
                bindings.clear();
            }
            Assert.notFalse(n2 != 0);
        }
        n4 = decompositionStruct2.goal.getStartTime();
        n3 = decompositionStruct2.goal.getEndTime();
        n2 = 0;
        while (n2 < decompositionStruct2.parents.size()) {
            string2 = (String)decompositionStruct2.parents.elementAt(n2);
            decompositionStruct = (DecompositionStruct)this.get(string2);
            TaskLink taskLink2 = this.findLink(string, string2);
            if (decompositionStruct.record == null) {
                if (decompositionStruct.image.isContinuous()) {
                    n = decompositionStruct.image.getStartTime();
                    int n7 = decompositionStruct.image.getEndTime();
                    int n8 = decompositionStruct.image.getInvocations();
                    int n9 = (n7 - n) / n8;
                    n4 = Math.min(n4, n);
                    n3 = Math.min(n3, n7 - n9);
                } else {
                    n3 = Math.min(n3, this.getStartTime(taskLink2, decompositionStruct));
                }
            } else if (decompositionStruct.goal.isContinuous()) {
                n4 = Math.min(n4, decompositionStruct.record.getStartTime());
                n3 = Math.min(n3, decompositionStruct.record.getEndTime() - decompositionStruct.record.getTask().getTime());
            } else {
                n3 = Math.min(n3, decompositionStruct.record.getStartTime());
            }
            ++n2;
        }
        decompositionStruct2.goal.setEndTime(n3);
        if (decompositionStruct2.goal.isContinuous()) {
            decompositionStruct2.goal.setStartTime(n4);
        }
        decompositionStruct2.path = Misc.copyVector(decompositionStruct3.path);
        decompositionStruct2.path.addElement(decompositionStruct3.goal.getFact());
        this.links.removeElement(taskLink);
        return true;
    }

    protected int getStartTime(TaskLink taskLink, DecompositionStruct decompositionStruct) {
        String string = (String)decompositionStruct.lookupTable.get(taskLink.getId());
        SuppliedItem suppliedItem = decompositionStruct.given.getSuppliedItem(string);
        return suppliedItem.getEarliestReservationTime();
    }

    protected String[] getReservationId(TaskLink taskLink, DecompositionStruct decompositionStruct) {
        String string = (String)decompositionStruct.lookupTable.get(taskLink.getId());
        SuppliedItem suppliedItem = decompositionStruct.given.getSuppliedItem(string);
        return suppliedItem.getReservationId();
    }

    public Fact[] getPreconditions(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.node.getPreconditions();
    }

    public Fact[] getPostconditions(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.node.getPostconditions();
    }

    public Vector getPath(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.path;
    }

    public Goal getGoal(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.goal;
    }

    public String getKey(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.key;
    }

    public PlanRecord getParentRecord(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.parent_record;
    }

    public void setRecords(String string, Vector vector) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        decompositionStruct.records = vector;
        decompositionStruct.record = (PlanRecord)vector.elementAt(0);
        decompositionStruct.scheduled = true;
        if (string.equals(this.root)) {
            return;
        }
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(decompositionStruct.current_parent);
        if (decompositionStruct2.record == null) {
            String string2 = (String)decompositionStruct2.lookupTable.get(decompositionStruct.parent_link);
            SuppliedItem suppliedItem = decompositionStruct2.given.getSuppliedItem(string2);
            String[] stringArray = suppliedItem.getReservationId();
            String string3 = decompositionStruct.agent;
            String string4 = decompositionStruct.record.getGoal().getId();
            int n = 0;
            while (n < stringArray.length) {
                String string5 = suppliedItem.getReservingAgent(stringArray[n]);
                String string6 = suppliedItem.getReservationGoalId(stringArray[n]);
                String string7 = suppliedItem.getReservationCommsKey(stringArray[n]);
                int n2 = suppliedItem.getReservedAmount(stringArray[n]);
                int n3 = suppliedItem.getReservationTime(stringArray[n]);
                boolean bl = suppliedItem.isReservationConsumed(stringArray[n]);
                Assert.notFalse(n2 > 0);
                decompositionStruct2.image.addProducer(string2, stringArray[n], string7, string3, string4, string5, string6);
                decompositionStruct.record.getProducedDb().replaceOrAdd(decompositionStruct.goal.getId(), string6 + "/" + stringArray[n], n3, n2, bl);
                ++n;
            }
        }
    }

    public boolean allNodesScheduled() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DecompositionStruct decompositionStruct = (DecompositionStruct)enumeration.nextElement();
            if (decompositionStruct.scheduled) continue;
            return false;
        }
        return true;
    }

    public void setQueued(String string, boolean bl) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        decompositionStruct.queued = bl;
    }

    public boolean isQueued(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.queued;
    }

    public boolean isScheduled(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.scheduled;
    }

    public PlanRecord getRecord(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        return decompositionStruct.record;
    }

    public PlanRecord getRootRecord() {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(this.root);
        return decompositionStruct.record;
    }

    public String getNodeWithGoalId(String string) {
        Core.DEBUG(3, "getNodeWithId\n" + this);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DecompositionStruct decompositionStruct = (DecompositionStruct)enumeration.nextElement();
            if (decompositionStruct.goal == null || !decompositionStruct.goal.getId().equals(string)) continue;
            return decompositionStruct.node.getName();
        }
        return null;
    }

    public void setImage(String string, Goal goal, String string2, String string3) {
        Core.DEBUG(3, "SetImage: node = " + string);
        Core.DEBUG(3, "SetImage: image = " + goal);
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        Core.DEBUG(3, "SetImage: st = " + decompositionStruct);
        SuppliedDb suppliedDb = goal.getSuppliedDb();
        Core.DEBUG(3, "SetImage: db = " + suppliedDb);
        Assert.notFalse(decompositionStruct.given.add(suppliedDb));
        Core.DEBUG(3, "SetImage: After assert");
        decompositionStruct.image = goal;
        decompositionStruct.agent = string2;
        decompositionStruct.scheduled = true;
        decompositionStruct.queued = false;
        DecompositionStruct decompositionStruct2 = (DecompositionStruct)this.get(decompositionStruct.current_parent);
        String string4 = decompositionStruct.agent;
        String string5 = decompositionStruct.image.getId();
        if (decompositionStruct2.record == null) {
            String string6 = (String)decompositionStruct2.lookupTable.get(decompositionStruct.parent_link);
            SuppliedItem suppliedItem = decompositionStruct2.given.getSuppliedItem(string6);
            String[] stringArray = suppliedItem.getReservationId();
            int n = 0;
            while (n < stringArray.length) {
                String string7 = suppliedItem.getReservingAgent(stringArray[n]);
                String string8 = suppliedItem.getReservationGoalId(stringArray[n]);
                String string9 = suppliedItem.getReservationCommsKey(stringArray[n]);
                int n2 = suppliedItem.getReservedAmount(stringArray[n]);
                int n3 = suppliedItem.getReservationTime(stringArray[n]);
                boolean bl = suppliedItem.isReservationConsumed(stringArray[n]);
                Assert.notFalse(n2 > 0);
                decompositionStruct2.image.addProducer(string6, stringArray[n], string9, string4, string5, string7, string8);
                decompositionStruct.image.addConsumer(string4, string5, string7, string8, stringArray[n], string9, n3, n2, bl);
                ++n;
            }
        } else {
            String string10 = this.planner.getAgentContext().newId("used");
            String string11 = this.planner.getAgentContext().whoami();
            String string12 = decompositionStruct2.goal.getId();
            int n = decompositionStruct2.record.getStartTime();
            int n4 = decompositionStruct2.record.getConsumedPosition(string5);
            boolean bl = decompositionStruct2.record.isPreconditionConsumed(n4);
            int n5 = decompositionStruct2.record.getAmountUsed(n4);
            Assert.notFalse(n5 > 0);
            decompositionStruct.image.addConsumer(string4, string5, string11, string12, string10, string3, n, n5, bl);
            decompositionStruct2.record.getConsumedDb().update(string5 + "/" + string10, string5);
        }
        decompositionStruct.key = string3;
    }

    public void enforceLinks() {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            int n;
            int n2;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String[] stringArray;
            SuppliedItem suppliedItem;
            String string6;
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            Core.DEBUG(2, "About to hardChain " + taskLink.getId());
            LinkInfo linkInfo = this.getLinkInfo(taskLink);
            if (linkInfo.child.record != null) {
                if (linkInfo.parent.record != null) {
                    linkInfo.child.record.getProducedDb().hardChain(linkInfo.effect_position, linkInfo.amount, linkInfo.parent.record, linkInfo.precond_position);
                    continue;
                }
                string6 = (String)linkInfo.parent.lookupTable.get(taskLink.getId());
                suppliedItem = linkInfo.parent.given.getSuppliedItem(string6);
                stringArray = suppliedItem.getReservationId();
                string5 = this.planner.getAgentContext().whoami();
                string4 = linkInfo.child.goal.getId();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string3 = suppliedItem.getReservingAgent(stringArray[n3]);
                    string2 = suppliedItem.getReservationGoalId(stringArray[n3]);
                    string = suppliedItem.getReservationCommsKey(stringArray[n3]);
                    linkInfo.parent.image.addProducer(string6, stringArray[n3], string, string5, string4, string3, string2);
                    n2 = suppliedItem.getReservedAmount(stringArray[n3]);
                    n = suppliedItem.getReservationTime(stringArray[n3]);
                    bl = suppliedItem.isReservationConsumed(stringArray[n3]);
                    Assert.notFalse(n2 > 0);
                    linkInfo.child.record.getProducedDb().hardChain(linkInfo.effect_position, string2 + "/" + stringArray[n3], n2, n, bl);
                    ++n3;
                }
                continue;
            }
            if (linkInfo.parent.record != null) {
                String string7 = this.planner.getAgentContext().newId("used");
                linkInfo.child.image.addConsumer(linkInfo.child.agent, linkInfo.child.goal.getId(), this.planner.getAgentContext().whoami(), linkInfo.parent.goal.getId(), string7, linkInfo.child.key, linkInfo.start, linkInfo.amount, linkInfo.consumed);
                linkInfo.parent.record.getConsumedDb().add(linkInfo.precond_position, linkInfo.child.goal.getId() + "/" + string7, linkInfo.amount);
                continue;
            }
            string6 = (String)linkInfo.parent.lookupTable.get(taskLink.getId());
            suppliedItem = linkInfo.parent.given.getSuppliedItem(string6);
            stringArray = suppliedItem.getReservationId();
            string5 = linkInfo.child.agent;
            string4 = linkInfo.child.goal.getId();
            int n4 = 0;
            while (n4 < stringArray.length) {
                string3 = suppliedItem.getReservingAgent(stringArray[n4]);
                string2 = suppliedItem.getReservationGoalId(stringArray[n4]);
                string = suppliedItem.getReservationCommsKey(stringArray[n4]);
                linkInfo.parent.image.addProducer(string6, stringArray[n4], string, string5, string4, string3, string2);
                n2 = suppliedItem.getReservedAmount(stringArray[n4]);
                n = suppliedItem.getReservationTime(stringArray[n4]);
                bl = suppliedItem.isReservationConsumed(stringArray[n4]);
                Assert.notFalse(n2 > 0);
                linkInfo.child.image.addConsumer(linkInfo.child.agent, linkInfo.child.goal.getId(), string3, string2, stringArray[n4], string, n, n2, bl);
                ++n4;
            }
        }
        this.links.removeAllElements();
    }

    protected LinkInfo getLinkInfo(TaskLink taskLink) {
        int n;
        Fact[] factArray;
        Fact fact;
        LinkInfo linkInfo = new LinkInfo();
        Bindings bindings = new Bindings(this.planner.getAgentContext().whoami());
        linkInfo.child = (DecompositionStruct)this.get(taskLink.getLeftNode());
        linkInfo.parent = (DecompositionStruct)this.get(taskLink.getRightNode());
        if (linkInfo.child.record != null) {
            fact = linkInfo.child.node.getPostcondition(taskLink.getLeftGroup(), taskLink.getLeftArg());
            factArray = linkInfo.child.record.getTask().getPostconditions();
            n = 0;
            while (n < factArray.length) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    linkInfo.effect_position = n;
                    break;
                }
                ++n;
                bindings.clear();
            }
        }
        if (linkInfo.parent.record != null) {
            fact = linkInfo.parent.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
            factArray = linkInfo.parent.record.getTask().getPreconditions();
            n = 0;
            while (n < factArray.length) {
                if (fact.unifiesWith(factArray[n], bindings)) {
                    linkInfo.precond_position = n;
                    linkInfo.amount = factArray[n].getNumber();
                    if (linkInfo.amount == 0) {
                        System.err.println("Error: integer expected in task.precond.fact.no field.\nEnsure \"no\" constraints are defined in all task specifications >> " + taskLink.getId());
                        linkInfo.amount = 1;
                    }
                    linkInfo.consumed = !factArray[n].isReadOnly();
                    linkInfo.start = linkInfo.parent.record.getStartTime();
                    break;
                }
                ++n;
                bindings.clear();
            }
        }
        return linkInfo;
    }

    public SuppliedDb getSuppliedDb(String string) {
        DecompositionStruct decompositionStruct = (DecompositionStruct)this.get(string);
        if (decompositionStruct.given != null) {
            return decompositionStruct.given;
        }
        decompositionStruct.given = new SuppliedDb(this.planner.getAgentContext().OntologyDb());
        decompositionStruct.lookupTable = new Hashtable();
        Enumeration enumeration = this.links.elements();
        String string2 = this.planner.getAgentContext().whoami();
        while (enumeration.hasMoreElements()) {
            TaskLink taskLink = (TaskLink)enumeration.nextElement();
            if (!taskLink.getRightNode().equals(string)) continue;
            Fact fact = decompositionStruct.node.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg());
            String string3 = this.planner.getAgentContext().newId("supplied");
            SuppliedItem suppliedItem = new SuppliedItem(string3, taskLink.getId(), string2, fact);
            decompositionStruct.given.add(suppliedItem);
            decompositionStruct.lookupTable.put(taskLink.getId(), string3);
        }
        return decompositionStruct.given;
    }
}

