/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import zeus.actors.PlanRecord;
import zeus.actors.ResourceDb;
import zeus.concepts.Fact;
import zeus.concepts.ResourceItem;
import zeus.util.Assert;
import zeus.util.Core;

public class DataRec
implements Observer {
    protected int nAvailable = 0;
    protected Fact fact = null;
    protected PlanRecord record = null;
    protected int position = -1;
    protected Vector available = new Vector();
    protected boolean isNegative;

    public DataRec() {
    }

    public DataRec(Fact fact, PlanRecord planRecord, int n) {
        Assert.notNull(fact);
        Assert.notNull(planRecord);
        Assert.notFalse(n >= 0);
        this.fact = fact;
        this.record = planRecord;
        this.position = n;
        this.isNegative = fact.isNegative();
    }

    public DataRec(Fact fact) {
        Core.ERROR(fact, 1, (Object)this);
        this.fact = fact;
        this.isNegative = fact.isNegative();
        Core.ERROR(!this.isNegative, 2, (Object)this);
    }

    public boolean add(ResourceItem resourceItem, int n, int n2) {
        Core.ERROR(!this.isNegative, 3, (Object)this);
        if (resourceItem.reserve(this, n, !this.fact.isReadOnly(), n2)) {
            this.available.addElement(resourceItem);
            this.nAvailable += n2;
            return true;
        }
        return false;
    }

    public void free() {
        this.nAvailable = 0;
        this.available.removeAllElements();
    }

    public void update(Observable observable, Object object) {
        Core.ERROR(!this.isNegative, 4, (Object)this);
        ResourceItem resourceItem = (ResourceItem)observable;
        String string = (String)object;
        Fact fact = resourceItem.getFact();
        Core.DEBUG(3, "Notification in datarec from " + fact.pprint() + " of " + string);
        if (string.equals("deleted")) {
            int n = this.remove(resourceItem);
            if (this.record != null) {
                if (!this.fact.isReadOnly()) {
                    this.record.updateCost(-1.0 * (double)n * fact.getUnitCost());
                }
                this.record.reallocateResource(this.position, n);
            } else {
                System.err.println("Reserved item deleted - what do we do??");
            }
        }
    }

    public boolean executeNow(ResourceDb resourceDb, int n) {
        if (this.isNegative) {
            return resourceDb.evalNegative(this.fact);
        }
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < this.available.size()) {
            ResourceItem resourceItem = (ResourceItem)this.available.elementAt(n2);
            bl &= resourceItem.executeNow(this, n);
            ++n2;
        }
        return bl;
    }

    public void newStartTime(int n) {
        if (this.isNegative) {
            return;
        }
        int n2 = 0;
        while (n2 < this.available.size()) {
            ResourceItem resourceItem = (ResourceItem)this.available.elementAt(n2);
            Assert.notFalse(resourceItem.newStartTime(this, n));
            ++n2;
        }
    }

    public DataRec subtract(PlanRecord planRecord, int n, int n2) {
        Core.ERROR(!this.isNegative, 5, (Object)this);
        Core.ERROR(this.record, 6, (Object)this);
        DataRec dataRec = planRecord.getDatarec(n);
        int n3 = planRecord.getStartTime();
        int n4 = 0;
        while (n2 > 0 && n4 < this.available.size()) {
            ResourceItem resourceItem = (ResourceItem)this.available.elementAt(n4);
            int n5 = resourceItem.getReservedAmount(this);
            if (n5 > n2) {
                resourceItem.changeReservedAmount(this, n5 - n2);
                dataRec.add(resourceItem, n3, n2);
            } else {
                resourceItem.cancelReservation(this);
                dataRec.add(resourceItem, n3, n5);
                this.available.removeElementAt(n4--);
            }
            this.nAvailable -= Math.min(n5, n2);
            n2 -= Math.min(n5, n2);
            ++n4;
        }
        return dataRec;
    }

    public boolean contains(ResourceItem resourceItem) {
        Core.ERROR(!this.isNegative, 7, (Object)this);
        return this.available.contains(resourceItem);
    }

    protected int remove(ResourceItem resourceItem) {
        this.available.removeElement(resourceItem);
        int n = resourceItem.getReservedAmount(this);
        resourceItem.cancelReservation(this);
        this.nAvailable -= n;
        return n;
    }

    public int getPosition() {
        Core.ERROR(this.record, 8, (Object)this);
        return this.position;
    }

    public PlanRecord getRecord() {
        Core.ERROR(this.record, 9, (Object)this);
        return this.record;
    }

    public String getId() {
        return this.fact.getId();
    }

    public Vector available() {
        return this.available;
    }

    public int nAvailable() {
        return this.isNegative ? this.fact.getNumber() : this.nAvailable;
    }

    public Fact getFact() {
        return this.fact;
    }

    public double getCost() {
        if (this.isNegative) {
            return this.fact.getNetCost();
        }
        double d = 0.0;
        int n = 0;
        while (n < this.available.size()) {
            ResourceItem resourceItem = (ResourceItem)this.available.elementAt(n);
            Fact fact = resourceItem.getFact();
            d += fact.getUnitCost() * (double)resourceItem.getReservedAmount(this);
            ++n;
        }
        return d;
    }

    public Fact[] getData() {
        Fact[] factArray;
        if (this.isNegative) {
            factArray = new Fact[]{this.fact};
        } else {
            Assert.notFalse(this.nAvailable > 0);
            factArray = new Fact[this.available.size()];
            int n = 0;
            while (n < this.available.size()) {
                ResourceItem resourceItem = (ResourceItem)this.available.elementAt(n);
                factArray[n] = new Fact(resourceItem.getFact());
                factArray[n].setNumber(resourceItem.getReservedAmount(this));
                ++n;
            }
        }
        return factArray;
    }

    public Fact mostGeneralDescriptor() {
        if (this.isNegative) {
            return this.fact;
        }
        if (this.available.isEmpty()) {
            return this.fact;
        }
        Fact fact = new Fact(((ResourceItem)this.available.elementAt(0)).getFact());
        int n = 1;
        while (n < this.available.size()) {
            Fact fact2 = ((ResourceItem)this.available.elementAt(n)).getFact();
            Assert.notFalse(fact.disjoin(fact2));
            ++n;
        }
        if (fact.isa("Entity")) {
            fact.setNumber(fact.newVar());
        }
        return fact;
    }
}

