/*
 * Decompiled with CFR 0.152.
 */
package zeus.actors;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.actors.DataRec;
import zeus.actors.PlanRecord;
import zeus.actors.PreconditionChain;
import zeus.actors.ResourceDb;
import zeus.actors.rtn.Engine;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.SuppliedDb;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.Misc;

public class ConsumedDb {
    protected Vector[] data = null;
    protected int[] consumed = null;
    protected DataRec[] records = null;
    protected PlanRecord owner = null;
    protected boolean resources_consumed = false;
    protected boolean resources_released = false;
    protected Vector all_subgoals = new Vector();

    public ConsumedDb() {
    }

    public ConsumedDb(PlanRecord planRecord, PrimitiveTask primitiveTask) {
        this.consumed = primitiveTask.numPreconditions();
        Assert.notNull(planRecord);
        this.owner = planRecord;
        this.data = new Vector[this.consumed.length];
        this.records = new DataRec[this.consumed.length];
        int n = 0;
        while (n < this.records.length) {
            this.records[n] = new DataRec(primitiveTask.getPrecondition(n), planRecord, n);
            ++n;
        }
    }

    public DataRec getDatarec(int n) {
        Core.DEBUG(2, "Getting datarec for " + this.owner + " at position " + n);
        return this.records[n];
    }

    public int amountUsed(int n) {
        return this.consumed[n];
    }

    public synchronized void add(int n, PlanRecord planRecord, int n2, int n3) {
        Assert.notFalse(this.requiredItems(n) >= n3);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        PreconditionChain preconditionChain = new PreconditionChain(planRecord, n2, n3);
        this.data[n].addElement(preconditionChain);
    }

    public synchronized void add(int n, String string, int n2) {
        Assert.notFalse(this.requiredItems(n) >= n2);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        PreconditionChain preconditionChain = new PreconditionChain(string, n2);
        this.data[n].addElement(preconditionChain);
    }

    public synchronized void add(int n, PreconditionChain preconditionChain) {
        Assert.notFalse(this.requiredItems(n) >= preconditionChain.amount);
        if (this.data[n] == null) {
            this.data[n] = new Vector();
        }
        this.data[n].addElement(preconditionChain);
    }

    public int requiredItems(int n) {
        if (this.records[n] == null) {
            return this.consumed[n];
        }
        int n2 = this.records[n].nAvailable();
        if (this.data[n] != null) {
            int n3 = 0;
            while (n3 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n3);
                n2 += preconditionChain.amount;
                ++n3;
            }
        }
        return this.consumed[n] - n2;
    }

    public boolean hasEnoughResources() {
        boolean bl = true;
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = (int)this.owner.getAgentContext().now();
        int n2 = 0;
        while (bl && n2 < this.records.length) {
            bl &= this.records[n2].nAvailable() == this.consumed[n2] && this.records[n2].executeNow(resourceDb, n);
            ++n2;
        }
        return bl;
    }

    public void newStartTime(int n) {
        int n2 = 0;
        while (n2 < this.records.length) {
            this.records[n2].newStartTime(n);
            ++n2;
        }
    }

    public void consumeResources() {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = 0;
        while (n < this.records.length) {
            resourceDb.consume(this.records[n]);
            ++n;
        }
        this.resources_consumed = true;
    }

    public int getPosition(String string) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (preconditionChain.isExternal() && string.equals(preconditionChain.key)) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        Assert.notNull(null);
        return -1;
    }

    public void factExists(int n, PlanRecord planRecord, int n2, int n3) {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        Vector vector = this.data[n];
        int n4 = 0;
        while (n4 < vector.size()) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(n4);
            if (preconditionChain.record == planRecord && preconditionChain.position == n2 && preconditionChain.amount == n3) {
                vector.removeElementAt(n4--);
                Goal goal = resourceDb.allocateResource(this.owner, n, n3);
                if (goal != null) {
                    System.err.println("Resource Taken by someone?:\n" + goal);
                    try {
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                Core.DEBUG(2, "Calling Constrain: " + this.records[n]);
                this.constrain(this.records[n]);
                return;
            }
            ++n4;
        }
        Assert.notNull(null);
    }

    public void factExists(String string) {
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = this.getPosition(string);
        Vector vector = this.data[n];
        int n2 = 0;
        while (n2 < vector.size()) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(n2);
            if (preconditionChain.isExternal() && preconditionChain.key.equals(string)) {
                vector.removeElementAt(n2--);
                Goal goal = resourceDb.allocateResource(this.owner, n, preconditionChain.amount);
                if (goal != null) {
                    System.err.println("Resource Taken by someone?:\n" + goal);
                }
                this.constrain(this.records[n]);
                Core.DEBUG(2, "Calling Constrain: " + this.records[n]);
                return;
            }
            ++n2;
        }
        Assert.notNull(null);
    }

    public synchronized void replace(String string, PlanRecord planRecord, int n, int n2) {
        int n3 = this.getPosition(string);
        Vector vector = this.data[n3];
        int n4 = 0;
        while (n4 < vector.size()) {
            PreconditionChain preconditionChain = (PreconditionChain)vector.elementAt(n4);
            if (preconditionChain.isExternal() && preconditionChain.key.equals(string)) {
                if (preconditionChain.amount == n2) {
                    vector.removeElementAt(n4--);
                } else {
                    preconditionChain.amount -= n2;
                }
                preconditionChain = new PreconditionChain(planRecord, n, n2);
                vector.addElement(preconditionChain);
                return;
            }
            ++n4;
        }
        Assert.notNull(null);
    }

    protected boolean constrain(DataRec dataRec) {
        Core.DEBUG(2, "Constrain: " + dataRec);
        Fact fact = dataRec.mostGeneralDescriptor();
        Core.DEBUG(2, "Constrain: mgd " + fact);
        Bindings bindings = new Bindings(this.owner.getAgentContext().whoami());
        Fact fact2 = dataRec.getFact();
        Core.DEBUG(2, "Constrain: getFact " + fact2);
        Assert.notFalse(fact.unifiesWith(fact2, bindings));
        return this.owner.applyConstraints(bindings);
    }

    public Fact[][] getInputData() {
        Fact[][] factArray = new Fact[this.consumed.length][];
        int n = 0;
        while (n < factArray.length) {
            factArray[n] = this.records[n].getData();
            ++n;
        }
        return factArray;
    }

    public PlanRecord getOwner() {
        return this.owner;
    }

    public synchronized void share(ConsumedDb consumedDb) {
        int n = 0;
        while (n < this.consumed.length) {
            int n2 = consumedDb.requiredItems(n);
            DataRec dataRec = this.records[n].subtract(consumedDb.getOwner(), n, n2);
            Assert.notNull(dataRec);
            Core.DEBUG(2, "Share consumedb of " + this.owner + " at " + n + " require " + (n2 -= dataRec.nAvailable()));
            int n3 = 0;
            while (n2 > 0 && n3 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n3);
                if (preconditionChain.amount <= n2) {
                    this.data[n].removeElementAt(n3--);
                    n2 -= preconditionChain.amount;
                } else {
                    preconditionChain.amount -= n2;
                    preconditionChain = new PreconditionChain(preconditionChain);
                    preconditionChain.amount = n2;
                    n2 = 0;
                }
                consumedDb.add(n, preconditionChain);
                ++n3;
            }
            ++n;
        }
    }

    public synchronized Hashtable getAllChildren() {
        System.out.println("getAllChildren is called");
        Hashtable<Fact, Object> hashtable = new Hashtable<Fact, Object>();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                Fact fact = new Fact(this.records[n].getFact());
                fact.setNumber(preconditionChain.amount);
                if (preconditionChain.isExternal()) {
                    hashtable.put(fact, preconditionChain.key);
                } else {
                    hashtable.put(fact, preconditionChain.record);
                }
                ++n2;
            }
            ++n;
        }
        return hashtable;
    }

    public synchronized Vector currentSubgoals() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (preconditionChain.isExternal()) {
                    StringTokenizer stringTokenizer = new StringTokenizer(preconditionChain.key, "/");
                    vector.addElement(stringTokenizer.nextToken());
                } else {
                    vector.addElement(preconditionChain.record.getGoal().getId());
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public synchronized Vector allSubgoals() {
        Vector vector = this.currentSubgoals();
        this.all_subgoals = Misc.union(this.all_subgoals, vector);
        return this.all_subgoals;
    }

    public synchronized PlanRecord[] getChildren() {
        Vector<PlanRecord> vector = new Vector<PlanRecord>();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (!preconditionChain.isExternal() && !vector.contains(preconditionChain.record)) {
                    vector.addElement(preconditionChain.record);
                }
                ++n2;
            }
            ++n;
        }
        PlanRecord[] planRecordArray = new PlanRecord[vector.size()];
        int n3 = 0;
        while (n3 < planRecordArray.length) {
            planRecordArray[n3] = (PlanRecord)vector.elementAt(n3);
            ++n3;
        }
        vector = null;
        return planRecordArray;
    }

    public synchronized boolean update(PlanRecord planRecord, PlanRecord planRecord2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (!preconditionChain.isExternal() && preconditionChain.record == planRecord2) {
                    preconditionChain.record = planRecord;
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean update(String string, String string2) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (preconditionChain.isExternal() && preconditionChain.key.equals(string2)) {
                    preconditionChain.key = string;
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public synchronized void releaseResources(SuppliedDb suppliedDb) {
        if (this.resources_consumed) {
            return;
        }
        if (this.resources_released) {
            return;
        }
        ResourceDb resourceDb = this.owner.getAgentContext().ResourceDb();
        int n = 0;
        while (n < this.records.length) {
            resourceDb.free(this.records[n]);
            ++n;
        }
        Engine engine = this.owner.getAgentContext().Engine();
        int n2 = 0;
        while (n2 < this.data.length) {
            int n3 = 0;
            while (this.data[n2] != null && n3 < this.data[n2].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n2].elementAt(n3);
                if (preconditionChain.isExternal()) {
                    if (suppliedDb == null || !suppliedDb.cancelReservation(preconditionChain.key)) {
                        engine.getAuditTable().cancel(preconditionChain.key);
                    }
                } else {
                    preconditionChain.record.breakEffectChain(preconditionChain.position, this.owner, n2, preconditionChain.amount);
                }
                ++n3;
            }
            ++n2;
        }
        this.resources_released = true;
    }

    public synchronized Fact remove(String string) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (this.data[n] != null && n2 < this.data[n].size()) {
                PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n2);
                if (preconditionChain.isExternal() && string.equals(preconditionChain.key)) {
                    this.data[n].removeElementAt(n2--);
                    Fact fact = new Fact(this.records[n].getFact());
                    fact.setNumber(preconditionChain.amount);
                    return fact;
                }
                ++n2;
            }
            ++n;
        }
        Assert.notNull(null);
        return null;
    }

    public synchronized Fact remove(int n, PlanRecord planRecord, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.data[n].size()) {
            PreconditionChain preconditionChain = (PreconditionChain)this.data[n].elementAt(n4);
            if (preconditionChain.record == planRecord && preconditionChain.position == n2 && preconditionChain.amount == n3) {
                this.data[n].removeElementAt(n4--);
                Fact fact = new Fact(this.records[n].getFact());
                fact.setNumber(preconditionChain.amount);
                return fact;
            }
            ++n4;
        }
        Assert.notNull(null);
        return null;
    }

    public String toString() {
        String string = "ConsumedDb(\n" + this.owner + "\n";
        int n = 0;
        while (n < this.data.length) {
            if (this.data[n] != null) {
                string = string + "data[" + n + "]: " + this.data[n] + "\n";
            }
            ++n;
        }
        string = string + ")";
        return string;
    }
}

