/*
 * Decompiled with CFR 0.152.
 */
package sl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import sl.CodecException;
import sl.Frame;
import sl.ISO8601;
import sl.OntologyException;
import sl.SL0Codec;

class SL0Encoder {
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class class$sl$Frame;

    SL0Encoder() {
    }

    public String encode(Frame frame) {
        StringWriter stringWriter = new StringWriter();
        try {
            if (frame.size() <= 0) {
                stringWriter.write(frame.getName());
            } else {
                this.writeFrame(frame, stringWriter);
            }
            stringWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
        catch (CodecException codecException) {
            codecException.printStackTrace();
        }
        return stringWriter.toString();
    }

    private void writeFrame(Frame frame, Writer writer) throws IOException, OntologyException, CodecException {
        writer.write("(" + frame.getName() + " ");
        int n = 0;
        while (n < frame.size()) {
            String string = frame.getSlotName(n);
            Object object = frame.getSlot(n);
            if (!string.startsWith(Frame.UNNAMEDPREFIX)) {
                if (!string.startsWith(":")) {
                    writer.write(":");
                }
                if (string.indexOf(" ") > -1) {
                    writer.write("\"" + string + "\"");
                } else {
                    writer.write(string);
                }
                writer.write(" ");
            }
            if (this.isFrame(object)) {
                this.writeFrame((Frame)object, writer);
            } else if (object.getClass().equals(class$java$util$Date == null ? SL0Encoder.class$("java.util.Date") : class$java$util$Date)) {
                writer.write(ISO8601.toString((Date)object));
            } else {
                if (object.getClass().equals(array$Ljava$lang$Byte == null ? SL0Encoder.class$("[Ljava.lang.Byte;") : array$Ljava$lang$Byte)) {
                    throw new CodecException("SL0 does not support bynary fields", null);
                }
                String string2 = object.toString();
                if (this.mustBeQuoted(string2)) {
                    writer.write("\"" + string2 + "\"");
                } else {
                    writer.write(string2);
                }
            }
            writer.write(" ");
            ++n;
        }
        writer.write(")");
    }

    private boolean mustBeQuoted(String string) {
        string.trim();
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return false;
        }
        return string.indexOf(" ") > -1 || string.equals("") || this.isAToken(string);
    }

    private boolean isAToken(String string) {
        return string.equalsIgnoreCase(SL0Codec.NAME_OF_ACTION_FRAME);
    }

    private boolean isFrame(Object object) {
        return object.getClass() == (class$sl$Frame == null ? (class$sl$Frame = SL0Encoder.class$("sl.Frame")) : class$sl$Frame);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

