/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.schema.facets;

import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsTerm;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.schema.Facet;
import JADE_SL.schema.ObjectSchema;
import java.util.Iterator;

public class TypedAggregateFacet
implements Facet {
    private ObjectSchema type;

    public TypedAggregateFacet(ObjectSchema objectSchema) {
        this.type = objectSchema;
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        if (!(absObject instanceof AbsAggregate)) {
            throw new OntologyException(absObject + " is not an AbsAggregate");
        }
        AbsAggregate absAggregate = (AbsAggregate)absObject;
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            AbsTerm absTerm = (AbsTerm)iterator.next();
            ObjectSchema objectSchema = ontology.getSchema(absTerm.getTypeName());
            if (objectSchema.isCompatibleWith(this.type)) continue;
            throw new OntologyException("Schema " + objectSchema + " for element " + absTerm + " is not compatible with type " + this.type);
        }
    }
}

