/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.schema;

import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsTerm;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.schema.ObjectSchema;
import JADE_SL.schema.TermSchema;
import java.util.Iterator;

public class AggregateSchema
extends TermSchema {
    public static final String BASE_NAME = "Aggregate";
    private static AggregateSchema baseSchema = new AggregateSchema();

    private AggregateSchema() {
        super(BASE_NAME);
    }

    public AggregateSchema(String string) {
        super(string);
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    public AbsObject newInstance() throws OntologyException {
        return new AbsAggregate(this.getTypeName());
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        if (!(absObject instanceof AbsAggregate)) {
            throw new OntologyException(absObject + " is not an AbsAggregate");
        }
        AbsAggregate absAggregate = (AbsAggregate)absObject;
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            AbsTerm absTerm = (AbsTerm)iterator.next();
            ObjectSchema objectSchema = ontology.getSchema(absTerm.getTypeName());
            objectSchema.validate(absTerm, ontology);
        }
    }

    protected boolean descendsFrom(ObjectSchema objectSchema) {
        if (objectSchema != null) {
            if (objectSchema.equals(AggregateSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(objectSchema);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null) {
            return this.getClass().getName().equals(object.getClass().getName());
        }
        return false;
    }
}

