/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.abs.AbsObject;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.schema.IRESchema;
import JADE_SL.schema.ObjectSchema;
import JADE_SL.schema.VariableSchema;
import java.lang.reflect.Method;

public class ReflectiveIntrospector
implements Introspector {
    public AbsObject externalise(Ontology ontology, Ontology ontology2, Object object) throws UnknownSchemaException, OntologyException {
        try {
            Class<?> clazz = object.getClass();
            ObjectSchema objectSchema = ontology.getSchema(clazz);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            AbsObject absObject = objectSchema.newInstance();
            Method[] methodArray = clazz.getMethods();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < methodArray.length) {
                AbsObject absObject2;
                String string;
                Method method = methodArray[n];
                String string2 = method.getName();
                if (string2.startsWith("get") && objectSchema.containsSlot(string = string2.substring(3, string2.length()).toUpperCase()) && (absObject2 = this.invokeGetMethod(ontology2, method, object)) != null) {
                    Ontology.setAttribute(absObject, string, absObject2);
                }
                ++n;
            }
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private AbsObject invokeGetMethod(Ontology ontology, Method method, Object object) throws OntologyException {
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
            if (object2 == null) {
                return null;
            }
            return ontology.fromObject(object2);
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking get method");
        }
    }

    public Object internalise(Ontology ontology, Ontology ontology2, AbsObject absObject) throws UngroundedException, UnknownSchemaException, OntologyException {
        try {
            String string = absObject.getTypeName();
            ObjectSchema objectSchema = ontology.getSchema(string, false);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            if (objectSchema instanceof IRESchema || objectSchema instanceof VariableSchema) {
                throw new UngroundedException();
            }
            Class clazz = ontology.getClassForElement(string);
            if (clazz == null) {
                throw new OntologyException("No java class associated to type " + string);
            }
            Object t = clazz.newInstance();
            Method[] methodArray = clazz.getMethods();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < methodArray.length) {
                AbsObject absObject2;
                String string2;
                Method method = methodArray[n];
                String string3 = method.getName();
                if (string3.startsWith("set") && objectSchema.containsSlot(string2 = string3.substring(3, string3.length()).toUpperCase()) && (absObject2 = absObject.getAbsObject(string2)) != null) {
                    this.invokeSetMethod(ontology2, method, t, absObject2);
                }
                ++n;
            }
            return t;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private void invokeSetMethod(Ontology ontology, Method method, Object object, AbsObject absObject) throws OntologyException {
        try {
            Object object2 = ontology.toObject(absObject);
            if (object2 == null) {
                return;
            }
            Object[] objectArray = new Object[]{object2};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 instanceof Long) {
                    Integer n = new Integer((int)((Long)object2).longValue());
                    objectArray[0] = n;
                } else if (object2 instanceof Double) {
                    Float f = new Float((float)((Double)object2).doubleValue());
                    objectArray[0] = f;
                }
                method.invoke(object, objectArray);
            }
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking set method");
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz) throws OntologyException {
    }
}

