/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.onto;

import JADE_SL.CaseInsensitiveString;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsObject;
import JADE_SL.onto.Introspector;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import JADE_SL.onto.UngroundedException;
import JADE_SL.onto.UnknownSchemaException;
import JADE_SL.schema.AggregateSchema;
import JADE_SL.schema.IRESchema;
import JADE_SL.schema.ObjectSchema;
import JADE_SL.schema.VariableSchema;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class BCReflectiveIntrospector
implements Introspector {
    public AbsObject externalise(Ontology ontology, Ontology ontology2, Object object) throws UnknownSchemaException, OntologyException {
        try {
            Class<?> clazz = object.getClass();
            ObjectSchema objectSchema = ontology.getSchema(clazz);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            AbsObject absObject = objectSchema.newInstance();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                ObjectSchema objectSchema2 = objectSchema.getSchema(string);
                String string2 = objectSchema2 instanceof AggregateSchema ? "getAll" + this.translateName(string) : "get" + this.translateName(string);
                Method method = this.findMethodCaseInsensitive(string2, clazz);
                AbsObject absObject2 = this.invokeGetMethod(ontology2, method, object);
                if (absObject2 != null) {
                    Ontology.setAttribute(absObject, string, absObject2);
                }
                ++n;
            }
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private AbsObject invokeGetMethod(Ontology ontology, Method method, Object object) throws OntologyException {
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
            if (object2 == null) {
                return null;
            }
            return ontology.fromObject(object2);
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking get method", exception);
        }
    }

    public Object internalise(Ontology ontology, Ontology ontology2, AbsObject absObject) throws UngroundedException, UnknownSchemaException, OntologyException {
        try {
            String string = absObject.getTypeName();
            ObjectSchema objectSchema = ontology.getSchema(string, false);
            if (objectSchema == null) {
                throw new UnknownSchemaException();
            }
            if (objectSchema instanceof IRESchema || objectSchema instanceof VariableSchema) {
                throw new UngroundedException();
            }
            Class clazz = ontology.getClassForElement(string);
            if (clazz == null) {
                throw new OntologyException("No java class associated to type " + string);
            }
            Object t = clazz.newInstance();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                AbsObject absObject2 = absObject.getAbsObject(string2);
                if (absObject2 != null) {
                    Method method;
                    String string3;
                    ObjectSchema objectSchema2 = objectSchema.getSchema(string2);
                    if (objectSchema2 instanceof AggregateSchema) {
                        string3 = "add" + this.translateName(string2);
                        method = this.findMethodCaseInsensitive(string3, clazz);
                        this.invokeAddMethod(ontology2, method, t, (AbsAggregate)absObject2);
                    } else {
                        string3 = "set" + this.translateName(string2);
                        method = this.findMethodCaseInsensitive(string3, clazz);
                        this.invokeSetMethod(ontology2, method, t, absObject2);
                    }
                }
                ++n;
            }
            return t;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    private void invokeSetMethod(Ontology ontology, Method method, Object object, AbsObject absObject) throws OntologyException {
        try {
            Object object2 = ontology.toObject(absObject);
            if (object2 == null) {
                return;
            }
            Object[] objectArray = new Object[]{object2};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 instanceof Long) {
                    Integer n = new Integer((int)((Long)object2).longValue());
                    objectArray[0] = n;
                } else if (object2 instanceof Double) {
                    Float f = new Float((float)((Double)object2).doubleValue());
                    objectArray[0] = f;
                }
                method.invoke(object, objectArray);
            }
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking set method", exception);
        }
    }

    private void invokeAddMethod(Ontology ontology, Method method, Object object, AbsAggregate absAggregate) throws OntologyException {
        try {
            List list = (List)ontology.toObject(absAggregate);
            if (list == null) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object[] objectArray = new Object[]{e};
                try {
                    method.invoke(object, objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Number number;
                    if (e instanceof Long) {
                        number = new Integer((int)((Long)e).longValue());
                        objectArray[0] = number;
                    } else if (e instanceof Double) {
                        number = new Float((float)((Double)e).doubleValue());
                        objectArray[0] = number;
                    }
                    method.invoke(object, objectArray);
                }
            }
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking add method", exception);
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz) throws OntologyException {
    }

    private Method findMethodCaseInsensitive(String string, Class clazz) throws OntologyException {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string2 = methodArray[n].getName();
            if (CaseInsensitiveString.equalsIgnoreCase(string2, string)) {
                return methodArray[n];
            }
            ++n;
        }
        throw new OntologyException("Method " + string + " not found in class " + clazz.getName());
    }

    private String translateName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case ':': {
                    break;
                }
                case '-': {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(Character.toUpperCase(c));
                        bl = false;
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

