/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.lang.sl;

import JADE_SL.CaseInsensitiveString;
import JADE_SL.ISO8601;
import JADE_SL.abs.AbsAgentAction;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsContentElement;
import JADE_SL.abs.AbsContentElementList;
import JADE_SL.abs.AbsIRE;
import JADE_SL.abs.AbsObjectImpl;
import JADE_SL.abs.AbsPredicate;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.abs.AbsTerm;
import JADE_SL.abs.AbsVariable;
import JADE_SL.lang.Codec;
import JADE_SL.lang.sl.ASCII_CharStream;
import JADE_SL.lang.sl.ParseException;
import JADE_SL.lang.sl.SLParserConstants;
import JADE_SL.lang.sl.SLParserTokenManager;
import JADE_SL.lang.sl.Token;
import JADE_SL.lang.sl.TokenMgrError;
import JADE_SL.onto.Ontology;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Vector;

class SLParser
implements SLParserConstants {
    Ontology curOntology = null;
    int slType = 3;
    public SLParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[20];
    private final int[] jj_la1_0 = new int[]{-2146422752, 0x100020, 0x200040, -2146422752, -37736448, -1967116288, -2146386016, -2147434752, -2146369632, -2113916928, -2146386016, 16384, -2146369632, 0x8400000, -2146422752, -2146422752, -2146386016, -184537088, 3840, -2147471360};
    private final int[] jj_la1_1 = new int[]{1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    private String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 1;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '\\' && string.charAt(n + 1) == '\"') {
                stringBuffer.append("\"");
                ++n;
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private AbsTerm toAbsAgentAction(AbsTerm absTerm) {
        if (absTerm instanceof AbsConcept && !(absTerm instanceof AbsAgentAction)) {
            AbsAgentAction absAgentAction = new AbsAgentAction(absTerm.getTypeName());
            String[] stringArray = absTerm.getNames();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    absAgentAction.set(stringArray[n], (AbsTerm)absTerm.getAbsObject(stringArray[n]));
                    ++n;
                }
            }
            return absAgentAction;
        }
        return absTerm;
    }

    void setSLType(int n) {
        this.slType = n;
    }

    AbsContentElement parse(Ontology ontology, String string) throws ParseException, TokenMgrError {
        this.curOntology = ontology;
        this.ReInit(new StringReader(string));
        AbsContentElementList absContentElementList = this.Content();
        if (absContentElementList.size() > 1) {
            return absContentElementList;
        }
        return absContentElementList.get(0);
    }

    public static void main(String[] stringArray) {
        SLParser sLParser = null;
        try {
            sLParser = new SLParser(System.in);
            sLParser.setSLType(Integer.parseInt(stringArray[0]));
        }
        catch (Exception exception) {
            System.out.println("usage: SLParser SLLevel\n  where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL");
            System.exit(0);
        }
        if (sLParser.slType < 3) {
            System.out.println("SL-" + sLParser.slType + " Parser Started ...");
        } else {
            System.out.println("Full-SL Parser Started ...");
        }
        while (true) {
            System.out.println("insert an SL expression to parse: ");
            try {
                AbsContentElementList absContentElementList = sLParser.Content();
                System.out.println("\n\n RESULT=\n" + absContentElementList.toString());
                System.out.println("\n\n");
                absContentElementList.dump();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public final AbsContentElementList Content() throws ParseException {
        AbsContentElementList absContentElementList = new AbsContentElementList();
        this.LBrace();
        block3: while (true) {
            AbsContentElement absContentElement = this.ContentExpression();
            absContentElementList.add(absContentElement);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 12: 
                case 13: 
                case 20: 
                case 31: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        this.RBrace();
        return absContentElementList;
    }

    public final void LBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void RBrace() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final AbsContentElement ContentExpression() throws ParseException {
        AbsContentElement absContentElement = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 31: 
            case 32: {
                String string = this.String();
                absContentElement = new AbsPredicate(string);
                break;
            }
            case 5: 
            case 20: {
                this.LBrace();
                absContentElement = this.ContentExpression_NoBrace();
                this.RBrace();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absContentElement;
    }

    public final AbsContentElement ContentExpression_NoBrace() throws ParseException {
        AbsObjectImpl absObjectImpl = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                absObjectImpl = this.IdentifyingExpression_NoBrace();
                break;
            }
            case 22: 
            case 27: {
                absObjectImpl = this.ActionExpression_NoBrace();
                break;
            }
            case 12: 
            case 13: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                absObjectImpl = this.Wff_NoBrace();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absObjectImpl;
    }

    public final AbsIRE IdentifyingExpression_NoBrace() throws ParseException {
        AbsIRE absIRE = null;
        Token token = this.jj_consume_token(23);
        if (this.slType < 2) {
            throw new ParseException("NotFullSL_IdentifyExpression_NotParsable_UseAtLeastSL2");
        }
        AbsVariable absVariable = this.Variable();
        AbsPredicate absPredicate = this.Wff();
        absIRE = new AbsIRE(token.image);
        absIRE.setVariable(absVariable);
        absIRE.setProposition(absPredicate);
        return absIRE;
    }

    public final AbsVariable Variable() throws ParseException {
        AbsVariable absVariable = null;
        Token token = this.jj_consume_token(7);
        absVariable = new AbsVariable();
        absVariable.setName(token.image);
        return absVariable;
    }

    public final AbsTerm Term() throws ParseException {
        AbsTerm absTerm = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                absTerm = this.Variable();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 32: {
                absTerm = this.Constant();
                break;
            }
            case 5: 
            case 20: {
                this.LBrace();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 25: 
                    case 31: 
                    case 32: {
                        absTerm = this.FunctionalTerm_NoBrace();
                        break;
                    }
                    case 22: 
                    case 27: {
                        absTerm = this.ActionExpression_NoBrace();
                        break;
                    }
                    case 23: {
                        absTerm = this.IdentifyingExpression_NoBrace();
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.RBrace();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absTerm;
    }

    public final AbsPrimitive Constant() throws ParseException {
        AbsPrimitive absPrimitive = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 31: 
            case 32: {
                String string = this.String();
                if (CaseInsensitiveString.equalsIgnoreCase(string, "true") || CaseInsensitiveString.equalsIgnoreCase(string, "false")) {
                    absPrimitive = AbsPrimitive.wrap(Boolean.getBoolean(string));
                    break;
                }
                absPrimitive = AbsPrimitive.wrap(string);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                absPrimitive = this.Number();
                break;
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                try {
                    Date date = ISO8601.toDate(token.image);
                    absPrimitive = AbsPrimitive.wrap(date);
                }
                catch (Exception exception) {
                    absPrimitive = AbsPrimitive.wrap(token.image);
                }
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absPrimitive;
    }

    public final AbsConcept FunctionalTerm_NoBrace() throws ParseException {
        AbsConcept absConcept = null;
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                Token token = this.jj_consume_token(25);
                AbsTerm absTerm = this.Term();
                AbsTerm absTerm2 = this.Term();
                absConcept = new AbsConcept(token.image);
                try {
                    String[] stringArray = this.curOntology.getSchema(token.image).getNames();
                    absConcept.set(stringArray[0], absTerm);
                    absConcept.set(stringArray[1], absTerm2);
                }
                catch (Exception exception) {
                    absConcept.set(Codec.UNNAMEDPREFIX + "0", absTerm);
                    absConcept.set(Codec.UNNAMEDPREFIX + "1", absTerm2);
                }
                break;
            }
            case 12: 
            case 13: 
            case 31: 
            case 32: {
                String string = this.String();
                absConcept = "set".equalsIgnoreCase(string) || "sequence".equalsIgnoreCase(string) ? new AbsAggregate(string) : new AbsConcept(string);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 31: 
                    case 32: {
                        this.FunctionalTermParameters(absConcept);
                        break block1;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absConcept;
    }

    public final void FunctionalTermParameters(AbsConcept absConcept) throws ParseException {
        int n = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 31: 
            case 32: {
                String[] stringArray = null;
                try {
                    stringArray = this.curOntology.getSchema(absConcept.getTypeName()).getNames();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                block14: while (true) {
                    AbsTerm absTerm = this.Term();
                    try {
                        absConcept.set(stringArray[n], absTerm);
                    }
                    catch (Exception exception) {
                        absConcept.set(Codec.UNNAMEDPREFIX + n, absTerm);
                    }
                    ++n;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 20: 
                        case 31: 
                        case 32: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            case 14: {
                block15: while (true) {
                    this.Parameter(absConcept);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: {
                            continue block15;
                        }
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Parameter(AbsConcept absConcept) throws ParseException {
        Token token = this.jj_consume_token(14);
        AbsTerm absTerm = this.Term();
        absConcept.set(token.image.substring(1), absTerm);
    }

    public final AbsAgentAction ActionExpression_NoBrace() throws ParseException {
        AbsAgentAction absAgentAction = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                Token token = this.jj_consume_token(22);
                AbsTerm absTerm = this.Term();
                AbsTerm absTerm2 = this.Term();
                absAgentAction = new AbsAgentAction(token.image);
                try {
                    String[] stringArray = this.curOntology.getSchema(token.image).getNames();
                    absAgentAction.set(stringArray[0], absTerm);
                    absAgentAction.set(stringArray[1], this.toAbsAgentAction(absTerm2));
                }
                catch (Exception exception) {
                    absAgentAction.set(Codec.UNNAMEDPREFIX + "0", absTerm);
                    absAgentAction.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(absTerm2));
                }
                break;
            }
            case 27: {
                Token token = this.jj_consume_token(27);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ActionOperatorExpression_NotParsable");
                }
                AbsAgentAction absAgentAction2 = this.ActionExpression();
                AbsAgentAction absAgentAction3 = this.ActionExpression();
                absAgentAction = new AbsAgentAction(token.image);
                try {
                    String[] stringArray = this.curOntology.getSchema(token.image).getNames();
                    absAgentAction.set(stringArray[0], absAgentAction2);
                    absAgentAction.set(stringArray[1], this.toAbsAgentAction(absAgentAction3));
                }
                catch (Exception exception) {
                    absAgentAction.set(Codec.UNNAMEDPREFIX + "0", absAgentAction2);
                    absAgentAction.set(Codec.UNNAMEDPREFIX + "1", this.toAbsAgentAction(absAgentAction3));
                }
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absAgentAction;
    }

    public final AbsAgentAction ActionExpression() throws ParseException {
        AbsAgentAction absAgentAction = null;
        this.LBrace();
        absAgentAction = this.ActionExpression_NoBrace();
        this.RBrace();
        return absAgentAction;
    }

    public final AbsPredicate Wff() throws ParseException {
        AbsPredicate absPredicate = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 31: 
            case 32: {
                String string = this.String();
                absPredicate = new AbsPredicate(string);
                break;
            }
            case 5: 
            case 20: {
                this.LBrace();
                absPredicate = this.Wff_NoBrace();
                this.RBrace();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absPredicate;
    }

    public final AbsPredicate Wff_NoBrace() throws ParseException {
        AbsPredicate absPredicate = null;
        String[] stringArray = null;
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                Token token = this.jj_consume_token(28);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_NotExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate absPredicate2 = this.Wff();
                absPredicate = new AbsPredicate(token.image);
                try {
                    stringArray = this.curOntology.getSchema(token.image).getNames();
                    absPredicate.set(stringArray[0], absPredicate2);
                }
                catch (Exception exception) {
                    absPredicate.set(Codec.UNNAMEDPREFIX + "0", absPredicate2);
                }
                break;
            }
            case 29: {
                Token token = this.jj_consume_token(29);
                if (this.slType < 1) {
                    throw new ParseException("NotFullSL_BinaryLogicalExpression_NotParsable_UseAtLeastSL1");
                }
                AbsPredicate absPredicate3 = this.Wff();
                AbsPredicate absPredicate4 = this.Wff();
                absPredicate = new AbsPredicate(token.image);
                try {
                    stringArray = this.curOntology.getSchema(token.image).getNames();
                    absPredicate.set(stringArray[0], absPredicate3);
                    absPredicate.set(stringArray[1], absPredicate4);
                }
                catch (Exception exception) {
                    absPredicate.set(Codec.UNNAMEDPREFIX + "0", absPredicate3);
                    absPredicate.set(Codec.UNNAMEDPREFIX + "1", absPredicate4);
                }
                break;
            }
            case 30: {
                Token token = this.jj_consume_token(30);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_QuantifierExpression_NotParsable_UseAtLeastSL2");
                }
                AbsVariable absVariable = this.Variable();
                AbsPredicate absPredicate5 = this.Wff();
                absPredicate = new AbsPredicate(token.image);
                try {
                    stringArray = this.curOntology.getSchema(token.image).getNames();
                    absPredicate.set(stringArray[0], absVariable);
                    absPredicate.set(stringArray[1], absPredicate5);
                }
                catch (Exception exception) {
                    absPredicate.set(Codec.UNNAMEDPREFIX + "0", absVariable);
                    absPredicate.set(Codec.UNNAMEDPREFIX + "1", absPredicate5);
                }
                break;
            }
            case 24: {
                Token token = this.jj_consume_token(24);
                if (this.slType < 2) {
                    throw new ParseException("NotFullSL_ModalOperatorExpression_NotParsable_UseAtLeastSL2");
                }
                AbsTerm absTerm = this.Term();
                AbsPredicate absPredicate6 = this.Wff();
                absPredicate = new AbsPredicate(token.image);
                try {
                    stringArray = this.curOntology.getSchema(token.image).getNames();
                    absPredicate.set(stringArray[0], absTerm);
                    absPredicate.set(stringArray[1], absPredicate6);
                }
                catch (Exception exception) {
                    absPredicate.set(Codec.UNNAMEDPREFIX + "0", absTerm);
                    absPredicate.set(Codec.UNNAMEDPREFIX + "1", absPredicate6);
                }
                break;
            }
            case 26: {
                Token token = this.jj_consume_token(26);
                AbsAgentAction absAgentAction = this.ActionExpression();
                absPredicate = new AbsPredicate(token.image);
                try {
                    stringArray = this.curOntology.getSchema(token.image).getNames();
                    absPredicate.set(stringArray[0], absAgentAction);
                }
                catch (Exception exception) {
                    absPredicate.set(Codec.UNNAMEDPREFIX + "0", absAgentAction);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 12: 
                    case 13: 
                    case 20: 
                    case 31: 
                    case 32: {
                        AbsPredicate absPredicate7 = this.Wff();
                        try {
                            absPredicate.set(stringArray[1], absPredicate7);
                        }
                        catch (Exception exception) {
                            absPredicate.set(Codec.UNNAMEDPREFIX + "1", absPredicate7);
                        }
                        break block8;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            case 12: 
            case 13: 
            case 31: 
            case 32: {
                String string = this.String();
                absPredicate = new AbsPredicate(string);
                int n = 0;
                try {
                    stringArray = this.curOntology.getSchema(string).getNames();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                block30: while (true) {
                    AbsTerm absTerm = this.Term();
                    try {
                        absPredicate.set(stringArray[n], absTerm);
                    }
                    catch (Exception exception) {
                        absPredicate.set(Codec.UNNAMEDPREFIX + n, absTerm);
                    }
                    ++n;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 20: 
                        case 31: 
                        case 32: {
                            continue block30;
                        }
                    }
                    break;
                }
                this.jj_la1[16] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absPredicate;
    }

    public final AbsPrimitive Number() throws ParseException {
        AbsPrimitive absPrimitive = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Token token = this.jj_consume_token(8);
                try {
                    absPrimitive = AbsPrimitive.wrap(Long.parseLong(token.image));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    absPrimitive = AbsPrimitive.wrap(token.image);
                }
                break;
            }
            case 9: {
                Token token = this.jj_consume_token(9);
                absPrimitive = AbsPrimitive.wrap(token.image);
                break;
            }
            case 10: {
                Token token = this.jj_consume_token(10);
                try {
                    double d = new Double(token.image);
                    absPrimitive = AbsPrimitive.wrap(d);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    absPrimitive = AbsPrimitive.wrap(token.image);
                }
                break;
            }
            case 11: {
                Token token = this.jj_consume_token(11);
                try {
                    double d = new Double(token.image);
                    absPrimitive = AbsPrimitive.wrap(d);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    absPrimitive = AbsPrimitive.wrap(token.image);
                }
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return absPrimitive;
    }

    public final String String() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                Token token = this.jj_consume_token(31);
                return token.image;
            }
            case 32: {
                Token token = this.jj_consume_token(32);
                return this.unescape(token.image);
            }
            case 12: {
                Token token = this.jj_consume_token(12);
                return token.image;
            }
            case 13: {
                Token token = this.jj_consume_token(13);
                return this.unescape(token.image);
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public SLParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new SLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public SLParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new SLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public SLParser(SLParserTokenManager sLParserTokenManager) {
        this.token_source = sLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(SLParserTokenManager sLParserTokenManager) {
        this.token_source = sLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 20) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[33];
        int n2 = 0;
        while (n2 < 33) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 20) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((this.jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 33) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, SLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

