/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.lang.sl;

import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsContentElement;
import JADE_SL.abs.AbsContentElementList;
import JADE_SL.abs.AbsIRE;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsPredicate;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.abs.AbsVariable;
import JADE_SL.lang.Codec;
import JADE_SL.lang.StringCodec;
import JADE_SL.lang.sl.SLOntology;
import JADE_SL.lang.sl.SLParser;
import JADE_SL.onto.Ontology;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import sl.ISO8601;

public class SLCodec
extends StringCodec {
    private SLParser parser;
    public static final String IOTA = "IOTA";
    static final String SET = "set";
    static final String SEQUENCE = "sequence";
    private Vector vectorOfPredefinedFunctionals;
    private static Vector SL0Functionals = new Vector(5);
    private static Vector FullSLFunctionals = new Vector(17);

    public SLCodec() {
        this(3);
    }

    public SLCodec(int n) {
        super(n == 0 ? "FIPA-SL0" : (n == 1 ? "FIPA-SL1" : (n == 2 ? "FIPA-SL2" : "FIPA-SL")));
        if (n < 0 || n > 2) {
            n = 3;
            this.vectorOfPredefinedFunctionals = FullSLFunctionals;
        } else {
            this.vectorOfPredefinedFunctionals = SL0Functionals;
        }
        this.parser = new SLParser(new StringReader(""));
        this.parser.setSLType(n);
    }

    public String encode(AbsContentElement absContentElement) throws Codec.CodecException {
        return this.encode(null, absContentElement);
    }

    public String encode(Ontology ontology, AbsContentElement absContentElement) throws Codec.CodecException {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (absContentElement instanceof AbsContentElementList) {
            Iterator iterator = ((AbsContentElementList)absContentElement).iterator();
            while (iterator.hasNext()) {
                AbsObject absObject = (AbsObject)iterator.next();
                stringBuffer.append(this.toString(absObject));
                stringBuffer.append(" ");
            }
        } else {
            stringBuffer.append(this.toString(absContentElement));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String quotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        stringBuffer.append("\"");
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private boolean isAWord(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = new String("#0123456789:-?");
        if (string2.indexOf(string.charAt(0)) >= 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"' || string.charAt(n) == '(' || string.charAt(n) == ')' || string.charAt(n) <= ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String encode(String string) {
        if (this.isAWord(string)) {
            return string;
        }
        return this.quotedString(string);
    }

    private String encode(AbsObject absObject, boolean bl) throws Codec.CodecException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.encode(absObject.getTypeName()));
        String[] stringArray = absObject.getNames();
        if (bl && stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(Codec.UNNAMEDPREFIX)) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (bl) {
                    stringBuffer.append(" :");
                    stringBuffer.append(this.encode(stringArray[n]));
                }
                stringBuffer.append(" ");
                stringBuffer.append(this.toString(absObject.getAbsObject(stringArray[n])));
                ++n;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String toString(AbsPredicate absPredicate) throws Codec.CodecException {
        if (absPredicate.getCount() > 0) {
            return this.encode(absPredicate, false);
        }
        return this.encode(absPredicate.getTypeName());
    }

    private String toString(AbsIRE absIRE) throws Codec.CodecException {
        return "(" + this.encode(absIRE.getTypeName()) + " " + this.toString(absIRE.getVariable()) + " " + this.toString(absIRE.getProposition()) + ")";
    }

    private String toString(AbsVariable absVariable) throws Codec.CodecException {
        String string = absVariable.getName();
        if (!string.startsWith("?")) {
            return "?" + this.encode(string);
        }
        return "?" + this.encode(string.substring(1));
    }

    private boolean requiresSlotNames(String string) {
        return !this.vectorOfPredefinedFunctionals.contains(string.toLowerCase());
    }

    private String toString(AbsConcept absConcept) throws Codec.CodecException {
        return this.encode(absConcept, this.requiresSlotNames(absConcept.getTypeName()));
    }

    private String toString(AbsAggregate absAggregate) throws Codec.CodecException {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.encode(absAggregate.getTypeName()));
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append(this.toString((AbsObject)iterator.next()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String toString(AbsPrimitive absPrimitive) throws Codec.CodecException {
        Object object = absPrimitive.getObject();
        if (object instanceof Date) {
            return ISO8601.toString((Date)object);
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            throw new Codec.CodecException("SL_does_not_allow_encoding_sequencesOfBytes");
        }
        return this.encode(object.toString());
    }

    private String toString(AbsObject absObject) throws Codec.CodecException {
        if (absObject instanceof AbsPrimitive) {
            return this.toString((AbsPrimitive)absObject);
        }
        if (absObject instanceof AbsPredicate) {
            return this.toString((AbsPredicate)absObject);
        }
        if (absObject instanceof AbsIRE) {
            return this.toString((AbsIRE)absObject);
        }
        if (absObject instanceof AbsVariable) {
            return this.toString((AbsVariable)absObject);
        }
        if (absObject instanceof AbsAggregate) {
            return this.toString((AbsAggregate)absObject);
        }
        if (absObject instanceof AbsConcept) {
            return this.toString((AbsConcept)absObject);
        }
        throw new Codec.CodecException("SLCodec cannot encode this object " + absObject);
    }

    public AbsContentElement decode(String string) throws Codec.CodecException {
        return this.decode(null, string);
    }

    public AbsContentElement decode(Ontology ontology, String string) throws Codec.CodecException {
        try {
            return this.parser.parse(ontology, string);
        }
        catch (Throwable throwable) {
            throw new Codec.CodecException("Parse exception", throwable);
        }
    }

    public static void main(String[] stringArray) {
        SLCodec sLCodec = null;
        try {
            sLCodec = new SLCodec(Integer.parseInt(stringArray[0]));
        }
        catch (Exception exception) {
            System.out.println("usage: SLCodec SLLevel\n  where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL");
            System.exit(0);
        }
        while (true) {
            try {
                while (true) {
                    System.out.println("insert an SL expression to parse (all the expression on a single line!): ");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    String string = bufferedReader.readLine();
                    System.out.println("\n\n");
                    AbsContentElement absContentElement = sLCodec.decode(string);
                    System.out.println("DUMP OF THE DECODE OUTPUT:");
                    absContentElement.dump();
                    System.out.println("\n\n");
                    System.out.println("AFTER ENCODE:");
                    System.out.println(sLCodec.encode(absContentElement));
                    System.out.println("\n\n");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Ontology getInnerOntology() {
        return SLOntology.getInstance();
    }

    static {
        SL0Functionals.addElement(SET);
        SL0Functionals.addElement(SEQUENCE);
        SL0Functionals.addElement("action");
        SL0Functionals.addElement("|");
        SL0Functionals.addElement(";");
        FullSLFunctionals.addElement(SL0Functionals.elementAt(0));
        FullSLFunctionals.addElement(SL0Functionals.elementAt(1));
        FullSLFunctionals.addElement(SL0Functionals.elementAt(2));
        FullSLFunctionals.addElement(SL0Functionals.elementAt(3));
        FullSLFunctionals.addElement("cons");
        FullSLFunctionals.addElement("first");
        FullSLFunctionals.addElement("rest");
        FullSLFunctionals.addElement("nth");
        FullSLFunctionals.addElement("append");
        FullSLFunctionals.addElement("union");
        FullSLFunctionals.addElement("intersection");
        FullSLFunctionals.addElement("difference");
        FullSLFunctionals.addElement("+");
        FullSLFunctionals.addElement("-");
        FullSLFunctionals.addElement("/");
        FullSLFunctionals.addElement("%");
    }
}

