/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.abs;

import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsTerm;
import java.io.PrintStream;
import java.util.Date;

public class AbsPrimitive
implements AbsTerm {
    private Object value = null;
    private String typeName = null;

    private AbsPrimitive(String string, Object object) {
        this.typeName = string;
        this.value = object;
    }

    public AbsPrimitive(String string) {
        this(string, null);
    }

    public static AbsPrimitive wrap(String string) {
        AbsPrimitive absPrimitive = null;
        if (string != null) {
            absPrimitive = new AbsPrimitive("BO_String", string);
        }
        return absPrimitive;
    }

    public static AbsPrimitive wrap(boolean bl) {
        AbsPrimitive absPrimitive = new AbsPrimitive("BO_Boolean", new Boolean(bl));
        return absPrimitive;
    }

    public static AbsPrimitive wrap(int n) {
        AbsPrimitive absPrimitive = new AbsPrimitive("BO_Integer", new Long(n));
        return absPrimitive;
    }

    public static AbsPrimitive wrap(long l) {
        AbsPrimitive absPrimitive = new AbsPrimitive("BO_Integer", new Long(l));
        return absPrimitive;
    }

    public static AbsPrimitive wrap(float f) {
        AbsPrimitive absPrimitive = new AbsPrimitive("BO_Float", new Double(f));
        return absPrimitive;
    }

    public static AbsPrimitive wrap(double d) {
        AbsPrimitive absPrimitive = new AbsPrimitive("BO_Float", new Double(d));
        return absPrimitive;
    }

    public static AbsPrimitive wrap(Date date) {
        AbsPrimitive absPrimitive = null;
        if (date != null) {
            absPrimitive = new AbsPrimitive("BO_Date", date);
        }
        return absPrimitive;
    }

    public static AbsPrimitive wrap(byte[] byArray) {
        AbsPrimitive absPrimitive = null;
        if (byArray != null) {
            absPrimitive = new AbsPrimitive("BO_Byte-sequence", byArray);
        }
        return absPrimitive;
    }

    public void set(String string) {
        if (!this.getTypeName().equals("BO_String")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = string;
    }

    public void set(boolean bl) {
        if (!this.getTypeName().equals("BO_Boolean")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Boolean(bl);
    }

    public void set(int n) {
        if (!this.getTypeName().equals("BO_Integer")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Long(n);
    }

    public void set(long l) {
        if (!this.getTypeName().equals("BO_Integer")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Long(l);
    }

    public void set(float f) {
        if (!this.getTypeName().equals("BO_Float")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Double(f);
    }

    public void set(double d) {
        if (!this.getTypeName().equals("BO_Float")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Double(d);
    }

    public void set(Date date) {
        if (!this.getTypeName().equals("BO_Date")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = date;
    }

    public void set(byte[] byArray) {
        if (!this.getTypeName().equals("BO_Byte-sequence")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = byArray;
    }

    public String getString() {
        return (String)this.value;
    }

    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    public int getInteger() {
        return (int)((Long)this.value).longValue();
    }

    public long getLong() {
        return (Long)this.value;
    }

    public float getFloat() {
        return (float)((Double)this.value).doubleValue();
    }

    public double getDouble() {
        return (Double)this.value;
    }

    public Date getDate() {
        return (Date)this.value;
    }

    public byte[] getByteSequence() {
        return (byte[])this.value;
    }

    public Object getObject() {
        return this.value;
    }

    protected void dump(int n, PrintStream printStream) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
        printStream.println(this.getClass());
        printStream.println(this.getObject());
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AbsObject getAbsObject(String string) {
        return null;
    }

    public String[] getNames() {
        return null;
    }

    public boolean isGrounded() {
        return true;
    }

    public int getCount() {
        return 0;
    }

    public void dump() {
        this.dump(0, System.out);
    }

    public String toString() {
        return this.value.toString();
    }
}

