/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL.abs;

import JADE_SL.ACLMessage;
import JADE_SL.AID;
import JADE_SL.ContentElement;
import JADE_SL.ContentElementList;
import JADE_SL.OntoACLMessage;
import JADE_SL.OntoAID;
import JADE_SL.abs.AbsAgentAction;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsContentElement;
import JADE_SL.abs.AbsContentElementList;
import JADE_SL.abs.AbsObject;
import JADE_SL.abs.AbsObjectImpl;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.abs.AbsTerm;
import JADE_SL.onto.Ontology;
import JADE_SL.onto.OntologyException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AbsHelper {
    public static AbsAggregate externaliseList(List list, Ontology ontology) throws OntologyException {
        AbsAggregate absAggregate = new AbsAggregate("sequence");
        try {
            int n = 0;
            while (n < list.size()) {
                absAggregate.add((AbsTerm)ontology.fromObject(list.get(n)));
                ++n;
            }
        }
        catch (Exception exception) {
            throw new OntologyException("Non term object in aggregate");
        }
        return absAggregate;
    }

    public static AbsAggregate externaliseIterator(Iterator iterator, Ontology ontology) throws OntologyException {
        AbsAggregate absAggregate = new AbsAggregate("sequence");
        try {
            while (iterator.hasNext()) {
                absAggregate.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non term object in aggregate");
        }
        return absAggregate;
    }

    public static AbsConcept externaliseAID(AID aID) {
        Object object;
        AbsConcept absConcept = new AbsConcept("agent-identifier");
        absConcept.set("agent-identifier", aID.getName());
        AbsAggregate absAggregate = new AbsAggregate("sequence");
        Iterator iterator = aID.getAllAddresses();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            absAggregate.add(AbsPrimitive.wrap((String)object));
        }
        absConcept.set("addresses", absAggregate);
        object = new AbsAggregate("sequence");
        Iterator iterator2 = aID.getAllResolvers();
        while (iterator2.hasNext()) {
            AID aID2 = (AID)iterator2.next();
            ((AbsAggregate)object).add(AbsHelper.externaliseAID(aID2));
        }
        absConcept.set("resolvers", (AbsTerm)object);
        return absConcept;
    }

    public static AbsContentElementList externaliseContentElementList(ContentElementList contentElementList, Ontology ontology) throws OntologyException {
        AbsContentElementList absContentElementList = new AbsContentElementList();
        try {
            int n = 0;
            while (n < contentElementList.size()) {
                absContentElementList.add((AbsContentElement)ontology.fromObject(contentElementList.get(n)));
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non content element object in content element list");
        }
        return absContentElementList;
    }

    public static AbsAgentAction externaliseACLMessage(ACLMessage aCLMessage, Ontology ontology) throws OntologyException {
        try {
            AbsAgentAction absAgentAction = new AbsAgentAction("acl-message");
            absAgentAction.set("performative", AbsPrimitive.wrap(aCLMessage.getPerformative()));
            absAgentAction.set("sender", (AbsTerm)ontology.fromObject(aCLMessage.getSender()));
            AbsAggregate absAggregate = new AbsAggregate("sequence");
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                absAggregate.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
            absAgentAction.set("receivers", absAggregate);
            AbsAggregate absAggregate2 = new AbsAggregate("sequence");
            iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                absAggregate2.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
            absAgentAction.set("reply-to", absAggregate2);
            absAgentAction.set("language", aCLMessage.getLanguage());
            absAgentAction.set("ontology", aCLMessage.getOntology());
            absAgentAction.set("protocol", aCLMessage.getProtocol());
            absAgentAction.set("in-reply-to", aCLMessage.getInReplyTo());
            absAgentAction.set("reply-with", aCLMessage.getReplyWith());
            absAgentAction.set("conversation-id", aCLMessage.getConversationId());
            absAgentAction.set("reply-by", aCLMessage.getReplyByDate());
            if (aCLMessage.hasByteSequenceContent()) {
                absAgentAction.set("bs-content", aCLMessage.getByteSequenceContent());
            } else {
                absAgentAction.set("content", aCLMessage.getContent());
            }
            absAgentAction.set("encoding", aCLMessage.getEncoding());
            return absAgentAction;
        }
        catch (Exception exception) {
            throw new OntologyException("Error externalising ACLMessage", exception);
        }
    }

    public static List internaliseList(AbsAggregate absAggregate, Ontology ontology) throws OntologyException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < absAggregate.size()) {
            Object object = ontology.toObject(absAggregate.get(n));
            Ontology.checkIsTerm(object);
            arrayList.add(object);
            ++n;
        }
        return arrayList;
    }

    public static OntoAID internaliseAID(AbsConcept absConcept) throws OntologyException {
        OntoAID ontoAID = new OntoAID();
        try {
            Object object;
            ontoAID.setName(absConcept.getString("agent-identifier"));
            AbsAggregate absAggregate = (AbsAggregate)absConcept.getAbsObject("addresses");
            int n = 0;
            while (n < absAggregate.size()) {
                object = ((AbsPrimitive)absAggregate.get(n)).getString();
                ontoAID.addAddresses((String)object);
                ++n;
            }
            object = (AbsAggregate)absConcept.getAbsObject("resolvers");
            int n2 = 0;
            while (n2 < ((AbsAggregate)object).size()) {
                OntoAID ontoAID2 = AbsHelper.internaliseAID((AbsConcept)((AbsAggregate)object).get(n2));
                ontoAID.addResolvers(ontoAID2);
                ++n2;
            }
            return ontoAID;
        }
        catch (Exception exception) {
            throw new OntologyException(absConcept + " is not a valid AID");
        }
    }

    public static ContentElementList internaliseContentElementList(AbsContentElementList absContentElementList, Ontology ontology) throws OntologyException {
        ContentElementList contentElementList = new ContentElementList();
        try {
            int n = 0;
            while (n < absContentElementList.size()) {
                ContentElement contentElement = (ContentElement)ontology.toObject(absContentElementList.get(n));
                contentElementList.add(contentElement);
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non content element object in content element list");
        }
        return contentElementList;
    }

    public static OntoACLMessage internaliseACLMessage(AbsAgentAction absAgentAction, Ontology ontology) throws OntologyException {
        OntoACLMessage ontoACLMessage = new OntoACLMessage();
        try {
            ontoACLMessage.setPerformative(absAgentAction.getInteger("performative"));
            ontoACLMessage.setSender((AID)ontology.toObject(absAgentAction.getAbsObject("sender")));
            ontoACLMessage.clearAllReceiver();
            List list = (List)ontology.toObject(absAgentAction.getAbsObject("receivers"));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ontoACLMessage.addReceiver((AID)iterator.next());
            }
            ontoACLMessage.clearAllReplyTo();
            list = (List)ontology.toObject(absAgentAction.getAbsObject("reply-to"));
            iterator = list.iterator();
            while (iterator.hasNext()) {
                ontoACLMessage.addReplyTo((AID)iterator.next());
            }
            ontoACLMessage.setLanguage(absAgentAction.getString("language"));
            ontoACLMessage.setOntology(absAgentAction.getString("ontology"));
            ontoACLMessage.setProtocol(absAgentAction.getString("protocol"));
            ontoACLMessage.setInReplyTo(absAgentAction.getString("in-reply-to"));
            ontoACLMessage.setReplyWith(absAgentAction.getString("reply-with"));
            ontoACLMessage.setConversationId(absAgentAction.getString("conversation-id"));
            ontoACLMessage.setReplyByDate(absAgentAction.getDate("reply-by"));
            String string = absAgentAction.getString("content");
            if (string != null) {
                ontoACLMessage.setContent(string);
            } else {
                byte[] byArray = absAgentAction.getByteSequence("bs-content");
                if (byArray != null) {
                    ontoACLMessage.setByteSequenceContent(byArray);
                }
            }
            ontoACLMessage.setEncoding(absAgentAction.getString("encoding"));
            return ontoACLMessage;
        }
        catch (Exception exception) {
            throw new OntologyException("Error internalising OntoACLMessage", exception);
        }
    }

    public static String toString(AbsObject absObject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((AbsObjectImpl)absObject).dump(0, new PrintStream(byteArrayOutputStream));
        return new String(byteArrayOutputStream.toByteArray());
    }
}

