/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL;

import JADE_SL.ACLMessage;
import JADE_SL.AID;
import JADE_SL.Base64;
import JADE_SL.CaseInsensitiveString;
import JADE_SL.ISO8601;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import zeus.concepts.FIPAParser;
import zeus.concepts.FIPAPerformative;

public class StringACLCodec {
    public static final String NAME = "STRING";
    private static final String BASE64ENCODING_KEY = new String("JADE-Encoding");
    private static final String BASE64ENCODING_VALUE = new String("Base64");
    private static final String SENDER = new String(" :sender ");
    private static final String RECEIVER = new String(" :receiver ");
    private static final String CONTENT = new String(" :content ");
    private static final String REPLY_WITH = new String(" :reply-with ");
    private static final String IN_REPLY_TO = new String(" :in-reply-to ");
    private static final String REPLY_TO = new String(" :reply-to ");
    private static final String LANGUAGE = new String(" :language ");
    private static final String ENCODING = new String(" :encoding ");
    private static final String ONTOLOGY = new String(" :ontology ");
    private static final String REPLY_BY = new String(" :reply-by ");
    private static final String PROTOCOL = new String(" :protocol ");
    private static final String CONVERSATION_ID = new String(" :conversation-id ");
    FIPAParser parser;
    Writer out;

    public StringACLCodec() {
        this.parser = new FIPAParser(System.in);
        this.out = new OutputStreamWriter(System.out);
    }

    public StringACLCodec(Reader reader, Writer writer) {
        this.parser = new FIPAParser(reader);
        this.out = writer;
    }

    private void checkBase64Encoding(ACLMessage aCLMessage) {
        block7: {
            String string = aCLMessage.getUserDefinedParameter(BASE64ENCODING_KEY);
            if (!CaseInsensitiveString.equalsIgnoreCase(BASE64ENCODING_VALUE, string)) break block7;
            try {
                String string2 = aCLMessage.getContent();
                if (string2 != null && string2.length() > 0) {
                    char[] cArray = new char[string2.length()];
                    string2.getChars(0, string2.length(), cArray, 0);
                    aCLMessage.setByteSequenceContent(Base64.decode(cArray));
                    aCLMessage.removeUserDefinedParameter(BASE64ENCODING_KEY);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                stringIndexOutOfBoundsException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("\t\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public FIPAPerformative decode() throws Exception {
        FIPAPerformative fIPAPerformative = this.parser.Message();
        return fIPAPerformative;
    }

    public void write(ACLMessage aCLMessage) {
        try {
            this.out.write(StringACLCodec.toString(aCLMessage));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String toString(ACLMessage aCLMessage) {
        Date date;
        String string;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(ACLMessage.getPerformative(aCLMessage.getPerformative()) + "\n");
        AID aID = aCLMessage.getSender();
        if (aID != null) {
            stringBuffer.append(SENDER + " " + aID.toString() + "\n");
        }
        if ((iterator = aCLMessage.getAllReceiver()).hasNext()) {
            stringBuffer.append(RECEIVER + " (set ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            stringBuffer.append(")\n");
        }
        if ((iterator = aCLMessage.getAllReplyTo()).hasNext()) {
            stringBuffer.append(REPLY_TO + " (set \n");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            stringBuffer.append(")\n");
        }
        if (aCLMessage.hasByteSequenceContent()) {
            stringBuffer.append(":X-" + BASE64ENCODING_KEY + " " + BASE64ENCODING_VALUE + "\n");
            try {
                string = new String(Base64.encode(aCLMessage.getByteSequenceContent()));
                stringBuffer.append(CONTENT + " \"" + string + "\" \n");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("\n\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                System.err.println("");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            string = aCLMessage.getContent();
            if (string != null && (string = string.trim()).length() > 0) {
                stringBuffer.append(CONTENT + " \"" + StringACLCodec.escape(string) + "\" \n");
            }
        }
        if ((string = aCLMessage.getReplyWith()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(REPLY_WITH + " " + string + "\n");
        }
        if ((string = aCLMessage.getInReplyTo()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(IN_REPLY_TO + " " + string + "\n");
        }
        if ((string = aCLMessage.getEncoding()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(ENCODING + " " + string + "\n");
        }
        if ((string = aCLMessage.getLanguage()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(LANGUAGE + " " + string + "\n");
        }
        if ((string = aCLMessage.getOntology()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(ONTOLOGY + " " + string + "\n");
        }
        if ((date = aCLMessage.getReplyByDate()) != null) {
            stringBuffer.append(REPLY_BY + " " + ISO8601.toString(date) + "\n");
        }
        if ((string = aCLMessage.getProtocol()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(PROTOCOL + " " + string + "\n");
        }
        if ((string = aCLMessage.getConversationId()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(CONVERSATION_ID + " " + string + "\n");
        }
        Properties properties = aCLMessage.getAllUserDefinedParameters();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = ((String)enumeration.nextElement()).trim();
            String string3 = properties.getProperty(string2);
            if (string3 == null || (string3 = string3.trim()).length() <= 0) continue;
            stringBuffer.append(" :X-" + string2 + " " + string3 + "\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public byte[] encode(ACLMessage aCLMessage) {
        try {
            return StringACLCodec.toString(aCLMessage).getBytes("US-ASCII");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new byte[0];
        }
    }

    public String getName() {
        return NAME;
    }
}

