/*
 * Decompiled with CFR 0.152.
 */
package JADE_SL;

import JADE_SL.CaseInsensitiveString;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import zeus.util.SystemProps;

public class AID {
    private String name = new String();
    private List addresses = new ArrayList();
    private List resolvers = new ArrayList();
    private Properties userDefSlots = new Properties();
    public static final boolean ISGUID = true;
    public static final boolean ISLOCALNAME = false;
    private static String atHAP = null;

    public AID() {
        this("", true);
    }

    public AID(String string) {
        this(string, true);
    }

    public AID(String string, boolean bl) {
        if (atHAP == null) {
            atHAP = "@" + SystemProps.getProperty("HAP.address");
        }
        if (bl) {
            this.setName(string);
        } else {
            this.setLocalName(string);
        }
    }

    public void setName(String string) {
        this.name = string.trim();
    }

    public void setLocalName(String string) {
        this.name = string.trim();
        if (this.name != null && !this.name.endsWith(atHAP)) {
            this.name = this.name.concat(atHAP);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addAddresses(String string) {
        if (!this.addresses.contains(string)) {
            this.addresses.add(string);
        }
    }

    public boolean removeAddresses(String string) {
        return this.addresses.remove(string);
    }

    public void clearAllAddresses() {
        this.addresses.clear();
    }

    public Iterator getAllAddresses() {
        return this.addresses.iterator();
    }

    public void addResolvers(AID aID) {
        this.resolvers.add(aID);
    }

    public boolean removeResolvers(AID aID) {
        return this.resolvers.remove(aID);
    }

    public void clearAllResolvers() {
        this.resolvers.clear();
    }

    public Iterator getAllResolvers() {
        return this.resolvers.iterator();
    }

    public void addUserDefinedSlot(String string, String string2) {
        this.userDefSlots.setProperty(string, string2);
    }

    public String[] getAddressesArray() {
        Object[] objectArray = this.addresses.toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public AID[] getResolversArray() {
        Object[] objectArray = this.resolvers.toArray();
        AID[] aIDArray = new AID[objectArray.length];
        System.arraycopy(objectArray, 0, aIDArray, 0, objectArray.length);
        return aIDArray;
    }

    public Properties getAllUserDefinedSlot() {
        return this.userDefSlots;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("( agent-identifier ");
        if (this.name != null && this.name.length() > 0) {
            stringBuffer.append(" :name ");
            stringBuffer.append(this.name);
        }
        if (this.addresses.size() > 0) {
            stringBuffer.append(" :addresses (sequence ");
        }
        int n = 0;
        while (n < this.addresses.size()) {
            try {
                stringBuffer.append((String)this.addresses.get(n));
                stringBuffer.append(" ");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            ++n;
        }
        if (this.addresses.size() > 0) {
            stringBuffer.append(")");
        }
        if (this.resolvers.size() > 0) {
            stringBuffer.append(" :resolvers (sequence ");
        }
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            try {
                stringBuffer.append(this.resolvers.get(n2).toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            stringBuffer.append(" ");
            ++n2;
        }
        if (this.resolvers.size() > 0) {
            stringBuffer.append(")");
        }
        Enumeration<?> enumeration = this.userDefSlots.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(" :X-");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(this.userDefSlots.getProperty(string));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void toText(Writer writer) {
        try {
            writer.write(this.toString());
            writer.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized Object clone() {
        AID aID = new AID(this.name);
        aID.addresses = (ArrayList)((ArrayList)this.addresses).clone();
        aID.resolvers = (ArrayList)((ArrayList)this.resolvers).clone();
        aID.userDefSlots = this.userDefSlots;
        return aID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)object);
        }
        try {
            AID aID = (AID)object;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, aID.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareTo(Object object) {
        AID aID = (AID)object;
        return this.name.toLowerCase().toUpperCase().compareTo(aID.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public String getLocalName() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return this.name;
        }
        return this.name.substring(0, n);
    }

    String getHap() {
        int n = this.name.lastIndexOf(64);
        if (n == -1) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }
}

