/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodePropertySet;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class UnicodeSet
extends UnicodeFilter {
    private static final int LOW = 0;
    private static final int HIGH = 0x110000;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    TreeSet strings = new TreeSet();
    private String pat = null;
    private static final int START_EXTRA = 16;
    private static final int GROW_EXTRA = 16;
    private static final String CATEGORY_NAMES = "CnLuLlLtLmLoMnMeMcNdNlNoZsZlZpCcCf--CoCsPdPsPePcPoSmScSkSo";
    public static final int A_NOT_B = 4;
    public static final int A_AND_B = 2;
    public static final int B_NOT_A = 1;
    public static final int ANY = 7;
    public static final int CONTAINS = 6;
    public static final int DISJOINT = 5;
    public static final int ISCONTAINED = 3;
    public static final int NO_B = 4;
    public static final int EQUALS = 2;
    public static final int NO_A = 1;
    public static final int NONE = 0;
    public static final int ADDALL = 7;
    public static final int A = 6;
    public static final int COMPLEMENTALL = 5;
    public static final int B = 3;
    public static final int REMOVEALL = 4;
    public static final int RETAINALL = 2;
    public static final int B_REMOVEALL = 1;

    public UnicodeSet() {
        this.list = new int[17];
        this.list[this.len++] = 0x110000;
    }

    public UnicodeSet(UnicodeSet other) {
        this.set(other);
    }

    public UnicodeSet(int start, int end) {
        this();
        this.complement(start, end);
    }

    public UnicodeSet(String pattern) {
        this(pattern, true);
    }

    public UnicodeSet(String pattern, boolean ignoreWhitespace) {
        this();
        this.applyPattern(pattern, ignoreWhitespace);
    }

    public UnicodeSet(String pattern, ParsePosition pos, SymbolTable symbols) {
        this();
        this.applyPattern(pattern, pos, symbols, true);
    }

    public UnicodeSet(int category) {
        if (category < 0 || category > 28 || category == 17) {
            throw new IllegalArgumentException("Invalid category");
        }
        String pat = "[:" + CATEGORY_NAMES.substring(2 * category, 2 * category + 2) + ":]";
        this.applyPattern(pat, false);
    }

    public Object clone() {
        return new UnicodeSet(this);
    }

    public UnicodeSet set(int start, int end) {
        this.clear();
        this.complement(start, end);
        return this;
    }

    public UnicodeSet set(UnicodeSet other) {
        this.list = (int[])other.list.clone();
        this.len = other.len;
        this.pat = other.pat;
        this.strings = (TreeSet)other.strings.clone();
        return this;
    }

    public final UnicodeSet applyPattern(String pattern) {
        return this.applyPattern(pattern, true);
    }

    public UnicodeSet applyPattern(String pattern, boolean ignoreWhitespace) {
        ParsePosition pos = new ParsePosition(0);
        this.applyPattern(pattern, pos, null, ignoreWhitespace);
        int i = pos.getIndex();
        if (ignoreWhitespace) {
            i = Utility.skipWhitespace(pattern, i);
        }
        if (i != pattern.length()) {
            throw new IllegalArgumentException("Parse of \"" + pattern + "\" failed at " + i);
        }
        return this;
    }

    public static boolean resemblesPattern(String pattern, int pos) {
        return pos + 1 < pattern.length() && pattern.charAt(pos) == '[' || UnicodePropertySet.resemblesPattern(pattern, pos);
    }

    private static void _appendToPat(StringBuffer buf, String s, boolean useHexEscape) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            UnicodeSet._appendToPat(buf, cp, useHexEscape);
            i += UTF16.getCharCount(i);
        }
    }

    private static void _appendToPat(StringBuffer buf, int c, boolean useHexEscape) {
        if (useHexEscape && Utility.escapeUnprintable(buf, c)) {
            return;
        }
        switch (c) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                buf.append('\\');
                break;
            }
            default: {
                if (!UCharacter.isWhitespace(c)) break;
                buf.append('\\');
            }
        }
        UTF16.append(buf, c);
    }

    public String toPattern(boolean escapeUnprintable) {
        StringBuffer result = new StringBuffer();
        return this._toPattern(result, escapeUnprintable).toString();
    }

    private StringBuffer _toPattern(StringBuffer result, boolean escapeUnprintable) {
        if (this.pat != null) {
            int backslashCount = 0;
            int i = 0;
            while (i < this.pat.length()) {
                int c = UTF16.charAt(this.pat, i);
                i += UTF16.getCharCount(c);
                if (escapeUnprintable && Utility.isUnprintable(c)) {
                    if (backslashCount % 2 == 1) {
                        result.setLength(result.length() - 1);
                    }
                    Utility.escapeUnprintable(result, c);
                    backslashCount = 0;
                    continue;
                }
                UTF16.append(result, c);
                if (c == 92) {
                    ++backslashCount;
                    continue;
                }
                backslashCount = 0;
            }
            return result;
        }
        return this._generatePattern(result, escapeUnprintable);
    }

    public StringBuffer _generatePattern(StringBuffer result, boolean escapeUnprintable) {
        int end;
        int start;
        int i;
        result.append('[');
        int count = this.getRangeCount();
        if (count > 1 && this.getRangeStart(0) == 0 && this.getRangeEnd(count - 1) == 0x10FFFF) {
            result.append('^');
            i = 1;
            while (i < count) {
                start = this.getRangeEnd(i - 1) + 1;
                end = this.getRangeStart(i) - 1;
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start != end) {
                    result.append('-');
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < count) {
                start = this.getRangeStart(i);
                end = this.getRangeEnd(i);
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start != end) {
                    result.append('-');
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
                ++i;
            }
        }
        if (this.strings.size() > 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                result.append('{');
                UnicodeSet._appendToPat(result, (String)it.next(), escapeUnprintable);
                result.append('}');
            }
        }
        return result.append(']');
    }

    public int size() {
        int n = 0;
        int count = this.getRangeCount();
        int i = 0;
        while (i < count) {
            n += this.getRangeEnd(i) - this.getRangeStart(i) + 1;
            ++i;
        }
        return n + this.strings.size();
    }

    public boolean isEmpty() {
        return this.len == 1 && this.strings.size() == 0;
    }

    public boolean contains(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = -1;
        while (start >= this.list[++i]) {
        }
        return (i & 1) != 0 && end < this.list[i];
    }

    public boolean matchesIndexValue(int v) {
        int i = 0;
        while (i < this.getRangeCount()) {
            int high;
            int low = this.getRangeStart(i);
            if ((low & 0xFFFFFF00) == ((high = this.getRangeEnd(i)) & 0xFFFFFF00) ? (low & 0xFF) <= v && v <= (high & 0xFF) : (low & 0xFF) <= v || v <= (high & 0xFF)) {
                return true;
            }
            ++i;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                int c = UTF16.charAt(s, 0);
                if ((c & 0xFF) != v) continue;
                return true;
            }
        }
        return false;
    }

    public int matches(Replaceable text, int[] offset, int limit, boolean incremental) {
        if (offset[0] == limit) {
            if (this.contains(65535)) {
                return incremental ? 1 : 2;
            }
            return 0;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            boolean forward = offset[0] < limit;
            char firstChar = text.charAt(offset[0]);
            int highWaterLength = 0;
            while (it.hasNext()) {
                String trial = (String)it.next();
                char c = trial.charAt(forward ? 0 : trial.length() - 1);
                if (forward && c > firstChar) break;
                if (c != firstChar) continue;
                int len = UnicodeSet.matchRest(text, offset[0], limit, trial);
                if (incremental) {
                    int maxLen;
                    int n = maxLen = forward ? limit - offset[0] : offset[0] - limit;
                    if (len == maxLen) {
                        return 1;
                    }
                }
                if (len != trial.length()) continue;
                if (len > highWaterLength) {
                    highWaterLength = len;
                }
                if (forward && len < highWaterLength) break;
            }
            if (highWaterLength != 0) {
                offset[0] = offset[0] + (forward ? highWaterLength : -highWaterLength);
                return 2;
            }
        }
        return super.matches(text, offset, limit, incremental);
    }

    private static int matchRest(Replaceable text, int start, int limit, String s) {
        int maxLen;
        int slen = s.length();
        if (start < limit) {
            maxLen = limit - start;
            if (maxLen > slen) {
                maxLen = slen;
            }
            int i = 1;
            while (i < maxLen) {
                if (text.charAt(start + i) != s.charAt(i)) {
                    return 0;
                }
                ++i;
            }
        } else {
            maxLen = start - limit;
            if (maxLen > slen) {
                maxLen = slen;
            }
            --slen;
            int i = 1;
            while (i < maxLen) {
                if (text.charAt(start - i) != s.charAt(slen - i)) {
                    return 0;
                }
                ++i;
            }
        }
        return maxLen;
    }

    public UnicodeSet getMatchSet(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this);
        return toUnionTo;
    }

    public int indexOf(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = 0;
        int n = 0;
        int start;
        while (c >= (start = this.list[i++])) {
            int limit;
            if (c < (limit = this.list[i++])) {
                return n + c - start;
            }
            n += limit - start;
        }
        return -1;
    }

    public int charAt(int index) {
        if (index >= 0) {
            int len2 = this.len & 0xFFFFFFFE;
            int i = 0;
            while (i < len2) {
                int start;
                int count;
                if (index < (count = this.list[i++] - (start = this.list[i++]))) {
                    return start + index;
                }
                index -= count;
            }
        }
        return -1;
    }

    public boolean contains(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        if (c == 0x110000) {
            return (this.len & 1) == 0;
        }
        int i = -1;
        while (c >= this.list[++i]) {
        }
        return (i & 1) != 0;
    }

    public final boolean contains(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            return this.strings.contains(s);
        }
        return this.contains(cp);
    }

    public UnicodeSet add(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.add(this.range(start, end), 2, 0);
        }
        return this;
    }

    public final UnicodeSet add(int c) {
        this.add(c, c);
        return this;
    }

    public final UnicodeSet add(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.add(s);
            this.pat = null;
        } else {
            this.add(cp, cp);
        }
        return this;
    }

    private static int getSingleCP(String s) {
        if (s.length() < 0) {
            throw new IllegalArgumentException("Can't use zero-length strings in UnicodeSet");
        }
        if (s.length() > 2) {
            return -1;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        int cp = UTF16.charAt(s, 0);
        if (cp > 65535) {
            return cp;
        }
        return -1;
    }

    public final UnicodeSet addAll(String s) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            this.add(cp, cp);
            i += UTF16.getCharCount(cp);
        }
        return this;
    }

    public final UnicodeSet retainAll(String s) {
        return this.retainAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet complementAll(String s) {
        return this.complementAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet removeAll(String s) {
        return this.removeAll(UnicodeSet.fromAll(s));
    }

    public static UnicodeSet from(String s) {
        return new UnicodeSet().add(s);
    }

    public static UnicodeSet fromAll(String s) {
        return new UnicodeSet().addAll(s);
    }

    public UnicodeSet retain(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 0);
        } else {
            this.clear();
        }
        return this;
    }

    public final UnicodeSet retain(int c) {
        return this.retain(c, c);
    }

    public final UnicodeSet retain(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            if (this.strings.size() == 1 && this.strings.contains(s)) {
                return this;
            }
            this.strings.clear();
            this.strings.add(s);
            this.pat = null;
        } else {
            this.retain(cp, cp);
        }
        return this;
    }

    public UnicodeSet remove(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 2);
        }
        return this;
    }

    public final UnicodeSet remove(int c) {
        return this.remove(c, c);
    }

    public final UnicodeSet remove(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.remove(s);
            this.pat = null;
        } else {
            this.remove(cp, cp);
        }
        return this;
    }

    public UnicodeSet complement(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.xor(this.range(start, end), 2, 0);
        }
        return this;
    }

    public final UnicodeSet complement(int c) {
        return this.complement(c, c);
    }

    public UnicodeSet complement() {
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            if (this.strings.contains(s)) {
                this.strings.remove(s);
            } else {
                this.strings.add(s);
            }
            this.pat = null;
        } else {
            this.complement(cp, cp);
        }
        return this;
    }

    public boolean containsAll(UnicodeSet c) {
        int n = c.getRangeCount();
        int i = 0;
        while (i < n) {
            if (!this.contains(c.getRangeStart(i), c.getRangeEnd(i))) {
                return false;
            }
            ++i;
        }
        return this.strings.containsAll(c.strings);
    }

    public boolean containsAll(String s) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            if (!this.contains(cp)) {
                return false;
            }
            i += UTF16.getCharCount(cp);
        }
        return true;
    }

    public boolean containsNone(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = -1;
        while (start >= this.list[++i]) {
        }
        return (i & 1) == 0 && end < this.list[i];
    }

    public boolean containsNone(UnicodeSet c) {
        int n = c.getRangeCount();
        int i = 0;
        while (i < n) {
            if (!this.containsNone(c.getRangeStart(i), c.getRangeEnd(i))) {
                return false;
            }
            ++i;
        }
        return UnicodeSet.hasRelation(this.strings, 5, c.strings);
    }

    public boolean containsNone(String s) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            if (this.contains(cp)) {
                return false;
            }
            i += UTF16.getCharCount(cp);
        }
        return true;
    }

    public final boolean containsSome(String s) {
        return !this.containsNone(s);
    }

    public final boolean containsSome(UnicodeSet s) {
        return !this.containsNone(s);
    }

    public final boolean containsSome(int start, int end) {
        return !this.containsNone(start, end);
    }

    public UnicodeSet addAll(UnicodeSet c) {
        this.add(c.list, c.len, 0);
        this.strings.addAll(c.strings);
        return this;
    }

    public UnicodeSet retainAll(UnicodeSet c) {
        this.retain(c.list, c.len, 0);
        this.strings.retainAll(c.strings);
        return this;
    }

    public UnicodeSet removeAll(UnicodeSet c) {
        this.retain(c.list, c.len, 2);
        this.strings.removeAll(c.strings);
        return this;
    }

    public UnicodeSet complementAll(UnicodeSet c) {
        this.xor(c.list, c.len, 0);
        UnicodeSet.doOperation(this.strings, 5, c.strings);
        return this;
    }

    public UnicodeSet clear() {
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        this.strings.clear();
        return this;
    }

    public int getRangeCount() {
        return this.len / 2;
    }

    public int getRangeStart(int index) {
        return this.list[index * 2];
    }

    public int getRangeEnd(int index) {
        return this.list[index * 2 + 1] - 1;
    }

    public UnicodeSet compact() {
        if (this.len != this.list.length) {
            int[] temp = new int[this.len];
            System.arraycopy(this.list, 0, temp, 0, this.len);
            this.list = temp;
        }
        this.rangeList = null;
        this.buffer = null;
        return this;
    }

    public boolean equals(Object o) {
        try {
            UnicodeSet that = (UnicodeSet)o;
            if (this.len != that.len) {
                return false;
            }
            int i = 0;
            while (i < this.len) {
                if (this.list[i] != that.list[i]) {
                    return false;
                }
                ++i;
            }
            if (!this.strings.equals(that.strings)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.len;
        int i = 0;
        while (i < this.len) {
            result *= 1000003;
            result += this.list[i];
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.toPattern(false) + ')';
    }

    void applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, boolean ignoreWhitespace) {
        StringBuffer rebuiltPat = new StringBuffer();
        this._applyPattern(pattern, pos, symbols, rebuiltPat, ignoreWhitespace);
        this.pat = rebuiltPat.toString();
    }

    /*
     * Unable to fully structure code
     */
    void _applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, StringBuffer rebuiltPat, boolean ignoreWhitespace) {
        rebuildPattern = false;
        newPat = new StringBuffer("[");
        nestedPatStart = -1;
        nestedPatDone = false;
        multiCharBuffer = new StringBuffer();
        invert = false;
        this.clear();
        lastChar = -1;
        isLastLiteral = false;
        lastOp = '\u0000';
        mode = 0;
        i = start = pos.getIndex();
        limit = pattern.length();
        varValueBuffer = null;
        ivarValueBuffer = 0;
        anchor = 0;
        block21: while (i < limit) {
            nestedSet = null;
            isLiteral = false;
            if (varValueBuffer != null) {
                if (ivarValueBuffer < varValueBuffer.length) {
                    c = UTF16.charAt(varValueBuffer, 0, varValueBuffer.length, ivarValueBuffer);
                    ivarValueBuffer += UTF16.getCharCount(c);
                    m = symbols.lookupMatcher(c);
                    try {
                        nestedSet = (UnicodeSet)m;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("Syntax error");
                    }
                    nestedPatDone = false;
                } else {
                    varValueBuffer = null;
                    c = UTF16.charAt(pattern, i);
                    i += UTF16.getCharCount(c);
                }
            } else {
                c = UTF16.charAt(pattern, i);
                i += UTF16.getCharCount(c);
            }
            if (ignoreWhitespace && UCharacter.isWhitespace(c)) continue;
            if (anchor > 0) {
                ++anchor;
            }
            block1 : switch (mode) {
                case 0: {
                    if (!UnicodePropertySet.resemblesPattern(pattern, i - 1)) ** GOTO lbl47
                    mode = 3;
                    ** GOTO lbl61
lbl47:
                    // 1 sources

                    if (c == 91) {
                        mode = 1;
                        break;
                    }
                    throw new IllegalArgumentException("Missing opening '['");
                }
                case 1: {
                    mode = 2;
                    switch (c) {
                        case 94: {
                            invert = true;
                            newPat.append((char)c);
                            break block1;
                        }
                        case 45: {
                            isLiteral = true;
                        }
                    }
                }
lbl61:
                // 4 sources

                default: {
                    if (varValueBuffer == null) {
                        if (UnicodePropertySet.resemblesPattern(pattern, i - 1)) {
                            pp = new ParsePosition(i - 1);
                            nestedSet = UnicodePropertySet.createFromPattern(pattern, pp);
                            if (nestedSet == null) {
                                throw new IllegalArgumentException("Invalid property pattern " + pattern.substring(i - 1));
                            }
                            nestedPatStart = newPat.length();
                            nestedPatDone = true;
                            switch (lastOp) {
                                case '&': 
                                case '-': {
                                    newPat.append(lastOp);
                                }
                            }
                            if (mode == 3) {
                                newPat.deleteCharAt(0);
                            }
                            newPat.append(pattern.substring(i - 1, pp.getIndex()));
                            rebuildPattern = true;
                            i = pp.getIndex();
                            if (mode == 3) {
                                this.set(nestedSet);
                                mode = 5;
                                break block21;
                            }
                        } else if (c == 92) {
                            offset = new int[]{i};
                            escaped = Utility.unescapeAt(pattern, offset);
                            if (escaped == -1) {
                                sta = Math.max(i - 8, 0);
                                lim = Math.min(i + 16, pattern.length());
                                throw new IllegalArgumentException("Invalid escape sequence " + pattern.substring(sta, i - 1) + "|" + pattern.substring(i - 1, lim));
                            }
                            i = offset[0];
                            isLiteral = true;
                            c = escaped;
                        } else {
                            if (symbols != null && !isLiteral && c == 36) {
                                pos.setIndex(i);
                                name = symbols.parseReference(pattern, pos, limit);
                                if (name != null) {
                                    varValueBuffer = symbols.lookup(name);
                                    if (varValueBuffer == null) {
                                        throw new IllegalArgumentException("Undefined variable: " + name);
                                    }
                                    ivarValueBuffer = 0;
                                    i = pos.getIndex();
                                    break;
                                }
                                anchor = 1;
                                break;
                            }
                            if (!isLiteral && c == 91) {
                                nestedPatStart = newPat.length();
                                pos.setIndex(--i);
                                switch (lastOp) {
                                    case '&': 
                                    case '-': {
                                        newPat.append(lastOp);
                                    }
                                }
                                nestedSet = new UnicodeSet();
                                nestedSet._applyPattern(pattern, pos, symbols, newPat, ignoreWhitespace);
                                nestedPatDone = true;
                                i = pos.getIndex();
                            } else if (!isLiteral && c == 123) {
                                length = 0;
                                st = i;
                                multiCharBuffer.setLength(0);
                                while (i < pattern.length()) {
                                    ch = UTF16.charAt(pattern, i);
                                    i += UTF16.getCharCount(ch);
                                    if (ch == 125) {
                                        length = -length;
                                        break;
                                    }
                                    if (ch == 92) {
                                        offset = new int[]{i};
                                        ch = Utility.unescapeAt(pattern, offset);
                                        if (ch == -1) {
                                            sta = Math.max(i - 8, 0);
                                            lim = Math.min(i + 16, pattern.length());
                                            throw new IllegalArgumentException("Invalid escape sequence " + pattern.substring(sta, i - 1) + "|" + pattern.substring(i - 1, lim));
                                        }
                                        i = offset[0];
                                    }
                                    --length;
                                    UTF16.append(multiCharBuffer, ch);
                                }
                                if (length < 1) {
                                    throw new IllegalArgumentException("Invalid multicharacter string");
                                }
                                this.add(multiCharBuffer.toString());
                                newPat.append('{').append(pattern.substring(st, i));
                                rebuildPattern = true;
                                break;
                            }
                        }
                    }
                    if (nestedSet != null) {
                        if (lastChar != -1) {
                            if (lastOp != '\u0000') {
                                throw new IllegalArgumentException("Illegal rhs for " + lastChar + lastOp);
                            }
                            this.add(lastChar, lastChar);
                            if (nestedPatDone) {
                                s = new StringBuffer();
                                UnicodeSet._appendToPat(s, lastChar, false);
                                newPat.insert(nestedPatStart, s.toString());
                            } else {
                                UnicodeSet._appendToPat(newPat, lastChar, false);
                            }
                            lastChar = -1;
                        }
                        switch (lastOp) {
                            case '-': {
                                this.removeAll(nestedSet);
                                break;
                            }
                            case '&': {
                                this.retainAll(nestedSet);
                                break;
                            }
                            case '\u0000': {
                                this.addAll(nestedSet);
                            }
                        }
                        if (!nestedPatDone) {
                            if (lastOp != '\u0000') {
                                newPat.append(lastOp);
                            }
                            nestedSet._toPattern(newPat, false);
                        }
                        rebuildPattern = true;
                        lastOp = '\u0000';
                        break;
                    }
                    if (!isLiteral && c == 93) {
                        if (anchor > 2 || anchor == 1) {
                            throw new IllegalArgumentException("Syntax error near $" + pattern);
                        }
                        if (anchor == 2) {
                            rebuildPattern = true;
                            newPat.append('$');
                            this.add(65535);
                        }
                        mode = 4;
                        break block21;
                    }
                    if (!(lastOp != '\u0000' || isLiteral || c != 45 && c != 38)) {
                        lastOp = (char)c;
                        break;
                    }
                    if (lastOp == '-') {
                        if (lastChar >= c) {
                            throw new IllegalArgumentException("Invalid range " + lastChar + '-' + c);
                        }
                        this.add(lastChar, c);
                        UnicodeSet._appendToPat(newPat, lastChar, false);
                        newPat.append('-');
                        UnicodeSet._appendToPat(newPat, c, false);
                        lastOp = '\u0000';
                        lastChar = -1;
                        break;
                    }
                    if (lastOp != '\u0000') {
                        throw new IllegalArgumentException("Unquoted " + lastOp);
                    }
                    if (lastChar != -1) {
                        this.add(lastChar, lastChar);
                        UnicodeSet._appendToPat(newPat, lastChar, false);
                    }
                    lastChar = c;
                    isLastLiteral = isLiteral;
                }
            }
        }
        if (mode < 4) {
            throw new IllegalArgumentException("Missing ']'");
        }
        if (lastChar == 36 && !isLastLiteral) {
            rebuildPattern = true;
            newPat.append((char)lastChar);
            this.add(65535);
        } else if (lastChar != -1) {
            this.add(lastChar, lastChar);
            UnicodeSet._appendToPat(newPat, lastChar, false);
        }
        if (lastOp == '-') {
            this.add(lastOp, lastOp);
            newPat.append('-');
        } else if (lastOp == '&') {
            throw new IllegalArgumentException("Unquoted trailing " + lastOp);
        }
        if (mode == 4) {
            newPat.append(']');
        }
        if (invert) {
            this.complement();
        }
        pos.setIndex(i);
        if (rebuildPattern) {
            rebuiltPat.append(newPat.toString());
        } else {
            this._generatePattern(rebuiltPat, false);
        }
    }

    private void ensureCapacity(int newLen) {
        if (newLen <= this.list.length) {
            return;
        }
        int[] temp = new int[newLen + 16];
        System.arraycopy(this.list, 0, temp, 0, this.len);
        this.list = temp;
    }

    private void ensureBufferCapacity(int newLen) {
        if (this.buffer != null && newLen <= this.buffer.length) {
            return;
        }
        this.buffer = new int[newLen + 16];
    }

    private int[] range(int start, int end) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{start, end + 1, 0x110000};
        } else {
            this.rangeList[0] = start;
            this.rangeList[1] = end + 1;
        }
        return this.rangeList;
    }

    private UnicodeSet xor(int[] other, int otherLen, int polarity) {
        int b;
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        if (polarity == 1 || polarity == 2) {
            b = 0;
            if (other[j] == 0) {
                b = other[++j];
            }
        } else {
            b = other[j++];
        }
        while (true) {
            if (a < b) {
                this.buffer[k++] = a;
                a = this.list[i++];
                continue;
            }
            if (b < a) {
                this.buffer[k++] = b;
                b = other[j++];
                continue;
            }
            if (a == 0x110000) break;
            a = this.list[i++];
            b = other[j++];
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet add(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        if (k > 0 && a <= this.buffer[k - 1]) {
                            a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = a;
                            a = this.list[i];
                        }
                        ++i;
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        if (k > 0 && b <= this.buffer[k - 1]) {
                            b = UnicodeSet.max(other[j], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = b;
                            b = other[j];
                        }
                        ++j;
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    if (k > 0 && a <= this.buffer[k - 1]) {
                        a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                    } else {
                        this.buffer[k++] = a;
                        a = this.list[i];
                    }
                    ++i;
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (b <= a) {
                        if (a == 0x110000) break block6;
                        this.buffer[k++] = a;
                    } else {
                        if (b == 0x110000) break block6;
                        this.buffer[k++] = b;
                    }
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet retain(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static boolean hasRelation(SortedSet a, int allow, SortedSet b) {
        if (allow < 0 || allow > 7) {
            throw new IllegalArgumentException("Relation " + allow + " out of range");
        }
        boolean anb = (allow & 4) != 0;
        boolean ab = (allow & 2) != 0;
        boolean bna = (allow & 1) != 0;
        switch (allow) {
            case 6: {
                if (a.size() >= b.size()) break;
                return false;
            }
            case 3: {
                if (a.size() <= b.size()) break;
                return false;
            }
            case 2: {
                if (a.size() == b.size()) break;
                return false;
            }
        }
        if (a.size() == 0) {
            if (b.size() == 0) {
                return true;
            }
            return bna;
        }
        if (b.size() == 0) {
            return anb;
        }
        Iterator ait = a.iterator();
        Iterator bit = b.iterator();
        Comparable aa = (Comparable)ait.next();
        Comparable bb = (Comparable)bit.next();
        while (true) {
            int comp;
            if ((comp = aa.compareTo(bb)) == 0) {
                if (!ab) {
                    return false;
                }
                if (!ait.hasNext()) {
                    if (!bit.hasNext()) {
                        return true;
                    }
                    return bna;
                }
                if (!bit.hasNext()) {
                    return anb;
                }
                aa = (Comparable)ait.next();
                bb = (Comparable)bit.next();
                continue;
            }
            if (comp < 0) {
                if (!anb) {
                    return false;
                }
                if (!ait.hasNext()) {
                    return bna;
                }
                aa = (Comparable)ait.next();
                continue;
            }
            if (!bna) {
                return false;
            }
            if (!bit.hasNext()) {
                return anb;
            }
            bb = (Comparable)bit.next();
        }
    }

    public static SortedSet doOperation(SortedSet a, int relation, SortedSet b) {
        switch (relation) {
            case 7: {
                a.addAll(b);
                return a;
            }
            case 6: {
                return a;
            }
            case 3: {
                a.clear();
                a.addAll(b);
                return a;
            }
            case 4: {
                a.removeAll(b);
                return a;
            }
            case 2: {
                a.retainAll(b);
                return a;
            }
            case 5: {
                TreeSet temp = new TreeSet(b);
                temp.removeAll(a);
                a.removeAll(b);
                a.addAll(temp);
                return a;
            }
            case 1: {
                TreeSet temp = new TreeSet(b);
                temp.removeAll(a);
                a.clear();
                a.addAll(temp);
                return a;
            }
            case 0: {
                a.clear();
                return a;
            }
        }
        throw new IllegalArgumentException("Relation " + relation + " out of range");
    }
}

