/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.text.ParsePosition;
import java.util.Hashtable;

class UnicodePropertySet {
    private static Hashtable NAME_MAP = null;
    private static Hashtable CATEGORY_MAP = null;
    private static UnicodeSet[] CATEGORY_CACHE = null;
    private static UnicodeSet[] SCRIPT_CACHE = null;
    private static final int ANY = -1;
    private static final UnicodeSet INCLUSIONS = new UnicodeSet("[^\\u3401-\\u4DB5 \\u4E01-\\u9FA5 \\uAC01-\\uD7A3 \\uD801-\\uDB7F \\uDB81-\\uDBFF \\uDC01-\\uDFFF \\uE001-\\uF8FF \\U0001044F-\\U0001CFFF \\U0001D801-\\U0001FFFF \\U00020001-\\U0002A6D6 \\U0002A6D8-\\U0002F7FF \\U0002FA1F-\\U000E0000 \\U000E0081-\\U000EFFFF \\U000F0001-\\U000FFFFD \\U00100001-\\U0010FFFD]");

    UnicodePropertySet() {
    }

    public static boolean resemblesPattern(String pattern, int pos) {
        if (pos + 5 > pattern.length()) {
            return false;
        }
        return pattern.regionMatches(pos, "[:", 0, 2) || pattern.regionMatches(true, pos, "\\p", 0, 2);
    }

    public static UnicodeSet createFromPattern(String pattern, ParsePosition ppos) {
        int close;
        UnicodePropertySet.init();
        UnicodeSet set = null;
        int pos = ppos.getIndex();
        if (pos + 5 > pattern.length()) {
            return null;
        }
        boolean posix = false;
        boolean invert = false;
        if (pattern.regionMatches(pos, "[:", 0, 2)) {
            posix = true;
            if ((pos = Utility.skipWhitespace(pattern, pos + 2)) < pattern.length() && pattern.charAt(pos) == '^') {
                ++pos;
                invert = true;
            }
        } else if (pattern.regionMatches(true, pos, "\\p", 0, 2)) {
            invert = pattern.charAt(pos + 1) == 'P';
            pos = Utility.skipWhitespace(pattern, pos + 2);
            if (pos == pattern.length() || pattern.charAt(pos++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((close = pattern.indexOf(posix ? ":]" : "}", pos)) < 0) {
            return null;
        }
        int equals = pattern.indexOf(61, pos);
        if (equals >= 0 && equals < close) {
            String typeName = UnicodePropertySet.munge(pattern, pos, equals);
            String valueName = UnicodePropertySet.munge(pattern, equals + 1, close);
            SetFactory factory = (SetFactory)NAME_MAP.get(typeName);
            if (factory == null) {
                return null;
            }
            set = factory.create(valueName);
        } else {
            String shortName = UnicodePropertySet.munge(pattern, pos, close);
            set = UnicodePropertySet.createCategorySet(shortName);
            if (set == null) {
                set = UnicodePropertySet.createScriptSet(shortName);
            }
        }
        if (invert) {
            set.complement();
        }
        ppos.setIndex(close + (posix ? 2 : 1));
        return set;
    }

    private static UnicodeSet createCategorySet(String valueName) {
        Integer valueObj = (Integer)CATEGORY_MAP.get(valueName);
        if (valueObj == null) {
            return null;
        }
        int valueCode = valueObj;
        UnicodeSet set = new UnicodeSet();
        if (valueCode == -1) {
            set.complement();
            return set;
        }
        int cat = 0;
        while (cat < 30) {
            if ((valueCode & 1 << cat) != 0) {
                set.addAll(UnicodePropertySet.getCategorySet(cat));
            }
            ++cat;
        }
        return set;
    }

    private static UnicodeSet createScriptSet(String valueName) {
        int[] script = UScript.getCode(valueName);
        if (script == null) {
            return null;
        }
        return new UnicodeSet(UnicodePropertySet.getScriptSet(script[0]));
    }

    private static UnicodeSet getCategorySet(final int cat) {
        if (CATEGORY_CACHE[cat] == null) {
            UnicodePropertySet.CATEGORY_CACHE[cat] = UnicodePropertySet.createSetFromFilter(new Filter(){

                public boolean contains(int cp) {
                    return UCharacter.getType(cp) == cat;
                }
            });
        }
        return CATEGORY_CACHE[cat];
    }

    private static UnicodeSet getScriptSet(final int script) {
        if (SCRIPT_CACHE[script] == null) {
            UnicodePropertySet.SCRIPT_CACHE[script] = UnicodePropertySet.createSetFromFilter(new Filter(){

                public boolean contains(int cp) {
                    return UScript.getScript(cp) == script;
                }
            });
        }
        return SCRIPT_CACHE[script];
    }

    private static String munge(String str, int start, int limit) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < limit) {
            int c = UTF16.charAt(str, i);
            i += UTF16.getCharCount(c);
            if (c == 95 || UCharacter.isWhitespace(c)) continue;
            UTF16.append(buf, UCharacter.toUpperCase(c));
        }
        return buf.toString();
    }

    static UnicodeSet createSetFromFilter(Filter filter) {
        UnicodeSet set = new UnicodeSet();
        int startHasProperty = -1;
        int limitRange = INCLUSIONS.getRangeCount();
        int j = 0;
        while (j < limitRange) {
            int start = INCLUSIONS.getRangeStart(j);
            int end = INCLUSIONS.getRangeEnd(j);
            int ch = start;
            while (ch <= end) {
                if (filter.contains(ch)) {
                    if (startHasProperty < 0) {
                        startHasProperty = ch;
                    }
                } else if (startHasProperty >= 0) {
                    set.add(startHasProperty, ch - 1);
                    startHasProperty = -1;
                }
                ++ch;
            }
            ++j;
        }
        if (startHasProperty >= 0) {
            set.add(startHasProperty, 0x10FFFF);
        }
        return set;
    }

    private static void addType(String shortName, String longName, SetFactory factory) {
        NAME_MAP.put(shortName, factory);
        NAME_MAP.put(longName, factory);
    }

    private static void addValue(Hashtable map, String shortName, String longName, int value) {
        if (map.get(shortName) != null) {
            throw new InternalError("Duplicate name " + shortName);
        }
        if (longName != null && map.get(longName) != null) {
            throw new InternalError("Duplicate name " + longName);
        }
        Integer valueObj = new Integer(value);
        map.put(shortName, valueObj);
        if (longName != null) {
            map.put(longName, valueObj);
        }
    }

    static void init() {
        if (NAME_MAP != null) {
            return;
        }
        NAME_MAP = new Hashtable();
        CATEGORY_MAP = new Hashtable();
        CATEGORY_CACHE = new UnicodeSet[30];
        SCRIPT_CACHE = new UnicodeSet[42];
        UnicodePropertySet.addType("GC", "GENERALCATEGORY", new SetFactory(){

            public UnicodeSet create(String valueName) {
                return UnicodePropertySet.createCategorySet(valueName);
            }
        });
        UnicodePropertySet.addType("NV", "NUMERICVALUE", new NumericValueFactory());
        UnicodePropertySet.addType("SC", "SCRIPT", new SetFactory(){

            public UnicodeSet create(String valueName) {
                return UnicodePropertySet.createScriptSet(valueName);
            }
        });
        UnicodePropertySet.addValue(CATEGORY_MAP, "ANY", null, -1);
        UnicodePropertySet.addValue(CATEGORY_MAP, "C", "OTHER", 491521);
        UnicodePropertySet.addValue(CATEGORY_MAP, "CC", "CONTROL", 32768);
        UnicodePropertySet.addValue(CATEGORY_MAP, "CF", "FORMAT", 65536);
        UnicodePropertySet.addValue(CATEGORY_MAP, "CN", "UNASSIGNED", 1);
        UnicodePropertySet.addValue(CATEGORY_MAP, "CO", "PRIVATEUSE", 131072);
        UnicodePropertySet.addValue(CATEGORY_MAP, "CS", "SURROGATE", 262144);
        UnicodePropertySet.addValue(CATEGORY_MAP, "L", "LETTER", 62);
        UnicodePropertySet.addValue(CATEGORY_MAP, "LL", "LOWERCASELETTER", 4);
        UnicodePropertySet.addValue(CATEGORY_MAP, "LM", "MODIFIERLETTER", 16);
        UnicodePropertySet.addValue(CATEGORY_MAP, "LO", "OTHERLETTER", 32);
        UnicodePropertySet.addValue(CATEGORY_MAP, "LT", "TITLECASELETTER", 8);
        UnicodePropertySet.addValue(CATEGORY_MAP, "LU", "UPPERCASELETTER", 2);
        UnicodePropertySet.addValue(CATEGORY_MAP, "M", "MARK", 448);
        UnicodePropertySet.addValue(CATEGORY_MAP, "MN", "NONSPACINGMARK", 64);
        UnicodePropertySet.addValue(CATEGORY_MAP, "MC", "SPACINGMARK", 256);
        UnicodePropertySet.addValue(CATEGORY_MAP, "ME", "ENCLOSINGMARK", 128);
        UnicodePropertySet.addValue(CATEGORY_MAP, "N", "NUMBER", 3584);
        UnicodePropertySet.addValue(CATEGORY_MAP, "ND", "DECIMALNUMBER", 512);
        UnicodePropertySet.addValue(CATEGORY_MAP, "NL", "LETTERNUMBER", 1024);
        UnicodePropertySet.addValue(CATEGORY_MAP, "NO", "OTHERNUMBER", 2048);
        UnicodePropertySet.addValue(CATEGORY_MAP, "P", "PUNCTUATION", 821559296);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PC", "CONNECTORPUNCTUATION", 0x400000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PD", "DASHPUNCTUATION", 524288);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PE", "ENDPUNCTUATION", 0x200000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PF", "FINALPUNCTUATION", 0x20000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PI", "INITIALPUNCTUATION", 0x10000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PO", "OTHERPUNCTUATION", 0x800000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "PS", "STARTPUNCTUATION", 0x100000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "S", "SYMBOL", 0xF000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "SC", "CURRENCYSYMBOL", 0x2000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "SK", "MODIFIERSYMBOL", 0x4000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "SM", "MATHSYMBOL", 0x1000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "SO", "OTHERSYMBOL", 0x8000000);
        UnicodePropertySet.addValue(CATEGORY_MAP, "Z", "SEPARATOR", 28672);
        UnicodePropertySet.addValue(CATEGORY_MAP, "ZL", "LINESEPARATOR", 8192);
        UnicodePropertySet.addValue(CATEGORY_MAP, "ZP", "PARAGRAPHSEPARATOR", 16384);
        UnicodePropertySet.addValue(CATEGORY_MAP, "ZS", "SPACESEPARATOR", 4096);
    }

    static interface Filter {
        public boolean contains(int var1);
    }

    static class NumericValueFactory
    implements SetFactory {
        NumericValueFactory() {
        }

        public UnicodeSet create(String valueName) {
            double value = Double.parseDouble(valueName);
            int ivalue = (int)value;
            if ((double)ivalue != value || ivalue < 0) {
                return new UnicodeSet();
            }
            return UnicodePropertySet.createSetFromFilter(new Filter(this, ivalue){
                private final /* synthetic */ int val$ivalue;
                private final /* synthetic */ NumericValueFactory this$0;
                {
                    this.this$0 = this$0;
                    this.val$ivalue = val$ivalue;
                }

                public boolean contains(int cp) {
                    return UCharacter.getUnicodeNumericValue(cp) == this.val$ivalue;
                }
            });
        }
    }

    static interface SetFactory {
        public UnicodeSet create(String var1);
    }
}

