/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;

class UnicodeNameTransliterator
extends Transliterator {
    char openDelimiter;
    char closeDelimiter;
    static final String _ID = "Any-Name";

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new UnicodeNameTransliterator(null);
            }
        });
    }

    public UnicodeNameTransliterator(char openDelimiter, char closeDelimiter, UnicodeFilter filter) {
        super(_ID, filter);
        this.openDelimiter = openDelimiter;
        this.closeDelimiter = closeDelimiter;
    }

    public UnicodeNameTransliterator(UnicodeFilter filter) {
        this('{', '}', filter);
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int cursor = offsets.start;
        int limit = offsets.limit;
        StringBuffer str = new StringBuffer();
        str.append(this.openDelimiter);
        while (cursor < limit) {
            int c = text.char32At(cursor);
            String name = UCharacter.getExtendedName(c);
            if (name != null) {
                str.setLength(1);
                str.append(name).append(this.closeDelimiter);
                int clen = UTF16.getCharCount(c);
                text.replace(cursor, cursor + clen, str.toString());
                int len = str.length();
                cursor += len;
                limit += len - clen;
                continue;
            }
            ++cursor;
        }
        offsets.contextLimit += limit - offsets.limit;
        offsets.limit = limit;
        offsets.start = cursor;
    }
}

