/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.dev.tool.translit.UnicodeSetClosure;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class TransliteratorUtility {
    static PrintWriter out;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            Enumeration e = Transliterator.getAvailableIDs();
            while (e.hasMoreElements()) {
                String ID = (String)e.nextElement();
                TransliteratorUtility.showSourceSet(ID, Normalizer.NO_OP, false);
            }
        } else {
            Normalizer.Mode m = Normalizer.NO_OP;
            boolean lowerFirst = false;
            if (args.length >= 2) {
                if (args[1].equalsIgnoreCase("NFD")) {
                    m = Normalizer.DECOMP;
                } else if (args[1].equalsIgnoreCase("NFKD")) {
                    m = Normalizer.DECOMP_COMPAT;
                } else {
                    TransliteratorUtility.usage();
                }
            }
            if (args.length >= 3) {
                if (args[2].equalsIgnoreCase("lower")) {
                    lowerFirst = true;
                } else {
                    TransliteratorUtility.usage();
                }
            }
            if (args.length > 3) {
                TransliteratorUtility.usage();
            }
            TransliteratorUtility.showSourceSet(args[0], m, lowerFirst);
        }
    }

    public static UnicodeSet getSourceSet(Transliterator t) {
        return t.getSourceSet();
    }

    static void showSourceSet(String ID, Normalizer.Mode m, boolean lowerFirst) throws IOException {
        File f = new File("UnicodeSetClosure.txt");
        String filename = f.getCanonicalFile().toString();
        out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        out.print('\ufeff');
        System.out.println();
        System.out.println("Writing " + filename);
        Transliterator t = Transliterator.getInstance(ID);
        TransliteratorUtility.showSourceSetAux(t, m, lowerFirst, true);
        TransliteratorUtility.showSourceSetAux(t.getInverse(), m, lowerFirst, false);
        out.close();
    }

    static void showSourceSetAux(Transliterator t, Normalizer.Mode m, boolean lowerFirst, boolean forward) throws IOException {
        UnicodeSet sourceSet = t.getSourceSet();
        if (m != Normalizer.NO_OP || lowerFirst) {
            UnicodeSetClosure.close((UnicodeSet)sourceSet, (Normalizer.Mode)m, (boolean)lowerFirst);
        }
        System.out.println(t.getID() + ": " + sourceSet.toPattern(true));
        out.println("# MINIMAL FILTER GENERATED FOR: " + t.getID() + (forward ? "" : " REVERSE"));
        out.println(":: " + (forward ? "" : "( ") + sourceSet.toPattern(true) + (forward ? "" : " )") + " ;");
        out.println("# Unicode: " + sourceSet.toPattern(false));
        out.println();
    }

    static void usage() {
        System.err.println("Usage: ID [ NFD|NFKD [lower] ]");
        System.exit(1);
    }
}

