/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.SearchIterator;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public final class StringSearch
extends SearchIterator {
    private CollationElementIterator iter;
    private RuleBasedCollator collator;
    private int strength;
    private static final int MAX_TABLE = 256;
    private int[] valueList = null;
    private int[] shiftTable = new int[256];
    private int[] backShiftTable = new int[256];
    private String pattern;
    private int normLen = 0;
    private int minLen = 0;
    private int maxLen = 0;
    private static final boolean DEBUG = false;

    public StringSearch(String pat, CharacterIterator target, RuleBasedCollator coll, BreakIterator breaker) {
        super(target, breaker);
        this.pattern = pat;
        this.collator = coll;
        this.strength = coll.getStrength();
        this.iter = this.collator.getCollationElementIterator(target);
        this.initialize();
    }

    public StringSearch(String pattern, CharacterIterator target, RuleBasedCollator collator) {
        this(pattern, target, collator, BreakIterator.getCharacterInstance());
    }

    public StringSearch(String pattern, CharacterIterator target, Locale loc) {
        this(pattern, target, (RuleBasedCollator)Collator.getInstance(loc), BreakIterator.getCharacterInstance(loc));
    }

    public StringSearch(String pattern, String target) {
        this(pattern, new StringCharacterIterator(target), (RuleBasedCollator)Collator.getInstance(), BreakIterator.getCharacterInstance());
    }

    public void setStrength(int newStrength) {
        this.strength = newStrength;
        this.collator.setStrength(this.strength);
        this.initialize();
    }

    public int getStrength() {
        return this.strength;
    }

    public void setCollator(RuleBasedCollator coll) {
        this.collator = coll;
        this.strength = this.collator.getStrength();
        this.iter = this.collator.getCollationElementIterator(this.getTarget());
        this.initialize();
    }

    public RuleBasedCollator getCollator() {
        return this.collator;
    }

    public void setPattern(String pat) {
        this.pattern = pat;
        this.initialize();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setTarget(CharacterIterator target) {
        super.setTarget(target);
        this.iter = this.collator.getCollationElementIterator(target);
    }

    protected int handleNext(int start) {
        CharacterIterator target = this.getTarget();
        int mask = StringSearch.getMask(this.strength);
        int done = 0xFFFFFFFF & mask;
        int index = start + this.minLen;
        int matchEnd = 0;
        while (index <= target.getEndIndex()) {
            int patIndex = this.normLen;
            int tval = 0;
            int pval = 0;
            boolean getP = true;
            this.iter.setOffset(index);
            matchEnd = index;
            while (!(patIndex <= 0 && getP || this.iter.getOffset() <= start)) {
                tval = this.iter.previous() & mask;
                if (getP) {
                    pval = this.valueList[--patIndex];
                }
                getP = true;
                if (tval == 0) {
                    getP = false;
                    continue;
                }
                if (pval != tval) {
                    index += this.getShift(tval, patIndex);
                    break;
                }
                if (patIndex != 0) continue;
                start = this.iter.getOffset();
                this.setMatchLength(matchEnd - start);
                return start;
            }
            if (index != matchEnd) continue;
            ++index;
        }
        return -1;
    }

    protected int handlePrev(int start) {
        int patLen = this.normLen;
        int index = start - this.minLen;
        int mask = StringSearch.getMask(this.strength);
        int done = 0xFFFFFFFF & mask;
        while (index >= 0) {
            int patIndex = 0;
            int tval = 0;
            int pval = 0;
            boolean getP = true;
            this.iter.setOffset(index);
            while (!(patIndex >= patLen && getP || this.iter.getOffset() >= start)) {
                tval = this.iter.next() & mask;
                if (getP) {
                    pval = this.valueList[patIndex++];
                }
                getP = true;
                if (tval == done) {
                    return -1;
                }
                if (tval == 0) {
                    getP = false;
                    continue;
                }
                if (pval != tval) {
                    int shift = this.getBackShift(tval, patIndex);
                    index -= shift;
                    break;
                }
                if (patIndex != patLen) continue;
                this.setMatchLength(this.iter.getOffset() - index);
                return index;
            }
            if (this.iter.getOffset() < start) continue;
            --index;
        }
        return -1;
    }

    private static final int getMask(int strength) {
        switch (strength) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void initialize() {
        int elem;
        CollationElementIterator iter = this.collator.getCollationElementIterator(this.pattern);
        int mask = StringSearch.getMask(this.strength);
        this.normLen = 0;
        while ((elem = iter.next()) != -1) {
            void var3_3;
            if ((var3_3 & mask) == 0) continue;
            ++this.normLen;
        }
        this.valueList = new int[this.normLen];
        int expandLen = 0;
        iter.reset();
        int i = 0;
        while (i < this.normLen) {
            elem = iter.next();
            if ((elem & mask) != 0) {
                this.valueList[i] = elem & mask;
            }
            expandLen += iter.getMaxExpansion(elem) - 1;
            ++i;
        }
        int uniLen = this.pattern.length();
        this.maxLen = Math.max(this.normLen, uniLen);
        this.minLen = Math.min(this.normLen, uniLen) - expandLen;
        int i2 = 0;
        while (i2 < 256) {
            this.shiftTable[i2] = this.backShiftTable[i2] = this.minLen;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.normLen - 1) {
            this.shiftTable[StringSearch.hash((int)this.valueList[i3])] = Math.max(this.minLen - i3 - 1, 1);
            ++i3;
        }
        this.shiftTable[StringSearch.hash((int)this.valueList[this.normLen - 1])] = 1;
        int i4 = this.normLen - 1;
        while (i4 > 0) {
            this.backShiftTable[StringSearch.hash((int)this.valueList[i4])] = i4;
            --i4;
        }
        this.backShiftTable[StringSearch.hash((int)this.valueList[0])] = 1;
    }

    private int getShift(int curValue, int curIndex) {
        int shiftAmt = this.shiftTable[StringSearch.hash(curValue)];
        int adjust = this.normLen - curIndex;
        if (adjust > 1 && shiftAmt >= adjust) {
            shiftAmt -= adjust - 1;
        }
        return shiftAmt;
    }

    private int getBackShift(int curValue, int curIndex) {
        int shiftAmt = this.backShiftTable[StringSearch.hash(curValue)];
        int adjust = curIndex;
        if (adjust > 1 && shiftAmt > adjust) {
            shiftAmt -= adjust - 1;
        }
        return shiftAmt;
    }

    private static final int hash(int order) {
        return CollationElementIterator.primaryOrder(order) % 256;
    }

    static void debug(String str) {
        System.out.println(str);
    }

    void dumpTables() {
        int i = 0;
        while (i < 256) {
            if (this.shiftTable[i] != this.minLen) {
                StringSearch.debug("shift[" + Integer.toString(i, 16) + "] = " + this.shiftTable[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 256) {
            if (this.backShiftTable[i2] != this.minLen) {
                StringSearch.debug("backShift[" + Integer.toString(i2, 16) + "] = " + this.backShiftTable[i2]);
            }
            ++i2;
        }
    }
}

