/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CanonicalIterator {
    private static boolean PROGRESS = false;
    private static Transliterator NAME = PROGRESS ? Transliterator.getInstance("name") : null;
    private static boolean SKIP_ZEROS = true;
    private String source;
    private boolean done;
    private String[][] pieces;
    private int[] current;
    private transient StringBuffer buffer = new StringBuffer();
    private static final UnicodeSet EMPTY = new UnicodeSet();
    private static final Set SET_WITH_NULL_STRING = new HashSet();
    private static UnicodeSet SAFE_START;
    private static CharMap AT_START;
    private static int LAST_UNICODE;

    public CanonicalIterator(String source) {
        this.setSource(source);
    }

    public String getSource() {
        return this.source;
    }

    public void reset() {
        this.done = false;
        int i = 0;
        while (i < this.current.length) {
            this.current[i] = 0;
            ++i;
        }
    }

    public String next() {
        if (this.done) {
            return null;
        }
        this.buffer.setLength(0);
        int i = 0;
        while (i < this.pieces.length) {
            this.buffer.append(this.pieces[i][this.current[i]]);
            ++i;
        }
        String result = this.buffer.toString();
        int i2 = this.current.length - 1;
        while (true) {
            if (i2 < 0) {
                this.done = true;
                break;
            }
            int n = i2;
            this.current[n] = this.current[n] + 1;
            if (this.current[i2] < this.pieces[i2].length) break;
            this.current[i2] = 0;
            --i2;
        }
        return result;
    }

    public void setSource(String newSource) {
        this.source = Normalizer.normalize(newSource, Normalizer.DECOMP, 0);
        this.done = false;
        if (newSource.length() == 0) {
            this.pieces = new String[1][];
            this.current = new int[1];
            this.pieces[0] = new String[]{""};
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int i = UTF16.findOffsetFromCodePoint(this.source, 1);
        while (i < this.source.length()) {
            int cp = UTF16.charAt(this.source, i);
            if (SAFE_START.contains(cp)) {
                list.add(this.source.substring(start, i));
                start = i;
            }
            i += UTF16.getCharCount(i);
        }
        list.add(this.source.substring(start, i));
        this.pieces = new String[list.size()][];
        this.current = new int[list.size()];
        i = 0;
        while (i < this.pieces.length) {
            if (PROGRESS) {
                System.out.println("SEGMENT");
            }
            this.pieces[i] = this.getEquivalents((String)list.get(i));
            ++i;
        }
    }

    public static void permute(String source, boolean skipZeros, Set output) {
        if (source.length() <= 2 && UTF16.countCodePoint(source) <= 1) {
            output.add(source);
            return;
        }
        HashSet subpermute = new HashSet();
        int i = 0;
        while (i < source.length()) {
            int cp = UTF16.charAt(source, i);
            if (!skipZeros || i == 0 || UCharacter.getCombiningClass(cp) != 0) {
                subpermute.clear();
                CanonicalIterator.permute(source.substring(0, i) + source.substring(i + UTF16.getCharCount(cp)), skipZeros, subpermute);
                String chStr = UTF16.valueOf(source, i);
                Iterator it = subpermute.iterator();
                while (it.hasNext()) {
                    String piece = chStr + (String)it.next();
                    output.add(piece);
                }
            }
            i += UTF16.getCharCount(cp);
        }
    }

    public static UnicodeSet getSafeStart() {
        return (UnicodeSet)SAFE_START.clone();
    }

    public static UnicodeSet getStarts(int cp) {
        UnicodeSet result = AT_START.get(cp);
        if (result == null) {
            result = EMPTY;
        }
        return (UnicodeSet)result.clone();
    }

    private String[] getEquivalents(String segment) {
        HashSet<String> result = new HashSet<String>();
        Set basic = this.getEquivalents2(segment);
        HashSet permutations = new HashSet();
        Iterator it = basic.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            permutations.clear();
            CanonicalIterator.permute(item, SKIP_ZEROS, permutations);
            Iterator it2 = permutations.iterator();
            while (it2.hasNext()) {
                String possible = (String)it2.next();
                if (Normalizer.isEquivalent(possible, segment, Normalizer.DECOMP, 0)) {
                    if (PROGRESS) {
                        System.out.println("Adding Permutation: " + NAME.transliterate(possible));
                    }
                    result.add(possible);
                    continue;
                }
                if (!PROGRESS) continue;
                System.out.println("-Skipping Permutation: " + NAME.transliterate(possible));
            }
        }
        String[] finalResult = new String[result.size()];
        result.toArray(finalResult);
        return finalResult;
    }

    private Set getEquivalents2(String segment) {
        HashSet<String> result = new HashSet<String>();
        if (PROGRESS) {
            System.out.println("Adding: " + NAME.transliterate(segment));
        }
        result.add(segment);
        StringBuffer workingBuffer = new StringBuffer();
        int i = 0;
        while (i < segment.length()) {
            int cp = UTF16.charAt(segment, i);
            UnicodeSet starts = AT_START.get(cp);
            if (starts != null) {
                UnicodeSetIterator usi = new UnicodeSetIterator(starts);
                while (usi.next()) {
                    int cp2 = usi.codepoint;
                    Set remainder = this.extract(cp2, segment, i, workingBuffer);
                    if (remainder == null) continue;
                    String prefix = segment.substring(0, i) + UTF16.valueOf(cp2);
                    Iterator it = remainder.iterator();
                    while (it.hasNext()) {
                        String item = (String)it.next();
                        if (PROGRESS) {
                            System.out.println("Adding: " + NAME.transliterate(prefix + item));
                        }
                        result.add(prefix + item);
                    }
                }
            }
            i += UTF16.getCharCount(cp);
        }
        return result;
    }

    private Set extract(int comp, String segment, int segmentPos, StringBuffer buffer) {
        if (PROGRESS) {
            System.out.println(" extract: " + NAME.transliterate(UTF16.valueOf(comp)) + ", " + NAME.transliterate(segment.substring(segmentPos)));
        }
        String decomp = Normalizer.normalize(comp, Normalizer.DECOMP, 0);
        boolean ok = false;
        int decompPos = 0;
        int decompCp = UTF16.charAt(decomp, 0);
        decompPos += UTF16.getCharCount(decompCp);
        buffer.setLength(0);
        int i = segmentPos;
        while (i < segment.length()) {
            int cp = UTF16.charAt(segment, i);
            if (cp == decompCp) {
                if (PROGRESS) {
                    System.out.println("  matches: " + NAME.transliterate(UTF16.valueOf(cp)));
                }
                if (decompPos == decomp.length()) {
                    buffer.append(segment.substring(i + UTF16.getCharCount(cp)));
                    ok = true;
                    break;
                }
                decompCp = UTF16.charAt(decomp, decompPos);
                decompPos += UTF16.getCharCount(decompCp);
            } else {
                if (PROGRESS) {
                    System.out.println("  buffer: " + NAME.transliterate(UTF16.valueOf(cp)));
                }
                UTF16.append(buffer, cp);
            }
            i += UTF16.getCharCount(cp);
        }
        if (!ok) {
            return null;
        }
        if (PROGRESS) {
            System.out.println("Matches");
        }
        if (buffer.length() == 0) {
            return SET_WITH_NULL_STRING;
        }
        String remainder = buffer.toString();
        if (!Normalizer.isEquivalent(UTF16.valueOf(comp) + remainder, segment.substring(segmentPos), Normalizer.DECOMP, 0)) {
            return null;
        }
        return this.getEquivalents2(remainder);
    }

    private static void buildData() {
        if (PROGRESS) {
            System.out.println("Getting Safe Start");
        }
        int cp = 0;
        while (cp <= LAST_UNICODE) {
            int cc;
            if (PROGRESS & (cp & 0x7FF) == 0) {
                System.out.print('.');
            }
            if ((cc = UCharacter.getCombiningClass(cp)) == 0) {
                SAFE_START.add(cp);
            }
            ++cp;
        }
        if (PROGRESS) {
            System.out.println();
        }
        if (PROGRESS) {
            System.out.println("Getting Containment");
        }
        int cp2 = 0;
        while (cp2 <= LAST_UNICODE) {
            if (PROGRESS & (cp2 & 0x7FF) == 0) {
                System.out.print('.');
            }
            if (!Normalizer.isNormalized(cp2, Normalizer.DECOMP, 0)) {
                String decomp = Normalizer.normalize(cp2, Normalizer.DECOMP, 0);
                int i = 0;
                while (i < decomp.length()) {
                    int component = UTF16.charAt(decomp, i);
                    if (i == 0) {
                        AT_START.add(component, cp2);
                    } else if (UCharacter.getCombiningClass(component) == 0) {
                        SAFE_START.remove(component);
                    }
                    i += UTF16.getCharCount(component);
                }
            }
            ++cp2;
        }
        if (PROGRESS) {
            System.out.println();
        }
    }

    static {
        SET_WITH_NULL_STRING.add("");
        SAFE_START = new UnicodeSet();
        AT_START = new CharMap();
        LAST_UNICODE = 0x10FFFF;
        CanonicalIterator.buildData();
    }

    private static class MutableInt {
        public int contents;

        private MutableInt() {
        }

        public int hashCode() {
            return this.contents;
        }

        public boolean equals(Object other) {
            return ((MutableInt)other).contents == this.contents;
        }

        public MutableInt set(int contents) {
            this.contents = contents;
            return this;
        }
    }

    private static class CharMap {
        Map storage = new HashMap();
        MutableInt probe = new MutableInt();
        boolean converted = false;

        private CharMap() {
        }

        public void add(int cp, int whatItIsIn) {
            UnicodeSet result = (UnicodeSet)this.storage.get(this.probe.set(cp));
            if (result == null) {
                result = new UnicodeSet();
                this.storage.put(this.probe, result);
            }
            result.add(whatItIsIn);
        }

        public UnicodeSet get(int cp) {
            return (UnicodeSet)this.storage.get(this.probe.set(cp));
        }
    }
}

