/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacterName;
import com.ibm.icu.lang.UCharacterNameIterator;
import com.ibm.icu.lang.UCharacterTypeIterator;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.RangeValueIterator;
import com.ibm.icu.util.ValueIterator;
import com.ibm.icu.util.VersionInfo;
import java.util.Locale;

public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int REPLACEMENT_CHAR = 65533;
    protected static final UCharacterName NAME_;
    private static final UCharacterProperty PROPERTY_;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final int SHIFT_16_ = 16;
    private static final int SHIFT_24_ = 24;
    private static final int NON_CHARACTER_SUFFIX_MIN_3_0_ = 65534;
    private static final int NON_CHARACTER_MIN_3_1_ = 64976;
    private static final int NON_CHARACTER_MAX_3_1_ = 65007;
    private static final int DECIMAL_RADIX_ = 10;
    private static final int NO_BREAK_SPACE_ = 160;
    private static final int NARROW_NO_BREAK_SPACE_ = 8239;
    private static final int ZERO_WIDTH_NO_BREAK_SPACE_ = 65279;
    private static final int IDEOGRAPHIC_NUMBER_ZERO_ = 12295;
    private static final int CJK_IDEOGRAPH_FIRST_ = 19968;
    private static final int CJK_IDEOGRAPH_SECOND_ = 20108;
    private static final int CJK_IDEOGRAPH_THIRD_ = 19977;
    private static final int CJK_IDEOGRAPH_FOURTH_ = 22232;
    private static final int CJK_IDEOGRAPH_FIFTH_ = 20116;
    private static final int CJK_IDEOGRAPH_SIXTH_ = 20845;
    private static final int CJK_IDEOGRAPH_SEVENTH_ = 19971;
    private static final int CJK_IDEOGRAPH_EIGHTH_ = 20843;
    private static final int CJK_IDEOGRAPH_NINETH_ = 20061;
    private static final int APPLICATION_PROGRAM_COMMAND_ = 159;
    private static final int UNIT_SEPERATOR_ = 31;
    private static final int DELETE_ = 127;
    private static final int ISO_CONTROL_FIRST_RANGE_MAX_ = 31;
    private static final int CJK_IDEOGRAPH_COMPLEX_ZERO_ = 38646;
    private static final int CJK_IDEOGRAPH_COMPLEX_ONE_ = 22777;
    private static final int CJK_IDEOGRAPH_COMPLEX_TWO_ = 36019;
    private static final int CJK_IDEOGRAPH_COMPLEX_THREE_ = 21443;
    private static final int CJK_IDEOGRAPH_COMPLEX_FOUR_ = 32902;
    private static final int CJK_IDEOGRAPH_COMPLEX_FIVE_ = 20237;
    private static final int CJK_IDEOGRAPH_COMPLEX_SIX_ = 38520;
    private static final int CJK_IDEOGRAPH_COMPLEX_SEVEN_ = 26578;
    private static final int CJK_IDEOGRAPH_COMPLEX_EIGHT_ = 25420;
    private static final int CJK_IDEOGRAPH_COMPLEX_NINE_ = 29590;
    private static final int CJK_IDEOGRAPH_TEN_ = 21313;
    private static final int CJK_IDEOGRAPH_COMPLEX_TEN_ = 25342;
    private static final int CJK_IDEOGRAPH_HUNDRED_ = 30334;
    private static final int CJK_IDEOGRAPH_COMPLEX_HUNDRED_ = 20336;
    private static final int CJK_IDEOGRAPH_THOUSAND_ = 21315;
    private static final int CJK_IDEOGRAPH_COMPLEX_THOUSAND_ = 20191;
    private static final int CJK_IDEOGRAPH_TEN_THOUSAND_ = 33356;
    private static final int CJK_IDEOGRAPH_HUNDRED_MILLION_ = 20740;

    public static int digit(int ch, int radix) {
        int props = UCharacter.getProps(ch);
        int numericType = UCharacterProperty.getNumericType(props);
        int result = -1;
        if (numericType == 1) {
            if (!UCharacterProperty.isExceptionIndicator(props)) {
                result = UCharacterProperty.getSignedValue(props);
            } else {
                int index = UCharacterProperty.getExceptionIndex(props);
                if (PROPERTY_.hasExceptionValue(index, 4)) {
                    return PROPERTY_.getException(index, 4);
                }
            }
        }
        if (result < 0 && radix > 10) {
            result = UCharacter.getEuropeanDigit(ch);
        }
        if (result < 0 || result >= radix) {
            return -1;
        }
        return result;
    }

    public static int digit(int ch) {
        return UCharacter.digit(ch, 10);
    }

    public static int getNumericValue(int ch) {
        return UCharacter.getNumericValueInternal(ch, true);
    }

    public static int getUnicodeNumericValue(int ch) {
        return UCharacter.getNumericValueInternal(ch, false);
    }

    public static int getType(int ch) {
        return UCharacterProperty.getPropType(UCharacter.getProps(ch));
    }

    public static boolean isDefined(int ch) {
        return UCharacter.getProps(ch) != 0;
    }

    public static boolean isDigit(int ch) {
        return UCharacter.getType(ch) == 9;
    }

    public static boolean isISOControl(int ch) {
        return ch >= 0 && ch <= 159 && (ch <= 31 || ch >= 127);
    }

    public static boolean isLetter(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5;
    }

    public static boolean isLetterOrDigit(int ch) {
        return UCharacter.isDigit(ch) || UCharacter.isLetter(ch);
    }

    public static boolean isLowerCase(int ch) {
        return UCharacter.getType(ch) == 2;
    }

    public static boolean isWhitespace(int ch) {
        int cat = UCharacter.getType(ch);
        return (cat == 12 || cat == 13 || cat == 14) && ch != 160 && ch != 8239 && ch != 65279 || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31;
    }

    public static boolean isSpaceChar(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 12 || cat == 13 || cat == 14;
    }

    public static boolean isTitleCase(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 3;
    }

    public static boolean isUnicodeIdentifierPart(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 10 || cat == 22 || cat == 9 || cat == 8 || cat == 6 || UCharacter.isIdentifierIgnorable(ch);
    }

    public static boolean isUnicodeIdentifierStart(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 10;
    }

    public static boolean isIdentifierIgnorable(int ch) {
        return ch <= 8 || ch >= 14 && ch <= 27 || ch >= 127 && ch <= 159 || UCharacter.getType(ch) == 16;
    }

    public static boolean isUpperCase(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 1;
    }

    public static int toLowerCase(int ch) {
        int props = UCharacter.getProps(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int cat = UCharacterProperty.getPropType(props);
            if (cat == 1 || cat == 3) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 1)) {
                return PROPERTY_.getException(index, 1);
            }
        }
        return ch;
    }

    public static String toString(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuffer result = new StringBuffer();
        result.append(UTF16.getLeadSurrogate(ch));
        result.append(UTF16.getTrailSurrogate(ch));
        return result.toString();
    }

    public static int toTitleCase(int ch) {
        int props = UCharacter.getProps(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            if (UCharacterProperty.getPropType(props) == 2) {
                return ch - UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 2)) {
                return PROPERTY_.getException(index, 2);
            }
            if (PROPERTY_.hasExceptionValue(index, 0)) {
                return PROPERTY_.getException(index, 0);
            }
        }
        return ch;
    }

    public static int toUpperCase(int ch) {
        int props = UCharacter.getProps(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            if (UCharacterProperty.getPropType(props) == 2) {
                return ch - UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 0)) {
                return PROPERTY_.getException(index, 0);
            }
        }
        return ch;
    }

    public static boolean isSupplementary(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isBMP(int ch) {
        return ch >= 0 && ch <= 65535;
    }

    public static boolean isPrintable(int ch) {
        int cat = UCharacter.getType(ch);
        return cat != 0 && cat != 15 && cat != 16 && cat != 17 && cat != 18 && cat != 0;
    }

    public static boolean isBaseForm(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 9 || cat == 11 || cat == 10 || cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 6 || cat == 7 || cat == 8;
    }

    public static int getDirection(int ch) {
        int props = UCharacter.getProps(ch);
        if (props != 0) {
            return UCharacterProperty.getDirection(props);
        }
        return 18;
    }

    public static boolean isMirrored(int ch) {
        int props = UCharacter.getProps(ch);
        return UCharacterProperty.isMirrored(props);
    }

    public static int getMirror(int ch) {
        int props = UCharacter.getProps(ch);
        if (UCharacterProperty.isMirrored(props)) {
            if (!UCharacterProperty.isExceptionIndicator(props)) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 6)) {
                return PROPERTY_.getException(index, 6);
            }
        }
        return ch;
    }

    public static int getCombiningClass(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return NormalizerImpl.getCombiningClass(ch);
    }

    public static boolean isLegal(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 55296) {
            return true;
        }
        if (ch <= 57343) {
            return false;
        }
        if (UCharacter.isNonCharacter(ch)) {
            return false;
        }
        return ch <= 0x10FFFF;
    }

    public static boolean isLegal(String str) {
        int size = str.length();
        int i = 0;
        while (i < size) {
            int codepoint = UTF16.charAt(str, i);
            if (!UCharacter.isLegal(codepoint)) {
                return false;
            }
            if (UCharacter.isSupplementary(codepoint)) {
                ++i;
            }
            ++i;
        }
        return true;
    }

    public static VersionInfo getUnicodeVersion() {
        return UCharacter.PROPERTY_.m_unicodeVersion_;
    }

    public static String getName(int ch) {
        return NAME_.getName(ch, 0);
    }

    public static String getName1_0(int ch) {
        return NAME_.getName(ch, 1);
    }

    public static String getExtendedName(int ch) {
        return NAME_.getName(ch, 2);
    }

    public static int getCharFromName(String name) {
        return NAME_.getCharFromName(0, name);
    }

    public static int getCharFromName1_0(String name) {
        return NAME_.getCharFromName(1, name);
    }

    public static int getCharFromExtendedName(String name) {
        return NAME_.getCharFromName(2, name);
    }

    public static int getCodePoint(char lead, char trail) {
        if (lead >= '\ud800' && lead <= '\udbff' && trail >= '\udc00' && trail <= '\udfff') {
            return UCharacterProperty.getRawSupplementary(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static int getCodePoint(char char16) {
        if (UCharacter.isLegal(char16)) {
            return char16;
        }
        throw new IllegalArgumentException("Illegal codepoint");
    }

    public static String toUpperCase(String str) {
        return UCharacter.toUpperCase(Locale.getDefault(), str);
    }

    public static String toLowerCase(String str) {
        return UCharacter.toLowerCase(Locale.getDefault(), str);
    }

    public static String toTitleCase(String str, BreakIterator breakiter) {
        return UCharacter.toTitleCase(Locale.getDefault(), str, breakiter);
    }

    public static String toUpperCase(Locale locale, String str) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return PROPERTY_.toUpperCase(locale, str, 0, str.length());
    }

    public static String toLowerCase(Locale locale, String str) {
        int length = str.length();
        StringBuffer result = new StringBuffer(length);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        PROPERTY_.toLowerCase(locale, str, 0, length, result);
        return result.toString();
    }

    public static String toTitleCase(Locale locale, String str, BreakIterator breakiter) {
        if (breakiter == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            breakiter = BreakIterator.getWordInstance(locale);
        }
        return PROPERTY_.toTitleCase(locale, str, breakiter);
    }

    public static int foldCase(int ch, boolean defaultmapping) {
        int props = PROPERTY_.getProperty(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int type = UCharacterProperty.getPropType(props);
            if (type == 1 || type == 3) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 8)) {
                int exception = PROPERTY_.getException(index, 8);
                if (exception != 0) {
                    int foldedcasech = PROPERTY_.getFoldCase(exception & 0xFFFF);
                    if (foldedcasech != 0) {
                        return foldedcasech;
                    }
                } else {
                    if (defaultmapping && (ch == 305 || ch == 304)) {
                        return 105;
                    }
                    return ch;
                }
            }
            if (PROPERTY_.hasExceptionValue(index, 1)) {
                return PROPERTY_.getException(index, 1);
            }
        }
        return ch;
    }

    public static String foldCase(String str, boolean defaultmapping) {
        int size = str.length();
        StringBuffer result = new StringBuffer(size);
        int offset = 0;
        while (offset < size) {
            int ch = UTF16.charAt(str, offset);
            offset += UTF16.getCharCount(ch);
            int props = PROPERTY_.getProperty(ch);
            if (!UCharacterProperty.isExceptionIndicator(props)) {
                int type = UCharacterProperty.getPropType(props);
                if (type == 1 || type == 3) {
                    ch += UCharacterProperty.getSignedValue(props);
                }
            } else {
                int index = UCharacterProperty.getExceptionIndex(props);
                if (PROPERTY_.hasExceptionValue(index, 8)) {
                    int exception = PROPERTY_.getException(index, 8);
                    if (exception != 0) {
                        PROPERTY_.getFoldCase(exception & 0xFFFF, exception >> 24, result);
                        continue;
                    }
                    if (defaultmapping && (ch == 305 || ch == 304)) {
                        result.append('i');
                        continue;
                    }
                    UTF16.append(result, ch);
                    continue;
                }
                if (PROPERTY_.hasExceptionValue(index, 1)) {
                    ch = PROPERTY_.getException(index, 1);
                }
            }
            UTF16.append(result, ch);
        }
        return result.toString();
    }

    public static int getHanNumericValue(int ch) {
        switch (ch) {
            case 12295: 
            case 38646: {
                return 0;
            }
            case 19968: 
            case 22777: {
                return 1;
            }
            case 20108: 
            case 36019: {
                return 2;
            }
            case 19977: 
            case 21443: {
                return 3;
            }
            case 22232: 
            case 32902: {
                return 4;
            }
            case 20116: 
            case 20237: {
                return 5;
            }
            case 20845: 
            case 38520: {
                return 6;
            }
            case 19971: 
            case 26578: {
                return 7;
            }
            case 20843: 
            case 25420: {
                return 8;
            }
            case 20061: 
            case 29590: {
                return 9;
            }
            case 21313: 
            case 25342: {
                return 10;
            }
            case 20336: 
            case 30334: {
                return 100;
            }
            case 20191: 
            case 21315: {
                return 1000;
            }
            case 33356: {
                return 10000;
            }
            case 20740: {
                return 100000000;
            }
        }
        return -1;
    }

    public static RangeValueIterator getTypeIterator() {
        return new UCharacterTypeIterator(PROPERTY_);
    }

    public static ValueIterator getNameIterator() {
        return new UCharacterNameIterator(NAME_, 0);
    }

    public static ValueIterator getName1_0Iterator() {
        return new UCharacterNameIterator(NAME_, 1);
    }

    public static ValueIterator getExtendedNameIterator() {
        return new UCharacterNameIterator(NAME_, 2);
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(ch);
    }

    public static boolean hasBinaryProperty(int ch, int property) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.hasBinaryProperty(ch, property);
    }

    public static boolean isUAlphabetic(int ch) {
        return UCharacter.hasBinaryProperty(ch, 0);
    }

    public static boolean isULowercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 22);
    }

    public static boolean isUUppercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 30);
    }

    public static boolean isUWhiteSpace(int ch) {
        return UCharacter.hasBinaryProperty(ch, 31);
    }

    static boolean isNonCharacter(int ch) {
        if ((ch & 0xFFFE) == 65534) {
            return true;
        }
        return ch >= 64976 && ch <= 65007;
    }

    private UCharacter() {
    }

    private static int getProps(int ch) {
        if (ch >= 0 & ch <= 0x10FFFF) {
            return PROPERTY_.getProperty(ch);
        }
        return 0;
    }

    private static int getEuropeanDigit(int ch) {
        if (ch <= 122) {
            if (ch >= 65 && ch <= 90) {
                return ch + 10 - 65;
            }
            if (ch >= 97) {
                return ch + 10 - 97;
            }
        } else if (ch >= 65313) {
            if (ch <= 65338) {
                return ch + 10 - 65313;
            }
            if (ch >= 65345 && ch <= 65370) {
                return ch + 10 - 65345;
            }
        }
        return -1;
    }

    private static int getNumericValueInternal(int ch, boolean useEuropean) {
        int europeannumeric;
        int props = UCharacter.getProps(ch);
        int numericType = UCharacterProperty.getNumericType(props);
        int result = -1;
        if (numericType == 3) {
            result = -2;
        }
        if (numericType != 0) {
            if (!UCharacterProperty.isExceptionIndicator(props)) {
                return UCharacterProperty.getSignedValue(props);
            }
            int index = UCharacterProperty.getExceptionIndex(props);
            if (!PROPERTY_.hasExceptionValue(index, 5) && PROPERTY_.hasExceptionValue(index, 4)) {
                return PROPERTY_.getException(index, 4);
            }
        }
        if (result < 0 && useEuropean && (europeannumeric = UCharacter.getEuropeanDigit(ch)) >= 0) {
            return europeannumeric;
        }
        return result;
    }

    static {
        try {
            NAME_ = new UCharacterName();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

