/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.ReplaceableString;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeMatcher;

public final class Utility {
    private static final char APOSTROPHE = '\'';
    private static final char BACKSLASH = '\\';
    private static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final boolean arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        return source.equals(target);
    }

    public static final boolean arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (!Utility.arrayEquals(source[i], target[i + delta])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean objectEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        return source.equals(target);
    }

    public static final String arrayToRLEString(int[] a) {
        StringBuffer buffer = new StringBuffer();
        Utility.appendInt(buffer, a.length);
        int runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            int s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(short[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        short runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            short s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(char[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        char runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            char s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, (short)runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, (short)runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(byte[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        byte runValue = a[0];
        int runLength = 1;
        byte[] state = new byte[2];
        int i = 1;
        while (i < a.length) {
            byte b = a[i];
            if (b == runValue && runLength < 255) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength, state);
                runValue = b;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength, state);
        if (state[0] != 0) {
            Utility.appendEncodedByte(buffer, (byte)0, state);
        }
        return buffer.toString();
    }

    private static final void encodeRun(StringBuffer buffer, int value, int length) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == 42405) {
                    Utility.appendInt(buffer, value);
                }
                Utility.appendInt(buffer, value);
                ++j;
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    Utility.appendInt(buffer, 42405);
                }
                Utility.appendInt(buffer, value);
                --length;
            }
            Utility.appendInt(buffer, 42405);
            Utility.appendInt(buffer, length);
            Utility.appendInt(buffer, value);
        }
    }

    private static final void appendInt(StringBuffer buffer, int value) {
        buffer.append((char)(value >>> 16));
        buffer.append((char)(value & 0xFFFF));
    }

    private static final void encodeRun(StringBuffer buffer, short value, int length) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                ++j;
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                --length;
            }
            buffer.append('\ua5a5');
            buffer.append((char)length);
            buffer.append((char)value);
        }
    }

    private static final void encodeRun(StringBuffer buffer, byte value, int length, byte[] state) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                ++j;
            }
        } else {
            if (length == -91) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                --length;
            }
            Utility.appendEncodedByte(buffer, (byte)-91, state);
            Utility.appendEncodedByte(buffer, (byte)length, state);
            Utility.appendEncodedByte(buffer, value, state);
        }
    }

    private static final void appendEncodedByte(StringBuffer buffer, byte value, byte[] state) {
        if (state[0] != 0) {
            char c = (char)(state[1] << 8 | value & 0xFF);
            buffer.append(c);
            state[0] = 0;
        } else {
            state[0] = 1;
            state[1] = value;
        }
    }

    public static final int[] RLEStringToIntArray(String s) {
        int length = Utility.getInt(s, 0);
        int[] array = new int[length];
        int ai = 0;
        int i = 1;
        int maxI = s.length() / 2;
        while (ai < length && i < maxI) {
            int c;
            if ((c = Utility.getInt(s, i++)) == 42405) {
                if ((c = Utility.getInt(s, i++)) == 42405) {
                    array[ai++] = c;
                    continue;
                }
                int runLength = c;
                int runValue = Utility.getInt(s, i++);
                int j = 0;
                while (j < runLength) {
                    array[ai++] = runValue;
                    ++j;
                }
                continue;
            }
            array[ai++] = c;
        }
        if (ai != length || i != maxI) {
            throw new InternalError("Bad run-length encoded int array");
        }
        return array;
    }

    static final int getInt(String s, int i) {
        return s.charAt(2 * i) << 16 | s.charAt(2 * i + 1);
    }

    public static final short[] RLEStringToShortArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        short[] array = new short[length];
        int ai = 0;
        int i = 2;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = (short)c;
                } else {
                    int runLength = c;
                    short runValue = (short)s.charAt(++i);
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = runValue;
                        ++j;
                    }
                }
            } else {
                array[ai++] = (short)c;
            }
            ++i;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final char[] RLEStringToCharArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        char[] array = new char[length];
        int ai = 0;
        int i = 2;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = c;
                } else {
                    int runLength = c;
                    char runValue = s.charAt(++i);
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = runValue;
                        ++j;
                    }
                }
            } else {
                array[ai++] = c;
            }
            ++i;
        }
        if (ai != length) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return array;
    }

    public static final byte[] RLEStringToByteArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        byte[] array = new byte[length];
        boolean nextChar = true;
        int c = 0;
        int node = 0;
        int runLength = 0;
        int i = 2;
        int ai = 0;
        while (ai < length) {
            int b;
            if (nextChar) {
                c = s.charAt(i++);
                b = (byte)(c >> 8);
                nextChar = false;
            } else {
                b = c & 0xFF;
                nextChar = true;
            }
            switch (node) {
                case 0: {
                    if (b == -91) {
                        node = 1;
                        break;
                    }
                    array[ai++] = b;
                    break;
                }
                case 1: {
                    if (b == -91) {
                        array[ai++] = -91;
                        node = 0;
                        break;
                    }
                    runLength = b;
                    if (runLength < 0) {
                        runLength += 256;
                    }
                    node = 2;
                    break;
                }
                case 2: {
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = b;
                        ++j;
                    }
                    node = 0;
                }
            }
        }
        if (node != 0) {
            throw new InternalError("Bad run-length encoded byte array");
        }
        if (i != s.length()) {
            throw new InternalError("Excess data in RLE byte array string");
        }
        return array;
    }

    public static final String formatForSource(String s) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (i > 0) {
                buffer.append('+').append(LINE_SEPARATOR);
            }
            buffer.append("        \"");
            int count = 11;
            while (i < s.length() && count < 80) {
                char c;
                if ((c = s.charAt(i++)) < ' ' || c == '\"' || c == '\\') {
                    buffer.append('\\');
                    buffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                    buffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                    buffer.append(HEX_DIGIT[c & 7]);
                    count += 4;
                    continue;
                }
                if (c <= '~') {
                    buffer.append(c);
                    ++count;
                    continue;
                }
                buffer.append("\\u");
                buffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
                buffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
                buffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
                buffer.append(HEX_DIGIT[c & 0xF]);
                count += 6;
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static final String escape(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int c = UTF16.charAt(s, i);
            i += UTF16.getCharCount(c);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            Utility.hex(c, four ? 4 : 8, buf);
        }
        return buf.toString();
    }

    public static int unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = UTF16.charAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig) {
                c = s.charAt(offset);
                dig = Character.digit((char)c, bitsPerDigit == 3 ? 8 : 16);
                if (dig < 0) break;
                result = result << bitsPerDigit | dig;
                ++offset;
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            offset16[0] = offset;
            return result;
        }
        int i = 0;
        while (i < UNESCAPE_MAP.length) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
            i += 2;
        }
        offset16[0] = offset;
        return c;
    }

    public static String unescape(String s) {
        StringBuffer buf = new StringBuffer();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e = Utility.unescapeAt(s, pos);
                if (e < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence " + s.substring(i - 1, Math.min(i + 8, s.length())));
                }
                UTF16.append(buf, e);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String unescapeLeniently(String s) {
        StringBuffer buf = new StringBuffer();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e = Utility.unescapeAt(s, pos);
                if (e < 0) {
                    buf.append(c);
                    continue;
                }
                UTF16.append(buf, e);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String hex(char ch) {
        StringBuffer temp = new StringBuffer();
        return Utility.hex(ch, temp).toString();
    }

    public static String hex(String s) {
        StringBuffer temp = new StringBuffer();
        return Utility.hex(s, temp).toString();
    }

    public static String hex(StringBuffer s) {
        return Utility.hex(s.toString());
    }

    public static StringBuffer hex(char ch, StringBuffer output) {
        return Utility.appendNumber(output, ch, 16, 4);
    }

    public static StringBuffer hex(int ch, int width, StringBuffer output) {
        return Utility.appendNumber(output, ch, 16, width);
    }

    public static String hex(int ch, int width) {
        StringBuffer buf = new StringBuffer();
        return Utility.appendNumber(buf, ch, 16, width).toString();
    }

    public static StringBuffer hex(String s, StringBuffer result) {
        int i = 0;
        while (i < s.length()) {
            if (i != 0) {
                result.append(',');
            }
            Utility.hex(s.charAt(i), result);
            ++i;
        }
        return result;
    }

    public static void split(String s, char divider, String[] output) {
        int last = 0;
        int current = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == divider) {
                output[current++] = s.substring(last, i);
                last = i + 1;
            }
            ++i;
        }
        output[current++] = s.substring(last, i);
        while (current < output.length) {
            output[current++] = "";
        }
    }

    public static int lookup(String source, String[] target) {
        int i = 0;
        while (i < target.length) {
            if (source.equals(target[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int skipWhitespace(String str, int pos) {
        while (pos < str.length()) {
            int c = UTF16.charAt(str, pos);
            if (!UCharacter.isWhitespace(c)) break;
            pos += UTF16.getCharCount(c);
        }
        return pos;
    }

    public static void skipWhitespace(String str, int[] pos) {
        pos[0] = Utility.skipWhitespace(str, pos[0]);
    }

    public static boolean parseChar(String id, int[] pos, char ch) {
        int start = pos[0];
        Utility.skipWhitespace(id, pos);
        if (pos[0] == id.length() || id.charAt(pos[0]) != ch) {
            pos[0] = start;
            return false;
        }
        pos[0] = pos[0] + 1;
        return true;
    }

    public static int parsePattern(String rule, int pos, int limit, String pattern, int[] parsedInts) {
        int[] p = new int[1];
        int intCount = 0;
        int i = 0;
        while (i < pattern.length()) {
            char cpat = pattern.charAt(i);
            switch (cpat) {
                case ' ': {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if (!UCharacter.isWhitespace(c = rule.charAt(pos++))) {
                        return -1;
                    }
                }
                case '~': {
                    pos = Utility.skipWhitespace(rule, pos);
                    break;
                }
                case '#': {
                    p[0] = pos;
                    parsedInts[intCount++] = Utility.parseInteger(rule, p, limit);
                    if (p[0] == pos) {
                        return -1;
                    }
                    pos = p[0];
                    break;
                }
                default: {
                    char c;
                    if (pos >= limit) {
                        return -1;
                    }
                    if ((c = (char)UCharacter.toLowerCase(rule.charAt(pos++))) == cpat) break;
                    return -1;
                }
            }
            ++i;
        }
        return pos;
    }

    public static int parseInteger(String rule, int[] pos, int limit) {
        int count = 0;
        int value = 0;
        int p = pos[0];
        int radix = 10;
        if (rule.regionMatches(true, p, "0x", 0, 2)) {
            p += 2;
            radix = 16;
        } else if (p < limit && rule.charAt(p) == '0') {
            ++p;
            count = 1;
            radix = 8;
        }
        while (p < limit) {
            int d;
            if ((d = UCharacter.digit(rule.charAt(p++), radix)) < 0) {
                --p;
                break;
            }
            ++count;
            int v = value * radix + d;
            if (v <= value) {
                return 0;
            }
            value = v;
        }
        if (count > 0) {
            pos[0] = p;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parseUnicodeIdentifier(String str, int[] pos) {
        StringBuffer buf = new StringBuffer();
        int p = pos[0];
        while (p < str.length()) {
            int ch = UTF16.charAt(str, p);
            if (buf.length() == 0) {
                if (!UCharacter.isUnicodeIdentifierStart(ch)) return null;
                UTF16.append(buf, ch);
            } else {
                if (!UCharacter.isUnicodeIdentifierPart(ch)) break;
                UTF16.append(buf, ch);
            }
            p += UTF16.getCharCount(ch);
        }
        pos[0] = p;
        return buf.toString();
    }

    public static StringBuffer trim(StringBuffer b) {
        int i = 0;
        while (i < b.length() && Character.isWhitespace(b.charAt(i))) {
            ++i;
        }
        b.delete(0, i);
        i = b.length() - 1;
        while (i >= 0 && Character.isWhitespace(b.charAt(i))) {
            --i;
        }
        return b.delete(i + 1, b.length());
    }

    public static StringBuffer appendNumber(StringBuffer result, int n) {
        return Utility.appendNumber(result, n, 10, 1);
    }

    public static StringBuffer appendNumber(StringBuffer result, int n, int radix, int minDigits) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Illegal radix " + radix);
        }
        if (n < 0) {
            n = -n;
            result.append('-');
        }
        int nn = n;
        int r = 1;
        while (nn >= radix) {
            nn /= radix;
            r *= radix;
            --minDigits;
        }
        while (--minDigits > 0) {
            result.append(DIGITS[0]);
        }
        while (r > 0) {
            int digit = n / r;
            result.append(DIGITS[digit]);
            n -= digit * r;
            r /= radix;
        }
        return result;
    }

    public static int parseNumber(String text, int[] pos, int radix) {
        int n = 0;
        int p = pos[0];
        while (p < text.length()) {
            int ch = UTF16.charAt(text, p);
            int d = UCharacter.digit(ch, radix);
            if (d < 0) break;
            if ((n = radix * n + d) < 0) {
                return -1;
            }
            ++p;
        }
        if (p == pos[0]) {
            return -1;
        }
        pos[0] = p;
        return n;
    }

    public static boolean isUnprintable(int c) {
        return c < 32 || c > 126;
    }

    public static boolean escapeUnprintable(StringBuffer result, int c) {
        if (Utility.isUnprintable(c)) {
            result.append('\\');
            if ((c & 0xFFFF0000) != 0) {
                result.append('U');
                result.append(HEX[0xF & c >> 28]);
                result.append(HEX[0xF & c >> 24]);
                result.append(HEX[0xF & c >> 20]);
                result.append(HEX[0xF & c >> 16]);
            } else {
                result.append('u');
            }
            result.append(HEX[0xF & c >> 12]);
            result.append(HEX[0xF & c >> 8]);
            result.append(HEX[0xF & c >> 4]);
            result.append(HEX[0xF & c]);
            return true;
        }
        return false;
    }

    public static int quotedIndexOf(String text, int start, int limit, String setOfChars) {
        int i = start;
        while (i < limit) {
            char c = text.charAt(i);
            if (c == '\\') {
                ++i;
            } else if (c == '\'') {
                while (++i < limit && text.charAt(i) != '\'') {
                }
            } else if (setOfChars.indexOf(c) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String formatInput(ReplaceableString input, Transliterator.Position pos) {
        StringBuffer appendTo = new StringBuffer();
        Utility.formatInput(appendTo, input, pos);
        return Utility.escape(appendTo.toString());
    }

    public static StringBuffer formatInput(StringBuffer appendTo, ReplaceableString input, Transliterator.Position pos) {
        if (0 <= pos.contextStart && pos.contextStart <= pos.start && pos.start <= pos.limit && pos.limit <= pos.contextLimit && pos.contextLimit <= input.length()) {
            String b = input.substring(pos.contextStart, pos.start);
            String c = input.substring(pos.start, pos.limit);
            String d = input.substring(pos.limit, pos.contextLimit);
            appendTo.append('{').append(b).append('|').append(c).append('|').append(d).append('}');
        } else {
            appendTo.append("INVALID Position {cs=" + pos.contextStart + ", s=" + pos.start + ", l=" + pos.limit + ", cl=" + pos.contextLimit + "} on " + input);
        }
        return appendTo;
    }

    public static String formatInput(Replaceable input, Transliterator.Position pos) {
        return Utility.formatInput((ReplaceableString)input, pos);
    }

    public static StringBuffer formatInput(StringBuffer appendTo, Replaceable input, Transliterator.Position pos) {
        return Utility.formatInput(appendTo, (ReplaceableString)input, pos);
    }

    public static void getChars(StringBuffer src, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin == srcEnd) {
            return;
        }
        src.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public static void appendToRule(StringBuffer rule, int c, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (isLiteral || escapeUnprintable && Utility.isUnprintable(c)) {
            if (quoteBuf.length() > 0) {
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(0) == '\'' && quoteBuf.charAt(1) == '\'') {
                    rule.append('\\').append('\'');
                    quoteBuf.delete(0, 2);
                }
                int trailingCount = 0;
                while (quoteBuf.length() >= 2 && quoteBuf.charAt(quoteBuf.length() - 2) == '\'' && quoteBuf.charAt(quoteBuf.length() - 1) == '\'') {
                    quoteBuf.setLength(quoteBuf.length() - 2);
                    ++trailingCount;
                }
                if (quoteBuf.length() > 0) {
                    rule.append('\'');
                    rule.append((Object)quoteBuf);
                    rule.append('\'');
                    quoteBuf.setLength(0);
                }
                while (trailingCount-- > 0) {
                    rule.append('\\').append('\'');
                }
            }
            if (c != -1) {
                if (c == 32) {
                    int len = rule.length();
                    if (len > 0 && rule.charAt(len - 1) != ' ') {
                        rule.append(' ');
                    }
                } else if (!escapeUnprintable || !Utility.escapeUnprintable(rule, c)) {
                    UTF16.append(rule, c);
                }
            }
        } else if (quoteBuf.length() == 0 && (c == 39 || c == 92)) {
            rule.append('\\').append((char)c);
        } else if (!(quoteBuf.length() <= 0 && (c < 33 || c > 126 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) && !UCharacter.isWhitespace(c))) {
            UTF16.append(quoteBuf, c);
            if (c == 39) {
                quoteBuf.append((char)c);
            }
        } else {
            UTF16.append(rule, c);
        }
    }

    public static void appendToRule(StringBuffer rule, String text, boolean isLiteral, boolean escapeUnprintable, StringBuffer quoteBuf) {
        int i = 0;
        while (i < text.length()) {
            Utility.appendToRule(rule, text.charAt(i), isLiteral, escapeUnprintable, quoteBuf);
            ++i;
        }
    }

    public static void appendToRule(StringBuffer rule, UnicodeMatcher matcher, boolean escapeUnprintable, StringBuffer quoteBuf) {
        if (matcher != null) {
            Utility.appendToRule(rule, matcher.toPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        }
    }
}

