/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

public final class USerializedSet {
    private char[] array;
    private int arrayOffset;
    private int bmpLength;
    private int length;

    public final boolean getSet(char[] src, int srcStart) {
        this.array = null;
        this.length = 0;
        this.bmpLength = 0;
        this.arrayOffset = 0;
        this.length = src[srcStart++];
        if ((this.length & 0x8000) > 0) {
            this.length &= Short.MAX_VALUE;
            if (src.length < srcStart + 1 + this.length) {
                this.length = 0;
                throw new IndexOutOfBoundsException();
            }
            this.bmpLength = src[srcStart++];
        } else {
            if (src.length < srcStart + this.length) {
                this.length = 0;
                throw new IndexOutOfBoundsException();
            }
            this.bmpLength = this.length;
        }
        this.array = src;
        this.arrayOffset = srcStart;
        return true;
    }

    public final boolean contains(int c) {
        if (c < 0 || 0x10FFFF < c) {
            return false;
        }
        if (c <= 65535) {
            int bmpLimit = this.arrayOffset + this.bmpLength;
            int i = this.arrayOffset;
            while (i < bmpLimit && c >= this.array[i]) {
                ++i;
            }
            return (i - this.arrayOffset & 1) > 0;
        }
        int limit = this.arrayOffset + this.length;
        char high = (char)(c >> 16);
        char low = (char)c;
        int i = this.arrayOffset + this.bmpLength;
        while (i < limit && (high > this.array[i] || high == this.array[i] && low >= this.array[i + 1])) {
            i += 2;
        }
        return (i + this.bmpLength - this.arrayOffset & 2) != 0;
    }

    public final boolean countRanges() {
        return (this.bmpLength + (this.length - this.bmpLength) / 2 + 1) / 2 > 0;
    }

    public final boolean getRange(int rangeIndex, int[] range) {
        if (rangeIndex < 0) {
            return false;
        }
        if (this.array == null) {
            this.array = new char[8];
        }
        range = new int[2];
        if ((rangeIndex *= 2) < this.bmpLength) {
            range[0] = this.array[this.arrayOffset + rangeIndex++];
            range[1] = rangeIndex < this.bmpLength ? this.array[this.arrayOffset + rangeIndex] : (rangeIndex < this.length ? this.array[this.arrayOffset + rangeIndex] << 16 | this.array[this.arrayOffset + rangeIndex + 1] : 0x110000);
            return true;
        }
        rangeIndex -= this.bmpLength;
        int suppLength = this.length - this.bmpLength;
        if ((rangeIndex *= 2) < suppLength) {
            int offset = this.arrayOffset + this.bmpLength;
            range[0] = this.array[offset + rangeIndex] << 16 | this.array[offset + rangeIndex + 1];
            range[1] = (rangeIndex += 2) < suppLength ? this.array[offset + rangeIndex] << 16 | this.array[offset + rangeIndex + 1] : 0x110000;
            return true;
        }
        return false;
    }

    public final void setSerializedToOne(int c) {
        if (0x10FFFF < c) {
            return;
        }
        if (c < 65535) {
            this.length = 2;
            this.bmpLength = 2;
            this.array[0] = (char)c;
            this.array[1] = (char)(c + 1);
        } else if (c == 65535) {
            this.bmpLength = 1;
            this.length = 3;
            this.array[0] = 65535;
            this.array[1] = '\u0001';
            this.array[2] = '\u0000';
        } else if (c < 0x10FFFF) {
            this.bmpLength = 0;
            this.length = 4;
            this.array[0] = (char)(c >> 16);
            this.array[1] = (char)c;
            this.array[2] = (char)(++c >> 16);
            this.array[3] = (char)c;
        } else {
            this.bmpLength = 0;
            this.length = 2;
            this.array[0] = 16;
            this.array[1] = 65535;
        }
    }

    public final boolean getSerializedRange(int rangeIndex, int[] range) {
        if (rangeIndex < 0) {
            return false;
        }
        if (this.array == null) {
            this.array = new char[8];
        }
        range = new int[2];
        if ((rangeIndex *= 2) < this.bmpLength) {
            range[0] = this.array[rangeIndex++];
            range[1] = rangeIndex < this.bmpLength ? this.array[rangeIndex] : (rangeIndex < this.length ? this.array[rangeIndex] << 16 | this.array[rangeIndex + 1] : 0x110000);
            return true;
        }
        rangeIndex -= this.bmpLength;
        this.length -= this.bmpLength;
        if ((rangeIndex *= 2) < this.length) {
            int offset = this.arrayOffset + this.bmpLength;
            range[0] = this.array[offset + rangeIndex] << 16 | this.array[offset + rangeIndex + 1];
            range[1] = (rangeIndex += 2) < this.length ? this.array[offset + rangeIndex] << 16 | this.array[offset + rangeIndex + 1] : 0x110000;
            return false;
        }
        return false;
    }

    public final boolean serializedContains(int c) {
        if (c > 0x10FFFF) {
            return false;
        }
        if (c <= 65535) {
            int i = 0;
            while (i < this.bmpLength && (char)c >= this.array[i]) {
                ++i;
            }
            return (i & 1) != 0;
        }
        char high = (char)(c >> 16);
        char low = (char)c;
        int i = this.bmpLength;
        while (i < this.length && (high > this.array[i] || high == this.array[i] && low >= this.array[i + 1])) {
            i += 2;
        }
        return (i + this.bmpLength & 2) != 0;
    }

    public final int countSerializedRanges() {
        return (this.bmpLength + (this.length - this.bmpLength) / 2 + 1) / 2;
    }
}

