/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.util.VersionInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UCharacterPropertyReader {
    private static final int INDEX_SIZE_ = 16;
    private DataInputStream m_dataInputStream_;
    private int m_propertyOffset_;
    private int m_exceptionOffset_;
    private int m_caseOffset_;
    private int m_additionalOffset_;
    private int m_additionalVectorsOffset_;
    private int m_additionalColumnsCount_;
    private int m_reservedOffset_;
    private static final byte[] DATA_FORMAT_ID_ = new byte[]{85, 80, 114, 111};
    private static final byte[] DATA_FORMAT_VERSION_ = new byte[]{3, 0, 5, 2};
    private static final byte[] UNICODE_VERSION_ = new byte[]{3, 1, 1, 0};

    protected UCharacterPropertyReader(InputStream inputStream) throws IOException {
        ICUBinary.readHeader(inputStream, DATA_FORMAT_ID_, DATA_FORMAT_VERSION_, UNICODE_VERSION_);
        this.m_dataInputStream_ = new DataInputStream(inputStream);
    }

    protected void read(UCharacterProperty ucharppty) throws IOException {
        int count = 16;
        this.m_propertyOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_exceptionOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_caseOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalVectorsOffset_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_additionalColumnsCount_ = this.m_dataInputStream_.readInt();
        --count;
        this.m_reservedOffset_ = this.m_dataInputStream_.readInt();
        this.m_dataInputStream_.skipBytes(--count << 2);
        ucharppty.m_trie_ = new CharTrie(this.m_dataInputStream_, ucharppty);
        int size = this.m_exceptionOffset_ - this.m_propertyOffset_;
        ucharppty.m_property_ = new int[size];
        int i = 0;
        while (i < size) {
            ucharppty.m_property_[i] = this.m_dataInputStream_.readInt();
            ++i;
        }
        size = this.m_caseOffset_ - this.m_exceptionOffset_;
        ucharppty.m_exception_ = new int[size];
        int i2 = 0;
        while (i2 < size) {
            ucharppty.m_exception_[i2] = this.m_dataInputStream_.readInt();
            ++i2;
        }
        size = this.m_additionalOffset_ - this.m_caseOffset_ << 1;
        ucharppty.m_case_ = new char[size];
        int i3 = 0;
        while (i3 < size) {
            ucharppty.m_case_[i3] = this.m_dataInputStream_.readChar();
            ++i3;
        }
        ucharppty.m_additionalTrie_ = new CharTrie(this.m_dataInputStream_, ucharppty);
        size = this.m_reservedOffset_ - this.m_additionalVectorsOffset_;
        ucharppty.m_additionalVectors_ = new int[size];
        int i4 = 0;
        while (i4 < size) {
            ucharppty.m_additionalVectors_[i4] = this.m_dataInputStream_.readInt();
            ++i4;
        }
        this.m_dataInputStream_.close();
        ucharppty.m_additionalColumnsCount_ = this.m_additionalColumnsCount_;
        ucharppty.m_unicodeVersion_ = VersionInfo.getInstance(UNICODE_VERSION_[0], UNICODE_VERSION_[1], UNICODE_VERSION_[2], UNICODE_VERSION_[3]);
    }
}

