/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

final class TrieBuilder {
    TrieBuilder() {
    }

    static int build(byte[] array, int start, int length, int blocksize, int[] indexarray, byte[] valuearray) {
        int valuesize = 0;
        int blockcount = 0;
        int index = 0;
        while (start < length) {
            int min;
            int valueindex = 0;
            while (valueindex < valuesize) {
                min = Math.min(blocksize, valuesize - valueindex);
                blockcount = 0;
                while (blockcount < min) {
                    if (array[start + blockcount] != valuearray[valueindex + blockcount]) break;
                    ++blockcount;
                }
                if (blockcount == blocksize || valueindex + blockcount == valuesize) break;
                ++valueindex;
            }
            min = Math.min(blocksize, length - start);
            while (blockcount < min) {
                valuearray[valuesize++] = array[start + blockcount];
                ++blockcount;
            }
            indexarray[index++] = valueindex;
            start += blocksize;
        }
        return valuesize;
    }

    static int build(char[] array, int start, int length, int blocksize, int[] indexarray, char[] valuearray) {
        int valuesize = 0;
        int blockcount = 0;
        int index = 0;
        while (start < length) {
            int min;
            int valueindex = 0;
            while (valueindex < valuesize) {
                min = Math.min(blocksize, valuesize - valueindex);
                blockcount = 0;
                while (blockcount < min) {
                    if (array[start + blockcount] != valuearray[valueindex + blockcount]) break;
                    ++blockcount;
                }
                if (blockcount == blocksize || valueindex + blockcount == valuesize) break;
                ++valueindex;
            }
            min = Math.min(blocksize, length - start);
            while (blockcount < min) {
                valuearray[valuesize++] = array[start + blockcount];
                ++blockcount;
            }
            indexarray[index++] = valueindex;
            start += blocksize;
        }
        return valuesize;
    }

    static int build(int[] array, int start, int length, int blocksize, int[] indexarray, int[] valuearray) {
        int valuesize = 0;
        int blockcount = 0;
        int index = 0;
        while (start < length) {
            int min;
            int valueindex = 0;
            while (valueindex < valuesize) {
                min = Math.min(blocksize, valuesize - valueindex);
                blockcount = 0;
                while (blockcount < min) {
                    if (array[start + blockcount] != valuearray[valueindex + blockcount]) break;
                    ++blockcount;
                }
                if (blockcount == blocksize || valueindex + blockcount == valuesize) break;
                ++valueindex;
            }
            min = Math.min(blocksize, length - start);
            while (blockcount < min) {
                valuearray[valuesize++] = array[start + blockcount];
                ++blockcount;
            }
            indexarray[index++] = valueindex;
            start += blocksize;
        }
        return valuesize;
    }
}

