/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.IntTrie;
import com.ibm.icu.impl.NormalizerImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class NormalizerDataReader {
    private static final boolean debug = ICUDebug.enabled("NormalizerDataReader");
    private DataInputStream dataInputStream;
    private static final byte[] DATA_FORMAT_ID_ = new byte[]{78, 111, 114, 109};
    private static final byte[] DATA_FORMAT_VERSION_ = new byte[]{2, 1, 5, 2};
    private static final byte[] UNICODE_VERSION_ = new byte[]{3, 1, 1, 0};
    private static final String UNICODE_VERSION_STRING_ = "3.1.1.0";

    protected NormalizerDataReader(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("Bytes in inputStream " + inputStream.available());
        }
        ICUBinary.readHeader(inputStream, DATA_FORMAT_ID_, DATA_FORMAT_VERSION_, UNICODE_VERSION_);
        if (debug) {
            System.out.println("Bytes left in inputStream " + inputStream.available());
        }
        this.dataInputStream = new DataInputStream(inputStream);
        if (debug) {
            System.out.println("Bytes left in dataInputStream " + this.dataInputStream.available());
        }
    }

    protected void read(NormalizerImpl impl) throws IOException {
        int[] indexes = new int[32];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = this.dataInputStream.readInt();
            ++i;
        }
        byte[] normBytes = new byte[indexes[0]];
        this.dataInputStream.read(normBytes);
        ByteArrayInputStream normTrieStream = new ByteArrayInputStream(normBytes);
        int extraDataTop = indexes[1];
        char[] extraData = new char[extraDataTop];
        int i2 = 0;
        while (i2 < extraDataTop) {
            extraData[i2] = this.dataInputStream.readChar();
            ++i2;
        }
        int combiningTableTop = indexes[2];
        char[] combiningTable = new char[combiningTableTop];
        int i3 = 0;
        while (i3 < combiningTableTop) {
            combiningTable[i3] = this.dataInputStream.readChar();
            ++i3;
        }
        byte[] fcdBytes = new byte[indexes[10]];
        this.dataInputStream.read(fcdBytes);
        ByteArrayInputStream fcdTrieStream = new ByteArrayInputStream(fcdBytes);
        byte[] auxBytes = new byte[indexes[11]];
        this.dataInputStream.read(auxBytes);
        ByteArrayInputStream auxTrieStream = new ByteArrayInputStream(auxBytes);
        Object[] canonStartSets = new Object[4];
        int[] canonStartSetsIndexes = new int[32];
        int i4 = 0;
        while (i4 < canonStartSetsIndexes.length) {
            canonStartSetsIndexes[i4] = this.dataInputStream.readChar();
            ++i4;
        }
        char[] startSets = new char[canonStartSetsIndexes[0] - 32];
        int i5 = 0;
        while (i5 < startSets.length) {
            startSets[i5] = this.dataInputStream.readChar();
            ++i5;
        }
        char[] bmpTable = new char[canonStartSetsIndexes[1]];
        int i6 = 0;
        while (i6 < bmpTable.length) {
            bmpTable[i6] = this.dataInputStream.readChar();
            ++i6;
        }
        char[] suppTable = new char[canonStartSetsIndexes[2]];
        int i7 = 0;
        while (i7 < suppTable.length) {
            suppTable[i7] = this.dataInputStream.readChar();
            ++i7;
        }
        canonStartSets[0] = canonStartSetsIndexes;
        canonStartSets[1] = startSets;
        canonStartSets[2] = bmpTable;
        canonStartSets[3] = suppTable;
        NormalizerImpl.NormTrieImpl.normTrie = new IntTrie(normTrieStream, NormalizerImpl.normTrieImpl);
        NormalizerImpl.FCDTrieImpl.fcdTrie = new CharTrie(fcdTrieStream, NormalizerImpl.fcdTrieImpl);
        NormalizerImpl.AuxTrieImpl.auxTrie = new CharTrie(auxTrieStream, NormalizerImpl.auxTrieImpl);
        NormalizerImpl.indexes = indexes;
        NormalizerImpl.extraData = extraData;
        NormalizerImpl.combiningTable = combiningTable;
        NormalizerImpl.isDataLoaded = true;
        NormalizerImpl.canonStartSets = canonStartSets;
        NormalizerImpl.isFormatVersion_2_1 = DATA_FORMAT_VERSION_[0] > 2 || DATA_FORMAT_VERSION_[0] == 2 && DATA_FORMAT_VERSION_[1] >= 1;
    }
}

