/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;
import zeus.visualiser.statistics.charts.GraphicsSymbol;

public class XYGraph
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static double TINY = 1.0E-6;
    protected static int LEFT = 100;
    protected static int STEP = 5;
    protected static int KEY_LINE_LENGTH = 15;
    protected String title;
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max_x = 0.0;
    protected double min_x = 0.0;
    protected double max_y = 0.0;
    protected double min_y = 0.0;
    protected double[][] x_values;
    protected double[][] y_values;
    protected String[] keys;
    protected int type = -1;

    public XYGraph() {
    }

    public XYGraph(double[] dArray, double[] dArray2, String string) {
        this.setData(dArray, dArray2, string);
    }

    public XYGraph(double[][] dArray, double[][] dArray2, String[] stringArray, String string) {
        this.setData(dArray, dArray2, stringArray, string);
    }

    public void setData(double[] dArray, double[] dArray2, String string) {
        this.type = 0;
        this.title = string;
        this.y_values = new double[1][];
        this.y_values[0] = dArray;
        this.x_values = new double[1][];
        this.x_values[0] = dArray2;
        this.computeMinMax();
    }

    public void setData(double[][] dArray, double[][] dArray2, String[] stringArray, String string) {
        this.type = 1;
        this.title = string;
        this.keys = stringArray;
        this.y_values = dArray;
        this.x_values = dArray2;
        this.computeMinMax();
    }

    protected void computeMinMax() {
        this.min_x = 0.0;
        this.max_x = 0.0;
        this.min_y = 0.0;
        this.max_y = 0.0;
        for (int i = 0; i < this.y_values.length; ++i) {
            for (int j = 0; j < this.y_values[i].length; ++j) {
                this.max_y = Math.max(this.max_y, this.y_values[i][j]);
                this.min_y = Math.min(this.min_y, this.y_values[i][j]);
                this.max_x = Math.max(this.max_x, this.x_values[i][j]);
                this.min_x = Math.min(this.min_x, this.x_values[i][j]);
            }
        }
    }

    public void drawYourSelf(Graphics graphics) {
        String string;
        int n;
        int n2;
        int n3;
        String string2;
        int n4;
        int n5;
        double d;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n6 = this.fm.stringWidth(this.title);
        int n7 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n6) / 2, n7);
        if (this.min_x == 0.0 && this.max_x == 0.0 && this.min_y == 0.0 && this.max_y == 0.0) {
            return;
        }
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        double d3 = this.min_x > 0.0 ? this.max_x : Math.abs(this.max_x - this.min_x);
        double d4 = d = this.min_y > 0.0 ? this.max_y : Math.abs(this.max_y - this.min_y);
        if (this.isZero(d3)) {
            d3 = 1.0E-6;
        }
        if (this.isZero(d)) {
            d = 1.0E-6;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (this.type == 1) {
            for (n5 = 0; n5 < this.keys.length; ++n5) {
                n10 = Math.max(n10, this.fm.stringWidth(this.keys[n5]));
            }
        }
        n11 = this.x - LEFT - (n10 += 30 + KEY_LINE_LENGTH + 10);
        n12 = this.y - 5 * n7;
        graphics.drawLine(LEFT, 3 * n7, LEFT, this.y - 2 * n7);
        n8 = LEFT;
        int n13 = n8 + n11;
        int n14 = n9 = (int)((double)(3 * n7 + n12) - (0.0 - this.min_y) * (double)n12 / d);
        graphics.drawLine(n8, n9, n13, n14);
        for (n5 = 0; n5 < this.y_values.length; ++n5) {
            if (this.y_values[n5].length <= 0) continue;
            n8 = (int)((this.x_values[n5][0] - this.min_x) * (double)n11 / d3 + (double)LEFT);
            n9 = (int)((double)n12 - (this.y_values[n5][0] - this.min_y) * (double)n12 / d + (double)(3 * n7));
            graphics.setColor(ColorManager.getColor(n5));
            GraphicsSymbol.drawSymbol(graphics, n5, 10, n8, n9);
            for (int i = 1; i < this.y_values[n5].length; ++i) {
                n13 = (int)((this.x_values[n5][i] - this.min_x) * (double)n11 / d3 + (double)LEFT);
                n14 = (int)((double)(3 * n7 + n12) - (this.y_values[n5][i] - this.min_y) * (double)n12 / d);
                GraphicsSymbol.drawSymbol(graphics, n5, 10, n13, n14);
                graphics.drawLine(n8, n9, n13, n14);
                n8 = n13;
                n9 = n14;
            }
        }
        n8 = (int)((double)LEFT + (0.0 - this.min_x) * (double)n11 / d3);
        n9 = (int)(3.0 * (double)n7 + (double)n12 - (0.0 - this.min_y) * (double)n12 / d);
        double d5 = Math.max(Math.abs(this.max_y), Math.abs(this.min_y)) / (double)STEP;
        if (d5 + 0.51 > 1.0) {
            d5 = (int)(d5 + 0.51);
        }
        int n15 = (int)(d5 * (double)n12 / d);
        graphics.setColor(Color.black);
        double d6 = 0.0;
        for (n4 = 0; (!this.isZero(d5) || n4 == 0) && d6 + d5 <= this.max_y; ++n4) {
            d6 = (double)n4 * d5;
            string2 = Misc.decimalPlaces(d6, 2);
            n3 = n8;
            n2 = n9 - n4 * n15;
            graphics.drawLine(n3, n2, n3 - 10, n2);
            n6 = this.fm.stringWidth(string2);
            graphics.drawString(string2, n3 - 10 - n6 - 5, n2);
        }
        if (this.min_y < 0.0) {
            d6 = -1.0 * d5;
            n4 = 1;
            while (!this.isZero(d5) && d6 - d5 >= this.min_y) {
                d6 = (double)(-1 * n4) * d5;
                string2 = Misc.decimalPlaces(d6, 2);
                n3 = n8;
                n2 = n9 + n4 * n15;
                graphics.drawLine(n3, n2, n3 - 10, n2);
                n6 = this.fm.stringWidth(string2);
                graphics.drawString(string2, n3 - 10 - n6 - 5, n2);
                ++n4;
            }
        }
        n8 = (int)((double)LEFT + (0.0 - this.min_x) * (double)n11 / d3);
        n9 = (int)(3.0 * (double)n7 + (double)n12 - (0.0 - this.min_y) * (double)n12 / d);
        double d7 = Math.max(Math.abs(this.max_x), Math.abs(this.min_x)) / (double)STEP;
        if (d7 + 0.51 > 1.0) {
            d7 = (int)(d7 + 0.51);
        }
        n15 = (int)(d7 * (double)n11 / d3);
        graphics.setColor(Color.black);
        d6 = 0.0;
        for (n = 0; (!this.isZero(d7) || n == 0) && d6 + d7 <= this.max_x; ++n) {
            d6 = (double)n * d7;
            string = Misc.decimalPlaces(d6, 2);
            n2 = n9;
            n3 = n8 + n * n15;
            graphics.drawLine(n3, n2, n3, n2 + 10);
            n6 = this.fm.stringWidth(string);
            graphics.drawString(string, n3 - n6 / 2, n2 + 10 + n7);
        }
        if (this.min_x < 0.0) {
            d6 = -1.0 * d7;
            n = 1;
            while (!this.isZero(d7) && d6 - d7 >= this.min_x) {
                d6 = (double)(-1 * n) * d7;
                string = Misc.decimalPlaces(d6, 2);
                n2 = n9;
                n3 = n8 - n * n15;
                graphics.drawLine(n3, n2, n3, n2 - 10);
                n6 = this.fm.stringWidth(string);
                graphics.drawString(string, n3 - n6 / 2, n2 - 10 - n7);
                ++n;
            }
        }
        if (this.type == 1) {
            n13 = LEFT + n11 + 20;
            n14 = 3 * n7;
            n = Math.max(n7 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n13, n14);
            for (int i = 0; i < this.keys.length; ++i) {
                graphics.setColor(ColorManager.getColor(i));
                graphics.drawLine(n13, n14 += n, n13 + KEY_LINE_LENGTH, n14);
                graphics.setColor(Color.black);
                graphics.drawString(this.keys[i], n13 + KEY_LINE_LENGTH + 10, n14);
            }
        }
    }

    void TEST(int n) {
        if (this.y_values[0].length == 0 || this.y_values[1].length == 0) {
            System.err.println("drawYourSelf position" + n);
        }
    }

    boolean isZero(double d) {
        return Math.abs(d) < TINY;
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }
}

