/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;

public class TabularGraph
implements DrawObject {
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 30;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;

    public TabularGraph() {
    }

    public TabularGraph(double[][] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public void setData(double[][] dArray, String[] stringArray, String string) {
        this.title = string;
        this.bars.removeAllElements();
        for (int i = 0; i < dArray.length; ++i) {
            Bar bar = new Bar();
            bar.values = new double[dArray[i].length];
            for (int j = 0; j < bar.values.length; ++j) {
                bar.values[j] = dArray[i][j];
            }
            bar.label = stringArray[i];
            this.bars.addElement(bar);
        }
    }

    public void drawYourSelf(Graphics graphics) {
        int n;
        int n2;
        String string;
        int n3;
        Bar bar;
        int n4;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n5 = this.fm.stringWidth(this.title);
        int n6 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n5) / 2, n6);
        if (this.bars.isEmpty()) {
            return;
        }
        int n7 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        int n8 = this.fm.getHeight() + this.gap;
        graphics.setFont(this.font);
        for (n4 = 0; n4 < this.bars.size(); ++n4) {
            bar = (Bar)this.bars.elementAt(n4);
            n7 = Math.max(n7, this.fm.stringWidth(bar.label));
            for (n3 = 0; n3 < bar.values.length; ++n3) {
                string = Misc.decimalPlaces(bar.values[n3], 2);
                n7 = Math.max(n7, this.fm.stringWidth(string));
            }
        }
        graphics.drawLine(30 + (n7 += this.gap), 3 * n6, 30 + n7, 3 * n6 + (this.bars.size() + 1) * n8);
        graphics.drawLine(30, 3 * n6 + n8, 30 + (this.bars.size() + 1) * n7, 3 * n6 + n8);
        n4 = 30 + n7 + this.gap / 2;
        int n9 = n3 = 3 * n6 + n8 - this.gap / 2;
        for (n2 = 0; n2 < this.bars.size(); ++n2) {
            bar = (Bar)this.bars.elementAt(n2);
            n = n4 + n2 * n7;
            graphics.drawString(bar.label, n, n9);
        }
        n4 = 30 + this.gap / 2;
        n3 = 3 * n6 + n8 + n8 - this.gap / 2;
        n = n4;
        for (n2 = 0; n2 < this.bars.size(); ++n2) {
            bar = (Bar)this.bars.elementAt(n2);
            n9 = n3 + n2 * n8;
            graphics.drawString(bar.label, n, n9);
            int n10 = n9;
            for (int i = 0; i < bar.values.length; ++i) {
                string = Misc.decimalPlaces(bar.values[i], 2);
                int n11 = n + n7 + i * n7;
                graphics.drawString(string, n11, n10);
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        String label;
        double[] values;

        Bar() {
        }
    }
}

