/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.gui.ColorManager;
import zeus.visualiser.statistics.charts.DrawObject;

public class PieChart
implements DrawObject {
    protected String title;
    protected Vector pieces = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected static double TINY = 1.0E-6;

    public PieChart() {
    }

    public PieChart(double[] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public void setData(double[] dArray, String[] stringArray, String string) {
        int n;
        this.title = string;
        double d = 0.0;
        int n2 = 0;
        this.pieces.removeAllElements();
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            if (!(Math.abs(dArray[n] - 0.0) > TINY)) continue;
            Slice slice = new Slice();
            slice.value = 100.0 * dArray[n] / d;
            slice.label = stringArray[n];
            slice.color = ColorManager.getColor(n2++);
            this.pieces.addElement(slice);
        }
    }

    public void drawYourSelf(Graphics graphics) {
        int n = 0;
        int n2 = this.y / 5;
        int n3 = this.x - this.x / 5;
        int n4 = this.x / 3;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        n = this.fm.stringWidth(this.title);
        graphics.drawString(this.title, (this.x - n) / 2, this.y / 13);
        if (this.pieces.isEmpty()) {
            return;
        }
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        graphics.drawString("Key", n3, n2);
        int n5 = 90;
        n2 += 25;
        for (int i = 0; i < this.pieces.size(); ++i) {
            Slice slice = (Slice)this.pieces.elementAt(i);
            int n6 = (int)Math.round(3.6 * slice.value);
            graphics.setColor(slice.color);
            graphics.fillArc(this.x / 3, this.y / 3, n4, n4, n5, n6);
            this.doLegend(graphics, n3, n2, slice.label, Math.round(slice.value));
            n5 += n6;
            n2 += 20;
        }
    }

    protected void doLegend(Graphics graphics, int n, int n2, String string, long l) {
        graphics.fillRect(n, n2, 10, 10);
        graphics.setColor(Color.black);
        if ((double)l < 10.0) {
            graphics.drawString("  " + l + " % :: " + string, n + 20, n2 + 10);
        } else {
            graphics.drawString(l + " % :: " + string, n + 20, n2 + 10);
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void userDraw(Graphics graphics, String string, int n, int n2) {
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        graphics.drawString(string, n, n2);
    }

    class Slice {
        double value;
        String label;
        Color color;

        Slice() {
        }
    }
}

