/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;
import zeus.visualiser.statistics.charts.GraphicsSymbol;

public class LineGraph
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 100;
    protected static final int STEP = 5;
    protected static final int TICK_SIZE = 10;
    protected static final int KEY_DEPTH = 20;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double sum = 0.0;
    protected int type = -1;
    protected boolean[] is_valid;
    protected String[] keys;

    public LineGraph() {
    }

    public LineGraph(double[] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public LineGraph(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.setData(dArray, stringArray, stringArray2, string);
    }

    public void setData(double[] dArray, String[] stringArray, String string) {
        this.type = 0;
        this.title = string;
        int n = 0;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - 0.0) > 1.0E-6)) continue;
            this.max = Math.max(this.max, dArray[i]);
            this.min = Math.min(this.min, dArray[i]);
            Bar bar = new Bar();
            bar.value = dArray[i];
            bar.label = stringArray[i];
            bar.color = ColorManager.getColor(n++);
            this.bars.addElement(bar);
        }
    }

    public void setData(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.type = 1;
        this.title = string;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.is_valid = new boolean[stringArray2.length];
        this.keys = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.keys[i] = stringArray2[i];
            this.is_valid[i] = false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(Math.abs(dArray[i][j] - 0.0) > 1.0E-6)) continue;
                this.is_valid[j] = true;
                d += dArray[i][j];
                this.max = Math.max(this.max, dArray[i][j]);
                this.min = Math.min(this.min, dArray[i][j]);
            }
            if (!(Math.abs(d - 0.0) > 1.0E-6)) continue;
            Bar bar = new Bar();
            bar.values = new double[dArray[i].length];
            for (int j = 0; j < bar.values.length; ++j) {
                bar.values[j] = dArray[i][j];
            }
            bar.label = stringArray[i];
            this.bars.addElement(bar);
        }
    }

    public void drawYourSelf(Graphics graphics) {
        String string;
        double d;
        int n;
        int n2;
        Bar bar;
        int n3;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n4 = this.fm.stringWidth(this.title);
        int n5 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n4) / 2, n5);
        if (this.bars.isEmpty()) {
            return;
        }
        int n6 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        for (n3 = 0; n3 < this.bars.size(); ++n3) {
            bar = (Bar)this.bars.elementAt(n3);
            n6 = Math.max(n6, this.fm.stringWidth(bar.label));
        }
        n3 = ((n6 += 10) + this.gap) * this.bars.size();
        double d3 = this.min > 0.0 ? this.max : Math.abs(this.max - this.min);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        switch (this.type) {
            case 0: {
                int n11;
                graphics.drawLine(100, 3 * n5, 100, this.y - 2 * n5);
                n7 = 100;
                n8 = (int)(3.0 * (double)n5 + this.max / d3 * ((double)this.y - 5.0 * (double)n5));
                n2 = n7 + n3;
                n = n8;
                graphics.drawLine(n7, n8, n2, n);
                graphics.setColor(Color.black);
                for (n11 = 0; n11 < this.bars.size(); ++n11) {
                    bar = (Bar)this.bars.elementAt(n11);
                    n2 = n7 + (n6 + this.gap) * n11 + (n6 + this.gap) / 2;
                    n = (int)((double)n8 - bar.value / this.max * ((double)n8 - 3.0 * (double)n5));
                    GraphicsSymbol.drawSymbol(graphics, 0, 10, n2, n);
                    if (n11 != 0) {
                        graphics.drawLine(n9, n10, n2, n);
                    }
                    n9 = n2;
                    n10 = n;
                    n4 = this.fm.stringWidth(bar.label);
                    graphics.drawString(bar.label, n2 - n4 / 2, n8 + n5);
                }
                break;
            }
            case 1: {
                int n11;
                graphics.drawLine(100, 3 * n5, 100, this.y - 2 * n5);
                n7 = 100;
                n8 = (int)(3.0 * (double)n5 + this.max / d3 * ((double)this.y - 5.0 * (double)n5));
                n2 = n7 + n3;
                n = n8;
                graphics.drawLine(n7, n8, n2, n);
                for (n11 = 0; n11 < this.keys.length; ++n11) {
                    for (int i = 0; i < this.bars.size(); ++i) {
                        bar = (Bar)this.bars.elementAt(i);
                        n2 = n7 + (n6 + this.gap) * i + (n6 + this.gap) / 2;
                        n = (int)((double)n8 - bar.values[n11] / this.max * ((double)n8 - 3.0 * (double)n5));
                        graphics.setColor(ColorManager.getColor(n11));
                        GraphicsSymbol.drawSymbol(graphics, n11, 10, n2, n);
                        if (i != 0) {
                            graphics.drawLine(n9, n10, n2, n);
                        }
                        n9 = n2;
                        n10 = n;
                    }
                }
                for (n11 = 0; n11 < this.bars.size(); ++n11) {
                    bar = (Bar)this.bars.elementAt(n11);
                    n2 = n7 + (n6 + this.gap) * n11 + (n6 + this.gap) / 2;
                    n4 = this.fm.stringWidth(bar.label);
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n2 - n4 / 2, n8 + n5);
                }
                break;
            }
            default: {
                return;
            }
        }
        d = (int)((d = this.max / 5.0) + 0.51) == 0 ? d : (double)((int)(d + 0.51));
        int n12 = (int)(((double)n8 - 3.0 * (double)n5) * d / this.max);
        graphics.setColor(Color.black);
        double d4 = 0.0;
        int n13 = n7;
        int n14 = n8;
        while (d4 - 1.0E-6 <= this.max) {
            string = Misc.decimalPlaces(d4, 2);
            graphics.drawLine(n13, n14, n13 - 10, n14);
            n4 = this.fm.stringWidth(string);
            graphics.drawString(string, n13 - 10 - n4 - 5, n14);
            d4 += d;
            n14 -= n12;
        }
        if (this.min < 0.0) {
            d4 = -d;
            n13 = n7;
            n14 = n8 + n12;
            while (d4 > this.min) {
                string = Misc.decimalPlaces(d4, 2);
                graphics.drawLine(n13, n14, n13 - 10, n14);
                n4 = this.fm.stringWidth(string);
                graphics.drawString(string, n13 - 10 - n4 - 5, n14);
                d4 -= d;
                n14 += n12;
            }
        }
        if (this.type == 1) {
            n2 = n7 + n3 + 100;
            n = 3 * n5;
            n5 = this.fm.getHeight();
            int n15 = Math.max(n5 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n2, n);
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.is_valid[i]) continue;
                graphics.setColor(ColorManager.getColor(i));
                GraphicsSymbol.drawSymbol(graphics, i, 10, n2 + (n15 - 3) / 2, (n += n15) + (n15 - 3) / 2);
                graphics.setColor(Color.black);
                graphics.drawString(this.keys[i], n2 + n15, n + (n15 - 3) / 2);
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        double value;
        String label;
        Color color;
        double[] values;

        Bar() {
        }
    }
}

