/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;

public class Histogram
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 100;
    protected static final int STEP = 5;
    protected static final int TICK_SIZE = 10;
    protected static final int KEY_DEPTH = 20;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double sum = 0.0;
    protected int type = -1;
    protected boolean[] is_valid;
    protected String[] keys;

    public Histogram() {
    }

    public Histogram(double[] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public Histogram(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.setData(dArray, stringArray, stringArray2, string);
    }

    public void setData(double[] dArray, String[] stringArray, String string) {
        this.type = 0;
        this.title = string;
        int n = 0;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - 0.0) > 1.0E-6)) continue;
            this.max = Math.max(this.max, dArray[i]);
            this.min = Math.min(this.min, dArray[i]);
            Bar bar = new Bar();
            bar.value = dArray[i];
            bar.label = stringArray[i];
            bar.color = ColorManager.getColor(n++);
            this.bars.addElement(bar);
        }
    }

    public void setData(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.type = 1;
        this.title = string;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.is_valid = new boolean[stringArray2.length];
        this.keys = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.keys[i] = stringArray2[i];
            this.is_valid[i] = false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(Math.abs(dArray[i][j] - 0.0) > 1.0E-6)) continue;
                this.is_valid[j] = true;
                d += dArray[i][j];
            }
            this.max = Math.max(this.max, d);
            this.min = Math.min(this.min, d);
            if (!(Math.abs(d - 0.0) > 1.0E-6)) continue;
            Bar bar = new Bar();
            bar.values = new double[dArray[i].length];
            for (int j = 0; j < bar.values.length; ++j) {
                bar.values[j] = dArray[i][j];
            }
            bar.label = stringArray[i];
            this.bars.addElement(bar);
        }
    }

    public void drawYourSelf(Graphics graphics) {
        String string;
        double d;
        int n;
        int n2;
        int n3;
        Bar bar;
        int n4;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n5 = this.fm.stringWidth(this.title);
        int n6 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n5) / 2, n6);
        if (this.bars.isEmpty()) {
            return;
        }
        int n7 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        for (n4 = 0; n4 < this.bars.size(); ++n4) {
            bar = (Bar)this.bars.elementAt(n4);
            n7 = Math.max(n7, this.fm.stringWidth(bar.label));
        }
        n4 = ((n7 += 10) + this.gap) * this.bars.size();
        double d3 = this.min > 0.0 ? this.max : Math.abs(this.max - this.min);
        int n8 = 0;
        int n9 = 0;
        switch (this.type) {
            case 0: {
                int n10;
                int n11;
                int n12;
                graphics.drawLine(100, 3 * n6, 100, this.y - 2 * n6);
                n8 = 100;
                n9 = (int)(3.0 * (double)n6 + this.max / d3 * ((double)this.y - 5.0 * (double)n6));
                n3 = n8 + n4;
                n2 = n9;
                graphics.drawLine(n8, n9, n3, n2);
                n2 = n9;
                for (n12 = 0; n12 < this.bars.size(); ++n12) {
                    bar = (Bar)this.bars.elementAt(n12);
                    n3 = n8 + (n7 + this.gap) * n12 + this.gap / 2;
                    n11 = n3 + (n7 + this.gap) - this.gap / 2;
                    n10 = (int)((double)n9 - bar.value / this.max * ((double)n9 - 3.0 * (double)n6));
                    graphics.setColor(bar.color);
                    graphics.fillRect(Math.min(n3, n11), Math.min(n2, n10), Math.abs(n11 - n3), Math.abs(n10 - n2));
                    n5 = this.fm.stringWidth(bar.label);
                    n = bar.value > 0.0 ? n2 + n6 : n2 - n6;
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n3 + (n7 + this.gap - n5) / 2, n);
                }
                break;
            }
            case 1: {
                int n10;
                int n11;
                int n12;
                graphics.drawLine(100, 3 * n6, 100, this.y - 2 * n6);
                n8 = 100;
                n9 = (int)(3.0 * (double)n6 + this.max / d3 * ((double)this.y - 5.0 * (double)n6));
                n3 = n8 + n4;
                n2 = n9;
                graphics.drawLine(n8, n9, n3, n2);
                for (n12 = 0; n12 < this.bars.size(); ++n12) {
                    bar = (Bar)this.bars.elementAt(n12);
                    n3 = n8 + (n7 + this.gap) * n12 + this.gap / 2;
                    n11 = n3 + (n7 + this.gap) - this.gap / 2;
                    double d4 = 0.0;
                    n10 = n2 = n9;
                    for (int i = 0; i < bar.values.length; ++i) {
                        n2 = n10;
                        n10 = (int)((double)n9 - (d4 += bar.values[i]) / this.max * ((double)n9 - 3.0 * (double)n6));
                        graphics.setColor(ColorManager.getColor(i));
                        graphics.fillRect(Math.min(n3, n11), Math.min(n2, n10), Math.abs(n11 - n3), Math.abs(n10 - n2));
                    }
                    n5 = this.fm.stringWidth(bar.label);
                    n = d4 > 0.0 ? n9 + n6 : n9 - n6;
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n3 + (n7 + this.gap - n5) / 2, n);
                }
                break;
            }
            default: {
                return;
            }
        }
        d = (int)((d = this.max / 5.0) + 0.51) == 0 ? d : (double)((int)(d + 0.51));
        int n13 = (int)(((double)n9 - 3.0 * (double)n6) * d / this.max);
        graphics.setColor(Color.black);
        double d5 = 0.0;
        int n14 = n8;
        n = n9;
        while (d5 - 1.0E-6 <= this.max) {
            string = Double.toString(d5);
            string = Misc.decimalPlaces(string, 2);
            graphics.drawLine(n14, n, n14 - 10, n);
            n5 = this.fm.stringWidth(string);
            graphics.drawString(string, n14 - 10 - n5 - 5, n);
            d5 += d;
            n -= n13;
        }
        if (this.min < 0.0) {
            d5 = -d;
            n14 = n8;
            n = n9 + n13;
            while (d5 > this.min) {
                string = Double.toString(d5);
                string = Misc.decimalPlaces(string, 2);
                graphics.drawLine(n14, n, n14 - 10, n);
                n5 = this.fm.stringWidth(string);
                graphics.drawString(string, n14 - 10 - n5 - 5, n);
                d5 -= d;
                n += n13;
            }
        }
        if (this.type == 1) {
            n3 = n8 + n4 + 100;
            n2 = 3 * n6;
            n6 = this.fm.getHeight();
            int n15 = Math.max(n6 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n3, n2);
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.is_valid[i]) continue;
                graphics.setColor(ColorManager.getColor(i));
                graphics.fillRect(n3, n2 += n15, n15 - 3, n15 - 3);
                graphics.setColor(Color.black);
                graphics.drawString(this.keys[i], n3 + n15, n2 + (n15 - 3) / 2);
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        double value;
        String label;
        Color color;
        double[] values;

        Bar() {
        }
    }
}

