/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.society;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import zeus.actors.AgentContext;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.NumberDialog;
import zeus.gui.graph.Graph;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.VideoTool;
import zeus.visualiser.society.AnimationManager;
import zeus.visualiser.society.SocietyModel;
import zeus.visualiser.society.SocietyPanel;

public class SocietyTool
extends VideoTool {
    private static int count = 0;
    private EditableMultipleSelectionDialog update_dialog = null;
    private EditableMultipleSelectionDialog message_dialog = null;
    private NumberDialog number_dialog = null;
    private SocietyMenuBar menubar;
    protected SocietyModel onlineModel;
    protected SocietyModel offlineModel;
    protected AnimationManager animationManager;
    protected Graph graph;

    public SocietyTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        super(agentContext, visualiserModel);
        this.setTitle(agentContext.whoami() + " - SocietyTool:" + count++);
        String string = SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator + "society-icon.gif";
        ImageIcon imageIcon = new ImageIcon(string);
        this.setIconImage(imageIcon.getImage());
        this.setBackground(Color.lightGray);
        this.onlineModel = new SocietyModel();
        this.offlineModel = new SocietyModel();
        SocietyPanel societyPanel = new SocietyPanel(this.onlineModel);
        this.graph = societyPanel.getGraph();
        this.animationManager = new AnimationManager(agentContext, this.graph);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)societyPanel, "Center");
        container.add((Component)this.videoToolbar, "North");
        this.menubar = new SocietyMenuBar();
        this.setJMenuBar(this.menubar);
        this.pack();
        this.setVisible(true);
        this.setMode(1);
        this.initialRegistration();
    }

    public void Exit() {
        if (this.animationManager != null) {
            this.animationManager.terminate();
        }
        super.Exit();
    }

    public void UpdateRelations() {
        Object[] objectArray;
        if (!this.hubOK()) {
            return;
        }
        if (!this.stopPlayback()) {
            return;
        }
        Object[] objectArray2 = this.model.getAgents();
        if (this.update_dialog == null) {
            this.update_dialog = new EditableMultipleSelectionDialog((Frame)this, "Select Agents", objectArray2);
            this.update_dialog.setLocationRelativeTo(this);
        } else {
            objectArray = this.update_dialog.getPriorSelection();
            this.update_dialog.setListData(objectArray2);
            this.update_dialog.setSelection(objectArray);
        }
        objectArray = this.update_dialog.getSelection();
        this.model.addAgents(Misc.stringArray(this.update_dialog.getListData()));
        if (objectArray != null && objectArray.length > 0) {
            this.query("your_relations", Misc.stringArray(objectArray), "log_relations");
        }
    }

    public void StreamMessages(boolean bl) {
        Object[] objectArray;
        if (!this.hubOK()) {
            return;
        }
        if (!this.stopPlayback()) {
            return;
        }
        Object[] objectArray2 = this.model.getAgents();
        if (this.message_dialog == null) {
            this.message_dialog = new EditableMultipleSelectionDialog((Frame)this, "Select Agents", objectArray2);
            this.message_dialog.setLocationRelativeTo(this);
        } else {
            objectArray = this.message_dialog.getPriorSelection();
            this.message_dialog.setListData(objectArray2);
            this.message_dialog.setSelection(objectArray);
        }
        objectArray = this.message_dialog.getSelection();
        this.model.addAgents(Misc.stringArray(this.message_dialog.getListData()));
        this.subscribe(bl, this.model.keys[1], Misc.stringArray(objectArray), "log_message");
    }

    protected void setMode(int n) {
        if (n == 1) {
            this.menubar.update(1);
            this.videoToolbar.setStatus(false);
            this.graph.setModel(this.onlineModel);
        } else {
            this.menubar.update(0);
            this.videoToolbar.setStatus(true);
            this.graph.setModel(this.offlineModel);
        }
    }

    protected void initialRegistration() {
        int n;
        String string = SystemProps.getProperty("agent.names.agent");
        String[] stringArray = this.model.getAgents(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.registerAgent(stringArray[n], string);
        }
        string = SystemProps.getProperty("agent.names.facilitator");
        stringArray = this.model.getAgents(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.registerAgent(stringArray[n], string);
        }
        string = SystemProps.getProperty("agent.names.visualiser");
        stringArray = this.model.getAgents(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.registerAgent(stringArray[n], string);
        }
        string = SystemProps.getProperty("agent.names.dbProxy");
        stringArray = this.model.getAgents(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.registerAgent(stringArray[n], string);
        }
        string = SystemProps.getProperty("agent.names.nameserver");
        stringArray = this.model.getAgents(string);
        for (n = 0; n < stringArray.length; ++n) {
            this.registerAgent(stringArray[n], string);
        }
    }

    protected void registerAgent(String string, String string2) {
        this.onlineModel.addAgent(string, string2);
        this.debug("added online name = " + string);
    }

    protected void registerListOfPlaybackAgents(Vector vector) {
        this.offlineModel.addAgents(vector);
    }

    protected void visualiseVideoData(int n, Performative performative) {
        if (this.state.mode == 0 && this.state.animating && this.filterMsg(performative)) {
            if (n == 1) {
                String string = performative.getReceiver();
                performative.setReceiver(performative.getSender());
                performative.setSender(string);
            }
            this.animationManager.animate(performative);
        }
    }

    public void log_relations(Performative performative) {
        if (!performative.getType().equals("inform")) {
            return;
        }
        Vector vector = ZeusParser.relationshipList(performative.getContent());
        String string = performative.getSender();
        this.onlineModel.addRelations(string, vector);
    }

    public void log_message(Performative performative) {
        this.debug("log_message 1");
        try {
            Performative performative2 = ZeusParser.performative(performative.getContent());
            this.debug("log_message 2");
            if (this.state.mode == 1 && this.state.animating && this.filterMsg(performative2)) {
                this.animationManager.animate(performative2);
            }
            this.debug("log_message 3");
            this.record_item(performative2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void Animation(boolean bl) {
        this.state.animating = bl;
        if (!bl) {
            this.animationManager.flushAnimator();
        }
    }

    void setAnimationMode(int n) {
        this.animationManager.setMode(n);
    }

    void AnimationSpeed() {
        long l = this.animationManager.getSpeed();
        if (this.number_dialog == null) {
            this.number_dialog = new NumberDialog((Frame)this, "Set Animation Speed", "Enter speed:");
            this.number_dialog.setLocationRelativeTo(this);
        }
        this.number_dialog.setValue(l);
        Long l2 = this.number_dialog.getValue();
        if (l2 != null) {
            this.animationManager.setSpeed(l2);
        }
    }

    void Help() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Society Viewer");
        helpWindow.setSize(new Dimension(this.getWidth(), 500));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.validate();
    }

    private void debug(String string) {
    }

    public class SocietyMenuBar
    extends JMenuBar
    implements ActionListener,
    ItemListener {
        protected JMenuItem connect;
        protected JMenuItem disconnect;
        protected JMenuItem exit;
        protected JMenuItem sessions;
        protected JMenuItem load;
        protected JMenuItem save;
        protected JMenuItem close;
        protected JMenuItem forward;
        protected JMenuItem rewind;
        protected JMenuItem fforward;
        protected JMenuItem frewind;
        protected JMenuItem stop;
        protected JMenuItem forward_step;
        protected JMenuItem rewind_step;
        protected JMenuItem forward_last;
        protected JMenuItem rewind_first;
        protected JMenuItem delete;
        protected JMenuItem purge;
        protected JMenuItem cc;
        protected JMenuItem update;
        protected JMenuItem un_cc;
        protected JMenuItem filter;
        protected JMenuItem animation_speed;
        protected JMenuItem player_speed;
        protected JMenuItem collapse;
        protected JMenuItem expand;
        protected JMenuItem recompute;
        protected JMenuItem redraw;
        protected JMenuItem select;
        protected JMenuItem selectAll;
        protected JMenuItem hide;
        protected JMenuItem show;
        protected JMenuItem help;
        protected JMenuItem about;
        protected JMenuItem onOff;
        protected JRadioButtonMenuItem letterAnim;
        protected JRadioButtonMenuItem arrowAnim;
        protected static final int CHECK = 0;
        protected static final int PLAIN = 1;
        protected static final int RADIO = 2;

        public SocietyMenuBar() {
            this.add(this.fileMenu());
            this.add(this.onlineMenu());
            this.add(this.playbackMenu());
            this.add(this.optionsMenu());
            this.add(this.viewMenu());
            this.add(this.helpMenu());
        }

        private JMenu fileMenu() {
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic('F');
            this.connect = this.createMenuItem(jMenu, 1, "Connect to namservers", 67);
            this.disconnect = this.createMenuItem(jMenu, 1, "Disconnect from nameservers", 68);
            this.exit = this.createMenuItem(jMenu, 1, "Quit", 81);
            return jMenu;
        }

        private JMenu onlineMenu() {
            JMenu jMenu = new JMenu("Online");
            jMenu.setMnemonic('O');
            this.update = this.createMenuItem(jMenu, 1, "Update relations", 85);
            this.cc = this.createMenuItem(jMenu, 1, "Request messages", 82);
            this.un_cc = this.createMenuItem(jMenu, 1, "Un-request messages", 78);
            return jMenu;
        }

        private JMenu playbackMenu() {
            JMenu jMenu = new JMenu("Playback");
            jMenu.setMnemonic('P');
            this.sessions = this.createMenuItem(jMenu, 1, "Request saved sessions", 0);
            this.delete = this.createMenuItem(jMenu, 1, "Delete session", 0);
            this.purge = this.createMenuItem(jMenu, 1, "Purge database", 0);
            jMenu.addSeparator();
            this.load = this.createMenuItem(jMenu, 1, "Load session", 0);
            this.save = this.createMenuItem(jMenu, 1, "Save session", 0);
            this.close = this.createMenuItem(jMenu, 1, "Close session", 0);
            jMenu.addSeparator();
            this.forward = this.createMenuItem(jMenu, 1, "Forward", 0);
            this.rewind = this.createMenuItem(jMenu, 1, "Rewind", 0);
            this.fforward = this.createMenuItem(jMenu, 1, "Fast forward", 0);
            this.frewind = this.createMenuItem(jMenu, 1, "Fast rewind", 0);
            this.forward_step = this.createMenuItem(jMenu, 1, "Step forward", 0);
            this.rewind_step = this.createMenuItem(jMenu, 1, "Step backward", 0);
            this.forward_last = this.createMenuItem(jMenu, 1, "Forward to end", 0);
            this.rewind_first = this.createMenuItem(jMenu, 1, "Rewind to beginning", 0);
            this.stop = this.createMenuItem(jMenu, 1, "Stop", 0);
            return jMenu;
        }

        private JMenu optionsMenu() {
            JMenu jMenu = new JMenu("Options");
            jMenu.setMnemonic('T');
            this.filter = this.createMenuItem(jMenu, 1, "Filter messages", 0);
            this.player_speed = this.createMenuItem(jMenu, 1, "Player speed...", 0);
            this.animation_speed = this.createMenuItem(jMenu, 1, "Animation speed...", 0);
            JMenu jMenu2 = new JMenu("Animation mode");
            jMenu.add(jMenu2);
            int n = SocietyTool.this.animationManager.getMode();
            this.arrowAnim = new JRadioButtonMenuItem("Arrow", n == 1);
            this.arrowAnim.addActionListener(this);
            this.letterAnim = new JRadioButtonMenuItem("Letter", n == 0);
            this.letterAnim.addActionListener(this);
            jMenu2.add(this.letterAnim);
            jMenu2.add(this.arrowAnim);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.arrowAnim);
            buttonGroup.add(this.letterAnim);
            this.onOff = this.createMenuItem(jMenu, 0, "Animation", 0);
            ((JCheckBoxMenuItem)this.onOff).setState(((SocietyTool)SocietyTool.this).state.animating);
            return jMenu;
        }

        private JMenu viewMenu() {
            JMenu jMenu = new JMenu("View");
            jMenu.setMnemonic('V');
            this.collapse = this.createMenuItem(jMenu, 1, "Collapse", 0);
            this.expand = this.createMenuItem(jMenu, 1, "Expand", 0);
            this.recompute = this.createMenuItem(jMenu, 1, "Recompute", 0);
            this.redraw = this.createMenuItem(jMenu, 1, "Redraw", 0);
            jMenu.addSeparator();
            this.select = this.createMenuItem(jMenu, 1, "Select", 0);
            this.selectAll = this.createMenuItem(jMenu, 1, "Select all", 0);
            jMenu.addSeparator();
            this.hide = this.createMenuItem(jMenu, 1, "Hide", 0);
            this.show = this.createMenuItem(jMenu, 1, "Show", 0);
            return jMenu;
        }

        private JMenu helpMenu() {
            JMenu jMenu = new JMenu("Help");
            jMenu.setMnemonic('H');
            this.help = this.createMenuItem(jMenu, 1, "Using the society tool", 85);
            this.about = this.createMenuItem(jMenu, 1, "About ZEUS...", 65);
            return jMenu;
        }

        private JMenuItem createMenuItem(JMenu jMenu, int n, String string, int n2) {
            JMenuItem jMenuItem;
            switch (n) {
                case 0: {
                    jMenuItem = new JCheckBoxMenuItem();
                    ((JCheckBoxMenuItem)jMenuItem).setState(false);
                    jMenuItem.addItemListener(this);
                    break;
                }
                case 2: {
                    jMenuItem = new JRadioButtonMenuItem();
                    jMenuItem.addActionListener(this);
                }
                default: {
                    jMenuItem = new JMenuItem();
                    jMenuItem.addActionListener(this);
                }
            }
            jMenuItem.setText(string);
            if (n2 > 0) {
                jMenuItem.setMnemonic(n2);
            }
            jMenu.add(jMenuItem);
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.connect) {
                SocietyTool.this.Connect(true);
            } else if (object == this.disconnect) {
                SocietyTool.this.Connect(false);
            } else if (object == this.exit) {
                SocietyTool.this.Exit();
            } else if (object == this.cc) {
                SocietyTool.this.StreamMessages(true);
            } else if (object == this.update) {
                SocietyTool.this.UpdateRelations();
            } else if (object == this.un_cc) {
                SocietyTool.this.StreamMessages(false);
            } else if (object == this.sessions) {
                SocietyTool.this.Sessions();
            } else if (object == this.delete) {
                SocietyTool.this.Delete();
            } else if (object == this.purge) {
                SocietyTool.this.Purge();
            } else if (object == this.load) {
                SocietyTool.this.Load();
            } else if (object == this.save) {
                SocietyTool.this.Record();
            } else if (object == this.close) {
                SocietyTool.this.Close();
            } else if (object == this.forward) {
                SocietyTool.this.Forward();
            } else if (object == this.rewind) {
                SocietyTool.this.Rewind();
            } else if (object == this.fforward) {
                SocietyTool.this.FForward();
            } else if (object == this.frewind) {
                SocietyTool.this.FRewind();
            } else if (object == this.stop) {
                SocietyTool.this.Stop();
            } else if (object == this.forward_step) {
                SocietyTool.this.StepForward();
            } else if (object == this.forward_last) {
                SocietyTool.this.ForwardEnd();
            } else if (object == this.rewind_step) {
                SocietyTool.this.StepRewind();
            } else if (object == this.rewind_first) {
                SocietyTool.this.RewindBegin();
            } else if (object == this.filter) {
                SocietyTool.this.Filter();
            } else if (object == this.player_speed) {
                SocietyTool.this.PlayerSpeed();
            } else if (object == this.animation_speed) {
                SocietyTool.this.AnimationSpeed();
            } else if (object == this.arrowAnim) {
                SocietyTool.this.setAnimationMode(1);
            } else if (object == this.letterAnim) {
                SocietyTool.this.setAnimationMode(0);
            } else if (object == this.collapse) {
                SocietyTool.this.graph.collapse();
            } else if (object == this.expand) {
                SocietyTool.this.graph.expand();
            } else if (object == this.recompute) {
                SocietyTool.this.graph.recompute();
            } else if (object == this.redraw) {
                SocietyTool.this.graph.redraw();
            } else if (object == this.select) {
                SocietyTool.this.graph.select();
            } else if (object == this.selectAll) {
                SocietyTool.this.graph.selectAll();
            } else if (object == this.hide) {
                SocietyTool.this.graph.hide();
            } else if (object == this.show) {
                SocietyTool.this.graph.show();
            } else if (object == this.help) {
                SocietyTool.this.Help();
            } else if (object == this.about) {
                SocietyTool.this.About();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.onOff) {
                boolean bl = ((JCheckBoxMenuItem)this.onOff).getState();
                this.animation_speed.setEnabled(bl);
                this.letterAnim.setEnabled(bl);
                this.arrowAnim.setEnabled(bl);
                SocietyTool.this.Animation(bl);
            }
        }

        public void update(int n) {
            boolean bl = n == 0;
            this.cc.setEnabled(!bl);
            this.update.setEnabled(!bl);
            this.forward.setEnabled(bl);
            this.rewind.setEnabled(bl);
            this.fforward.setEnabled(bl);
            this.frewind.setEnabled(bl);
            this.stop.setEnabled(bl);
            this.forward_step.setEnabled(bl);
            this.rewind_step.setEnabled(bl);
            this.forward_last.setEnabled(bl);
            this.rewind_first.setEnabled(bl);
        }
    }
}

