/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.society;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import zeus.concepts.Performative;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;
import zeus.util.ArrowData;
import zeus.util.Core;
import zeus.util.SystemProps;

public class AnimationQueue
extends Thread {
    static final int LETTER = 0;
    static final int ARROWS = 1;
    static int FLUSH_QUEUE_LIMIT = 100;
    static int count = 0;
    long speed = 80L;
    int length = 10;
    int mode = 0;
    Graph graph;
    protected Vector queue = new Vector();
    protected boolean running = true;

    public AnimationQueue(Graph graph) {
        this.graph = graph;
        this.setPriority(7);
        this.start();
    }

    synchronized void flush() {
        this.queue.removeAllElements();
    }

    void setSpeed(long l) {
        this.speed = l;
    }

    long getSpeed() {
        return this.speed;
    }

    int getMode() {
        return this.mode;
    }

    int getLength() {
        return this.length;
    }

    void setMode(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.mode = n;
                break;
            }
            default: {
                Core.USER_ERROR("Illegal animation type " + n);
            }
        }
    }

    void setLength(int n) {
        Core.ERROR(n > 0, 1, (Object)this);
        this.length = n;
    }

    void terminate() {
        this.running = false;
    }

    public synchronized void add(Performative performative, GraphNode graphNode, GraphNode graphNode2, Color color) {
        Core.ERROR(performative, 1, (Object)this);
        Core.ERROR(graphNode, 2, (Object)this);
        Core.ERROR(graphNode2, 3, (Object)this);
        Core.ERROR(color, 4, (Object)this);
        if (this.queue.size() > FLUSH_QUEUE_LIMIT) {
            this.queue.removeAllElements();
        }
        AnimationQueueItem animationQueueItem = new AnimationQueueItem(performative, graphNode, graphNode2, color);
        if (this.queue.isEmpty()) {
            this.queue.addElement(animationQueueItem);
            this.debug("in add empty - notifying");
            this.notify();
            return;
        }
        double d = performative.getSendTime().getTime();
        for (int i = 0; i < this.queue.size(); ++i) {
            AnimationQueueConstraint animationQueueConstraint;
            AnimationQueueItem animationQueueItem2 = (AnimationQueueItem)this.queue.elementAt(i);
            String string = animationQueueItem2.id;
            double d3 = animationQueueItem2.sendTime;
            double d4 = animationQueueItem2.receiveTime;
            if (d >= d4) {
                animationQueueConstraint = new AnimationQueueConstraint(string, 1);
                animationQueueItem.addConstraint(animationQueueConstraint);
                continue;
            }
            if (!(d < d4) || !(d > d3)) continue;
            animationQueueConstraint = new AnimationQueueConstraint(string, 0);
            animationQueueItem.addConstraint(animationQueueConstraint);
        }
        this.queue.addElement(animationQueueItem);
        this.debug("in add more than one - notifying");
        this.notify();
    }

    private void debug(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            this.debug("in animation queue");
            AnimationQueue animationQueue = this;
            synchronized (animationQueue) {
                while (this.queue.isEmpty()) {
                    try {
                        this.wait();
                        this.debug("notified animation thread - waking");
                    }
                    catch (InterruptedException interruptedException) {}
                }
                for (int i = 0; i < this.queue.size(); ++i) {
                    AnimationQueueItem animationQueueItem = (AnimationQueueItem)this.queue.elementAt(i);
                    if (animationQueueItem == null) continue;
                    if (animationQueueItem.isDone()) {
                        this.queue.removeElementAt(i--);
                        continue;
                    }
                    if (animationQueueItem.isRunning()) {
                        animationQueueItem.next();
                        continue;
                    }
                    if (animationQueueItem.isRunning() || !animationQueueItem.evalConstraints(this.queue)) continue;
                    animationQueueItem.start();
                }
            }
            try {
                AnimationQueue.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("stopped sleeping");
        }
    }

    public class Animation {
        int NUM_COUNT = 1;
        int LETTTER_WIDTH = 40;
        private GraphNode source;
        private GraphNode target;
        private Color color;
        private Point p2;
        private Point p1;
        private boolean done = false;
        private boolean running = false;
        private int count = 0;
        private Image image = null;
        ImageLabel imageLabel;

        public Animation(GraphNode graphNode, GraphNode graphNode2, Color color, Performative performative) {
            Core.ERROR(graphNode, 1, (Object)this);
            Core.ERROR(graphNode2, 2, (Object)this);
            Core.ERROR(color, 3, (Object)this);
            this.source = graphNode;
            this.target = graphNode2;
            this.color = color;
            Rectangle rectangle = AnimationQueue.this.graph.getBounds(graphNode);
            Rectangle rectangle2 = AnimationQueue.this.graph.getBounds(graphNode2);
            this.p1 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            this.p2 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            this.image = Toolkit.getDefaultToolkit().getImage(SystemProps.getProperty("gif.dir") + "visualiser" + File.separator + "anim.gif");
            this.imageLabel = new ImageLabel(color, this.image, performative.getType());
            this.imageLabel.setVisible(false);
            AnimationQueue.this.graph.add(this.imageLabel);
            AnimationQueue.this.graph.validate();
            this.running = true;
            switch (AnimationQueue.this.mode) {
                case 0: {
                    this.imageLabel.setVisible(true);
                    this.drawLetter(this.p1, this.imageLabel);
                    break;
                }
                case 1: {
                    this.drawArrows(this.p1, this.p2);
                }
            }
        }

        boolean isDone() {
            return this.done;
        }

        boolean isRunning() {
            return this.running;
        }

        void next() {
            if (!this.done && AnimationQueue.this.mode == 0) {
                if (!this.imageLabel.isVisible()) {
                    this.imageLabel.setVisible(true);
                }
                Rectangle rectangle = AnimationQueue.this.graph.getBounds(this.target);
                this.p2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                double d = Math.sqrt(Math.pow(this.p2.x - this.p1.x, 2.0) + Math.pow(this.p2.y - this.p1.y, 2.0));
                double d3 = ArrowData.GetAngle(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                double d4 = d > (double)AnimationQueue.this.length ? (double)AnimationQueue.this.length : d;
                this.p1.x += (int)(d4 * Math.cos(d3));
                this.p1.y += (int)(d4 * Math.sin(d3));
                this.drawLetter(this.p1, this.imageLabel);
                this.done = rectangle.contains(this.p1);
            } else if (!this.done && AnimationQueue.this.mode == 1) {
                this.imageLabel.setVisible(false);
                AnimationQueue.this.graph.repaint();
                this.drawArrows(this.p1, this.p2);
                Rectangle rectangle = AnimationQueue.this.graph.getBounds(this.source);
                Rectangle rectangle2 = AnimationQueue.this.graph.getBounds(this.target);
                this.p1 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                this.p2 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
                this.drawArrows(this.p1, this.p2);
                boolean bl = this.done = ++this.count == this.NUM_COUNT;
            }
            if (this.done) {
                AnimationQueue.this.graph.remove(this.imageLabel);
                this.running = false;
                if (AnimationQueue.this.mode == 1) {
                    this.drawArrows(this.p1, this.p2);
                }
            }
        }

        protected void drawArrows(Point point, Point point2) {
            Graphics graphics = AnimationQueue.this.graph.getGraphics();
            if (graphics != null) {
                graphics.setXORMode(AnimationQueue.this.graph.getBackground());
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                this.drawThickLine(graphics, point, point2);
                Point point3 = new Point(point.x, point.y);
                Point point4 = new Point(0, 0);
                double d = Math.sqrt(Math.pow(point2.x - point3.x, 2.0) + Math.pow(point2.y - point3.y, 2.0));
                double d3 = ArrowData.GetAngle(point3.x, point3.y, point2.x, point2.y);
                double d4 = d > 1.5 * (double)AnimationQueue.this.length ? 1.5 * (double)AnimationQueue.this.length : d;
                point4.x = point3.x + (int)(d4 * Math.cos(d3));
                point4.y = point3.y + (int)(d4 * Math.sin(d3));
                this.drawArrow(graphics, point3, point4);
                while (d4 >= 1.5 * (double)AnimationQueue.this.length) {
                    point3.x = point4.x;
                    point3.y = point4.y;
                    d = Math.sqrt(Math.pow(point2.x - point3.x, 2.0) + Math.pow(point2.y - point3.y, 2.0));
                    d3 = ArrowData.GetAngle(point3.x, point3.y, point2.x, point2.y);
                    d4 = d > 1.5 * (double)AnimationQueue.this.length ? 1.5 * (double)AnimationQueue.this.length : d;
                    point4.x = point3.x + (int)(d4 * Math.cos(d3));
                    point4.y = point3.y + (int)(d4 * Math.sin(d3));
                    this.drawArrow(graphics, point3, point4);
                }
                graphics.setColor(color);
            }
        }

        protected void drawThickLine(Graphics graphics, Point point, Point point2) {
            if (point != null && point2 != null && graphics != null) {
                int n = 2;
                double d = ArrowData.GetAngle(point.x, point.y, point2.x, point2.y);
                double d3 = d + 1.5707963267948966;
                double d4 = d - 1.5707963267948966;
                Polygon polygon = new Polygon();
                int n2 = (int)((double)point.x + (double)n * Math.cos(d3));
                int n3 = (int)((double)point.y + (double)n * Math.sin(d3));
                polygon.addPoint(n2, n3);
                n2 = (int)((double)point.x + (double)n * Math.cos(d4));
                n3 = (int)((double)point.y + (double)n * Math.sin(d4));
                polygon.addPoint(n2, n3);
                n2 = (int)((double)point2.x + (double)n * Math.cos(d4));
                n3 = (int)((double)point2.y + (double)n * Math.sin(d4));
                polygon.addPoint(n2, n3);
                n2 = (int)((double)point2.x + (double)n * Math.cos(d3));
                n3 = (int)((double)point2.y + (double)n * Math.sin(d3));
                polygon.addPoint(n2, n3);
                graphics.fillPolygon(polygon);
            }
        }

        protected void drawArrow(Graphics graphics, Point point, Point point2) {
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            Point[] pointArray = ArrowData.getPoints(point.x, point.y, point2.x, point2.y);
            for (int i = 0; i < 2; ++i) {
                graphics.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
            }
        }

        protected void drawLetter(Point point, ImageLabel imageLabel) {
            imageLabel.setLocation(point);
            AnimationQueue.this.graph.repaint();
        }
    }

    class ImageLabel
    extends JPanel {
        Color color;
        JLabel label;

        public ImageLabel(Color color, Image image, String string) {
            this.setLayout(new GridLayout(1, 1));
            this.label = new JLabel(string, new ImageIcon(image), 0);
            this.label.setOpaque(true);
            this.label.setBackground(color);
            this.label.setFont(new Font("Helvetica", 0, 10));
            this.label.repaint();
            this.add(this.label);
            Image image2 = Toolkit.getDefaultToolkit().getImage(SystemProps.getProperty("gif.dir") + "visualiser" + File.separator + "border.gif");
            this.setBorder(BorderFactory.createMatteBorder(2, 4, 2, 4, new ImageIcon(image2)));
            this.setPreferredSize(new Dimension(70, 25));
        }

        public void setLetterColor(Color color) {
            this.label.setBackground(color);
            this.label.repaint();
        }
    }

    class AnimationQueueItem {
        Performative msg;
        GraphNode sender;
        GraphNode receiver;
        String id;
        Vector constraints = new Vector();
        Animation duke = null;
        double sendTime;
        double receiveTime;
        Color color;

        AnimationQueueItem(Performative performative, GraphNode graphNode, GraphNode graphNode2, Color color) {
            this.msg = performative;
            this.sendTime = performative.getSendTime().getTime();
            this.receiveTime = performative.getReceiveTime().getTime();
            this.sender = graphNode;
            this.receiver = graphNode2;
            this.color = color;
            this.id = new String("AnimationQueueItemId-" + ++count);
        }

        void addConstraint(AnimationQueueConstraint animationQueueConstraint) {
            this.constraints.addElement(animationQueueConstraint);
        }

        boolean isDone() {
            return this.duke != null && this.duke.isDone();
        }

        boolean isRunning() {
            return this.duke != null && this.duke.isRunning();
        }

        void next() {
            if (this.duke != null) {
                this.duke.next();
            }
        }

        boolean evalConstraints(Vector vector) {
            boolean bl = true;
            for (int i = 0; i < this.constraints.size(); ++i) {
                AnimationQueueConstraint animationQueueConstraint = (AnimationQueueConstraint)this.constraints.elementAt(i);
                for (int j = 0; j < vector.size(); ++j) {
                    AnimationQueueItem animationQueueItem = (AnimationQueueItem)vector.elementAt(j);
                    if (!animationQueueItem.id.equals(animationQueueConstraint.id)) continue;
                    if (animationQueueConstraint.constraint == 0) {
                        bl = bl && animationQueueItem.isRunning();
                        break;
                    }
                    if (animationQueueConstraint.constraint != 1) break;
                    bl = bl && animationQueueItem.isDone();
                    break;
                }
                if (bl) continue;
                return bl;
            }
            return bl;
        }

        void start() {
            this.duke = new Animation(this.sender, this.receiver, this.color, this.msg);
        }
    }

    class AnimationQueueConstraint {
        static final int FINISH = 1;
        static final int START = 0;
        String id;
        int constraint;

        AnimationQueueConstraint(String string, int n) {
            this.id = string;
            this.constraint = n;
        }
    }
}

