/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.society;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.concepts.Goal;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.generator.agent.AcquaintanceModel;
import zeus.gui.ColorManager;
import zeus.gui.graph.Graph;
import zeus.gui.graph.GraphNode;
import zeus.util.Time;
import zeus.visualiser.society.AnimationQueue;
import zeus.visualiser.society.SocietyModel;

public class AnimationManager {
    public static final Hashtable MessageColor = new Hashtable();
    protected AnimationQueue queue;
    protected Hashtable dynamicColor = new Hashtable();
    protected AgentContext context;
    protected Graph graph;

    public AnimationManager(AgentContext agentContext, Graph graph) {
        this.context = agentContext;
        this.graph = graph;
        this.queue = new AnimationQueue(graph);
    }

    public void terminate() {
        this.queue.terminate();
    }

    public void flushAnimator() {
        this.queue.flush();
    }

    public void setMode(int n) {
        this.queue.setMode(n);
    }

    public int getMode() {
        return this.queue.getMode();
    }

    public void setSpeed(long l) {
        this.queue.setSpeed(l);
    }

    public long getSpeed() {
        return this.queue.getSpeed();
    }

    private void debug(String string) {
    }

    public void animate(Performative performative) {
        this.debug("animate 1");
        String string = performative.getSender();
        this.debug("animate 2");
        String string2 = performative.getReceiver();
        this.debug("animate 3");
        if (performative.getSendTime() == null) {
            performative.setSendTime(new Time(0.0));
        }
        this.debug("animate 4");
        if (performative.getReceiveTime() == null) {
            performative.setReceiveTime(new Time(0.05));
        }
        this.debug("animate 5");
        if (!string.equals(string2)) {
            this.debug("animate 6");
            SocietyModel societyModel = (SocietyModel)this.graph.getModel();
            this.debug("model = " + societyModel.toString());
            this.debug("sender = " + string);
            this.debug("receiver = " + string2);
            GraphNode graphNode = societyModel.getNode(string);
            this.debug("node1 = " + graphNode.toString());
            GraphNode graphNode2 = societyModel.getNode(string2);
            this.debug("node2 = " + graphNode2.toString());
            if (graphNode != null && graphNode2 != null && this.graph.isVisible(graphNode) && this.graph.isVisible(graphNode2)) {
                this.debug("animate 7");
                Color color = this.selectColor(performative);
                this.debug("adding to queue");
                this.queue.add(performative, graphNode, graphNode2, color);
            }
        }
    }

    protected Color selectColor(Performative performative) {
        Color color = null;
        String string = performative.getType().toLowerCase();
        String string2 = performative.getInReplyTo();
        String string3 = performative.getReplyWith();
        if (string2 != null) {
            color = (Color)this.dynamicColor.get(string2);
        }
        if (color != null) {
            return color;
        }
        if (string3 != null) {
            color = (Color)this.dynamicColor.get(string3);
        }
        if (color != null) {
            return color;
        }
        color = MessageColor.containsKey(string) ? (Color)MessageColor.get(string) : this.selectDynamicColor(performative);
        if (string3 != null) {
            this.dynamicColor.put(string3, color);
        } else if (string2 != null) {
            this.dynamicColor.put(string2, color);
        }
        return color;
    }

    protected Color selectDynamicColor(Performative performative) {
        String string = performative.getReplyWith();
        String string2 = performative.getInReplyTo();
        String string3 = performative.getContent();
        Vector vector = ZeusParser.goalList(this.context.OntologyDb(), string3);
        Goal goal = (Goal)vector.elementAt(0);
        String string4 = goal.getRootId();
        Color color = (Color)this.dynamicColor.get(string4);
        if (color == null) {
            color = this.nextColor();
            this.dynamicColor.put(string4, color);
            this.dynamicColor.put(string, color);
        }
        return color;
    }

    protected Color nextColor() {
        int n = (int)(Math.random() * 256.0);
        int n2 = (int)(Math.random() * 256.0);
        int n3 = (int)(Math.random() * 256.0);
        return new Color(n, n2, n3);
    }

    static {
        int n = AcquaintanceModel.RELATIONS_LIST.size();
        MessageColor.put("agree", ColorManager.getColor(n++));
        MessageColor.put("cancel", ColorManager.getColor(n++));
        MessageColor.put("confirm", ColorManager.getColor(n++));
        MessageColor.put("disconfirm", ColorManager.getColor(n++));
        MessageColor.put("failure", ColorManager.getColor(n++));
        MessageColor.put("inform", ColorManager.getColor(n++));
        MessageColor.put("inform-if", ColorManager.getColor(n++));
        MessageColor.put("inform-ref", ColorManager.getColor(n++));
        MessageColor.put("not-understood", ColorManager.getColor(n++));
        MessageColor.put("query-if", ColorManager.getColor(n++));
        MessageColor.put("query-ref", ColorManager.getColor(n++));
        MessageColor.put("refuse", ColorManager.getColor(n++));
        MessageColor.put("request", ColorManager.getColor(n++));
        MessageColor.put("request-when", ColorManager.getColor(n++));
        MessageColor.put("request-whenever", ColorManager.getColor(n++));
        MessageColor.put("subscribe", ColorManager.getColor(n++));
        MessageColor.put("accept-proposal", ColorManager.getColor(n++));
        MessageColor.put("cfp", ColorManager.getColor(n++));
        MessageColor.put("reject-proposal", ColorManager.getColor(n++));
        MessageColor.put("propose", ColorManager.getColor(n++));
    }
}

